import { FormBuilder, FormGroup } from "@angular/forms";

export interface ratemanagement
{
    feature: string,
    usage: string,
    recurring_mrc: string,
    setup: string,
    port_in_nrc: string  
    port_out_nrc: string,
    disconnect: string,
}

export interface HTTPratemanagement
{
    feature: string,
    usage: string,
    recurring_mrc: string,
    setup: string,
    port_in_nrc: string, 
    port_out_nrc: string,
    disconnect: string,
}

export class ratemanagementForm implements HTTPratemanagement
{
    feature: string;
    usage: string;
    recurring_mrc: string;
    setup: string;
    port_in_nrc: string;
    port_out_nrc: string;
    disconnect: string;
  
    constructor(data : ratemanagement) 
    {
        if(data == null)
        {        
            this.feature="";
            this.usage="";
            this.recurring_mrc="";
            this.setup="";
            this.port_in_nrc="";
            this.port_out_nrc="";
            this.disconnect = "";
        }
        else
        {         
            this.feature=this.feature;
            this.usage=this.usage;
            this.recurring_mrc=this.recurring_mrc;
            this.setup=this.setup;
            this.port_in_nrc=this.port_in_nrc;
            this.port_out_nrc=this.port_out_nrc;
            this.disconnect = this.disconnect;
        }
    }

    public makeform(fb:FormBuilder):FormGroup
    {
        return fb.group({ 
            feature: [this.feature],       
            usage: [this.usage],
            recurring_mrc: [this.recurring_mrc],
            setup: [this.setup],
            port_in_nrc: [this.port_in_nrc],
            port_out_nrc: [this.port_out_nrc],
            disconnect: [this.disconnect],
        });
    }

    public saveForm(fg:FormGroup):boolean
    {
        if(fg.valid)
        {     
            this.feature=fg.get("feature").value;     
            this.usage = fg.get("usage").value;
            this.recurring_mrc = fg.get("recurring_mrc").value;
            this.setup = fg.get("setup").value;
            this.port_in_nrc = fg.get("port_in_nrc").value;
            this.port_out_nrc = fg.get("port_out_nrc").value;
            this.disconnect = fg.get("disconnect").value;            
            return true;
        }
        else
        {
            return false;
        }
    }
  }



//   Tier Management

export interface tiermanagement
{
    feature: string,
    usage: string,
    recurring_MRC: string,
    one_time_NRC: string,
    port_in_NRC: string  
    port_Out_NRC: string,
    disconnect: string,
}

export interface HTTPtiermanagement
{
    feature: string,
    usage: string,
    recurring_MRC: string,
    one_time_NRC: string,
    port_in_NRC: string, 
    port_Out_NRC: string,
    disconnect: string,
}

export class tiermanagementForm implements HTTPtiermanagement
{
    feature: string;
    usage: string;
    recurring_MRC: string;
    one_time_NRC: string;
    port_in_NRC: string;
    port_Out_NRC: string;
    disconnect: string;
  
    constructor(data : tiermanagement) 
    {
        if(data == null)
        {        
            this.feature="";
            this.usage="";
            this.recurring_MRC="";
            this.one_time_NRC="";
            this.port_in_NRC="";
            this.port_Out_NRC="";
            this.disconnect = "";
        }
        else
        {         
            this.feature=this.feature;
            this.usage=this.usage;
            this.recurring_MRC=this.recurring_MRC;
            this.one_time_NRC=this.one_time_NRC
            this.port_in_NRC=this.port_in_NRC
            this.port_Out_NRC=this.port_Out_NRC
            this.disconnect = this.disconnect;
        }
    }

    public makeform(fb:FormBuilder):FormGroup
    {
        return fb.group({ 
            feature: [this.feature],       
            usage: [this.usage],
            recurring_MRC: [this.recurring_MRC],
            one_time_NRC: [this.one_time_NRC],
            port_in_NRC: [this.port_in_NRC],
            port_Out_NRC: [this.port_Out_NRC],
            disconnect: [this.disconnect],
            });
    }

    public saveForm(fg:FormGroup):boolean
    {
        if(fg.valid)
        {     
            this.feature=fg.get("feature").value;     
            this.usage = fg.get("usage").value;
            this.recurring_MRC = fg.get("recurring_MRC").value;
            this.one_time_NRC = fg.get("one_time_NRC").value;
            this.port_in_NRC = fg.get("port_in_NRC").value;
            this.port_Out_NRC = fg.get("port_Out_NRC").value;
            this.disconnect = fg.get("disconnect").value;  
            return true;
        }
        else
        {
            return false;
        }
    }
  }