import { Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import { ActivatedRoute } from '@angular/router';
import { FormGroup, FormBuilder, Validators } from '@angular/forms';
import { TollfreesmsService } from '../tollfreesms.service';
import { Observable } from 'rxjs';

declare var $: any;

@Component({
  selector: 'app-assign-toll-free-number',
  templateUrl: './assign-toll-free-number.component.html',
  styleUrls: ['./assign-toll-free-number.component.css']
})
export class AssignTollFreeNumberComponent implements OnInit {
  @ViewChild('selectElement') selectElement: ElementRef;
  @ViewChild('assigntolldisable') assigntolldisable: ElementRef;
  @ViewChild('assigntollfree') assigntollfree: ElementRef;
  show_filter: boolean = false;
  public tollFree: FormGroup;
  batchId: boolean = false;
  public userInfo2: any;
  public userInfo3: any;
  Status: any;
  label: Observable<any>;
  selectedUser: any;
  selectedStatus: any;
  did_number: any[];
  request_ID: any;
  AssignNum: any;
  selectedRequestId: any;
  number: any;
  responseMessage: any = "";
  errMessage: any = "";
  did1: any;
  unique_id: any;
  status: any;
  public submitted: boolean = false;

  constructor(private route: ActivatedRoute, public data: TollfreesmsService, public fb: FormBuilder,) { }

  ngOnInit(): void {

    let session$ = sessionStorage.getItem("isLoggedIn");
    let session = JSON.parse(session$);
    let iduser = session.iduser;
    this.data.get_tollfreeheader().subscribe((result) => {
      this.userInfo2 = result[1].filterheader;
      this.label = this.userInfo2;
      this.userInfo3 = result[2].rejectfield;
      this.Status = result[4].StatusVal;
    });
    this.GetDid_number()
    this.tollFree = this.fb.group({
      from_date: [''],
      to_date: [''],
      Request_Id: [''],
      statusResponse: ['']
    });

    this.data.get_RequestID().subscribe((result) => {
      if (result.status == 200) {
        // this.request_ID = result.data.filter(item => [5, 6, 7].includes(item.status));
        this.request_ID = result.data.filter(item => [7].includes(item.status));
      }
    });

    this.data.getAssign_number(iduser).subscribe((result) => {
      if (result.status == 200) {
        this.AssignNum = result.data;
      }
    })

  }

  filterByUser(ev: any) {
    this.selectedUser = ev.target.value;
  }

  byStatus(ev: any) {
    this.selectedStatus = ev.target.value;
  }

  GetDid_number() {
    this.data.did_number().subscribe((result) => {
      const uniqueDidNumbers = [];
      const didArray = [];

      result.data.forEach(item => {
        const did = item.did.trim();
        if (!didArray.includes(did)) {
          uniqueDidNumbers.push({ ...item, did });
          didArray.push(did);
        }
      });

      this.did_number = uniqueDidNumbers;
      $('#basic-datatables8').dataTable().fnClearTable();
      $('#basic-datatables8').dataTable().fnDraw();
      $('#basic-datatables8').dataTable().fnDestroy();
      $.getScript('./assets/tollfree.js');

    });
  }


  openmodal(id: any, sinch_status: any) {
    this.selectElement.nativeElement.value = '';
    this.number = id
    this.status = sinch_status
    const modal = document.getElementById('assigntollfree');
    $(modal).modal('show');
  }

  openmodal_disable(id: any) {
    this.selectElement.nativeElement.value = '';
    this.did1 = id
    const user = this.AssignNum.find((u) => u.did === this.did1.trim());
    this.unique_id = user.requestId;
    const modal = document.getElementById('assigntolldisable');
    $(modal).modal('show');
  }

  onSelectChange(event: any) {
    this.selectedRequestId = event.target.value;
  }


  onsubmit() {
    let payLoad: any = JSON.stringify({
      DID: this.number,
      request_id: this.selectedRequestId,
      sinch_status: this.status

    });
    this.data.onEnable_service(payLoad).subscribe((res) => {
      if (res.status == 200) {
        this.responseMessage = res.message;
        const modal = document.getElementById('assigntollfree');
        $(modal).modal('hide');
        this.GetDid_number()
        setTimeout(() => {
          this.responseMessage = '';
        }, 5000);
      } else {
        const modal = document.getElementById('assigntollfree');
        $(modal).modal('hide');
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = '';
        }, 5000);
      }
    });
  }


  DisableTF() {
    let payLoad: any = JSON.stringify({
      DID: this.did1,
      // request_id : this.selectedRequestId,
      request_ID: this.unique_id
    });
    this.data.onDisable_service(payLoad).subscribe((res) => {
      if (res.status == 200) {
        this.responseMessage = res.message;
        const modal = document.getElementById('assigntolldisable');
        $(modal).modal('hide');
        this.GetDid_number();
        setTimeout(() => {
          this.responseMessage = '';
        }, 5000);
      } else {
        const modal = document.getElementById('assigntolldisable');
        $(modal).modal('hide');
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = '';
        }, 5000);
      }
    });

  }

  /*for filter function*/

  showfilter() {
    if (this.show_filter == false) {
      this.show_filter = true;
    }
    else {
      this.show_filter = false;
    }
  }

  /*for filter process*/
  onSubmitfilter() {
    this.submitted = true;
    if (this.tollFree.invalid) {
      return false;
    } else {
      this.data.applyFilter(this.tollFree.value).subscribe((res) => {
        if (res.status == 200) {
          this.did_number = res.data;
          $('#basic-datatables8').dataTable().fnClearTable();
          $('#basic-datatables8').dataTable().fnDraw();
          $('#basic-datatables8').dataTable().fnDestroy();
          $.getScript('./assets/tollfree.js');
        } else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = '';
          }, 5000);
        }
      });
    }
  }

  resetfilter() {
    this.submitted = false;
    this.tollFree.reset();
    Object.keys(this.tollFree.controls).forEach(key => {
      this.tollFree.get(key).setValue('');
    });
    // this.tollFree.get('statusResponse').setValue('');
    this.GetDid_number()
  }

  messageshow() {
    const fromDate = this.tollFree.get('from_date').value;
    const toDate = this.tollFree.get('to_date').value;
    const currentDate = new Date();
    if ((!fromDate && !toDate)) {
    } else if ((fromDate == null || !fromDate) && (toDate != null)) {
      this.tollFree.get('from_date').setErrors({ 'dateRange': 'Please select From Date' });
    } else if ((fromDate != null) && (toDate == null || !toDate)) {
      this.tollFree.get('to_date').setErrors({ 'dateRange': 'Please select To Date' });
    } else if (fromDate && toDate && new Date(toDate) < new Date(fromDate)) {
      this.tollFree.get('to_date').setErrors({ 'dateRange': 'To date cannot be smaller than from date' });
      return;
    } else if (toDate && new Date(toDate) > currentDate) {
      this.tollFree.get('to_date').setErrors({ 'dateRange': 'To date cannot be greater than current date' });
      return;
    } else if (fromDate && new Date(fromDate) > currentDate) {
      this.tollFree.get('from_date').setErrors({ 'dateRange': 'From date cannot be greater than current date' });
      return;
    } else {
      this.tollFree.get('from_date').setErrors(null);
      this.tollFree.get('to_date').setErrors(null);
    }
  }

  ngOnDestroy() {
    this.assigntolldisable.nativeElement.click();
    this.assigntollfree.nativeElement.click();
  }

}
