import { Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import { TollfreesmsService } from '../tollfreesms.service';
import { ActivatedRoute, ParamMap } from '@angular/router';
declare var $: any;

@Component({
  selector: 'app-view',
  templateUrl: './view.component.html',
  styleUrls: ['./view.component.css']
})
export class ViewComponent implements OnInit {
  @ViewChild('viewnumber') viewnumber: ElementRef;
  tabheader1: any;
  public userInfo: any;
  id: string;
  view_data: any;
  errMessage: string;
  did_sinch: any[];
  did_status: any[];
  reques_id: any;
  number: any[];
  AssignNum: any;

  constructor(public data: TollfreesmsService, private route: ActivatedRoute) { }

  ngOnInit(): void {

    this.data.get_tollfreeheader().subscribe((result) => {
      $.getScript('./assets/tollfree.js');
      this.userInfo = result[0].header;
      this.tabheader1 = this.userInfo[0].tableheaders
    });

    this.route.paramMap.subscribe((params: ParamMap) => {
      this.id = params.get('batch_id');
      this.data.getRequestIdfromBatchId(this.id).subscribe(res => {
        if (res.status == 200) {
          this.view_data = res.data;
          this.setStatus(this.view_data);
          $('#basic-datatables1').dataTable().fnClearTable();
          $('#basic-datatables1').dataTable().fnDraw();
          $('#basic-datatables1').dataTable().fnDestroy();
          $.getScript('./assets/tollfree.js');
        } else {
          this.errMessage = "";
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      }, err => {
        this.errMessage = err.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      });
    });
  }

  setStatus(list) {
    list.forEach((element) => {
      if (element.status == 1) {
        element.status = 'Pending Review';
      }
      if (element.status == 2) {
        element.status = 'Rejected';
      }
      if (element.status == 3) {
        element.status = 'Awaiting Downstream Processing';
      }
      if (element.status == 4) {
        element.status = 'Verified Sender Review Process Started';
      }
      if (element.status == 5) {
        element.status = 'Verified Sender Submission Rejected';
      }
      if (element.status == 6) {
        element.status = 'Verified Sender Submission Approved';
      }
    });
  }

  getNumber(id: any,iduser:any) {
    this.did_status = [];
    this.number = [];
    this.reques_id = id;

    this.data.getAssign_number(iduser).subscribe((result) => {
      if (result.status === 200) {
        const dataArray = result.data;

        const groupedData = {};

        dataArray.forEach((item) => {
          const requestId = item.requestId;
          const didList = item.did.split(',');

          if (!groupedData[requestId]) {
            groupedData[requestId] = [item];
          } else {
            const existingItem = groupedData[requestId][0];
            existingItem.did += ',' + didList.join(',');
          }
        });

        this.AssignNum = Object.values(groupedData);
        this.AssignNum = [].concat(...this.AssignNum);
      }

      const user = this.AssignNum.find(
        (user) => user.requestId === this.reques_id
      );
      if (user?.did) {
        this.number = this.number || [];
        const numbersArray = user.did.split(',');
        this.number = this.number.concat(numbersArray);
        let payLoad: any = JSON.stringify({
          iduser: iduser,
          number:this.number
        })
        this.data.get_status(payLoad).subscribe((result) => {
          if (result.status == 200) {
            this.did_sinch = result.data;
            this.did_status = this.did_sinch.filter(
              (obj, index, self) =>
                index === self.findIndex((o) => o.did === obj.did)
            );
          }
        });
      }
    });
  }


  ngOnDestroy(){
    this.viewnumber.nativeElement.click();
  }

}
