import { Component, OnInit } from '@angular/core';
import { ActivatedRoute, ParamMap, Router } from '@angular/router';
import { UsermanagementService } from '../usermanagement.service';

@Component({
  selector: 'app-customer-count',
  templateUrl: './customer-count.component.html',
  styleUrls: ['./customer-count.component.css']
})
export class CustomerCountComponent implements OnInit {
  idaccount: any;
  iduser: string;
  BrandData: any;
  Campaign: any;
  connection: any;
  tarrif: any;
  stripeCard: any;
  subcustomer: any;
  BillindAddres: any;
  wallet: any;
  Suspended: any;
  DID: any;
  isLoading: boolean = false;
  reseller: any;
  errMessage: any = "";
  responseMessage = "";



  constructor(public router: Router, private route: ActivatedRoute, public data: UsermanagementService) { }

  ngOnInit(): void {

    this.route.paramMap.subscribe((params: ParamMap) => {
      this.idaccount = parseInt(params.get('idaccount'));
      this.iduser = params.get('iduser');
      this.CustomerCount()
    });

  }

  CustomerCount() {
    this.isLoading = true;
    let data: any = JSON.stringify({
      iduser: this.iduser,
      idaccount: this.idaccount
    })
    this.data.getCustomerCount(data).subscribe((res) => {
      if (res.status == 201) {
        this.BrandData = res.data
        this.Campaign = res.data2
        this.connection = res.data3
        this.tarrif = res.data4
        this.subcustomer = res.data5
        this.stripeCard = res.data6
        this.BillindAddres = res.data7
        this.wallet = res.data8
        this.Suspended = res.data9
        this.DID = res.data10
        this.reseller = res.data11
        this.responseMessage = res.message
        this.isLoading = false;
        setTimeout(() => {
          this.responseMessage = ""
        }, 5000);
      } else {
        this.errMessage = res.message
        this.isLoading = false;
        setTimeout(() => {
          this.errMessage = ""
        }, 5000);
      }
    })
  }
}
