import { Component, OnInit, ViewChild, Input, ElementRef } from '@angular/core';
import { FormBuilder, FormControl, FormGroup, Validators } from '@angular/forms';
import { ActivatedRoute, Router } from '@angular/router';
import { UsermanagementService } from '../usermanagement.service';
declare var $: any;

@Component({
  selector: 'app-domain-blocker',
  templateUrl: './domain-blocker.component.html',
  styleUrls: ['./domain-blocker.component.css']
})
export class DomainBlockerComponent implements OnInit {
  @ViewChild('ipaddressmodals') ipaddressmodals: ElementRef;
  public domainForm: FormGroup;
  submitted: boolean = false;
  responseMessage = "";
  @ViewChild('closebutton') closebutton;
  errMessage: any;
  domainInfo: any;
  modeltext: string = '';
  messs: string ='';
  saveDomain :any = 'Submit';
  @ViewChild('closeModal') private closeModal: ElementRef;
  originalDomenId: any ='';
  domenIdToUpdate : any

  constructor(public data: UsermanagementService, public fb: FormBuilder, private route: ActivatedRoute, public router: Router,) { }

  ngOnInit(): void {
    this.domainForm = this.fb.group({
      ip: ['', [Validators.pattern('(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)')]],
      email: ['', [Validators.pattern("^([A-Za-z0-9._%+-]+)@([A-Za-z0-9-]+\\.[A-Za-z]{2,10})(\\.[A-Za-z]{2,10})?$")]],
      specific_domain: ['', [Validators.pattern('^(?!-)[A-Za-z0-9-]+([\\-\\.]{1}[a-z0-9]+)*\\.[A-Za-z]{2,6}$')]],
      first_name: [''],
      last_name: [''],
      contact: [''],
      domen_id: ['']
    })
    this.getDomenlist();
  }

  onKeyPress(event: any) {
    this.messs='';
  }

  blankMsg(event: any) {
    this.messs='';
    this.domainForm.reset({
      domen_id: this.originalDomenId 
    });
  }

  getDomenlist() {
    this.data.getDomainBlock().subscribe(res => {
      if (res.status == 200) {
        this.domainInfo = res.data;
        $("#basic-datatabless12").DataTable().clear();
        $("#basic-datatabless12").DataTable().destroy();
        $.getScript('./assets/table.js');
      } else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    });
  }

  showdata(data: any) {
    this.onClose()
    this.modeltext = 'Add Domain Block',
    this.saveDomain='Submit';
    if (data.domain_block_id) {
      this.modeltext = 'Edit Domain Block';
      this.saveDomain='Update'; 
      this.domainForm.patchValue({
        ip: data.ip_address,
        email: data.email,
        specific_domain: data.domain_name,
        first_name: data.first_name,
        last_name: data.last_name,
        contact: data.contact,
        domen_id: data.domain_block_id
      });
      this.domenIdToUpdate = data.domain_block_id;
    }
    else {
      //reset form
    }
  }

  onsubmit() {
    if (this.domainForm.invalid) {
      this.submitted = true;
      // this.submitted = false;
      return;
    }
    else {
      if(this.domainForm.value.ip || this.domainForm.value.email || 
        this.domainForm.value.specific_domain || this.domainForm.value.first_name || this.domainForm.value.last_name || this.domainForm.value.contact)
        {
          
          this.domainForm.value.ip= this.domainForm.value.ip==null?'':this.domainForm.value.ip ;
          this.domainForm.value.email= this.domainForm.value.email==null?'':this.domainForm.value.email ;
          this.domainForm.value.specific_domain= this.domainForm.value.specific_domain==null?'':this.domainForm.value.specific_domain ;
          this.domainForm.value.first_name= this.domainForm.value.first_name==null?'':this.domainForm.value.first_name ;
          this.domainForm.value.last_name= this.domainForm.value.last_name==null?'':this.domainForm.value.last_name ;
          this.domainForm.value.contact= this.domainForm.value.contact==null?'':this.domainForm.value.contact ;
          if (this.domenIdToUpdate) {
            this.domainForm.value.domen_id = this.domenIdToUpdate;
            this.data.updateDomainBlock(this.domainForm.value).subscribe(res => {
              if (res.status == 200) {
                this.responseMessage = res.message;                
                setTimeout(() => {
                  this.responseMessage = "";
                }, 3000);
                document.getElementById("add-domain").click();
                this.getDomenlist();
                this.domainForm.reset();
                this.closeModal.nativeElement.click();
              }
              else {
                this.errMessage = res.message;
                setTimeout(() => {
                  this.errMessage = "";
                }, 3000);
              }
            })
          }
          else 
         {   
          this.saveDomain='Submit';     
          this.data.saveDomainBlock(this.domainForm.value).subscribe(res => {
            if (res.status == 200) {
              this.responseMessage = res.message;             
              setTimeout(() => {
                this.responseMessage = "";
              }, 3000);
              document.getElementById("add-domain").click();
              this.getDomenlist();
              this.domainForm.reset();
              this.closeModal.nativeElement.click();
            }
            else {
              this.errMessage = res.message;
              setTimeout(() => {
                this.errMessage = "";
              }, 3000);
            }
          })
         }
        }
        else{
          this.messs="Please Enter atleast 1 field!";
        }
     
    }
  }

  onClose() {
    this.domainForm.reset();
    this.messs='';
  }

  deleteDomen(id: any) {
    if (confirm("Are you sure you want delete data!")) {
      this.data.onDeleteDomainBlock(id).subscribe(res => {
        if (res.status == 201) {
          this.responseMessage = res.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 3000);
          this.getDomenlist();
        }
        else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          });
        }
      }, error => {
        this.responseMessage = error.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 3000);
      });
    }
    else {
      return
    }
  }
  ngOnDestroy() {
    this.ipaddressmodals.nativeElement.click();
  }
}
