import { Component, OnInit } from '@angular/core';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import { ActivatedRoute, ParamMap, Router } from '@angular/router';

@Component({
  selector: 'app-account-message',
  templateUrl: './account-message.component.html',
  styleUrls: ['./account-message.component.css']
})
export class AccountMessageComponent implements OnInit {
  iduser: string;
  kyc_status: any;
  idaccount: any;
  sesiduser: any;
  federal_status: any;

  constructor(protected userSerive: UsermanagementService, public router: Router,) { }

  ngOnInit(): void {
    let isLoggedIn = sessionStorage.getItem("isLoggedIn");
    this.sesiduser = JSON.parse(isLoggedIn);
    this.idaccount = this.sesiduser.idaccount;
    this.iduser = this.sesiduser.iduser;
    this.userSerive.getSingleUsers().subscribe(res => {
      // To KYC Status
      this.kyc_status = res.data1[0].kyc_verify_status;     
      this.federal_status = res.data1[0].federal_status;

    })
  }

  redirectPage()
  {
    if(this.kyc_status==1)
    {
      this.router.navigate(['/dashboards'])
          .then(() => {
            location.reload();
          })
    }
    else{
      this.router.navigate(['user/account-action'])
      .then(() => {
        location.reload();
      })
    }
   
  }

  federalRoute()
  {
    if(this.federal_status==0 || this.federal_status==3 || this.federal_status==4)
    {
      this.router.navigate(['/federal/federal'])
          .then(() => {
            location.reload();
          })
    }
    else{
      this.router.navigate(['federal/federal-details'])
      .then(() => {
        location.reload();
      })
    }
  }

}
