import { NgModule } from '@angular/core';
import { CommonModule, DatePipe } from '@angular/common';
import { ReactiveFormsModule } from '@angular/forms';
import { BillingRoutingModule } from './billing-routing.module';
import { InvoicesComponent } from './invoices/invoices.component';
import { BillingprofileComponent } from './billingprofile/billingprofile.component';
import { CurrentusageComponent } from './currentusage/currentusage.component';
import { CdrftpComponent } from './cdrftp/cdrftp.component';
import { AccountledgerComponent } from './accountledger/accountledger.component';
import { NgbModule } from '@ng-bootstrap/ng-bootstrap';
import { PaymentsettingsComponent } from './paymentsettings/paymentsettings.component';
import { RatedecksComponent } from './ratedecks/ratedecks.component';
import { OutboundcdrftpComponent } from './outboundcdrftp/outboundcdrftp.component';
import { Ng2SearchPipeModule } from 'ng2-search-filter';
import { OrderhistoryComponent } from './orderhistory/orderhistory.component';
import { FormsModule } from '@angular/forms';
import { NgxPaginationModule } from 'ngx-pagination';
// import { ListpaymentComponent } from './listpayment/listpayment.component';
import { DemoMaterialModule } from '../demo-material-module';
import { SharedModule } from '../shared/shared.module';
import { BillingAddressComponent } from './billing-address/billing-address.component';
import { ViewbillingComponent } from './viewbilling/viewbilling.component';
import { FloorDecimal } from './decimal.pipe';
import { DateFormatPipe } from './datepipe.pipe';
import { OrderPipe } from './orderPipe.pipe';
import { StripeCardComponent } from './stripe-card/stripe-card.component';
import { DetailcustomercardComponent } from './detailcustomercard/detailcustomercard.component';

@NgModule({
  declarations: [InvoicesComponent, OrderhistoryComponent, BillingprofileComponent, 
                CurrentusageComponent, CdrftpComponent, AccountledgerComponent,  
                PaymentsettingsComponent, RatedecksComponent, OutboundcdrftpComponent, 
                BillingAddressComponent, ViewbillingComponent, FloorDecimal, DateFormatPipe,OrderPipe, StripeCardComponent, DetailcustomercardComponent],
  imports: [
    CommonModule,
    BillingRoutingModule,
    ReactiveFormsModule,
    Ng2SearchPipeModule,
    FormsModule,
    NgbModule,
    NgxPaginationModule,
    DemoMaterialModule,
    SharedModule,
  ],
  exports: [
    BillingAddressComponent
],
  providers:[DatePipe,OrderPipe]
})
export class BillingModule { }
