
import {Pipe, PipeTransform } from '@angular/core';

@Pipe({ name: 'decimal'})

export class FloorDecimal implements PipeTransform {
    
    transform(value: any):string {
        if(value == null || value == undefined){
            return "";
        } else if (value < 0 || isNaN(Number(value))) {
            return "0";
        }
        else{
            return value.toFixed(4);
        }
    }
}