import { Component } from '@angular/core';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { FormBuilder, FormControl, FormGroup, Validators } from '@angular/forms';
import { ActivatedRoute, ParamMap, Router } from '@angular/router';
import { CampaignsService } from '../campaigns.service';
import { IDropdownSettings } from 'ng-multiselect-dropdown';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';

@Component({
  selector: 'app-addbrand',
  templateUrl: './addbrand.component.html',
  styleUrls: ['./addbrand.component.css']
})

export class AddbrandComponent extends AppComponentClass<any, any> {
  isLinear: Boolean = false;
  brandRelationForm: FormGroup;
  contactForm: FormGroup;
  public submitted1: boolean = false;
  public brandForm: FormGroup;
  responseMessage: any;
  brand: any;
  brandVertical: any;
  brandType: any;
  isRegister: Boolean = false;
  register: any;
  companyData: any = [];
  
	brandRelationship: any = [];
	altBusinessIdType: any = [];
  country: any = [];
  strategy: IDropdownSettings = {};
  errMessage: any = "";
  selectedItems: any = [];
  submitted2: Boolean = false;
  submitted3: Boolean = false;
  submitted4: Boolean = false;

  constructor(public data: CampaignsService, public router: Router, private userService: UsermanagementService, 
              public fb: FormBuilder,  private route: ActivatedRoute)
  {

  super(data, router, fb);
  }

  ngOnInit(): void {

    this.strategy = {
      singleSelection: true,
      idField: 'id',
      textField: 'name',
      itemsShowLimit: 2,
      allowSearchFilter: true
    };

    this.country = [
      {id: 1, name: "US" },
      {id: 2, name: "Canada"}
    ]

    this.userService.companyProfile().subscribe(res => {
      if(res.data.length > 0){
          this.companyData = res.data[0];
            this.brandForm.patchValue({
              idcompany: res.data[0].idcompany,
              company_name: res.data[0].company_name,
              street: res.data[0].address,
              city: res.data[0].city,
              state:res.data[0].state,
              postalCode: res.data[0].postal_code,
              ein: res.data[0].ein,
              phone: res.data[0].phone,
              email: res.data[0].email,
              website: res.data[0].website,
            });
            this.selectedItems = [res.data[0].country];
        }
    });

     this.route.paramMap.subscribe((params: ParamMap) => {
      this.register = params.get('id');
      if(this.register !== "register"){
        this.isRegister = false;
        this.brandForm = this.fb.group({
          brand_key: new FormControl('', [Validators.required]),
          companyName: new FormControl('', [Validators.required]),
        });
      }
      else{
        this.isRegister = true;
        this.brandForm = this.fb.group({
          companyName: new FormControl('', [Validators.required]),
          displayName: new FormControl('', [Validators.required]),
          entityType: new FormControl('', [Validators.required]),
          ein: new FormControl('', [Validators.required]),
          phone: new FormControl('', [Validators.required]),
          country: new FormControl('', [Validators.required]),
          email: new FormControl('', [Validators.required]),
          street: new FormControl('', [Validators.required]),
          city: new FormControl('', [Validators.required]),
          state: new FormControl('', [Validators.required]),
          postalCode: new FormControl('', [Validators.required]),
          website: new FormControl('', [Validators.required]),
          vertical: new FormControl('', [Validators.required]),
          brandRelationship: new FormControl('', [Validators.required])
        });
      }
    });
    // firstName: new FormControl('', [Validators.required]),
    // lastName: new FormControl('', [Validators.required])
    
	this.data.brandRelationship().subscribe(res => {
		 if(res.status == 200){
      this.brandRelationship = res.data;
     }
     else{
       this.errMessage = res.message;
       setTimeout(() => {
         this.errMessage = "";
       });
     }
	});

	this.data.altBusinessIdType().subscribe(res => {
		this.altBusinessIdType = res.data.slice(1, 4);
	});

	this.data.brandVertical().subscribe(res => {
		let tmp:any=[];
		Object.entries(res.data).forEach((ele:any)=>{
			let t=ele[1];
			t["name"]=ele[0];
			tmp.push(t);
		});
		this.brandVertical = tmp;
	});
  
	this.data.brandEntityType().subscribe(res => {
		this.brandType = res.data;
	});

  this.data.getBrands().subscribe(res => {
    this.brand = res;
  });

  this.data.brandVertical().subscribe(res => {
    let tmp:any=[];
    Object.entries(res.data).forEach((ele:any)=>{
      let t=ele[1];
      t["name"]=ele[0];
      tmp.push(t);
    });
    this.brandVertical = tmp;
  });
  this.data.brandEntityType().subscribe(res => {
    this.brandType = res.data;
  });
  }

  onSaveBrand(){
    this.submitted2 = true;
    console.log(this.brandForm);
      if(this.brandForm.invalid){
        return 
      }
      else{
        this.isLinear = true;
        console.log(this.brandForm.value);
      }
  }

  onSubmit() {  
	}

  onAddBrand(){
    this.submitted1 = true;
    if(this.brandForm.invalid){
      return 
    }
    else{
      this.data.onAddBrand(this.brandForm.value).subscribe(response => {
        if(response.status == 201){
          this.responseMessage = response.message;  
          this.router.navigateByUrl('/campaigns/brands');
          setTimeout(()=>{
            this.responseMessage= "";
          }, 5000);
        }
        else{
          this.errMessage = response.message;  
            setTimeout(()=>{
              this.errMessage= "";
            }, 5000);
        }
      });
    }
  }
}
