import { Injectable } from '@angular/core';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Observable } from 'rxjs';
import { AppService } from 'src/app/shared/service/AppService.class';
import { environment } from 'src/environments/environment';
import { LoaderEnabled } from '../shared/loader/loader.service';

@Injectable({
  providedIn: 'root'
})

export class CampaignsService extends AppService<any> {

  httpHeaders: any = new HttpHeaders({
    "Content-Type": "application/json"
  });

  constructor(public http: HttpClient) {
    super(http)
   }


   @LoaderEnabled()
   brandDCA(): Observable<any>{
     this.appmod = "brandDCA";
     let result = super.getService();
     this.appmod = "";
     return result;
   }

   @LoaderEnabled()
   brandRelationship(): Observable<any>{
     this.appmod = "brandRelationship";
     let result = super.getService();
     this.appmod = "";
     return result;
   }

   @LoaderEnabled()
   brandVettingClass(): Observable<any>{
     this.appmod = "vettingClass";
     let result = super.getService();
     this.appmod = "";
     return result;
   }
 
   @LoaderEnabled()
  brandEntityType(): Observable<any>{
    this.appmod = "brandEntity";
    let result = super.getService();
    this.appmod = "";
    return result;
  }
  
  @LoaderEnabled()
  brandVertical(): Observable<any>{
    this.appmod = "brandVertical";
    let result = super.getService();
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  altBusinessIdType(): Observable<any>{
    this.appmod = "altBusinessIdType";
    let result = super.getService();
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getSinglebrand(brandId): Observable<any> {
    this.appmod = "brand";
    let result = super.getService(brandId);
    this.appmod = "";
    return result;
  }

   @LoaderEnabled()
   getBrand(): Observable<any> {
      this.appmod = 'getbrands';
      let result = super.getService();
      this.appmod = "";
      return result;
   }

   @LoaderEnabled()
   onAddBrand(data: any): Observable<any> {
      let apiURL = environment.SERVER+ "addbrand";
      return this.http.post(apiURL, data, { headers: this.httpHeaders });
   }

   @LoaderEnabled()
   onBrandRegister(data: any): Observable<any> {
      let apiURL = environment.SERVER+ "registerbrand";
      return this.http.post(apiURL, data, { headers: this.httpHeaders });
   }

   
   @LoaderEnabled()
   onGetCampaign(): Observable<any> {
    this.appmod = 'campaignsList';
    let result = super.getService();
    this.appmod = "";
    return result;
   }

   @LoaderEnabled()
   onGetCampaigns(brandId): Observable<any> {
    this.appmod = 'brandCampaign';
    let result = super.getService(brandId);
    this.appmod = "";
    return result;
   }

   @LoaderEnabled()
   onAddCampaign(data: any): Observable<any> {
    let apiURL = environment.SERVER+ "addcampaign";
    return this.http.post(apiURL, data, { headers: this.httpHeaders });
   }

   @LoaderEnabled()
   onRegisterCampaign(data: any): Observable<any> {
    let apiURL = environment.SERVER+ "registercampaign";
    return this.http.post(apiURL, data, { headers: this.httpHeaders });
   }

   @LoaderEnabled()
   onDeleteCampaign(data: any): Observable<any> {
    this.appmod = 'deletecampaign';
    let result = super.deleteService(data);
    this.appmod = "";
    return result;
   }

   @LoaderEnabled()
   getCampaignCases(): Observable<any> {
     this.appmod = "campcases";
     let result = super.getService();
     this.appmod = "";
     return result;
   }

   getBrands():Observable<any>{
    return this.http.get('./assets/brand.json');
  }

   get_mycampaign():Observable<any>{
    return this.http.get('./assets/mycampaign.json')
  }


  get_brands():Observable<any>{
    return this.http.get('./assets/brands.json')
  }


}
