import { Component, Input, OnInit } from '@angular/core';
import { FormBuilder, FormGroup } from '@angular/forms';
import { Router } from '@angular/router';
import { Store } from '@ngrx/store';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { Cart, gettollfreenumbers, gettollfreenumbersForm } from '../inbound.class';
import { InboundService } from '../inbound.service';
import * as fromInbound from "../inbound.reducer";
import * as inboundAction from '../inbound.action';
import { BehaviorSubject, Observable, Subscription } from 'rxjs';
import { CapmaignserviceService } from 'src/app/campaign/capmaignservice.service';
import { ConnectionsService } from 'src/app/connections/connections.service';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
declare var $: any;

@Component({
	selector: 'app-tollfreenumbers',
	templateUrl: './tollfreenumbers.component.html',
	styleUrls: ['./tollfreenumbers.component.css']
})

export class TollfreenumbersComponent extends AppComponentClass<gettollfreenumbers, gettollfreenumbersForm>  {
	searchText = { count: 0 };
	filtre: string;
	viewMode: any;
	rowdata: any;
	label: any;
	label1: any;
	listdata: any[];
	list1: any;
	p: number = 1;
	value: any;
	page = 1;
	count = 0;
	tableSize = 25;
	tableSizes = [25, 50, 100];
	filterTerm: string
	//public inbound: any[];
	label2: any;
	public value1: any;
	public gettollfreenumbersForm: FormGroup;
	public submitted: boolean = false;
	public show: boolean = false;
	public show1: boolean = false;
	headers: any;
	tollFreeDids: any = [];
	responseMessage = "";
	tfSucsMessage = "";
	errMessage: any = "";
	counter$: Observable<Cart[]>
	selectedDid: any = [];
	isSelected$ = new BehaviorSubject<Boolean>(false);
	isSelected = this.isSelected$.asObservable();
	isSelect$ = new BehaviorSubject<Boolean>(false);
	isSelect = this.isSelected$.asObservable();
	iselectAll: boolean;
	isDisabled: boolean;
	showTab: string;
	subscription: Subscription;
	isCartText: string;
	cartDid: any = [];
	selectedDIDCount: any;
	withoutcartDid: any = [];
	connectionLists: any;
	singleConnection: any;
	connectionKeyVal: any;
	connectionKey$ = new BehaviorSubject<any>("");
	connection = this.connectionKey$.asObservable();
	connectionValue = "";
	inboundKey$ = new BehaviorSubject<any>("");
	inbound = this.inboundKey$.asObservable();
	inboundValue = "";
	outboundKey$ = new BehaviorSubject("");
	outbound = this.outboundKey$.asObservable();
	outboundValue = "";
	campaign$ = new BehaviorSubject<string>("");
	campaign = this.campaign$.asObservable();
	campaignValue = "";
	tfMstatus: any = 0;
	isDisabledServiceStatus: boolean;
	serviceMessage:any ="Did Buy service has been suspended. More information please contact support";
	featureServiceData: any;
	//@Input() isTollFree: Boolean = false;

	constructor(private connectionService: ConnectionsService, private campService: CapmaignserviceService, public data: InboundService,public userService: UsermanagementService, public router: Router, public fb: FormBuilder,
		private store: Store<fromInbound.inboundState>) {
		super(data, router, fb);
	}

	ngAfterViewInit(): void {
		this.selectedDIDCount = '';
		this.campService.onGetCampaign().subscribe(res => {
			if (res.status == 200) {
				this.campaign$.next(res.data);
			}
			else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		});

		this.data.getconnection().subscribe(res => {
			this.connectionLists = res.data;
			this.connectionKey$.next(this.connectionLists);
		});
		this.data.singleConnections().subscribe(res => {
			this.singleConnection = res.data;
			this.connectionKeyVal = this.singleConnection[0].connection_key;
			this.connectionValue = this.connectionKeyVal;
			let connection = this.connectionLists.filter(item => {
				if (item.connection_key == this.connectionValue) {
					return item.idendpoint
				}
			});

			this.connectionService.getInbound(this.singleConnection[0].idendpoint).subscribe(res => {
				this.singleConnection[0].name = connection[0].name;
				this.inboundValue = res.data[0].inbound_key;
			});
			this.connectionService.getOutbound(this.singleConnection[0].idendpoint).subscribe(res => {
				this.singleConnection[0].name = connection[0].name;
				this.outboundValue = res.data[0].outbound_key;
			});
			this.campaignValue = '';
		});
	}

	ngOnInit(): void {
		this.userService.getfeatureServiceStatus().subscribe(res => {
			this.featureServiceData = res.data.find(x => x.fs_id == '5');
			if(this.featureServiceData!==undefined && this.featureServiceData.as_status==1)
			{
			 this.isDisabledServiceStatus=false;
			   
			}else{
			 this.isDisabledServiceStatus=true;
			 this.showMsg();
			}
			 
		   });
		this.cartDid = [];
		this.selectedDIDCount = '';
		this.withoutcartDid = [];
		$('#basic-datatables').DataTable().clear();
		$('#basic-datatables').DataTable().destroy();
		$.getScript('./assets/table.js');
		this.showTab = '2';
		this.iselectAll = false;
		this.isDisabled = true;
		this.counter$ = this.store.select(fromInbound.getCartItems);

		this.data.solution.subscribe(res => {
			if (res != null) {
				this.cdata = new gettollfreenumbersForm(res);
				this.keyfield = res.id;
				this.gettollfreenumbersForm = this.cdata.makeform(this.fb);
			} else {
				this.cdata = new gettollfreenumbersForm(null);
				this.keyfield = -1;
				this.gettollfreenumbersForm = this.cdata.makeform(this.fb);
			}
		});

		this.data.getnumber().subscribe((result) => {
			this.label = result[1];
			this.list1 = result[0].list;
			this.headers = result[0].headers_details1;
			this.rowdata = result[0].product_details;
			this.label2 = result[2];
		});
	}

	get f() { return this.gettollfreenumbersForm.controls; };

	generateUniqueOrder(): any {
		let iUD: any = "SOD" + String(new Date().getTime())
		return iUD;
	}

	onTollFree(): any {
		this.showTab = '2';
		this.isDisabled = false;
		this.iselectAll = false;
		this.submitted = true;
		if (this.gettollfreenumbersForm.invalid) {
			return;
		}
		else {
			this.tollFreeDids = [];
			this.cartDid = [];
			this.withoutcartDid = [];
			$('#basic-datatables').DataTable().clear();
			$('#basic-datatables').DataTable().destroy();

			let __GOpayload: any = {
				name: this.generateUniqueOrder(),
				total_dids: this.gettollfreenumbersForm.value.Qty,
				numbers: '',
				routing: this.connectionValue,
				in_routing: this.inboundValue,
				out_routing: this.outboundValue,
				campaign: this.campaignValue
			}
			this.data.CreateGroupOrder(__GOpayload).subscribe(res => {
				if (res.error == 0) {
					let id_grouporder: number = res.data.id_grouporder
					if (this.cdata.saveForm(this.gettollfreenumbersForm)) {
						let payload: any = {
							cdata: this.cdata,
							groupId: id_grouporder
						}
						this.data.onTfRequest(payload).subscribe(response => {
							if (response.status == 200) {
								this.tfMstatus = 1;
								this.tollFreeDids = response.data;
								$.getScript('./assets/table.js');
								// this.responseMessage = response.message;
								this.tfSucsMessage = response.message;
								setTimeout(() => {
									this.tfSucsMessage = "";
									document.getElementById("closeOrderPlace").click();
									this.gettollfreenumbersForm.reset();
									this.tfMstatus = 0;
								}, 5000);
							}
							else {
								this.errMessage = response.message;
								setTimeout(() => {
									this.errMessage = "";
									document.getElementById("closeOrderPlace").click();
								}, 5000);
							}
						});
					}
				}
				else {
					this.errMessage = res.message
					setTimeout(() => {
						this.errMessage = "";
						document.getElementById("closeOrderPlace").click();
					}, 5000);
				}
			}, err => {
				this.errMessage = "Something went wrong with DID Buy process. Please Try again"
				setTimeout(() => {
					this.errMessage = "";
					document.getElementById("closeOrderPlace").click();
				}, 5000);
			})			
		}
	}


	onSelectDid(event, did, idx) {
		this.showTab = '2';
		this.isDisabled = false;
		this.iselectAll = false;
		if (event.target.checked) {
			this.counter$.subscribe((res: any) => {
				if (res.length > 0) {
					var dids = res.map((item) => { return item.did });
					var isDuplicate = dids.some(function (item, idx) {
						return item == did.phone_number
					});
					if (isDuplicate) {
						return this.Exist(event);
					}
					else {
						return this.selectedDid.push({ phone_number: did.phone_number, disable: did.disable, provider: did.provider });
					}
				}
				else {
					return this.selectedDid.push({ phone_number: did.phone_number, disable: did.disable, provider: did.provider });
				}
			});
			this.selectedDIDCount = this.selectedDid.length;
		}
		else {
			if (this.selectedDid.length > 0) {
				//let index = this.selectedDid.indexOf(did.phone_number);
				//this.selectedDid.splice(index, 1);
				this.selectedDid.forEach((value, index) => {
					if (value.phone_number == did.phone_number)
						this.selectedDid.splice(index, 1);
				});
				this.selectedDIDCount = this.selectedDid.length;
			}

		}
		if (Array.isArray(this.selectedDid) && this.selectedDid.length > 0) {
			this.isSelected$.next(true);
			this.iselectAll = true;
		}
		else {
			this.isSelected$.next(false);
			this.iselectAll = false;
			this.selectedDIDCount = '';
		}
		if (this.selectedDid.length == this.withoutcartDid.length) {
			this.isSelect$.next(true);
			this.iselectAll = true;
		}
		else {
			if (this.selectedDid.length == this.tollFreeDids.length) {
				this.isSelect$.next(true);
				this.iselectAll = true;
			} else {
				this.isSelect$.next(false);
				this.iselectAll = false;
			}
		}
	}

	async onSelectAll(event) {
		this.showTab = '2';
		this.isDisabled = false;
		this.subscription = this.counter$.subscribe((res: any) => {
			if (event.target.checked) {
				this.selectedDid = [];
				this.tollFreeDids.forEach((element, idx) => {
					if (res.length > 0) {
						var dids = res.map((item) => {
							return item.did
						});
						var isDuplicate = dids.some(function (item, idx) {
							return item == element.phone_number
						});
						if (isDuplicate) {
							element.isCart = false;
							element.isCartText = 'Already in Cart';
							element.isDisabledSingle = true;
						}
						else {
							this.isCartText = '';
							element.isCart = true;
							element.isDisabledSingle = false;
							this.selectedDid.push({ phone_number: element.phone_number, disable: "false", provider: element.provider });
						}
					}
					else {
						this.isCartText = '';
						element.isCart = true;
						element.isDisabledSingle = false;
						this.selectedDid.push({ phone_number: element.phone_number, disable: "false", provider: element.provider });
					}
					this.selectedDIDCount = this.selectedDid.length;
				});
				this.selectedDIDCount = this.selectedDid.length;
			}
			else {
				this.selectedDid = [];
				this.tollFreeDids.map((item: any) => {
					item.isCart = false;
					return item;
				});
			}
		});
		if (this.selectedDid.length == this.withoutcartDid.length) {
			this.isSelect$.next(true);
			this.iselectAll = true;
		}
		else {
			this.isSelect$.next(false);
			this.iselectAll = false;
		}
		if (Array.isArray(this.selectedDid) && this.selectedDid.length > 0) {
			this.isSelected$.next(true);
			this.iselectAll = true;
		}
		else {
			this.isSelected$.next(false);
			this.iselectAll = false;
			this.selectedDIDCount = '';
		}
	}
	onResetDID() {
		this.showTab = '2';
		this.iselectAll = false;
		this.isDisabled = true;
		this.selectedDid = [];
		$('#basic-datatables').DataTable().clear();
		$('#basic-datatables').DataTable().destroy();
		$.getScript('./assets/table.js');

	}
	addToCart() {
		this.showTab = '2';
		this.iselectAll = false;
		$('#basic-datatables').DataTable().clear();
		$('#basic-datatables').DataTable().destroy();
		$.getScript('./assets/table.js');
		this.data.onAddAllToCart(this.selectedDid).subscribe(res => {
			if (res.status == 201) {
				this.isDisabled = true;
				this.store.dispatch(new inboundAction.Add(this.selectedDid));
				// this.selectedDid.forEach((el, idx1) => {
				// 	this.tollFreeDids.filter((ele, idx2) => {
				// 	  if(el.phone_number == ele.phone_number){
				// 		  this.tollFreeDids.splice(idx2, 1);
				// 	  }
				// 	});
				// });
				this.subscription = this.counter$.subscribe((res: any) => {
					this.tollFreeDids.forEach((element, idx) => {
						if (res.length > 0) {
							var dids = res.map((item) => {
								return item.did
							});
							var isDuplicate = dids.some(function (item, idx) {
								return item == element.phone_number
							});
							if (isDuplicate) {
								element.isCart = false;
								element.isCartText = 'Already in Cart';
								element.isDisabledSingle = true;
								this.cartDid.push({ did: element.phone_number });
							}
							else {
								this.isCartText = '';
								element.isCart = false;
								element.isDisabledSingle = false;
								this.withoutcartDid.push({ phone_number: element.phone_number, disable: "false", provider: element.provider });
							}
						}
						else {
							this.isCartText = '';
							element.isCart = false;
							element.isDisabledSingle = false;
						}
					});
				});
				if (this.selectedDid.length == this.tollFreeDids.length) {
					this.isSelect$.next(true);
					this.iselectAll = true;
				}
				else {
					this.isSelect$.next(false);
					this.iselectAll = false;
				}
				this.isSelected$.next(false);
				this.isSelect$.next(false);
				this.selectedDid = [];
				this.responseMessage = res.message;
				setTimeout(() => {
					this.responseMessage = "";
				}, 5000);
				window.location.reload();
			}
			else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		});
	}


	changed(i) {
		console.log(i);
	}

	Exist(event) {
		event.target.checked = false;
		this.errMessage = "This DID already in cart";
		setTimeout(() => {
			this.errMessage = "";
		}, 3000);
	}
	ExistAll(event) {
		event.target.checked = false;
		this.errMessage = "Some DID already in cart";
		setTimeout(() => {
			this.errMessage = "";
		}, 3000);
	}
	onDestroy(): void {
		this.subscription.unsubscribe();
	}
	showMsg()
	{
		this.errMessage = this.serviceMessage;
		setTimeout(() => {
			this.errMessage = "";
		}, 5000);
	}
}
