import { Component, OnInit, ElementRef, Renderer2, ViewChild } from '@angular/core';
import { NewCamapignService } from '../new-camapign.service';
import { FormBuilder, FormGroup, FormArray, Validators, ValidatorFn, AbstractControl, ValidationErrors } from '@angular/forms';
import { Router, ActivatedRoute } from '@angular/router';
import { element } from 'protractor';
import { environment } from 'src/environments/environment';
import { HttpClient, HttpRequest } from '@angular/common/http';
declare var $: any;
// import { log } from 'console';
@Component({
	selector: 'app-newcampaign-details',
	templateUrl: './newcampaign-details.component.html',
	styleUrls: ['./newcampaign-details.component.css']
})
export class NewcampaignDetailsComponent implements OnInit {
	@ViewChild('closeModal') private closeModal: ElementRef;
	@ViewChild('showbutton') showbutton;
	@ViewChild('toggleButton') toggleButton: ElementRef;
	@ViewChild('menu') menu: ElementRef;
	@ViewChild('campaignresubmissionmodal') campaignresubmissionmodal: ElementRef;
	@ViewChild('resubmissionmodel') resubmissionmodel: ElementRef;
	@ViewChild('deactivatedmodal') deactivatedmodal: ElementRef;
	@ViewChild('campaignsDetailmodals') campaignsDetailmodals: ElementRef;
	@ViewChild('samplemessagesmodals') samplemessagesmodals: ElementRef;
	@ViewChild('deletefileconfirmationmodals') deletefileconfirmationmodals: ElementRef;
	// @ViewChild('toggle1') toggle1: ElementRef;
	// @ViewChild('sub') sub: ElementRef;
	public yes: boolean = false;
	openeye: boolean = false;
	outoption: boolean = false;
	opthelp: boolean = false;
	open_optout: boolean = false;
	open_opthelp: boolean = false;
	menushow: boolean = false;
	renew_no: boolean = false;
	listmix: boolean = false;
	campaignForm: FormGroup;
	campaignMnoForm: FormGroup;
	// disabled = false;
	submitted: boolean = false;
	campaignMno: any = [];
	responseMessage: any;
	errMessage: any;
	campaingn_keyId: any;
	CampaignkeyID: any = [];
	campaigns: any = [];
	CkeyID: any;
	BID: any;
	Cdate: any;
	Ucase: any;
	Subcase: any = [];
	AutoRenewal: boolean;
	showRenewal: any;

	camp: { first: any; second: any; };
	opt_out: { first: any; second: any; };
	opt_outhelp: { first: any; second: any; };
	campDetails: any = [];
	ischeck: boolean;
	subUsecases: any = [];
	issubscriberOptin: any;
	reqSubscriberOptout: string;
	reqSubscriberHelp: string;

	numberPool: string;
	directLending: string;
	noEmbeddedLink: string;
	noEmbeddedPhone: string;
	ageGated: string;
	termsAndConditions: string;
	autoRenewal: string;
	showRenewalVal: string;
	campMnoDetails: any;
	campaignIds: any;
	campaignIDs: any;
	renewalDate: string;
	renewalText: string;
	public mediaForm: FormGroup;
	cnpCampStatus: any;
	hideEdit: boolean = false;
	mnoIds: any = [];
	mnoButton: boolean = true;
	campMnoDetailsVal: any = [];
	// maxChars = 320;
	cDstatus: any = 0;
	cSumitstatus: any = 0;
	webHookEvent: any = [];
	eventTypeSignalmash: any = [];
	eventTypeCamapign: any = [];
	provisionName: any;
	brandId: any = '';
	checkEdit: boolean = false;
	autoRen: boolean = false;
	sesiduser: any;
	usertype: any;
	brand_name: any;
	idusers: any;
	usecase: any;
	idsForResubmit: string;
	newMnoDetails: any = [];
	currentData: any;
	newMnoData: any = [];
	resubmitMnoDetail: any = [];
	selectedFile: File[] = [];
	fileData: any;
	campaignSample: any[] = [];
	fileToDelete: any;
	displayedFilesCount: number = 0;
	resubmitMnoCheckboxHide: boolean=false;
	constructor(private campaignService: NewCamapignService, public fb: FormBuilder, private route: ActivatedRoute, public router: Router,public _http: HttpClient, private renderer: Renderer2) {
		this.renderer.listen('window', 'click', (e: Event) => {
			if (this.menushow == true) {
				if (e.target !== this.toggleButton.nativeElement && e.target !== this.menu.nativeElement) {
					this.menushow = false;
				}
			}
		});
		// this.renderer.listen('window', 'click',(e:Event)=>{
		// 	if(e.target !== this.toggle1.nativeElement && e.target!==this.sub.nativeElement){
		// 		this.subUsecases=false;
		// 	}
		// });
	}

	ngOnInit(): void {
		this.menushow = false;
		// this.subUsecases=false;
		this.campaignForm = this.fb.group({
			campaign_key: [],
			description: ['', [Validators.required, Validators.minLength(40), Validators.maxLength(4096)]],
			messageFlow: ['', [Validators.required, Validators.minLength(40), Validators.maxLength(2048)]],
			optinMessage: ['', [Validators.minLength(20)]],
			optoutMessage: ['', [Validators.required, Validators.minLength(20)]],
			helpMessage: ['', [Validators.required, Validators.minLength(20)]],
			sample1: ['', [Validators.required, Validators.minLength(20), Validators.maxLength(1024)]],
			sample2: ['', [Validators.required, Validators.minLength(20), Validators.maxLength(1024)]],
			sample3: ['', [Validators.minLength(20), Validators.maxLength(1024)]],
			sample4: ['', [Validators.minLength(20), Validators.maxLength(1024)]],
			sample5: ['', [Validators.minLength(20), Validators.maxLength(1024)]],
			autoRenewal: [true],
			review_nudge: [],
			appeal_nudge: [],
			subscriberOptin: [],
			subscriberOptout: [],
			subscriberHelp: [],
			numberPool: [],
			optinKeywords: [],
			optoutKeywords: [],
			helpKeywords: [],
			directLending: [],
			embeddedLink: [],
			embeddedPhone: [],
			ageGated: []
		});
		this.mediaForm = this.fb.group({
			fileInput: ['', Validators.required]
		})
		this.campaignMnoForm = this.fb.group({
			mnoIds: [''],

		});
		// showmenu
		//mno records
		// this.campaignService.onGetCampaignsMno().subscribe(res => {
		// 	let mnoDetail = res.data;
		// 	let length = Object.keys(mnoDetail).length;
		// 	for (let i = 0; i < length; i++) {
		// 		this.campaignMno[i] = Object.values(mnoDetail)[i];
		// 	}
		// })
		let isLoggedIn = sessionStorage.getItem("isLoggedIn");
		this.sesiduser = JSON.parse(isLoggedIn);
		this.usertype = this.sesiduser.type;

		this.CampaignkeyID = this.route.snapshot.params.id;
		this.campaignIDs = this.CampaignkeyID.split('-')[0];
		let campIds = this.CampaignkeyID.split('-')[0];
		this.idusers = this.CampaignkeyID.split('-')[1];
		this.cnpCampStatus = this.CampaignkeyID.split('-')[2];
		this.campaignIds = JSON.stringify({
			campId: campIds,
			iduser: this.idusers,
		});
		if (this.cnpCampStatus == '1') {
			this.hideEdit = false;
		}
		else {
			this.hideEdit = true;
		}
		this.campaignDetail(this.campaignIds);
		this.getCampaignMnoDetails();

		// this.campaignService.getCampaignMnoDetails(this.campaignIds).subscribe(res => {
		// console.log("response old mno details",res);
		// 	});
		this.eventLog();
		this.getCampaignFile(this.campaignIds);
	}
	getCampaignFile(campId) {
		this.campaignService.getCampaignsFileById(campId).subscribe((res) => {
			this.campaignSample = res.data;
			if(this.campaignSample.length >= 5){
				this.displayedFilesCount = 5;
				const buttonClick = document.getElementById("file");
				buttonClick.style.pointerEvents = "none";
 			}
		})
	}
	eventLog() {
		this.campaignService.getCampaignEvents(this.campaignIds).subscribe(res => {
			$('#basic-datatables13').DataTable().clear();
			$('#basic-datatables13').DataTable().destroy();
			$.getScript('./assets/table.js');
			if (res.status == 200) {
				this.webHookEvent = res.data;
				this.webHookEvent.forEach(element => {
					if (element.event_type == '29' || element.event_type == '30' || element.event_type == '31' || element.event_type == '32') {
						element['source'] = 'SIGNALMASH'
						this.eventTypeSignalmash.push(element);
					}
					else {
						element['source'] = 'CAMPAIGN'
						this.eventTypeCamapign.push(element);
					}
				});
				// this.responseMessage = res.message;
				// setTimeout(() => {
				// 	this.responseMessage = "";
				// }, 5000);
			}
			else {
				/* this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000); */
			}
		});
	}
	getCampaignMnoDetails() {
		this.mnoIds = [];
		this.campaignService.campMnoMetaDataDetails(this.campaignIds).subscribe(res => {
			if (res.status == 200) {
				this.campMnoDetails = res.data;
				this.campaignMno = [];
				if (this.campMnoDetails != undefined) {
					//this.mnoIds = Object.keys(this.campMnoDetails)
					let length = Object.keys(this.campMnoDetails).length;
					for (let i = 0; i < length; i++) {
						this.campaignMno.push({ "campMnoDetails": Object.values(this.campMnoDetails)[i], "key": Object.keys(this.campMnoDetails)[i] })
					}
					this.campaignMno.forEach(element => {
						if (element.campMnoDetails.qualify == 'true') {
							this.mnoIds.push(element.campMnoDetails.campaign_class);
						}
					});
				}
			}
			else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		})
	}

	deactiveCamp() {
		this.campaignService.DeleteNewCampaign(this.campaignIDs).subscribe(res => {
			if (res.status == 201) {
				this.cDstatus = 1;
				this.responseMessage = res.message;
				setTimeout(() => {
					document.getElementById("closeCampaignModal").click();
			     	window.location.reload()
					this.responseMessage = "";
				}, 5000);
				//this.ngOnInit();
				// this.router.navigate(['/new-campaign/campaigns']);
			} else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.errMessage = err.message;
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		})
	}

	resubmitCampaign() {
		let payLoad = JSON.stringify({
			'mnodetail': [...new Set(this.mnoIds)],
			'campId': this.campaignIDs
		})
		this.campaignService.resubmitCampaign(payLoad).subscribe(res => {
			if (res.status == 201) {
				this.cSumitstatus = 1;
				this.responseMessage = res.message;
				setTimeout(() => {
					this.responseMessage = "";
					this.cSumitstatus = 0;
				}, 5000);
			} else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
					this.cSumitstatus = 0;
				}, 5000);
			}
		})
	}
	reloadCampEvent() {
		this.ngOnInit();
	}
	getMnoVal(e: any, mnoid: any) {
		this.mnoIds = [...new Set(this.mnoIds)]
		if (e.target.checked) {
			this.mnoIds.push(mnoid);
			//   this.campaignMnoForm.patchValue({
			// 	mnoIds: this.mnoIds
			//   })
		}
		else {
			this.mnoIds.forEach((value, index) => {
				if (value == mnoid)
					this.mnoIds.splice(index, 1);
				//   this.campaignMnoForm.patchValue({
				//   mnoIds: this.mnoIds
				// })
			});
		}
		if (this.mnoIds.length <= 0) {
			this.mnoButton = false
		}
		else {
			this.mnoButton = true
		}
			
	}
	closeBtn() {
		this.ngOnInit();
	}
	campaignDetail(campId) {
		this.openeye = false;
		this.yes = false;
		this.open_optout = false;
		this.outoption = false;
		this.open_opthelp = false;
		this.opthelp = false;
		this.campDetails = [];
		this.campaignService.getCampaignsDetailId(campId).subscribe((res) => {
			if (res.status == 200) {
				this.campDetails = res.data[0];
				this.brandId = this.campDetails.brandId;
				this.usecase = this.campDetails.usecase;
				this.brand_name = this.campDetails.brand_name;
				if (this.campDetails.provisioning_status == 0) {
					this.provisionName = 'Pending Review'
				} if (this.campDetails.provisioning_status == 1) {
					this.provisionName = 'Campaign Shared'
				} if (this.campDetails.provisioning_status == 2) {
					this.provisionName = 'Provisioning Pending'
				} if (this.campDetails.provisioning_status == 3) {
					this.provisionName = 'Campaign Provisioned'
				} if (this.campDetails.provisioning_status == 4) {
					this.provisionName = ' Provisioning Failed'
				}
				if (this.campDetails.provisioning_status == 5) {
					this.provisionName = 'Customer Action Required'
				}
				// let d = new Date(this.campDetails.start_date);
				//  d.setMonth(d.getMonth() + 3);
				//  this.renewalDate=d.toISOString();
				this.renewalDate = this.campDetails.nextRenewalOrExpirationDate;
				if (this.campDetails == 'undefined' || this.campDetails == '' || !this.campDetails) {
					this.router.navigate(['/new-campaign']);
				}
				this.subUsecases = this.campDetails.subUsecases.split(',');
				if (this.campDetails.subscriberOptin || this.campDetails.subscriberOptout || this.campDetails.subscriberHelp) {
					this.campDetails.subscriberOptin == 'true' ? this.issubscriberOptin = 'true' : this.issubscriberOptin = '';
					this.campDetails.subscriberOptout == 'true' ? this.reqSubscriberOptout = 'true' : this.reqSubscriberOptout = '';
					this.campDetails.subscriberHelp == 'true' ? this.reqSubscriberHelp = 'true' : this.reqSubscriberHelp = '';
				}
				if (this.campDetails.numberPool || this.campDetails.directLending || this.campDetails.noEmbeddedLink || this.campDetails.noEmbeddedPhone || this.campDetails.ageGated || this.campDetails.termsAndConditions) {
					this.campDetails.numberPool == 'true' ? this.numberPool = 'true' : this.numberPool = 'false';
					this.campDetails.directLending == 'true' ? this.directLending = 'true' : this.directLending = '';
					this.campDetails.noEmbeddedLink == 'true' ? this.noEmbeddedLink = 'true' : this.noEmbeddedLink = '';
					this.campDetails.noEmbeddedPhone == 'true' ? this.noEmbeddedPhone = 'true' : this.noEmbeddedPhone = '';
					this.campDetails.ageGated == 'true' ? this.ageGated = 'true' : this.ageGated = '';
					this.campDetails.termsAndConditions == 'true' ? this.termsAndConditions = 'true' : this.termsAndConditions = '';
					this.campDetails.autoRenewal == 'true' ? this.showRenewalVal = "YES" : this.showRenewalVal = "NO";
					this.campDetails.autoRenewal == 'true' ? this.renewalText = "Renewal Date" : this.renewalText = "Expiration Date";
				}
				this.autoRenewal = this.campDetails.autoRenewal == 'true' ? 'true' : '';
				this.showRenewal = this.campDetails.autoRenewal == 'true' ? 'true' : '';
				this.renewalText = this.campDetails.autoRenewal == 'true' ? "Renewal Date" : "Expiration Date";
				this.campaignForm.patchValue({
					campaign_key: this.campDetails.campaign_key,
					description: this.campDetails.campaign_description,
					messageFlow: this.campDetails.messageFlow,
					optinMessage: this.campDetails.optinMessage,
					optoutMessage: this.campDetails.optoutMessage,
					helpMessage: this.campDetails.helpMessage,
					sample1: this.campDetails.sample1,
					sample2: this.campDetails.sample2,
					sample3: this.campDetails.sample3,
					sample4: this.campDetails.sample4,
					sample5: this.campDetails.sample5,
					optinKeywords: this.campDetails.optinKeywords,
					optoutKeywords: this.campDetails.optoutKeywords,
					helpKeywords: this.campDetails.helpKeywords,
					autoRenewal: this.campDetails.autoRenewal,
					subscriberOptin: this.campDetails.subscriberOptin,
					subscriberOptout: this.campDetails.subscriberOptout,
					subscriberHelp: this.campDetails.subscriberHelp,
					numberPool: this.campDetails.numberPool,
					directLending: this.campDetails.directLending,
					embeddedLink: this.campDetails.noEmbeddedLink,
					embeddedPhone: this.campDetails.noEmbeddedPhone,
					ageGated: this.campDetails.ageGated,
				});

				if (this.campDetails.identityStatus !== 'VERIFIED' && this.campDetails.usecase == 'SOLE_PROPRIETOR') {
					this.errMessage = 'Sole Proprietor brand pending OTP verification';
					setTimeout(() => {
						this.errMessage = "";
						if (this.campDetails.brand_deleted == '1') {
							this.errMessage = 'Brand not found';
							setTimeout(() => {
								this.errMessage = "";
							}, 5000);
						}
					}, 5000);
				}
				else {
					if (this.campDetails.brand_deleted == '1') {
						this.errMessage = 'Brand not found';
						setTimeout(() => {
							this.errMessage = "";
						}, 5000);
					}
				}

				if (this.campDetails.deleted == 1 || this.campDetails.provisioning_status !== 5) {
					this.campaignForm.get('numberPool').disable();
					this.campaignForm.get('directLending').disable();
					this.campaignForm.get('embeddedLink').disable();
					this.campaignForm.get('embeddedPhone').disable();
					this.campaignForm.get('ageGated').disable();
				}
				if (this.campDetails.optoutMessage == '' || this.campDetails.optoutMessage == 'false') {
					let optoutMessage: any = this.campaignForm.get('optoutMessage');
					optoutMessage.setValidators([]);
					optoutMessage.updateValueAndValidity();
				}
				if (this.campDetails.helpMessage == '' || this.campDetails.helpMessage == 'false') {
					let helpMessage: any = this.campaignForm.get('helpMessage');
					helpMessage.setValidators([]);
					helpMessage.updateValueAndValidity();
				}
				this.idsForResubmit = JSON.stringify({
					usecase: this.usecase,
					brandId: this.brandId
				});
				this.qualifyBrandByUsecase(this.idsForResubmit);
			}
			else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		})
	}
	qualifyBrandByUsecase(idsForResubmit) {
		this.resubmitMnoDetail=[];
		this.mnoIds=[];
		this.campaignService.mnoMetaDataForResubmit(idsForResubmit).subscribe(res => {
			if (res.status = 200) {
				this.newMnoData = res.data;
				let length = Object.keys(res.data).length;
				for (let i = 0; i < length; i++) {
					this.resubmitMnoDetail.push({ "campMnoDetailsNew": Object.values(res.data)[i], "key": Object.keys(res.data)[i] })
				}
				this.resubmitMnoDetail.forEach((ele:any,index:any) => {
					this.mnoIds.push(ele.key);
					this.campaignMno.forEach(element => {
						if (ele.key == element.campMnoDetails.campaign_class) {
							ele['currentMnoDetails']=element.campMnoDetails
						}
					})

				})				
			}
			else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		})
	}
	toggle() {
		var resToggle: Boolean = jQuery('#togal').is(':checked') ? true : false;
		if (resToggle == true) {
			//this.autoRen = true;
			this.campaignForm.patchValue({
				autoRenewal: true
			});
			this.detailCampaign();
			this.showRenewal = 'true';
			this.showRenewalVal = "YES"
			this.renewalText = 'Renewal Date';

		}
		else {
			//this.autoRen = true;
			this.showbutton.nativeElement.click();
			this.showRenewal = 'true';
			this.showRenewalVal = "YES"
			this.renewalText = 'Renewal Date';
		}
	}

	getAutorenewal(e) {

		if (e == true) {
			//this.autoRen = true;
			this.campaignForm.patchValue({
				autoRenewal: false
			})

			this.detailCampaign();
			this.showRenewal == 'false';
			this.showRenewalVal = "NO"
			this.renewalText = "Expiration Date";
		}
		else {
			//this.autoRen = true;
			this.campaignForm.patchValue({
				autoRenewal: true
			})
			this.showRenewal = 'true';
			this.showRenewalVal = "YES"
			this.renewalText = 'Renewal Date';
		}
	}

	onSelect(data: any, formControl: any) {
		if (data == 'Yes') {
			this.campaignForm.get(formControl).setValue('true');
		}
		else {
			this.campaignForm.get(formControl).setValue('false');
		}
		this.detailCampaign();
	}

	detailCampaign() {
		/* if(this.reqSubscriberOptout==''){
			this.campaignForm.get('optoutMessage').setValidators([]);
		} */
		if (this.campaignForm.invalid) {
			this.submitted = true;
			return
		}
		else {
			//if (!this.autoRen) { this.checkEdit = true };
			this.CampaignkeyID = this.route.snapshot.params.id;
			let campId = this.CampaignkeyID.split('-')[0]
			let iduser = this.CampaignkeyID.split('-')[1]
			let payLoad: any = JSON.stringify({
				campId: campId,
				iduser: iduser,
				mainData: this.campaignForm.value
			});

			this.campaignService.updateCampaignsDetail(payLoad).subscribe(res => {
				if (res.status == 200) {
					this.responseMessage = res.message;
					document.getElementById("campaignCenter").click();
					document.getElementById("sampleCenter").click();
					setTimeout(() => {
						this.responseMessage = "";
						// this.ngOnInit();
						this.campaignDetail(this.campaignIds);
					}, 5000);
				}
				else {
					this.errMessage = res.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			});
		}
	}

	// showmenu() {
	// 	if (this.menushow == false) {
	// 		this.menushow = true;
	// 	}
	// 	else {
	// 		this.menushow = false;
	// 	}
	// }
	showmenu() {
		this.menushow = !this.menushow;
	}


	// yes no starts here
	showyes(e: any) {
		if (e == 1) {
			let optmessage: any = this.campaignForm.get('optinMessage');
            optmessage.setValidators([this.minLengthWithoutSpacesValidator(20)]);
            optmessage.updateValueAndValidity();
			if (this.yes == false) {
				this.yes = true;
			}

			else {
				this.yes = ! false;
			}
		}
		else if (e == 2) {
			let optoutMessage: any = this.campaignForm.get('optoutMessage');
            optoutMessage.setValidators([Validators.required,this.minLengthWithoutSpacesValidator(20)]);
            optoutMessage.updateValueAndValidity();
			if (this.outoption == false) {
				this.outoption = true;
			}

			else {
				this.outoption = ! false;
			}
		}
		else if (e == 3) {
			let helpMessage: any = this.campaignForm.get('helpMessage');
            helpMessage.setValidators([Validators.required, this.minLengthWithoutSpacesValidator(20)]);
            helpMessage.updateValueAndValidity();
			if (this.opthelp == false) {
				this.opthelp = true;
			}

			else {
				this.opthelp = ! false;
			}
		}

	}

	opentext(e: any) {
		if (e == 1) {
			if (this.openeye == false) {
				this.openeye = true;
			}
			else {
				this.openeye = ! false;
			}
		}
		if (e == 2) {
			if (this.open_optout == false) {
				this.open_optout = true;
			}
			else {
				this.open_optout = ! false;
			}
		}
		if (e == 3) {
			if (this.open_opthelp == false) {
				this.open_opthelp = true;
			}
			else {
				this.open_opthelp = ! false;
			}
		}
	}
	editclose() {
		if (this.openeye == true || this.yes == true) {
			this.openeye = false;
			this.yes = false;
		}
		else {
			this.openeye = ! true;
			this.yes = ! true;
		}

	}
	optout_close() {
		if (this.open_optout == true || this.outoption == true) {
			this.open_optout = false;
			this.outoption = false;
		}
		else {
			this.open_optout = ! true;
			this.outoption = ! true;
		}

	}
	helpclose() {
		if (this.open_opthelp == true || this.opthelp == true) {
			this.open_opthelp = false;
			this.opthelp = false;
		}
		else {
			this.open_opthelp = ! true;
			this.opthelp = ! true;
		}

	}

	closeModel() {
		document.getElementById("closeCompanyDetails").click();
	}

	toggleDescription(data: any) {
		data.moreShown = !data.moreShown;
	}
	reqCampaignApproval() {
		let payLoad: any = JSON.stringify({
			iduser: this.idusers,
			campId: this.campaignIDs
		});
		this.campaignService.finalUpdateForCampaign(payLoad).subscribe(res => {
			if (res.status == 200) {
				this.responseMessage = res.message;
				setTimeout(() => {
					this.responseMessage = "";
					this.campaignDetail(this.campaignIds);
				}, 5000);
			}
			else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		});
	}
	
	addSampleMedia(campaignIDs) {
		if (this.fileData.files && this.fileData.files.length > 0) {
			const file: File = this.fileData.files[0];
			//   this.appealRequest.get('fileInput').setErrors(null);
			const fileSize = file.size;
			const maxSizePerFile = 10 * 1024 * 1024;
			if (fileSize > maxSizePerFile) {
				this.errMessage = "Individual file size limit exceeded";
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
				this.fileData.value = '';
				return;
			}
			this.selectedFile.length=0;
			const totalFileSize = this.selectedFile.reduce((total, selectedFile) => total + selectedFile.size, 0);
			const maxTotalSize = 30 * 1024 * 1024;
			if (totalFileSize + fileSize > maxTotalSize) {
				this.errMessage = "Total files size limit exceeded";
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
				this.fileData.value = '';
				return;
			}
			const reader = new FileReader();
			reader.readAsDataURL(file);
			this.selectedFile.push(file);
			const target = environment.SERVER + "campaignMultimediaFileUpload";
			const formData = new FormData();
			var _http = this._http
			// const payLoad = {
			// 	campaignId: campaignIDs
			// };
			formData.append('campaignId',campaignIDs);
			for (let i = 0; i < this.selectedFile.length; i++) {
				formData.append("ATTACHMENTS", this.selectedFile[i], this.selectedFile[i].name);
			}
			this.fileData.value = '';
			const req = new HttpRequest('POST', target, formData, {
				reportProgress: true
			});
			_http.request(req).subscribe(
				(res: any) => {
					if (res.body) {
						if (res.body.status == 200) {
							this.responseMessage = res.body.message;
							// window.location.reload();
							this.getCampaignFile(this.campaignIds);
						} else {
							this.errMessage = res.body.message;
						}
						setTimeout(() => {
							this.responseMessage = "";
							this.errMessage = "";
						}, 5000);
					}
				},
				(error: any) => {
				}
			);
			
		}
		this.mediaForm.reset();
	}
	onFileChange(event: Event) {
		const fileInput = event.target as HTMLInputElement;
		if (fileInput.files && fileInput.files.length > 0) {
			this.fileData = fileInput;
		}

	}
	savedDownloadFile(e) {
		fetch(e.path).then(resp => resp.arrayBuffer()).then(resp => {
			const file = new Blob([resp], { type: 'application/pdf' });
			const fileURL = URL.createObjectURL(file);
			const link = document.createElement('a');
			link.href = fileURL;
			link.download = e.path.split('campaignMultimediaFile/')[1];
			link.click();
		});
	}

	viewsavedFile(data: any, type: any) {
		if (type == 'pdf') {
			const pdfModal = document.getElementById('modalPdfForFile');
			let modalPdf = document.getElementById('modalPdf') as HTMLIFrameElement;
			modalPdf.src = data.path;
			$(pdfModal).modal('show');
		}
		if (type == 'image') {
			const imageModal = document.getElementById('modalImageForFile');
			let modalImage = document.getElementById('modalImage') as HTMLImageElement;
			modalImage.src = data.path;
			$(imageModal).modal('show');
		}
		if(type == 'audio'){
			const audioModal = document.getElementById('modalAudioForFile');
			let audioModal12 = document.getElementById('audioModal') as HTMLAudioElement;
			audioModal12.src = data.path;
			$(audioModal).modal('show');
			$(audioModal).on('hidden.bs.modal', function () {
				audioModal12.pause();
			  });
		}
		if(type == 'video'){
			const videoModal = document.getElementById('modalVideoForFile');
			let videoModal12 = document.getElementById('videoModal') as HTMLVideoElement;
			videoModal12.src = data.path;
			$(videoModal).modal('show');
			$(videoModal).on('hidden.bs.modal', function () {
				videoModal12.pause();
			  });
		}
		if(type == 'txt'){
			const txtModal = document.getElementById('modalTxtForFile');
			let txtModal12 = document.getElementById('txtModal') as HTMLIFrameElement;
			txtModal12.src = data.path;
			$(txtModal).modal('show');
		}
		if (type == 'other') {
			this.savedDownloadFile(data);
		}
	}
	
	openDeleteFileModal(file: any): void {
		const deletemodal = document.getElementById('deleteFileConfModal');
		$(deletemodal).modal('show');
		this.fileToDelete = file;
	}
	removeFile(): void {
		const uuidToRemove = this.fileToDelete.uuid;
		this.campaignSample = this.campaignSample.filter(file => file.uuid !== uuidToRemove);
		this.campaignService.deleteCampFile(uuidToRemove).subscribe((res) => {
			if (res.status == 200) {
				const deletemodal = document.getElementById('deleteFileConfModal');
				$(deletemodal).on('hide.bs.modal', function (e) {
				$('.modal-backdrop').remove();
				});
				$(deletemodal).modal('hide');
				this.responseMessage = res.message;
				this.displayedFilesCount--;
				const buttonClick = document.getElementById("file");
				buttonClick.style.pointerEvents = "auto";
				setTimeout(() => {
				  this.responseMessage = "";
				 // window.location.reload();
				}, 5000);
			  }
			  else {
				this.errMessage = res.message;
				setTimeout(() => {
				  this.errMessage = "";
				}, 5000);
			  }
		})
	} 
   closeDeleteFileModal(){
	const deletemodal = document.getElementById('deleteFileConfModal');
				$(deletemodal).on('hide.bs.modal', function (e) {
				$('.modal-backdrop').remove();
				});
				$(deletemodal).modal('hide');
	}

	getCharacterCount(input: string): number {
		const characters = input.replace(/\s/g, '');
		return characters.length;
	  }
	  
	
	  minLengthWithoutSpacesValidator(minLength: number): ValidatorFn {
		return (control: AbstractControl): ValidationErrors | null => {
		  const value: string = control.value;
	  
		  if (!value) {
			return null; 
		  }
			const nonWhitespaceLength = value.replace(/\s/g, '').length;
		  return nonWhitespaceLength >= minLength ? null : { minLengthWithoutSpaces: true };
		};
	  }
	// ChangeEditBtn(){
	// 	this.checkEdit=true;		
	// }

	// ngOnDestroy() {
	// 	if (this.checkEdit) {
	// 		if (confirm("Please click on 'OK' to Submit Your Updated Campaign")) {
	// 			this.CampaignkeyID = this.route.snapshot.params.id;
	// 			let campId = this.CampaignkeyID.split('-')[0]
	// 			let iduser = this.CampaignkeyID.split('-')[1]
	// 			let payLoad: any = JSON.stringify({
	// 				campId: campId,
	// 				iduser: iduser,
	// 				mainData: this.campaignForm.value
	// 			});
	// 			this.campaignService.finalUpdateForCampaign(campId).subscribe(res => {
	// 				if (res.status == 200) {
	// 					this.responseMessage = res.message;
	// 					setTimeout(() => {
	// 						this.responseMessage = "";
	// 					}, 5000);
	// 				}
	// 				else {
	// 					this.errMessage = res.message;
	// 					setTimeout(() => {
	// 						this.errMessage = "";
	// 					}, 5000);
	// 				}
	// 			});
	// 		}

	// 	}

	// }

	ngOnDestroy(){
		this.campaignresubmissionmodal.nativeElement.click();
		this.resubmissionmodel.nativeElement.click();
		this.deactivatedmodal.nativeElement.click();
		this.campaignsDetailmodals.nativeElement.click();
		this.samplemessagesmodals.nativeElement.click();
		this.deletefileconfirmationmodals.nativeElement.click();
	}
}
