import { Component, OnInit } from '@angular/core';
import { OutboundService } from '../outbound.service';
import { ActivatedRoute, Router } from '@angular/router';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
declare var $: any;
@Component({
  selector: 'app-media-upload-files',
  templateUrl: './media-upload-files.component.html',
  styleUrls: ['./media-upload-files.component.css']
})
export class MediaUploadFilesComponent implements OnInit {
  header: any[];
  uploadForm: FormGroup;
  submitted: boolean = false;
  errMessage: any = "";
  responseMessage: any = "";
  file: File;
  mediaFiles: any;
  fileErr: string;

  constructor(public data: OutboundService, public router: Router, public fb: FormBuilder,
    private route: ActivatedRoute) { }

  ngOnInit(): void {
    this.data.getMediaUpload().subscribe((result) => {
      this.header = result[0].headers_details
      $.getScript('./assets/table.js');
    });



    this.uploadForm = this.fb.group({
      name: ['', [Validators.required, Validators.minLength(3), Validators.pattern("^[a-zA-Z \'][a-zA-Z \']*$")]],
      uploadFile: ['', [Validators.required]]
    })

    this.data.getMediaFiles().subscribe(res => {
      if (res.status == 200) {
        $('#basic-datatables15').DataTable().clear();
        $('#basic-datatables15').DataTable().destroy();
        this.mediaFiles = res.data;
        $.getScript('./assets/table.js');
        this.responseMessage = res.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
      } else {
        this.errMessage = "";
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.errMessage = err.message;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });
  }

  onFilePicked(event: Event) {
    const file: File = (event.target as HTMLInputElement).files[0];
    this.file = file;
    const reader = new FileReader();
    reader.readAsDataURL(file)
    this.fileErr = '';
  }

  submitform() {
    if (this.uploadForm.invalid) {
      this.submitted = true;
      return
    }
    else {
      let filename = $('#upload').val();
      if (filename) {
        this.data.uploadMediaFile(this.uploadForm.value, this.file).subscribe((res) => {
          if (res.status == 200) {
            this.responseMessage = res.message;
            setTimeout(() => {
              this.responseMessage = "";
            }, 5000);
            window.location.reload();
          }
          else {
            this.errMessage = res.message;
            setTimeout(() => {
              this.errMessage = "";
            }, 5000);
          }
        }, err => {
          this.responseMessage = err.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
        });
      }
      else {
        this.fileErr = "File is required";
      }
    }
  }

  resetForm()
  {
    this.submitted = false;
  }

  onDelete(mediaID) {
    if (confirm("Are you sure you want to delete this data!")) {
      this.data.deleteMediaFile(mediaID).subscribe(response => {
        if (response.status == 201) {
          this.responseMessage = response.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
          location.reload();
         // this.ngOnInit();
        }
        else {
          this.errMessage = response.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      }, err => {
        this.errMessage = err.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      });
    } else {
      "Cancel!"
    }
  }

  closepop() {
    this.submitted = false;
    this.uploadForm.reset();
    $('#upload').val("");
  }

}
