import { Component, OnInit } from '@angular/core';
import { AbstractControl, FormBuilder, FormControl, FormGroup, ValidatorFn, Validators } from '@angular/forms';
import { trigger, transition, style, animate, state } from '@angular/animations';
import { ResellerService } from '../reseller.service';
import { ActivatedRoute, ParamMap } from '@angular/router';
import * as XLSX from 'xlsx';
import { saveAs } from 'file-saver';
declare var $: any;
@Component({
  selector: 'app-customer-details',
  templateUrl: './customer-details.component.html',
  styleUrls: ['./customer-details.component.css'],
  animations: [
    trigger('widthGrow', [
      state(
        'closed',
        style({
          border: "0px",
          height: "0px",
          margin: "0px 0px 20px 0px",
        })
      ),
      state(
        'open',
        style({

          margin: "0px 0px 20px 0px",
        })
      ),
      transition('* => *', animate(500)),
    ]),
  ],
})
export class CustomerDetailsComponent implements OnInit {
  responseMessage: any = "";
  errMessage: any = "";
  searchText = { count: 0 };
  count = 0;
  tableSize = 25;
  tableSizes = [25, 50, 100];
  show: boolean = false;
  filterIconVal: any;
  state: any;
  idUser: string;
  id: any;
  submitted: boolean = false;
  customerfilter: any = [];
  Reseller: any = [];

  public custoDfilter: FormGroup;
  idate: any;
  fdate: any;
  ldate: any;
  customerfilterCSV: any = [];
  EXCEL_TYPE = 'application/csv';
  EXCEL_EXTENSION = '.csv';

  constructor(private data: ResellerService, private route: ActivatedRoute, public fb: FormBuilder) { }

  ngOnInit(): void {
    this.state = 'closed';
    this.filterIconVal = "1";

    this.route.paramMap.subscribe((params: ParamMap) => {
      this.id = params.get('id');
      this.idate = params.get('date');
    });

    if (!this.idate) {
      this.fdate = this.startDate();
      this.ldate = this.current_datetime()

    } else {
      this.fdate = this.idate
      this.ldate = this.current_datetime()
    }


    this.custoDfilter = this.fb.group({
      fromDate: new FormControl(this.fdate, [Validators.required]),
      toDate: new FormControl(this.ldate, [Validators.required]),
      san: new FormControl('', [Validators.pattern(/^-?(0|[1-9]\d*)?$/)]),
      // username: [],
      selectedUser: new FormControl(''),
      commission_amount: [''],
      // id: [this.idUser]
    });

    if (this.id > 0) {
      this.filterIconVal = "2";
      this.show = true;
      this.custoDfilter.patchValue({
        selectedUser: this.id
      })
    }

    /*add filter for commission details */
    this.getCustomerDetails();
    $('#basic-datatables4').DataTable().clear();
    $('#basic-datatables4').DataTable().destroy();
    $.getScript('./assets/tollfree.js');
    this.getReseller();
  }

  getReseller() {
    this.data.getReseller().subscribe(res => {
      if (res.status == 200) {
        this.Reseller = res.data;
        this.Reseller.sort((a, b) => {
          return a.iduser - b.iduser;
        });
        // this.responseMessage = res.message;
        // setTimeout(() => {
        //   this.responseMessage = "";
        // }, 5000);
      }
    });
  }

  filterByUser(e) {
    this.custoDfilter.patchValue({
      selectedUser: e.target.value
    });
  }

  getCustomerDetails() {
    this.data.applyCustomerDFilter(JSON.stringify(this.custoDfilter.value)).subscribe(response => {
      if (response.data) {
        this.customerfilter = response.data;
        $('#basic-datatables4').DataTable().clear();
        $('#basic-datatables4').DataTable().destroy();
        $.getScript('./assets/tollfree.js');
      }
    });
  }
  /**Function for filter hide open**/
  showField() {
    if (this.show == false) {
      this.show = true;
    } else {
      this.show = false;
    }
  }
  /*change value of filter button*/
  changeState(val): void {
    this.state == 'closed' ? (this.state = 'open') : (this.state = 'closed');
    val == '1' ? (this.filterIconVal = '2') : (this.filterIconVal = '1');
  }


  resetFilter() {
    this.ngOnInit();
    // this.custoDfilter.reset();
    // this.getCustomerDetails();
    if (!this.idate) {
      this.fdate = this.startDate();
      this.ldate = this.current_datetime()

    } else {
      this.fdate = this.idate
      this.ldate = this.current_datetime()
    }
    this.custoDfilter.patchValue({
      fromDate: this.fdate,
      toDate: this.ldate,
    })
    this.customerfilter = [];
  }

  customerDetailFilter() {
    this.submitted = true
    if (this.custoDfilter.invalid) {
      return false;
    } else {
      let ddata = JSON.stringify(this.custoDfilter.value);
      this.data.applyCustomerDFilter(ddata).subscribe(res => {
        if (res.status == 200) {
          this.customerfilter = res.data;
          this.customerfilterCSV = res.data;
          $('#basic-datatables4').DataTable().clear();
          $('#basic-datatables4').DataTable().destroy();
          $.getScript('./assets/tollfree.js');
        }
        else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      })
    }
  }

  messageshow() {
    const fromDate = this.custoDfilter.get('fromDate').value;
    const toDate = this.custoDfilter.get('toDate').value;
    const currentDate = new Date();
    if ((!fromDate && !toDate)) {
    } else if ((fromDate == null || !fromDate) && (toDate != null)) {
      this.custoDfilter.get('fromDate').setErrors({ 'dateRange': 'Please select From Date' });
    } else if ((fromDate != null) && (toDate == null || !toDate)) {
      this.custoDfilter.get('toDate').setErrors({ 'dateRange': 'Please select To Date' });
    } else if (fromDate && toDate && new Date(toDate) < new Date(fromDate)) {
      this.custoDfilter.get('toDate').setErrors({ 'dateRange': 'To date cannot be smaller than from date' });
      return;
    } else if (toDate && new Date(toDate) > currentDate) {
      this.custoDfilter.get('toDate').setErrors({ 'dateRange': 'To date cannot be greater than current date' });
      return;
    } else if (fromDate && new Date(fromDate) > currentDate) {
      this.custoDfilter.get('fromDate').setErrors({ 'dateRange': 'From date cannot be greater than current date' });
      return;
    } else {
      this.custoDfilter.get('fromDate').setErrors(null);
      this.custoDfilter.get('toDate').setErrors(null);
    }

  }

  downloadCSVFile() {
    this.customerDetailFilter();
    setTimeout(() => {
      if (this.customerfilterCSV.length > 0) {
        let NewFilteredRes = this.customerfilterCSV.map((item) => {
          const { invoice_number, reseller_iduser, san, reseller_name, customer_name, created_at, total_amount, commission_amount } = item;
          const formattedDate = new Date(created_at).toLocaleDateString('en-US');
          return {
            'Reseller ID': reseller_iduser,
            'Reseller Name': reseller_name,
            'INV': invoice_number,
            'SAN': san,
            'Customer Name': customer_name,
            'Date': formattedDate,
            'Total Invoice Amount': total_amount,
            'Commission Amount': commission_amount
          };
        });
        const worksheet: XLSX.WorkSheet = XLSX.utils.json_to_sheet(NewFilteredRes);
        const workbook: XLSX.WorkBook = { Sheets: { Commission_Details: worksheet }, SheetNames: ['Commission_Details'] };
        const excelBuffer: any = XLSX.write(workbook, { bookType: 'csv', type: 'array' });
        this.saveAsExcelFile(excelBuffer, 'Commission_Details');
      } else {
        //this.errMessage = 'No Record Available!';
        setTimeout(() => {
          this.errMessage = '';
        }, 5000);
      }
    }, 1000);
  }

  private saveAsExcelFile(buffer: any, fileName: string): void {
    const data: Blob = new Blob([buffer], {
      type: this.EXCEL_TYPE
    });
    saveAs(data, fileName + new Date().getTime() + this.EXCEL_EXTENSION);
  }

  numberOnly(event): boolean {
    const charCode = (event.which) ? event.which : event.keyCode;
    if (charCode > 31 && (charCode < 48 || charCode > 57)) {
      return false;
    }
    return true;
  }

  startDate() {
    let now = new Date();
    let year = "" + now.getFullYear();
    let month = "" + (now.getMonth() + 1); if (month.length == 1) { month = "0" + month; }
    let day = "" + now.getDate(); if (day.length == 1) { day = "0" + day; }
    let hour = "" + now.getHours(); if (hour.length == 1) { hour = "0" + hour; }
    let minute = "" + now.getMinutes(); if (minute.length == 1) { minute = "0" + minute; }
    let second = "" + now.getSeconds(); if (second.length == 1) { second = "0" + second; }
    return year + '-' + month + "-" + "01";
  }


  current_datetime() {
    let now = new Date();
    let year = "" + now.getFullYear();
    let month = "" + (now.getMonth() + 1); if (month.length == 1) { month = "0" + month; }
    let day = "" + now.getDate(); if (day.length == 1) { day = "0" + day; }
    let hour = "" + now.getHours(); if (hour.length == 1) { hour = "0" + hour; }
    let minute = "" + now.getMinutes(); if (minute.length == 1) { minute = "0" + minute; }
    let second = "" + now.getSeconds(); if (second.length == 1) { second = "0" + second; }
    return year + '-' + month + "-" + day;
  }

  // static dateLessThan(fromDate: string, toDate: string, validatorField: { [key: string]: boolean }): ValidatorFn {
  //   return (c: AbstractControl): { [key: string]: boolean } | null => {
  //     const date1 = c.get(fromDate).value;
  //     const date2 = c.get(toDate).value;
  //     if ((date1 !== null && date2 !== null) && date1 > date2) {
  //       return validatorField;
  //     }
  //     return null;
  //   };
  // }
}
