import { Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import { FormBuilder, FormControl, FormGroup, Validators } from '@angular/forms';
import { ActivatedRoute, Router } from '@angular/router';
import { Observable } from 'rxjs';
import 'rxjs/add/observable/timer';
import 'rxjs/add/operator/map';
import 'rxjs/add/operator/take';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import { SmsService } from '../sms.service';
declare var $: any;

@Component({
  selector: 'app-favoicedetails',
  templateUrl: './favoicedetails.component.html',
  styleUrls: ['./favoicedetails.component.css']
})
export class FavoicedetailsComponent implements OnInit {
 @ViewChild('closeModal') closeModal: ElementRef;

  page = 1;
  field: any;
  header: any;
  listdata: any;
  errMessage: string;
  responseMessage: any;
  count = 0;
  tableSize = 25;
  tableSizes = [25, 50, 100];
  searchText = { count: 0 };
  filtre: string;
  type: any;
  otpForm: FormGroup;
  isOtpEnable: Boolean = false;
  countDown;
  counter: any;
  tick = 1000;
  isCounter: Boolean = false;
  submitted: Boolean = false;
  template: any;
  featureServiceData: any;
  isDisabledServiceStatus: boolean;
  constructor(private data: SmsService, public router: Router, public fb: FormBuilder,private user: UsermanagementService, private route: ActivatedRoute) { }

  ngOnInit(): void {
    this.otpForm = this.fb.group({
      FROM: new FormControl('', [Validators.required, Validators.minLength(10)]),
      TO: new FormControl('', [Validators.required, Validators.minLength(10)]),
      template: new FormControl('',[Validators.required]),
      otp: new FormControl('')
    });
    this.user.getfeatureServiceStatus().subscribe(res => {
      this.featureServiceData = res.data.find(x => x.fs_id == '1');
      if(this.featureServiceData!==undefined && this.featureServiceData.as_status=='1')
      {
       this.isDisabledServiceStatus=false;
      }else{
       this.isDisabledServiceStatus=true;
       this.showMsg();
      }
    });
    this.get2FAvoice();
  }

  get2FAvoice(){
    this.data.get2FATemplates('voice').subscribe(res => {
      if (res.status == 200) {
        this.listdata = res.data;
        $('#basic-datatables').DataTable().clear();
        $('#basic-datatables').DataTable().destroy();
        $.getScript('./assets/table.js');
      }
      else {
        this.errMessage = "";
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.errMessage = err.message;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    })
  }

  onDelete(id2fa_template) {
    if (confirm("Are you sure you want to delete data!")) {
      this.data.delete2FATemplate(id2fa_template).subscribe(response => {
        if (response.status == 201) {
          this.responseMessage = response.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
          this.get2FAvoice();
          //this.ngOnInit();
        } else {
          this.errMessage = response.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      }, err => {
        this.errMessage = err.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      })
    } else {
      "Cancel!"
    }
  }

  // onGenerateOtp() {
  //   this.data.SendOtpByCall(this.otpForm.value).subscribe(res => {
  //     if (res.status == 201) {
  //       this.counter = 30;
  //       this.isCounter = false;
  //       this.isOtpEnable = true;
  //       this.countDown = Observable.timer(0, this.tick)
  //         .take(this.counter)
  //         .map(() => {
  //           if (this.counter <= 1) {
  //             this.isOtpEnable = true;
  //             this.isCounter = true;
  //           }
  //           return --this.counter
  //         });
  //       this.responseMessage = res.message;
  //       setTimeout(() => {
  //         this.responseMessage = "";
  //       }, 5000);
  //     }
  //     else {
  //       this.isOtpEnable = false;
  //       this.errMessage = res.message;
  //       setTimeout(() => {
  //         this.errMessage = "";
  //       }, 5000);
  //     }
  //   });
  // }

  onGenerateOtp() {
    this.submitted = true;
      if (this.otpForm.value.template == 'null'){
        this.errMessage = "There is no Template Key for this Template!";
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
        return false;
      }
   
    if (this.otpForm.invalid){
      return false;
    }
    else{
    this.data.SendOtpByCall(this.otpForm.value).subscribe(res => {
      if (res.status == 201) {
        this.counter = 30;
        this.isCounter = false;
        this.isOtpEnable = true;
        this.countDown = Observable.timer(0, this.tick)
          .take(this.counter)
          .map(() => {
            if (this.counter <= 1) {
              this.isOtpEnable = true;
              this.isCounter = true;
            }
            return --this.counter
          });
        this.responseMessage = res.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
      }
      else {
        this.isOtpEnable = false;
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    });
  }

}

  verifyOtp() {
    this.data.verifyOtp(this.otpForm.value).subscribe(res => {
      if (res.status == 200) {
        this.resetModal();
        this.responseMessage = res.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    });
  }

  resetModal() {
    $("#exampleModal").hide();
    $(".modal-backdrop").remove();
    this.submitted=false;
    this.isOtpEnable = false;
    this.otpForm.reset();
    this.otpForm.get('template').setValue('');
    this.otpForm.get('otp').setValue('');
  }

  onClode() {
    this.otpForm.reset();
   //  location.reload();
    this.submitted = false;
  }

  showMsg()
	{
		this.errMessage = "2FA Voice service has been suspended. More information please contact support";
		setTimeout(() => {
			this.errMessage = "";
		}, 5000);
	}
  ngOnDestroy() {
    this.closeModal.nativeElement.click();
  }
}

