import { Component, OnInit } from '@angular/core';
import { MatSnackBar } from '@angular/material/snack-bar'
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { Router } from '@angular/router';
import { SmsService } from '../sms.service';
import { Validators, FormBuilder, FormGroup, AbstractControl, ValidatorFn } from '@angular/forms';
import { BehaviorSubject, Observable } from 'rxjs';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import { DatePipe, formatDate } from '@angular/common';
import { saveAs } from 'file-saver';
import * as XLSX from 'xlsx';
declare var $: any;

@Component({
	selector: 'app-mdrs',
	templateUrl: './mdrs.component.html',
	styleUrls: ['./mdrs.component.css']
})

export class MdrsComponent extends AppComponentClass<any, any> {
	show_filter: boolean = false;
	show_daily: boolean = false;
	editData?: Observable<any>;
	searchText = { count: 0 };
	filtre: string;
	label: Observable<any>;
	header: any;
	rowdata: any;
	p: number = 1;
	page = 1;
	count = 0;
	tableSize = 50;
	tableSizes = [50, 100, 150];
	filterTerm: string
	snackBar: any;
	public mdrsForm: FormGroup;
	public summerymdrsForm: FormGroup;
	public submitted: boolean = false;
	filterMDR: any = [];
	singleMDR: any = [];
	isOutbound$ = new BehaviorSubject<Boolean>(false);
	isOutbound = this.isOutbound$.asObservable();
	username: any;
	userlist: any = [];
	isAdmin: Boolean = false;
	errMessage: any = "";
	EXCEL_TYPE = 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=UTF-8';
	EXCEL_EXTENSION = '.xlsx';
	monthNameList: any = [];
	filterSummarySms: any = [];
	currentDate: any;
	startdate: any;
	lastdate: any;
	sel: boolean;
	exportfile: any = [];

	constructor(public data: SmsService, public router: Router,
		public fb: FormBuilder, msg: MatSnackBar,
		private userService: UsermanagementService,
		private datePipe: DatePipe) {
		super(data, router, fb);
	}

	ngOnInit(): void {
		this.currentDate = new Date();
		this.currentDate = new Date(this.currentDate.setDate(this.currentDate.getDate() - 1));
		const sValue = formatDate(this.currentDate, 'yyyy-MM-dd', 'en-US');
		this.startdate = sValue;

		this.lastdate = new Date(this.currentDate.setDate(this.currentDate.getDate() - 6));
		const lValue = formatDate(this.currentDate, 'yyyy-MM-dd', 'en-US');
		this.lastdate = lValue;

		this.userService.getUsers("main").subscribe(res => {
			this.userlist = res.data[0];
			// $.getScript('./assets/table.js');
		}, err => {
			console.log(err.message);
		});

		let isLoggedIn = sessionStorage.getItem("isLoggedIn");
		let user = JSON.parse(isLoggedIn);
		this.username = user.username;
		if (user.type == '1') {
			this.isAdmin = true;
		}
		else {
			this.isAdmin = false;
		}

		this.mdrsForm = this.fb.group({
			from_date: [this.startDate()],
			to_date: [this.current_datetime()],
			from_number: [''],
			to_number: [''],
			direction: [''],
			iduser: [''],
			fType: ['']
		}, {
			validator: Validators.compose([
				MdrsComponent.dateLessThan('from_date', 'to_date', { 'from_date': true })
			])
		});
		this.summerymdrsForm = this.fb.group({
			from_date: ['', [Validators.required]],
			to_date: ['', [Validators.required]],
			directionSummery: ['Both'],
			fType: ['']
		}, {
			validator: Validators.compose([
				MdrsComponent.dateLessThan('from_date', 'to_date', { 'from_date': true })
			])
		});

		this.summerymdrsForm.patchValue({
			from_date: this.lastdate,
			to_date: this.startdate
		});

		this.data.get_mdrs().subscribe((result) => {
			this.label = result[1];
			this.header = result[0].headers_details;
			this.rowdata = result[0].product_details;
		});
		this.mdrsForm.patchValue({
			fType:""
		})
		this.data.getMDRFilter(JSON.stringify(this.mdrsForm.value)).subscribe(response => {
			if (response.data) {
				this.filterMDR = response.data;
				$.getScript('./assets/table.js');
			}
		});
		this.summerySmsmdrsForm();
	}

	// @to save/update form data
	onMdrsGet() {
		this.submitted = true;
		this.mdrsForm.patchValue({
			fType:""
		})
		if (this.mdrsForm.invalid) {
			$('#basic-datatables11').DataTable().destroy();
			return
		}
		else {
			this.filterMDR = [];
			this.data.getMDRFilter(JSON.stringify(this.mdrsForm.value)).subscribe(response => {
				if (response.status == 200) {
					this.filterMDR = response.data;
					$('#basic-datatables11').DataTable().clear();
					$('#basic-datatables11').DataTable().destroy();
					$.getScript('./assets/table.js');
				}
				else {
					this.errMessage = response.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			});
		}
	}

	getFullMdr(idmdr) {
		this.singleMDR = this.filterMDR.find(element => element.idmdr == idmdr);
		if (this.singleMDR.direction == "outbound") {
			this.isOutbound$.next(true);
		}
		else {
			this.isOutbound$.next(false);
		}
	}

	exportFile(e: any) {
		let fType = "filter";
		this.mdrsForm.patchValue({
			fType:fType
		})
		this.summerymdrsForm.patchValue({
			fType:fType
		})
		if (e == 'call') {
			this.exportfile=[];
			this.data.getMDRFilter(JSON.stringify(this.mdrsForm.value)).subscribe(response => {
				if (response.status == 200) {
					if(response.data.length > 0){
						for(let i of response.data){
							delete i.idmdr
							this.exportfile.push(i);
						}
						const worksheet: XLSX.WorkSheet = XLSX.utils.json_to_sheet(this.exportfile);
						const workbook: XLSX.WorkBook = { Sheets: { 'SMS-MDR': worksheet }, SheetNames: ['SMS-MDR'] };
						const excelBuffer: any = XLSX.write(workbook, { bookType: 'xlsx', type: 'array' });
						this.saveAsExcelFile(excelBuffer, "SMS-MDR");
					}
					else{
						this.errMessage = "Record Not Found !";
						setTimeout(() => {
							this.errMessage =""
						}, 5000);
					}
				}
				else {
					this.errMessage = response.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			});

		}
		if (e == 'summery') {
			this.exportfile=[];
			this.data.summerySmsmdrForm(JSON.stringify(this.summerymdrsForm.value)).subscribe(response => {
				if (response.status == 200) {
					if(response.data.length > 0){
						for(let i of response.data){
							delete i.idmdr
							this.exportfile.push(i);
						}
						const worksheet: XLSX.WorkSheet = XLSX.utils.json_to_sheet(this.exportfile);
						const workbook: XLSX.WorkBook = { Sheets: { 'SMS-MDR': worksheet }, SheetNames: ['SMS-MDR'] };
						const excelBuffer: any = XLSX.write(workbook, { bookType: 'xlsx', type: 'array' });
						this.saveAsExcelFile(excelBuffer, "SMS-MDR");
					}
					else{
						this.errMessage = "Record Not Found !";
						setTimeout(() => {
							this.errMessage =""
						}, 5000);
					}
				}
				else {
					this.errMessage = response.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			});
		}
		
	}

	private saveAsExcelFile(buffer: any, fileName: string): void {
		const data: Blob = new Blob([buffer], {
			type: this.EXCEL_TYPE
		});
		saveAs(data, fileName + new Date().getTime() + this.EXCEL_EXTENSION);
	}



	startDate() {
		let now = new Date();
		let year = "" + now.getFullYear();
		let month = "" + (now.getMonth() + 1); if (month.length == 1) { month = "0" + month; }
		let day = "" + now.getDate(); if (day.length == 1) { day = "0" + day; }
		let hour = "" + now.getHours(); if (hour.length == 1) { hour = "0" + hour; }
		let minute = "" + now.getMinutes(); if (minute.length == 1) { minute = "0" + minute; }
		let second = "" + now.getSeconds(); if (second.length == 1) { second = "0" + second; }
		return year + '-' + month + "-" + "01";
	}


	current_datetime() {
		let now = new Date();
		let year = "" + now.getFullYear();
		let month = "" + (now.getMonth() + 1); if (month.length == 1) { month = "0" + month; }
		let day = "" + now.getDate(); if (day.length == 1) { day = "0" + day; }
		let hour = "" + now.getHours(); if (hour.length == 1) { hour = "0" + hour; }
		let minute = "" + now.getMinutes(); if (minute.length == 1) { minute = "0" + minute; }
		let second = "" + now.getSeconds(); if (second.length == 1) { second = "0" + second; }
		return year + '-' + month + "-" + day;
	}

	monthsList() {
		this.monthNameList = [
			{ name: "Jan", value: "1" },
			{ name: "Feb", value: "2" },
			{ name: "Mar", value: "3" },
			{ name: "Apr", value: "4" },
			{ name: "May", value: "5" },
			{ name: "Jun", value: "6" },
			{ name: "Jul", value: "7" },
			{ name: "Aug", value: "8" },
			{ name: "Sep", value: "9" },
			{ name: "Oct", value: "10" },
			{ name: "Nov", value: "11" },
			{ name: "Dec", value: "12" }
		];
	}


	static dateLessThan(from_date: string, to_date: string, validatorField: { [key: string]: boolean }): ValidatorFn {
		return (c: AbstractControl): { [key: string]: boolean } | null => {
			const date1 = c.get(from_date).value;
			const date2 = c.get(to_date).value;
			if ((date1 !== null && date2 !== null) && date1 > date2) {
				return validatorField;
			}
			return null;
		};
	}
	showfilter() {
		if (this.show_filter == false) {
			this.show_filter = true;
		}
		else {
			this.show_filter = false;
		}

	}
	showdaily() {
		if (this.show_daily == false) {
			this.show_daily = true;
		}
		else {
			this.show_daily = false;
		}
	}

	summerySmsmdrsForm() {
		this.summerymdrsForm.patchValue({
			fType:""
		})
		if (this.summerymdrsForm.invalid) {
			return false
		}
		else {
			this.filterSummarySms=[];
			this.data.summerySmsmdrForm(JSON.stringify(this.summerymdrsForm.value)).subscribe(response => {
				if (response.status == 200) {
					this.filterSummarySms = response.data;
					$('#basic-datatabless11').DataTable().clear();
					$('#basic-datatabless11').DataTable().destroy();
					$.getScript('./assets/table.js');
				}
				else {
					this.errMessage = response.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			});
		}
	}

	resetMdr() {
		this.submitted = false;
		// this.mdrsForm.reset();
		this.ngOnInit();
		this.mdrsForm.patchValue({
			from_date: this.startDate(),
			to_date: this.current_datetime(),
		})
		this.onMdrsGet();
	}

	resSumry() {
		this.submitted = false;
		this.summerymdrsForm.reset();
		this.summerymdrsForm.get('directionSummery').setValue('Both')
		this.summerymdrsForm.patchValue({
			from_date: this.lastdate,
			to_date: this.startdate
		})
		this.summerySmsmdrsForm();
	}

}
