import { Component, OnInit } from '@angular/core';
import { MatSnackBar } from '@angular/material/snack-bar'
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { Router } from '@angular/router';
import { SmsService } from '../sms.service';
import { Validators, FormBuilder, FormGroup, AbstractControl, ValidatorFn } from '@angular/forms';
import { BehaviorSubject, Observable } from 'rxjs';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import { DatePipe, formatDate } from '@angular/common';
import { saveAs } from 'file-saver';
import * as XLSX from 'xlsx';
import { MdrsComponent } from '../mdrs/mdrs.component';
declare var $: any;

@Component({
	selector: 'app-mms-mdr',
	templateUrl: './mms-mdr.component.html',
	styleUrls: ['./mms-mdr.component.css']
})
export class MmsMDRComponent implements OnInit {
	show_filter: boolean = false;
	show_daily: boolean = false;
	editData?: Observable<any>;
	searchText = { count: 0 };
	filtre: string;
	label: Observable<any>;
	header: any;
	rowdata: any;
	p: number = 1;
	page = 1;
	count = 0;
	tableSize = 50;
	tableSizes = [50, 100, 150];
	filterTerm: string
	snackBar: any;
	public mmdrsForm: FormGroup;
	public summerymmsForm: FormGroup;
	public submitted: boolean = false;
	filterMDR: any = [];
	singleMDR: any = [];
	isOutbound$ = new BehaviorSubject<Boolean>(false);
	isOutbound = this.isOutbound$.asObservable();
	username: any;
	userlist: any = [];
	isAdmin: Boolean = false;
	errMessage: any = "";
	EXCEL_TYPE = 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=UTF-8';
	EXCEL_EXTENSION = '.xlsx';
	monthNameList: any = [];
	filterSummaryMms: any = [];
	currentDate: any;
	startdate: any;
	lastdate: any;
	exportfile: any = [];
	
	constructor(public data: SmsService, public router: Router,
		public fb: FormBuilder, msg: MatSnackBar,
		private userService: UsermanagementService,
		private datePipe: DatePipe) {

	}

	ngOnInit(): void {
		this.currentDate = new Date();
		this.currentDate = new Date(this.currentDate.setDate(this.currentDate.getDate() - 1));
		const sValue = formatDate(this.currentDate, 'yyyy-MM-dd', 'en-US');
		this.startdate = sValue;

		this.lastdate = new Date(this.currentDate.setDate(this.currentDate.getDate() - 6));
		const lValue = formatDate(this.currentDate, 'yyyy-MM-dd', 'en-US');
		this.lastdate = lValue;

		this.userService.getUsers("main").subscribe(res => {
			this.userlist = res.data[0];
			// $.getScript('./assets/table.js');
		}, err => {
			console.log(err.message);
		});

		let isLoggedIn = sessionStorage.getItem("isLoggedIn");
		let user = JSON.parse(isLoggedIn);
		this.username = user.username;
		if (user.type == '1') {
			this.isAdmin = true;
		}
		else {
			this.isAdmin = false;
		}

		this.mmdrsForm = this.fb.group({
			from_date: [this.startDate()],
			to_date: [this.current_datetime()],
			from_number: [''],
			to_number: [''],
			direction: [''],
			iduser: [''],
			fType: ['']
		}, {
			validator: Validators.compose([
				MdrsComponent.dateLessThan('from_date', 'to_date', { 'from_date': true })
			])
		});
		this.summerymmsForm = this.fb.group({
			to_date: ['', [Validators.required]],
			from_date: ['', [Validators.required]],
			directionSummery: ['Both'],
			fType: ['']
			// Status: [''],
		}, {
			validator: Validators.compose([
				MdrsComponent.dateLessThan('from_date', 'to_date', { 'from_date': true })
			])
		});

		this.summerymmsForm.patchValue({
			to_date: this.startdate,
			from_date: this.lastdate,
		});

		this.data.get_mdrs().subscribe((result) => {
			this.label = result[1];
			this.header = result[0].headers_details;
			this.rowdata = result[0].product_details;
		});

		this.data.getMMSMDR(JSON.stringify(this.mmdrsForm.value)).subscribe(response => {
			if (response.data) {
				this.filterMDR = response.data;
				$.getScript('./assets/table.js');
			}
		});
		this.summeryMms()
	}

	onMMdrsGet() {
		this.submitted = true;
		this.mmdrsForm.patchValue({
			fType:""
		})
		if (this.mmdrsForm.invalid) {
			return
		}
		else {
			this.filterMDR = [];
			this.data.getMMSMDR(JSON.stringify(this.mmdrsForm.value)).subscribe(response => {
				if (response.status == 200) {
					this.filterMDR = response.data;
					$('#basic-datatables11a').DataTable().clear();
					$('#basic-datatables11a').DataTable().destroy();
					$.getScript('./assets/table.js');
				}
				else {
					this.errMessage = response.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			});
		}
	}

	getFullMdr(idmdr) {
		this.singleMDR = this.filterMDR.find(element => element.idmdr == idmdr);
		if (this.singleMDR.direction == "outbound") {
			this.isOutbound$.next(true);
		}
		else {
			this.isOutbound$.next(false);
		}
	}

	exportFile(e: any) {
		let fType = "filter";
		this.mmdrsForm.patchValue({
			fType:fType
		})
		this.summerymmsForm.patchValue({
			fType:fType
		})
		if (e == 'message') {
			this.exportfile = [];
			this.data.getMMSMDR(JSON.stringify(this.mmdrsForm.value)).subscribe(response => {
				if (response.status == 200) {
					if(response.data.length > 0){
						for(let i of response.data){
							delete i.idmdr
							this.exportfile.push(i);
						}
						const worksheet: XLSX.WorkSheet = XLSX.utils.json_to_sheet(this.exportfile);
						const workbook: XLSX.WorkBook = { Sheets: { 'MMS-MDR': worksheet }, SheetNames: ['MMS-MDR'] };
						const excelBuffer: any = XLSX.write(workbook, { bookType: 'xlsx', type: 'array' });
						this.saveAsExcelFile(excelBuffer, "MMS-MDR");
					}
					else{
						this.errMessage = "Record Not Found !";
						setTimeout(() => {
							this.errMessage =""
						}, 5000);
					}
				}
				else {
					this.errMessage = response.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			});
		}
		if (e == 'summery') {
			this.exportfile = [];
			this.data.summeryCdrForm(JSON.stringify(this.summerymmsForm.value)).subscribe(response => {
				if (response.status == 200) {
					if(response.data.length > 0){
						for(let i of response.data){
							delete i.idmdr
							this.exportfile.push(i);
						}
						const worksheet: XLSX.WorkSheet = XLSX.utils.json_to_sheet(this.exportfile);
						const workbook: XLSX.WorkBook = { Sheets: { 'MMS-MDR': worksheet }, SheetNames: ['MMS-MDR'] };
						const excelBuffer: any = XLSX.write(workbook, { bookType: 'xlsx', type: 'array' });
						this.saveAsExcelFile(excelBuffer, "MMS-MDR");
					}
					else{
						this.errMessage = "Record Not Found !";
						setTimeout(() => {
							this.errMessage =""
						}, 5000);
					}
				}
				else {
					this.errMessage = response.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			});
		}
	}

	private saveAsExcelFile(buffer: any, fileName: string): void {
		const data: Blob = new Blob([buffer], {
			type: this.EXCEL_TYPE
		});
		saveAs(data, fileName + new Date().getTime() + this.EXCEL_EXTENSION);
	}

	startDate() {
		let now = new Date();
		let year = "" + now.getFullYear();
		let month = "" + (now.getMonth() + 1); if (month.length == 1) { month = "0" + month; }
		let day = "" + now.getDate(); if (day.length == 1) { day = "0" + day; }
		let hour = "" + now.getHours(); if (hour.length == 1) { hour = "0" + hour; }
		let minute = "" + now.getMinutes(); if (minute.length == 1) { minute = "0" + minute; }
		let second = "" + now.getSeconds(); if (second.length == 1) { second = "0" + second; }
		return year + '-' + month + "-" + "01";
	}


	current_datetime() {
		let now = new Date();
		let year = "" + now.getFullYear();
		let month = "" + (now.getMonth() + 1); if (month.length == 1) { month = "0" + month; }
		let day = "" + now.getDate(); if (day.length == 1) { day = "0" + day; }
		let hour = "" + now.getHours(); if (hour.length == 1) { hour = "0" + hour; }
		let minute = "" + now.getMinutes(); if (minute.length == 1) { minute = "0" + minute; }
		let second = "" + now.getSeconds(); if (second.length == 1) { second = "0" + second; }
		return year + '-' + month + "-" + day;
	}

	monthsList() {
		this.monthNameList = [
			{ name: "Jan", value: "1" },
			{ name: "Feb", value: "2" },
			{ name: "Mar", value: "3" },
			{ name: "Apr", value: "4" },
			{ name: "May", value: "5" },
			{ name: "Jun", value: "6" },
			{ name: "Jul", value: "7" },
			{ name: "Aug", value: "8" },
			{ name: "Sep", value: "9" },
			{ name: "Oct", value: "10" },
			{ name: "Nov", value: "11" },
			{ name: "Dec", value: "12" }
		];
	}


	static dateLessThan(from_date: string, to_date: string, validatorField: { [key: string]: boolean }): ValidatorFn {
		return (c: AbstractControl): { [key: string]: boolean } | null => {
			const date1 = c.get(from_date).value;
			const date2 = c.get(to_date).value;
			if ((date1 !== null && date2 !== null) && date1 > date2) {
				return validatorField;
			}
			return null;
		};
	}
	showfilter() {
		if (this.show_filter == false) {
			this.show_filter = true;
		}
		else {
			this.show_filter = false;
		}

	}
	showdaily() {
		if (this.show_daily == false) {
			this.show_daily = true;
		}
		else {
			this.show_daily = false;
		}
	}


	summeryMms() {
		this.summerymmsForm.patchValue({
			fType:""
		})
		if (this.summerymmsForm.invalid) {
			return false
		}
		else {
			this.filterSummaryMms=[];
			this.data.summeryCdrForm(JSON.stringify(this.summerymmsForm.value)).subscribe(response => {
				if (response.status == 200) {
					this.filterSummaryMms = response.data;
					$('#basic-datatables11b').DataTable().clear();
					$('#basic-datatables11b').DataTable().destroy();
					$.getScript('./assets/table.js');
				}
				else {
					this.errMessage = response.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			});
		}
	}

	resetMMdr() {
		this.submitted = false;
		// this.mmdrsForm.reset();
		this.ngOnInit();
		this.mmdrsForm.patchValue({
			from_date: this.startDate(),
			to_date: this.current_datetime(),
		})
		this.onMMdrsGet();
	}
	mmsSumry() {
		this.submitted = false;
		this.summerymmsForm.reset();
		this.summerymmsForm.get('directionSummery').setValue('Both');
		this.summerymmsForm.patchValue({
			from_date: this.lastdate,
			to_date: this.startdate
		})
		this.summeryMms();
	}
}
