import { Component, OnInit } from '@angular/core';
import { FormBuilder, FormControl, FormGroup, Validators } from '@angular/forms';
import { IDropdownSettings } from 'ng-multiselect-dropdown';
import { TariffService } from '../tariff.service';

@Component({
  selector: 'app-operator-mapping',
  templateUrl: './operator-mapping.component.html',
  styleUrls: ['./operator-mapping.component.css']
})
export class OperatorMappingComponent implements OnInit {
  page = 1;
  count = 0;
  tableSize = 50;
  tableSizes = [50, 100, 200];
  filterTerm: string;
  searchText = { count: 0 };
  filtre: string;
  closeDropdownSelection = true;

  strategy1: IDropdownSettings = {};
  strategy2: IDropdownSettings = {};
  strategy3: IDropdownSettings = {};

  strategyOptions1: any = [];
  strategyOptions2: any = [];
  strategyOptions3: any = [];
  responseMessage = "";
  operatorForm: FormGroup;
  submitted: boolean = false;
  mapdata: any = [];

  constructor(private tariffService: TariffService, private fb: FormBuilder) {
    this.operatorForm = this.fb.group({
      strategyOptions1: new FormControl(null, [Validators.required]),
      strategyOptions2: new FormControl(null, [Validators.required]),
      strategyOptions3: new FormControl(null, [Validators.required]),
    });
  }

  ngOnInit(): void {

    this.strategy1 = {
      singleSelection: true,
      idField: 'id',
      textField: 'name',
      itemsShowLimit: 3,
      allowSearchFilter: true,
      closeDropDownOnSelection: this.closeDropdownSelection
    };

    this.strategy2 = {
      singleSelection: true,
      idField: 'idlerg_operator',
      textField: 'category',
      itemsShowLimit: 3,
      allowSearchFilter: true,
      closeDropDownOnSelection: this.closeDropdownSelection
    };


    this.strategy3 = {
      singleSelection: false,
      idField: 'idlerg_operator',
      textField: 'operator',
      itemsShowLimit: 3,
      allowSearchFilter: true
    };

    this.tariffService.searchByOperator("").subscribe(res => {
      this.strategyOptions1 = res.data;

    }, err => {
      this.responseMessage = err.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 3000);
    });

    this.tariffService.categoryLergInfo().subscribe(res => {
      this.strategyOptions2 = res.data;
      $.getScript('./assets/table.js');
    }, err => {
      this.responseMessage = err.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 3000);
    });

    this.tariffService.getoperatormaping().subscribe(res => {
      this.mapdata = [];
      let tmp = res.data;
      tmp.forEach(ele => {
        this.mapdata.push(JSON.parse("{" + ele.name + "}"));
      });
    });
  }

  setMapping() {
    this.submitted = true;
    if (this.operatorForm.invalid) {
      return
    }
    else {
      let data = { operator1: this.operatorForm.value.strategyOptions1[0], category: this.operatorForm.value.strategyOptions2, operator2: this.operatorForm.value.strategyOptions3 };
      this.tariffService.setOperatorMapping(data).subscribe(res => {
        this.responseMessage = res.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 3000);
        this.ngOnInit();
      }, err => {
        this.responseMessage = err.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 3000);
      })
    }
  }


  onItemSelect(item: any) {
    this.tariffService.operatorsLergInfo(item).subscribe(res => {
      this.strategyOptions3 = res.data;
    }, err => {
      this.responseMessage = err.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 3000);
    });
  }

  deleteMapping(idmapping) {
    if (confirm("Are you sure you want delete Mapping!")) {
      this.tariffService.deleteMapping(idmapping).subscribe(res => {
        if (res.status == 201) {
          this.responseMessage = res.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 3000);
          this.ngOnInit();
        }
        else {
          this.responseMessage = res.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 3000);
          this.ngOnInit();
        }
      }, err => {
        this.responseMessage = err.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 3000);
      });
    }
    else {
      "Cancel"
    }
  }

  onReset() {    
    this.submitted = false;
    this.operatorForm.reset();    
  }

}
