import { Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import { TariffService } from '../tariff.service';
declare var $:any;
@Component({
  selector: 'app-service',
  templateUrl: './service.component.html',
  styleUrls: ['./service.component.css']
})
export class ServiceComponent implements OnInit {
  // userlistmodels
 @ViewChild('userlistmodels') userlistmodels: ElementRef;

  searchText = { count: 0 };
	filtre: string;
  hide:boolean=true;
  tariffs: any;
  page = 1;
	count = 0;
	tableSize = 50;
	tableSizes = [50, 100, 150];
  filterTerm: string;
	row: any;
  responseMessage = "";
  errMessage: any = "";
  preferenceServices: any = [];
  userlist: any = [];
  matchedUser : any = [];
  usercount: number = 0;
  constructor(private data: UsermanagementService,
              private tariffService: TariffService,
              private fb: FormBuilder ) { }

  ngOnInit(): void {
      this.tariffService.getPreferenceService().subscribe(res => {
        this.preferenceServices = res.data;        
        $('#basic-datatable01').DataTable().clear();
				$('#basic-datatable01').DataTable().destroy();
        $.getScript('./assets/table.js');
      }, err => {
          console.log(err);
      })
      this.data.getUsers("main").subscribe(res => {
        this.userlist = res.data[0];
        });
  }
  viewUser(idservice: any){
    this.matchedUser = [];
    this.usercount = 0;
    this.userlist.forEach((user:any)=>{
    if(user.idservice===idservice)
    {
      this.matchedUser.push(user);
    }
    })
    this.usercount = this.matchedUser.length;
    $('#basic-datatables1').DataTable().draw();
    $('#basic-datatables1').DataTable().destroy();
    $.getScript('./assets/table.js');
  }
  setAsDefaultService(idservice,iduser) {
		let data = idservice+ '-' + iduser;    
    this.tariffService.setDefault(data).subscribe((res) => {
			if (res.status == 201) {
				this.responseMessage = res.message;
				setTimeout(() => {
					this.responseMessage = "";
				}, 5000);
				this.ngOnInit();
			}
			else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		});
	}


  deleteService(idservice){
    if(confirm("Are you sure you want delete data!")){
      this.tariffService.deletePreferenceService(idservice).subscribe(res => {
        this.responseMessage = res.message;
        setTimeout(()=>{
          this.responseMessage= "";
        }, 5000);
        this.ngOnInit();
      }, err => {
        this.responseMessage = err.message;
        setTimeout( () => {
          this.responseMessage = "";
        }, 5000)
      })
    }else{
      "Cancel!";
    }
  }
  ngOnDestroy() {
    this.userlistmodels.nativeElement.click();
  }

}
