import { Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import { UsermanagementService } from '../usermanagement.service';
import { FormGroup } from '@angular/forms';
import { ActivatedRoute, ParamMap, Router } from '@angular/router';
import { interval as observableInterval } from "rxjs";
import { takeWhile, scan, tap } from "rxjs/operators";
declare var $: any;

@Component({
  selector: 'app-new-account',
  templateUrl: './new-account.component.html',
  styleUrls: ['./new-account.component.css']
})
export class NewAccountComponent implements OnInit {
  @ViewChild ('closeKYC') closeKYC : ElementRef;
  @ViewChild ('federalClose') federalClose : ElementRef;
  @ViewChild ('downloadpdf') downloadpdf : ElementRef;
  @ViewChild ('closebutton') closebutton : ElementRef;
  @ViewChild ('KYCverifcation') KYCverifcation : ElementRef;

  userlistFull: any = [];
  fedralListFull: any = [];
  userlist: any ;
  subCustomer: any = [];
  public userlistheader: any;
  countUser: any;
  kycStatus: any;
	KYCiduser: any;
	Kycidaccount: any;
  responseMessage = "";
  iduser: any;
  showKycPdf: any;
  showcardPdf: any;
  rechargeForm: FormGroup;
  errMessage: any = "";
  idaccount: any;
  kycPdfDetails: any =[];
  federalPdfDetails: any = [];
  showfederalPdf: any;
  userKycVerified: any =[];
  userFederalVerified: any =[];
  userKycReject: any =[];
  userFederalReject: any =[];
  kycPDF: any;
  federalPDF: any =[];
  federalList: any =[];
  kycLogPDF: any =[];
  kycLogList: any =[];
  constructor(public data: UsermanagementService,public router: Router) { }

  ngOnInit(): void {
    
    this.getUserList();
    this.data.getuserheader().subscribe((result) => {
      this.userlistheader = result.accountKyc;
    });
    this.data.getfederalPdfData().subscribe((res) => {
      this.federalPdfDetails = res.data;
    })
    this.data.getKycPdfData().subscribe((res) => {
        this.kycPdfDetails = res.data;
      })
    this.data.getFederalPDFAccount().subscribe(res => {
      this.federalPDF = res.data;
    });
    this.data.getKycPDFLog().subscribe(res => {
      this.kycLogPDF = res.data;
    });
  }


  getUserList(){
    this.data.getUsers("main").subscribe(res => {
      $('#basic-datatables05').dataTable().fnClearTable();
      $('#basic-datatables05').dataTable().fnDraw();
      $('#basic-datatables05').dataTable().fnDestroy();

      $('#basic-datatablesFed').dataTable().fnClearTable();
      $('#basic-datatablesFed').dataTable().fnDraw();
      $('#basic-datatablesFed').dataTable().fnDestroy();

      $('#basic-datatablesVer').dataTable().fnClearTable();
      $('#basic-datatablesVer').dataTable().fnDraw();
      $('#basic-datatablesVer').dataTable().fnDestroy();

      $('#basic-datatablesFA').dataTable().fnClearTable();
      $('#basic-datatablesFA').dataTable().fnDraw();
      $('#basic-datatablesFA').dataTable().fnDestroy();

      $('#basic-datatablesRej').dataTable().fnClearTable();
      $('#basic-datatablesRej').dataTable().fnDraw();
      $('#basic-datatablesRej').dataTable().fnDestroy();

      $('#basic-datatablesFR').dataTable().fnClearTable();
      $('#basic-datatablesFR').dataTable().fnDraw();
      $('#basic-datatablesFR').dataTable().fnDestroy();
      this.userlist = res.data[0];
      this.userlistFull = [];
      this.fedralListFull = [];
      this.userKycVerified = [];
      this.userFederalVerified = [];
      this.userKycReject = [];
      this.userFederalReject = [];
      this.userlist.forEach(element => { 

        if (element.kyc_verify_status == 1 && element.newUser_status == 1) {
          this.userKycVerified.push(element);
        
            let verifyPDF = this.kycPdfDetails.find(i => i.iduser == element.iduser);
            if(verifyPDF!=undefined)
            {
              element.kyc_pdf=verifyPDF.value
            }
        }  
        if (element.federal_status == 1 && element.newUser_status == 1) {
          this.userFederalVerified.push(element);
          let verifyFederalPDF = this.federalPDF.find(i => i.iduser == element.iduser && i.federal_status==1);
          if(verifyFederalPDF!=undefined)
          {
            element.federal_pdf=verifyFederalPDF.pdf
          } 
        }

        if (element.kyc_verify_status == 2 && element.newUser_status == 1) {
          this.userlistFull.push(element);
        }
        if (element.federal_status == 2 && element.newUser_status == 1) {
          this.fedralListFull.push(element);
        }

        if ((element.kyc_verify_status == 3 || element.kyc_verify_status == 4) && element.newUser_status == 1) {
          this.userKycReject.push(element);
          let rejectKycPDF = this.kycPdfDetails.find(i => i.iduser == element.iduser && (i.kyc_verify_status==3 || i.kyc_verify_status==4));
          if(rejectKycPDF!=undefined)
          {
            element.reject_kyc_pdf = rejectKycPDF.value;
          }
        }
        if (element.newUser_status == 1 && (element.federal_status == 3 || element.federal_status == 4)) {
          this.userFederalReject.push(element);
          let rejectFederalPDF = this.federalPDF.find(i => i.iduser == element.iduser && (i.federal_status==3 || i.federal_status==4));
          if(rejectFederalPDF!=undefined)
          {
            // there is fetching only last rejected pdf
            element.reject_federal_pdf=rejectFederalPDF.pdf
          }
        }
      });
      $.getScript('./assets/table.js');
    });
  }

  getKycstatus(data:any,iduser,idaccount){
    this.kycStatus=data;
    this.KYCiduser=iduser;
    this.Kycidaccount=idaccount;
    }
  /*Kyc Verify function*/
  verifyKyc() {
  let data = {
    idaccount: this.Kycidaccount,
    iduser: this.KYCiduser
  }
  this.data.kycVerify(data).subscribe((res) => {
    if (res.status == 201) {
      this.kycStatus = 1;
      this.responseMessage = res.message;
      setTimeout(() => {
        document.getElementById("closeKycModal").click();
        this.responseMessage = "";
      }, 5000);
      window.location.reload();
    }
    else {
      this.errMessage = res.message;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    }
  }, err => {
    this.responseMessage = err.message;
    setTimeout(() => {
      this.responseMessage = "";
    }, 5000);
  });
  }

  downloadPdf(iduser: any, idaccount: any) {
    this.iduser = iduser;
    this.idaccount = idaccount;
    let findedData = this.kycPdfDetails.find(i => i.iduser == this.iduser);
    if(findedData!=undefined)
    {
      this.showKycPdf=findedData.value
    }
    else{
      this.showKycPdf=false
    }
    let findUserCardPdf = this.userlistFull.find(j => j.iduser == this.iduser);
      if (findUserCardPdf != undefined) {
        this.showcardPdf = findUserCardPdf.card_pdf
      }
      else {
        this.showcardPdf = false
      }
    let findfederaldData = this.federalPdfDetails.find(k => k.iduser == this.iduser);
    if (findfederaldData != undefined) {
      this.showfederalPdf = findfederaldData.value;
      
    }
    else {
      this.showfederalPdf = false;
    }
  }

  pdfReview(iduser, idaccount) {
  this.router.navigate(['kyc/kyc-details', iduser + '-' + idaccount])
      .then(() => {
        location.reload();
      })
  }
  federalpdfReview(iduser, idaccount)
  {

    this.router.navigate(['federal/federal-details', iduser + '-' + idaccount])
      .then(() => {
        location.reload();
      })
  }
  resetFrm() {
    this.rechargeForm.reset();
    this.rechargeForm.patchValue({
      paymentType: 2
    })
  }

  federalLog(iduser){
    // this.federalList=[];
    $('#basic-datatables1').dataTable().fnClearTable();
    $('#basic-datatables1').dataTable().fnDraw();
    $('#basic-datatables1').dataTable().fnDestroy();
    this.federalPDF.forEach(element => {
      if(element.iduser == iduser){
        this.federalList.push(element)
      }
    });
      $.getScript('./assets/table.js');
  }

  // To dawnload all pdf
  downloadPDF(e){
      fetch(e).then(resp => resp.arrayBuffer()).then(resp => {
          // set the blog type to final pdf
          const file = new Blob([resp], {type: 'application/pdf'});
          // process to auto download it
          const fileURL = URL.createObjectURL(file);
          const link = document.createElement('a');
          link.href = fileURL;
          link.download = e.split('federal_pdf/')[1] || e.split('kyc_pdf/')[1] || e.split('card_pdf/')[1];
          link.click();
      });
  }
  kycLog(iduser){
    // this.kycLogList = [];
    $('#basic-datatables11').dataTable().fnClearTable();
    $('#basic-datatables11').dataTable().fnDraw();
    $('#basic-datatables11').dataTable().fnDestroy();
    this.kycLogPDF.forEach(element => {
      if(element.iduser == iduser){
        this.kycLogList.push(element)
      }
    });
    $.getScript('./assets/table.js');  
  }
  scrollToTop(el) {
		const duration = 10;
		const interval = 5;
		const move = el.scrollTop * interval / duration;
		observableInterval(interval).pipe(
			scan((acc, curr) => acc - move, el.scrollTop),
			tap(position => el.scrollTop = position),
			takeWhile(val => val > 0)).subscribe();
	}
  ngOnDestroy(){
    this.closeKYC.nativeElement.click();
    this.federalClose.nativeElement.click();
    this.downloadpdf.nativeElement.click();
    this.closebutton.nativeElement.click();
    this.KYCverifcation.nativeElement.click();
  }
}
