import { Component, ElementRef, EventEmitter, OnInit, Output, ViewChild } from '@angular/core';
import { UsermanagementService } from '../../usermanagement.service';
import * as pdfMake from 'pdfmake/build/pdfmake.js';
import * as pdfFonts from 'pdfmake/build/vfs_fonts.js';
import { environment } from 'src/environments/environment';
import { HttpClient, HttpRequest } from '@angular/common/http';
pdfMake.vfs = pdfFonts.pdfMake.vfs;
(pdfMake as any).vfs = pdfFonts.pdfMake.vfs;
import { DatePipe } from '@angular/common';
import html2PDF from 'jspdf-html2canvas';
import htmlToPdfmake from 'html-to-pdfmake';
import { AuthenticationService } from 'src/app/authentication/authentication.service';
import { MatDialogRef } from '@angular/material/dialog';
@Component({
  selector: 'app-final-invoice',
  templateUrl: './final-invoice.component.html',
  styleUrls: ['./final-invoice.component.css']
})
export class FinalInvoiceComponent implements OnInit {
  @ViewChild('htmlTable') pdfTable: ElementRef;
  @Output() submitClicked = new EventEmitter<any>();
  billData: any = [];
  public billingAddress: any;
  onLoad: boolean = false;
  username: any;
  monthYear: any;
  lastDate: any;
  total: any;
  fromHTML: any;
  current: any;
  responseMessage:any = "";
  idinvoice: any;
  errMessage: any = "";
  currentInvoice: any = [];
  invoiceData1_1: any = [];
  invoiceData1_2: any = [];
  invoiceData2_1: any = [];
  invoiceData2_2: any = [];
  invoiceData3: any = [];
  invoiceData4: any = [];
  invoiceData5: any = [];
  invoiceData6: any = [];
  invoiceData7: any = [];
  lastMonthInvoice: any = {};
  GrandTotal: number = 0;
  iNumber: any = "";
  calls: any;
  date: any = "";
  newFmt: any = [];
  body: any = [];
  body1: any = [];
  issueDate: any = "";
  status: boolean = false;
  idaccount: any = "";
  invoiceDataForCount: any = [];
  invoiceData1: any = [];
  invoiceData2: any = [];
  totalamt: any = 0;
  totalDue: any;
  finalCharge: any;
  previousDue: any;
  remainingWallet: any;
  taxes: any;
  showModel: boolean = false;
  getextradidMrc: any = 0;
  totalAccSummary: any = "";
  getextradidMrcQty: any;
  constructor(public data: UsermanagementService, public _http: HttpClient, private datePipe: DatePipe, protected authService: AuthenticationService,public dialogRef: MatDialogRef<FinalInvoiceComponent>) { }
  public userInfo: any;
  ngOnInit(): void {

    let session$ = sessionStorage.getItem("isLoggedIn");
    let session = JSON.parse(session$);
    this.idaccount = session.idaccount;

    this.data.get_addcard().subscribe((result) => {
      this.userInfo = result[2].finalinvoice;
    });

    this.data.getInvoiceDetails().subscribe(res => {
      if (res.status == 200) {
        this.submitClicked.emit({status:res.status,message:res.message});
        this.currentInvoice = res.data;
        this.previousDue = res.previousDue;
        this.totalamt = res.totalamt && res.totalamt ? res.totalamt : 0; 
        this.taxes = res.taxes && res.taxes != 'null' ? res.taxes : 0;
        this.remainingWallet = res.remainingWallet && res.remainingWallet != 'null' ? res.remainingWallet : '0.00';
        this.finalCharge = res.finalCharge && this.finalCharge != 'null' ? res.finalCharge : '0.00';
        this.totalDue = res.totaldue;
        this.getextradidMrc = res.getextradidMrc.cost ? res.getextradidMrc.cost : 0;
        this.getextradidMrcQty = res.getextradidMrc.did_qty ? res.getextradidMrc.did_qty : 0;
        // this.totalAccSummary = parseFloat(res.getextradidMrc.cost) + parseFloat(this.taxes) + parseFloat(this.previousDue);
        this.totalAccSummary = (parseFloat(res.getextradidMrc.cost) || 0) + (parseFloat(this.taxes) || 0) + (parseFloat(this.previousDue) || 0);
        this.status = true;
        this.body.push(
          [{ text: 'Item', style: 'header3' }, { text: 'Quantity', style: 'header3' }, { text: 'Total', style: 'header3' }],
          [{ text: 'Usage/Event Based Charges:\n\nCalling Activity:\n\nCalling/Inbound:', style: 'header3' }, '', ''],
        );
        this.currentInvoice.forEach(data => {
          if (data.category == 1 && data.subcategory == 1) {
            this.invoiceData1_1.push(data);
            this.body.push([{ text: `${data.label}`, style: 'subcategory' }, `${data.value && data.value != 'null' ? data.value : '0'}`, `${data.cost && data.cost != 'null' ? data.cost : '0.00'}`],)
          }
        });
        this.body.push(
          [{ text: '\nCalling/Outbound:', style: 'header3' }, '', ''],
        );
        this.currentInvoice.forEach(data => {
          if (data.category == 1 && data.subcategory == 2) {
            this.invoiceData1_2.push(data);
            this.body.push([{ text: `${data.label}`, style: 'subcategory' }, `${data.value && data.value != 'null' ? data.value : '0'}`, `${data.cost && data.cost != 'null' ? data.cost : '0.00'}`],)
          }
        });
        this.body.push([{ text: '\nMessaging Activity:\n\nSMS/Inbound:', style: 'header3' }, '', ''],);
        this.currentInvoice.forEach(data => {
          if (data.category == 2 && data.subcategory == 1) {
            this.invoiceData2_1.push(data);
            this.body.push([{ text: `${data.label}`, style: 'subcategory' }, `${data.value && data.value != 'null' ? data.value : '0'}`, `${data.cost && data.cost != 'null' ? data.cost : '0.00'}`],)
          }
        });
        this.body.push([{ text: '\nSMS/Outbound:', style: 'header3' }, '', ''],);
        this.currentInvoice.forEach(data => {
          if (data.category == 2 && data.subcategory == 2) {
            this.invoiceData2_2.push(data);
            this.body.push([{ text: `${data.label}`, style: 'subcategory' }, `${data.value && data.value != 'null' ? data.value : '0'}`, `${data.cost && data.cost != 'null' ? data.cost : '0.00'}`],)
          }
        });
        this.body.push([{ text: '\nNew One-Time and Monthly Recurring Activity:\n Numbering and Campaign Activity:\n\nNumbers:', style: 'header3' }, '', ''],);

        this.currentInvoice.forEach(data => {
          if (data.category == 3 && data.subcategory == 1 || (data.category == 3 && data.subcategory == 0)) {
            this.invoiceData3.push(data);
            this.body.push([{ text: `${data.label}`, style: 'subcategory' }, `${data.value && data.value != 'null' ? data.value : '0'}`, `${data.cost && data.cost != 'null' ? data.cost : '0.00'}`],)
          }
        });
        this.body.push([{ text: '\nA2P Campaign:', style: 'header3' }, '', ''],);
        this.currentInvoice.forEach(data => {
          if (data.category == 4) {
            this.invoiceData4.push(data);
            this.body.push([{ text: `${data.label}`, style: 'subcategory' }, `${data.value && data.value != 'null' ? data.value : '0'}`, `${data.cost && data.cost != 'null' ? data.cost : '0.00'}`],)
          }
        })
        if (Array.isArray(res.data) && res.data.length > 0) {
          this.date = this.datePipe.transform(this.currentInvoice[0].created_at, "MM-dd-yyyy");
          // this.GrandTotal = this.currentInvoice[0].grand_total;
        }
        this.showModel = true;
        this.createPDf();
      }
      else{
        this.submitClicked.emit({status:res.status,message:res.message});
      }
    });
  }

  createPDf() {
    var target = environment.SERVER + "sendInvoicePdf";
    var _http = this._http
    let payload = JSON.stringify({
      idaccount: '123',
      iduser: '45678',
      federal_status: '2'
    });
    const documentDefinition = {
      content: [
        {
          columns: [
            {
              width: '100%',
              text: 'Final Invoice',
              style: 'FinalInvoice'
            },
          ],
        },
        { text: '', style: 'space' },
        { canvas: [{ type: 'line', x1: 0, y1: 0, x2: 520, y2: 0, lineWidth: 0.5, lineColor: '#b6b2b2' }] },
        { text: '', style: 'space' },
        { text: 'Final Account Summary', style: 'header2' },
        { text: '', style: 'space' },
        {
          columns: [
            {
              width: '50%',
              text: 'Item',
              style: 'header',
            },

            {
              width: '30%',
              text: 'Quantity',
              style: 'header'
            },
            {
              width: '20%',
              text: 'Total',
              style: 'header'
            }
          ],
        },
        { text: '', style: 'space' },
        { canvas: [{ type: 'line', x1: 0, y1: 0, x2: 520, y2: 0, lineWidth: 0.5, lineColor: '#b6b2b2' }] },
        { text: '', style: 'space' },
        {
          columns: [
            {

              width: '50%',
              text: 'Previous Balance Due',
            },

            {
              width: '30%',
              text: ''
            },
            {
              width: '20%',
              text: `${this.previousDue !==undefined && this.previousDue !==null && this.previousDue ? this.previousDue : '0.00'}`
            }
          ],
        },
        { text: '', style: 'space' },
        { canvas: [{ type: 'line', x1: 0, y1: 0, x2: 520, y2: 0, lineWidth: 0.5, lineColor: '#b6b2b2' }] },
        { text: '', style: 'space' },
        {
          columns: [
            {

              width: '50%',
              text: 'Final Charges',
            },

            {
              width: '30%',
              text: `${this.getextradidMrcQty}`
            },
            {
              width: '20%',
              text: `${(this.getextradidMrc.toFixed(2))}`
            }
          ],
        },
        { text: '', style: 'space' },
        { canvas: [{ type: 'line', x1: 0, y1: 0, x2: 520, y2: 0, lineWidth: 0.5, lineColor: '#b6b2b2' }] },
        { text: '', style: 'space' },
        {
          columns: [
            {

              width: '50%',
              text: '',
            },

            {
              width: '30%',
              text: 'Taxes'
            },
            {
              width: '20%',
              text: `${this.taxes}`
            }
          ],
        },
        { text: '', style: 'space' },
        { canvas: [{ type: 'line', x1: 0, y1: 0, x2: 520, y2: 0, lineWidth: 0.5, lineColor: '#b6b2b2' }] },
        { text: '', style: 'space' },
        {
          columns: [
            {

              width: '50%',
              text: '',
            },

            {
              width: '30%',
              text: 'Total Due'
            },
            {
              width: '20%',
              text: `${(this.totalAccSummary).toFixed(2)}`
            }
          ],
        },
        { canvas: [{ type: 'line', x1: 0, y1: 0, x2: 520, y2: 0, lineWidth: 0.5, lineColor: '#b6b2b2' }] },
        { text: '', style: 'space1' },
        { text: '\nFinal Recurring Charges', style: 'header2' },
        { text: '', style: 'space' },
        {
          columns: [
            {
              width: '50%',
              text: 'Item',
              style: 'header',
            },

            {
              width: '30%',
              text: 'Quantity',
              style: 'header'
            },
            {
              width: '20%',
              text: 'Total',
              style: 'header'
            }
          ],
        },
        { text: '', style: 'space' },
        { canvas: [{ type: 'line', x1: 0, y1: 0, x2: 520, y2: 0, lineWidth: 2, lineColor: 'black' }] },
        { text: '', style: 'space' },
        {
          columns: [
            {

              width: '50%',
              text: 'Numbers:', style: 'number',
            },

            {
              width: '30%',
              text: ''
            },
            {
              width: '20%',
              text: ''
            }
          ],
        },
        { text: '', style: 'space' },
        { canvas: [{ type: 'line', x1: 0, y1: 0, x2: 520, y2: 0, lineWidth: 0.1, lineColor: '#b6b2b2' }] },
        {
          columns: [
            {
              width: '50%',
              text: 'Remaining Wallet',
            },
            {
              width: '30%',
              text: '0'
            },
            {
              width: '20%',
              text: `${this.previousDue !==undefined && this.previousDue !==null && this.previousDue ? this.previousDue : '0.00'}`
            }
          ]
        },
        { canvas: [{ type: 'line', x1: 0, y1: 0, x2: 520, y2: 0, lineWidth: 0.1, lineColor: '#b6b2b2' }] },
        {
          columns: [
            {
              width: '50%',
              text: 'Extra Did MRC',
            },
            {
              width: '30%',
              text: `${this.getextradidMrcQty}`
            },
            {
              width: '20%',
              text: `${(this.getextradidMrc).toFixed(2)}`
            }
          ]
        },
        { text: '', style: 'space' },
        { canvas: [{ type: 'line', x1: 0, y1: 0, x2: 520, y2: 0, lineWidth: 0.5, lineColor: '#b6b2b2' }] },
        { text: '', style: 'space' },
        // dynomic data under Platform Activity Charges
        {
          columns: [
            {
              width: '80%',
              // text: `\nPlatform Activity Charges (${this.currentInvoice[0].last_date})\n\n`,
              text: `\nPlatform Activity Charges\n\n`,
              style: 'header1',
            }
          ]
        },
        {
          layout: 'lightHorizontalLines',
          table: {
            headerRows: 1,
            widths: ['50%', "30%", '20%'],

            body: this.body,
          }
        },
        { canvas: [{ type: 'line', x1: 0, y1: 0, x2: 520, y2: 0, lineWidth: 0.1, lineColor: '#b6b2b2' }] },
        {
          columns: [
            {
              width: '80%',
              text: 'Total Amount(USD):',
              style: 'anotherStyle1'
            },
            {
              width: '20%',
              text: `$ ${(+this.totalamt+ +this.totalAccSummary).toFixed(2)}\n\n`,
              style: 'anotherStyle1'
            }
          ]
        }
      ],

      styles: {
        header: {
          fontSize: 12,
          bold: true,
          color: '#000000',
          padding: [5, 5, 5, 0]
        },
        header1: {
          fontSize: 13,
          bold: true,
          color: '#0339fc'
        },
        header2: {
          fontSize: 12,
          bold: true,
          color: '#0339fc'
        },
        column: {
          background: '#0339fc',

        },
        header3: {
          fontSize: 12,
          bold: true,
          padding: [5, 5, 5, 0]
        },
        subcategory: {
          margin: [18, 0, 0, 0],
        },
        note: {
          fontSize: 7,
        },
        date: {
          color: '#0339fc'
        },
        payment: {
          fontSize: 10,
        },
        mr: {
          fontSize: 18,
          bold: true,
          color: '#0339fc',
          margin: [0, 18, 0, 0],
        },
        anotherStyle: {
          alignment: 'right',
          bold: 'true'
        },
        anotherStyle1: {
          fontSize: 14,
          bold: 'true',
          color: '#0339fc',
          paddingTop: '20px',
        }
      }
    };
    //pdfMake.createPdf(documentDefinition).download(`chakrawarti`);
    const pdfDocGenerator = pdfMake.createPdf(documentDefinition);
    pdfDocGenerator.getBlob((blob) => {
      const pdfBlob = new Blob([blob], { type: 'application/pdf' });
      const fd = new FormData();
      fd.append("UPLOAD", pdfBlob, 'pdf');
      fd.append("UPLOAD", payload);
      const req = new HttpRequest('POST', target, fd, {
        reportProgress: true
      });
      _http.request(req).subscribe((res: any) => {

      })
    });
  }


  logoutSession(){
    this.data.confirmInvoice(this.idaccount).subscribe(res => {
      if(res.status == 200){
        this.dialogRef.close({ data: {}, reload: false });
        this.authService.logout();
      }
      else{
        this.errMessage = res.message;
      }
    });
  }
}
