import { Component, EventEmitter, Inject, OnInit, Output } from '@angular/core';
import { FormBuilder, FormControl, FormGroup, Validators } from '@angular/forms';
import { MatDialogRef, MAT_DIALOG_DATA } from '@angular/material/dialog';
import { Observable } from 'rxjs';
import { SmsService } from 'src/app/sms/sms.service';
import { UsermanagementService } from '../../usermanagement.service';
import 'rxjs/add/observable/timer';
import 'rxjs/add/operator/map';
import 'rxjs/add/operator/take';

@Component({
  selector: 'app-otpverify',
  templateUrl: './otpverify.component.html',
  styleUrls: ['./otpverify.component.css']
})


export class OtpverifyComponent implements OnInit {
  @Output() addCardClicked = new EventEmitter<any>();

  otpForm: FormGroup;
  submitted1: boolean = false;
  responseMessage: any = "";
  otpEnable: Boolean = false;
  countDown;
  counter: any;
  tick = 1000;
  num: number;
  errMessage: any = "";
  otpErr: string;
  
  constructor(public dialogRef: MatDialogRef<OtpverifyComponent>,
    @Inject(MAT_DIALOG_DATA) public data: any, private fb: FormBuilder, 
    private userSerive: UsermanagementService, protected smsService: SmsService) { }

  ngOnInit(): void {

      this.otpForm = this.fb.group({
        TO: new FormControl('',[Validators.required]),
        otp: new FormControl('')
    });
    
    this.otpForm.setValidators([Validators.required]);
  }

  sendOtp(){
    if(this.otpForm.invalid){
      this.submitted1 = true;
      return
    }
    else{
      let otp = Math.floor(100000 + Math.random() * 900000);
      let body = `Your Signalmash verification code is ${otp}`;
      this.userSerive.saveOtp({otp: otp, FROM: "2029808085", TO: this.otpForm.value.TO, BODY: body}).subscribe(response => {
        if(response.status == 201){
          sessionStorage.setItem("contact", this.otpForm.value.TO);
          this.submitted1 = false;
          this.otpEnable = true;
          this.num=this.otpForm.value.TO;
          let val: any = this.otpForm.get("TO");
          val.setValidators([]);
          val.updateValueAndValidity();
          let val2: any = this.otpForm.get("otp");
          val2.setValidators([Validators.required, Validators.minLength(6), Validators.maxLength(6)]);
          val2.updateValueAndValidity();
          this.counter = 120;
          this.countDown = Observable.timer(0, this.tick)
          .take(this.counter)
          .map(() =>  {
            if(this.counter <= 1){
              this.otpEnable = false;
              this.otpForm.patchValue({ TO: this.num });
              this.otpForm.get("otp").reset();
              let valdata: any = this.otpForm.get("TO");
              valdata.setValidators([Validators.required]);
              valdata.updateValueAndValidity();
              let valdata2: any = this.otpForm.get("otp");
              valdata2.setValidators([]);
              valdata2.updateValueAndValidity();
            }
            return --this.counter
          });
          this.addCardClicked.emit({message:response.message, status: response.status});  
        }
        else{
          this.addCardClicked.emit({message:response.message, status: response.status});      
        }               
      }, err => {
        this.addCardClicked.emit({message:err.message, status: err.status});
      });
    }
  // let otp = Math.floor(100000 + Math.random() * 900000);
  // let body = `Your Signalmash verification code is ${otp}`;
  // this.smsService.sendSMS({FROM: '8662179750', TO: this.data.contact, BODY: body }).subscribe(res => {
  //   if(res.status == 201){
  //     this.data.saveOtp({otp: otp, FROM: "8662179750", TO: this.data.contact}).subscribe(res => {
  //       this.responseMessage = res.message;  
  //         setTimeout(()=>{
  //           this.responseMessage= "";
  //         }, 3000);
  //         this.ngOnInit(); 
  //   });
  //   }  
  //   else{
  //       this.responseMessage = res.errorMessage;
  //       setTimeout(()=>{
  //         this.responseMessage= "";
  //       }, 3000);
  //       this.ngOnInit(); 
  //   }
  // }, err => {
  //   this.responseMessage = err.message;  
  //   setTimeout(()=>{
  //     this.responseMessage= "";
  //   }, 3000);
  // });
}


verifyNumber(){
  this.otpForm.patchValue({
    TO: this.data.contact
  });
  if(this.otpForm.invalid){
    this.submitted1 = true;
    return
  }
  else{
    this.otpForm.patchValue({
        TO: sessionStorage.getItem("contact")
    });
    this.userSerive.verifyOtp(this.otpForm.value).subscribe(res =>{
      if(res.status == 200){
        this.submitted1 = false;
        this.dialogRef.close({contact: this.data.contact, message: res.message});
      }
      else{
        this.addCardClicked.emit({message:res.message, status: res.status});
      }
    });
  }
}

  onClose() {
    this.dialogRef.close(this.data.contact);
  }
}
