import { Component, ViewChild, HostListener, ElementRef } from '@angular/core';
import { FormBuilder, FormControl, FormGroup, Validators } from '@angular/forms';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { ActivatedRoute, ParamMap, Router } from '@angular/router';
import { UsermanagementService } from '../../usermanagement.service';
import { mimeType } from "./mime-type-validator";
import { IDropdownSettings } from 'ng-multiselect-dropdown';
import { MatDialog, MatDialogConfig } from '@angular/material/dialog';
import { OtpverifyComponent } from '../otpverify/otpverify.component';
import { SmsService } from 'src/app/sms/sms.service';
import { BehaviorSubject } from 'rxjs';
import { NgbModal, ModalDismissReasons } from '@ng-bootstrap/ng-bootstrap';
import { PasswordComponent } from '../password/password.component';
import { BillingService } from 'src/app/billing/billing.service';
import { AddressComponent } from '../address/address.component';
import { BalanceComponent } from '../balance/balance.component';
import { AuthenticationService } from 'src/app/authentication/authentication.service';
import { AddCardComponent } from '../add-card/add-card.component';
import { FinalInvoiceComponent } from '../final-invoice/final-invoice.component';
import * as pdfMake from 'pdfmake/build/pdfmake.js';
import * as pdfFonts from 'pdfmake/build/vfs_fonts.js';
pdfMake.vfs = pdfFonts.pdfMake.vfs;
(pdfMake as any).vfs = pdfFonts.pdfMake.vfs;
@Component({
  selector: 'app-userprofile',
  templateUrl: './userprofile.component.html',
  styleUrls: ['./userprofile.component.css']
})

export class UserprofileComponent extends AppComponentClass<any, any>{
  @ViewChild('closePackage') closePackage: ElementRef;
  @ViewChild('creditcard') creditcard: ElementRef;
  profileForm: FormGroup;
  changepasswordForm: FormGroup;
  submitted1: boolean = false;
  submitted2: boolean = false;
  submitted3: boolean = false;
  private userlist$ = new BehaviorSubject<any>([{ iduser: -1, first_name: "", last_name: "", user_name: "", email: "", contact_number: "", password: "", profile_pic: "", pShow: false, pswd: "password" }]);
  userlist: any = this.userlist$.asObservable();

  private billingaddr$ = new BehaviorSubject<any>([{ "idbilling_address": -1, "idaccount": -1, "first_name": "", "last_name": "", "contact": "", "email": "", "address1": "", "address2": "", "city": "", "state": "", "postal_code": "", "country": "" }]);
  billingaddr: any = this.billingaddr$.asObservable();
  tariffForm: FormGroup;
  tariffSubbmitted: boolean = false;
  public key: number;
  imagePreview: any;
  // "/assets/img/profile.jpg"
  isPlan: Boolean = false;
  responseMessage = "";
  companyForm: FormGroup;
  companyData: any = [];
  curaccount: any;
  userType: any;
  balance: any = 0;
  password: any;
  activeLinkPayment$ = new BehaviorSubject<string>("");
  activeLinkPayment = this.activeLinkPayment$.asObservable();
  paymentMethod: any;
  defaultLink: any;
  country: any = [];
  strategy: IDropdownSettings = {};
  token: any = "";
  disabled: boolean = false;
  title: any;
  isEmailVerify: boolean = false;
  planname: string = "";
  ismonthly: boolean = false;
  price: string = "";
  isMobileVerify: boolean = false;
  isAddress: boolean = false;
  sesiduser: any;
  isPlanVerify: boolean = false;
  isAutoPayment: Boolean = false;
  isAutoEmail: Boolean = false;
  isAutowebhook: Boolean = false;
  userProfile: any = [];
  closeResult: string = '';
  profile_pic: any = File;
  campaigns: any = [];
  filterForm: FormGroup;
  dids: any = [];
  checkdelete: boolean = false;
  returnsms: boolean = false;
  isDeleted: any = '1';
  data1: any;
  active = {
    style1: "cursor: pointer;",
    style2: "cursor: pointer;",
    style3: "cursor: pointer;",
    style4: "cursor: pointer;",

  }
  balanceData: any = {};
  billingAddress: any = [];
  selectedItems = [];
  errMessage: any = "";
  closeDropdownSelection = true;
  inputvalue: any = '';
  /**
   * TimeZones Data
   */
  TimeZones: any = []
  UserTimeZone: any = {}
  timezone: number = 0
  IsTZ: boolean = false

  @ViewChild('closebutton') closebutton;
  userlength: any;
  idaccount: any;
  iduser: any;
  zipLength: any;
  resellerUser: any;
  resellerIduser: any;
  signupLink: any;
  type: string;
  idTariff: any;
  tariff: any;
  fixedTrf: any;
  planName: any;
  tariffIDs: any;
  san: any;
  stripeCards: any = [];
  expireDefaultCard: boolean = false;
  notAuthorization: boolean = false;
  stripeCardId: any;
  invalidCard: boolean = false;
  cardNumber: any = "";
  isLoading: boolean = false;
  finalinvoiceGen: boolean = false;
  disableCloseAccount: boolean = false;

  constructor(public data: UsermanagementService, private billing: BillingService,
    public router: Router, public fb: FormBuilder,
    private route: ActivatedRoute,
    public dialog: MatDialog, private modalService: NgbModal,
    private smsService: SmsService,
    protected authService: AuthenticationService,) {
    super(data, router, fb);

    this.password = "password";

    this.curaccount = JSON.parse(sessionStorage.getItem("isLoggedIn"));
    this.userType = this.curaccount.type;
    if (this.curaccount.isMobileVerfy == "true") {
      this.disabled = true;
      this.title = "Verify Phone Number";
    }
    else {
      this.disabled = false;
      this.title = "Phone Number Verified";
    }
  }

  ngOnInit(): void {
    let isLoggedIn = sessionStorage.getItem("isLoggedIn");
    this.sesiduser = JSON.parse(isLoggedIn);
    this.idaccount = this.sesiduser.idaccount;
    this.iduser = this.sesiduser.iduser;

    this.tariffForm = this.fb.group({
      tariff1: new FormControl('', [Validators.required])
    });

    this.strategy = {
      singleSelection: true,
      idField: 'id',
      textField: 'name',
      itemsShowLimit: 3,
      allowSearchFilter: true,
      closeDropDownOnSelection: true
    };

    this.country = [
      { id: 1, name: "US" },
      { id: 2, name: "Canada" }
    ]

    this.paymentMethod = "";
    this.defaultLink = "active";
    this.activeLinkPayment$.next("");
    this.route.paramMap.subscribe((params: ParamMap) => {
      let id = params.get('id');
      if (id == 'payment') {
        this.defaultLink = "";
        this.paymentMethod = "";
        this.activeLinkPayment$.next("active");
      }
    });

    this.dids = [];
    this.filterForm = this.fb.group({
      selectedUser: new FormControl(''),
      didnumber: new FormControl(''),
      didnpa: new FormControl(''),
      selectState: new FormControl(''),
      selectSMS: new FormControl('')
    });
    this.dids[0] = "Comming...";
    this.data.getAllDID(this.filterForm.value).subscribe(res => {
      if (res.status == 200) {
        this.dids = res.data.length;
      }
    });
    // get subCustomer Length
    this.data.getSubListUsers({ idaccount: this.idaccount, iduser: this.iduser, type: "profile" }).subscribe((result: any) => {
      if (result.status == 200) {
        this.userlength = result.data[0].length;
      }
    })

    this.data.getBalance().subscribe(response => {
      if (response.status == 200) {
        if (response.data.length > 0) {
          this.balance = response.data[0].balance;
          this.balanceData = response.data[0];
        }
      }
      else {
        this.errMessage = response.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.errMessage = err.message;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });

    this.profileForm = this.fb.group({
      iduser: [],
      first_name: ['', [Validators.required, Validators.minLength(3), Validators.maxLength(100)]],
      last_name: ['', [Validators.required, Validators.minLength(3), Validators.maxLength(100)]],
      contact_number: ['', [Validators.required, Validators.minLength(10), Validators.maxLength(11)]],
      profile_pic: [, { validators: [Validators.required], asyncValidators: [mimeType] }]
    });

    if (this.userType == 22) {
      this.companyForm = this.fb.group({
        idcompany: [''],
        company_name: [''],
        address: [''],
        city: [''],
        state: [''],
        postal_code: [''],
        country: [''],
        ein: [''],
        phone: [''],
        email: [''],
        website: ['']
      });
    }
    else {
      this.companyForm = this.fb.group({
        idcompany: [''],
        company_name: ['', [Validators.required]],
        address: ['', [Validators.required]],
        // city: ['', [Validators.required,  Validators.maxLength(50)]],
        city: ['', [Validators.required, Validators.pattern("^[a-zA-Z ]*$")]],
        state: ['', [Validators.required, Validators.pattern("^[a-zA-Z ]*$")]],
        // postal_code: ['', [Validators.required, Validators.pattern("^[0-9]*$"), Validators.minLength(5),]],
        postal_code: ['', [Validators.required]],
        country: ['', [Validators.required]],
        ein: ['', [Validators.required, Validators.minLength(9), Validators.maxLength(9)]],
        phone: ['', [Validators.required, Validators.minLength(10), Validators.maxLength(11)]],
        email: ['', [Validators.required, Validators.pattern("^([A-Za-z0-9._%+-]+)@([A-Za-z0-9-]+\\.[A-Za-z]{2,4})(\\.[A-Za-z]{2,4})?$")]],
        website: ['', [Validators.required, Validators.pattern(/^((ftp|http|https):\/\/)?www\.{0,1}[a-zA-Z0-9\.\-]+\.([a-zA-Z]{2,5})/)]]
      });
    }


    this.changepasswordForm = this.fb.group({
      old_password: ['', [Validators.required]],
      new_password: ['', [Validators.required]],
      confirm_password: ['', [Validators.required]]
    });

    this.data.companyProfile().subscribe(res => {
      if (res.status == 200) {
        if (res.data.length > 0) {
          this.companyData = res.data[0];
          this.companyForm.patchValue({
            idcompany: res.data[0].idcompany,
            company_name: res.data[0].company_name,
            address: res.data[0].address,
            city: res.data[0].city,
            state: res.data[0].state,
            postal_code: res.data[0].postal_code,
            ein: res.data[0].ein || '',
            phone: res.data[0].phone,
            email: res.data[0].email,
            website: res.data[0].website
          });
          this.selectedItems = [(res.data[0].country == "US" || res.data[0].country == "Canada") && res.data[0].country !== undefined ? res.data[0].country : null]
          setTimeout(() => {
            this.getStretegy('');
          }, 1000);
        }
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.errMessage = err.message;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });

    this.billingaddr$.subscribe(res => {
    });
    this.getBillingAdd();
    this.getUsers();

    /**
     * Load the TimeZones
     */
    this.GetTimeZones();

    /**
     * Load the user's TimeZone
     */
    this.GetUserTimeZone();
    /*
    * To get Campaign List By Iduser]
    */
    this.showAllCampData(this.sesiduser.idaccount, this.sesiduser.iduser)

    this.data.getResellerUsers().subscribe(result => {
      this.resellerUser = result.data;
      this.resellerIduser = this.resellerUser[0].reseller_iduser;
      this.signupLink = this.resellerUser[0].signup_link_id;
      this.type = JSON.stringify({
        key: this.signupLink,
        iduser: this.resellerIduser
      })
      this.data.getResellerTariff(this.type).subscribe(res => {
        if (res.status == 200) {
          this.idTariff = res.data;
          this.idTariff.forEach(ele => {
            this.tariff = ele.idtariff;
            if (this.tariffIDs == this.tariff && this.signupLink !== '') {
              this.planname = ele.name;
              this.fixedTrf = this.tariffIDs;
              this.active.style4 = "border: 3px solid #43ad5b;cursor: pointer;";
            }
            this.tariffForm.patchValue({
              tariff1: this.tariffIDs
            });
          });
          // this.responseMessage = res.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 3000);
        } else {
          this.errMessage = "";
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      }, err => {
        this.errMessage = err.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      });
    });
    this.getCards('');
  }

  getBillingAdd() {
    this.billing.getBillingAddress().subscribe(res => {
      if (res.status == 200) {
        this.billingAddress = res.data;
        this.billingaddr$.next(res.data);
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    });
  }
  getUsers() {
    this.data.getUsers("detail").subscribe(res => {
      if (res.status == 200) {
        this.userlist$.next(res.data[0]);
        this.userProfile = res.data[0];
        this.userProfile.forEach(element => {
          element.pShow = false;
          element.pswd = "password";
          this.san = element.san
        });

        let tmplist = res.data[0];
        this.tariffIDs = tmplist[0].idtariff;
        this.imagePreview = tmplist[0].profile_pic;
        this.profileForm.patchValue({
          iduser: tmplist[0].iduser,
          first_name: tmplist[0].first_name,
          last_name: tmplist[0].last_name,
          user_name: tmplist[0].user_name,
          email: tmplist[0].email,
          contact_number: tmplist[0].contact_number,
          password: tmplist[0].password,
          profile_pic: tmplist[0].profile_pic
        });
        this.tariffForm.patchValue({
          tariff1: this.tariffIDs
        });
        if (tmplist[0].idtariff == "142") {
          this.active.style1 = "border: 3px solid #43ad5b;cursor: pointer;";
          this.planname = "LAUNCH PLAN";
          this.price = "Pay As You Go"
        }
        if (tmplist[0].idtariff == "143") {
          this.active.style2 = "border: 3px solid #43ad5b;cursor: pointer;";
          this.planname = "GROWTH PLAN";
          this.price = "99";
          this.ismonthly = true;
        }
        if (tmplist[0].idtariff == "145") {
          this.active.style3 = "border: 3px solid #43ad5b;cursor: pointer;";
          this.planname = "SCALE PLAN";
          this.price = "2499";
          this.ismonthly = true;
        }
        if (!this.signupLink) {
          switch (tmplist[0].idtariff) {

            case 142:
            case "142":
              {
                this.planname = "LAUNCH PLAN";
                this.price = "Pay As You Go"
              }
              break;
            case 143:
            case "143":
              {
                this.planname = "GROWTH PLAN";
                this.price = "99";
                this.ismonthly = true;
              }
              break;
            case 145:
            case "145":
              {
                this.planname = "SCALE PLAN";
                this.price = "2499";
                this.ismonthly = true;
              }
              break;
            default:
              this.planname = "CUSTOM PLAN";
              break;
          }
        }
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.errMessage = err.message;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });
  }

  /*
  * To get Campaign List By Iduser]
  */
  showAllCampData(idaccount, iduser) {
    let payLoad = JSON.stringify({
      idaccount: idaccount,
      iduser: iduser
    })
    this.data.getCampaignForReview(payLoad).subscribe(result => {
      if (result.status == 200) {
        this.campaigns = result.data.length;
      }
      else {
        this.errMessage = result.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    });
  }
  /**
   * It will load the TimeZones
   */
  GetTimeZones(): void {
    this.data.GetTimeZones().subscribe(res => {
      if (res.error == 0) {
        this.TimeZones = res.data || []
      }
    }, err => {
      console.log("err::", err)
    });
  }


  /**
   * It will load the user's TimeZone
   */
  GetUserTimeZone(): void {
    this.data.GetUserTimeZone().subscribe(res => {
      if (res.error == 0) {
        this.UserTimeZone = res.data || {}
        this.timezone = this.UserTimeZone?.id_timezone || 0
      }
    }, err => {
      console.log("err::", err)
    });
  }


  /**
   * It will save/update the user's TimeZone
   */
  UpdateUserTimeZone(e: any): void {
    if (e) {
      let id_timezone: number = parseInt(e.target.value) || 0
      if (id_timezone > 0) {
        this.IsTZ = true
        this.data.UpdateUserTimeZone({
          timezone: id_timezone
        }).subscribe(res => {
          console.log("res::", res)
          alert(res.message)
          location.reload()
        }, err => {
          console.log("err::", err)
          alert(err)
        })
      }
      else {
        alert("Invalid Time Zone!")
      }
    }
  }

  open(content: any) {
    let mref = this.modalService.open(PasswordComponent, {
      ariaLabelledBy: 'modal-basic-title',
      backdrop: 'static'
    });
    mref.componentInstance.currentUser = content;
    mref.result.then((result) => {
      if (result.status) {
        this.responseMessage = ` ${result.message}`;
        setTimeout(() => {
          this.responseMessage = "";
        }, 2000);
        window.location.reload();
      }
    }, (reason) => {
      if (reason.status) {
        this.responseMessage = `${reason.message}`;
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
      }
    });
  }

  private getDismissReason(reason: any): string {
    if (reason === ModalDismissReasons.ESC) {
      return 'by pressing ESC';
    } else if (reason === ModalDismissReasons.BACKDROP_CLICK) {
      return 'by clicking on a backdrop';
    } else {
      return `with: ${reason}`;
    }
  }

  onImagePicked(event: Event) {
    const file = (event.target as HTMLInputElement).files[0];
    if (!file) {
      return;
    }
    const allowedExtensions = ["jpg", "jpeg", "png", "gif", "webp", "svg", "bmp", "tif"];
    const fileExtension = file.name.split('.').pop()?.toLowerCase();
    if (!allowedExtensions.includes(fileExtension)) {
      this.errMessage = "Please upload a valid image file";
      setTimeout(() => {
        this.errMessage = "";
      }, 2000)
      return;
    }
    this.profile_pic = file;
    const reader = new FileReader();
    reader.onload = () => {
      this.imagePreview = reader.result[0];

    }
    reader.readAsDataURL(this.profile_pic);

    this.data.updateProfilePic(this.profile_pic).subscribe((res) => {
      if (res.status == 201) {
        this.responseMessage = res.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
        window.location.reload();
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.responseMessage = err.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    });
  }

  onImageRemove(event: Event) {
    this.data.removeProfilePic(this.profile_pic).subscribe((res) => {
      if (res.status == 201) {
        this.responseMessage = res.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
        window.location.reload();
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.responseMessage = err.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    });
  }

  updateProfile() {
    this.submitted1 = true;
    if (this.profileForm.invalid) {
      return;
    }
    else {
      this.profileForm.patchValue({
        country: this.profileForm.value.country[0].name
      });
      this.data.updateProfile(this.profileForm.value, this.profileForm.value.profile_pic).subscribe((res) => {
        if (res.status == 201) {
          this.responseMessage = res.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
          window.location.reload();
        }
        else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      }, err => {
        this.responseMessage = err.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
      });
    }
  }

  /*Show country */
  getStretegy(event) {
    this.companyForm.patchValue({
      Strategy: event.name
    });
    if (this.userType !== 22) {
      this.specialNumber('');
    }
    if (event.name) {
      this.selectedItems = [event.name];
      if (this.selectedItems[0] == "US") {
        this.zipLength = '';
        let post = this.companyForm.get('postal_code').value;

        if (post.length != 5) {
          this.companyForm.get('postal_code').setValue('');
        }
      }
      if (this.selectedItems[0] == "Canada") {
        this.zipLength = '';
        let post = this.companyForm.get('postal_code').value;

        if (post.length != 7) {
          this.companyForm.get('postal_code').setValue('');
        }
      }
    }
  }

  onCompanyProfile() {

    this.submitted2 = true;
    if (this.companyForm.value.country[0] == "Select country") {
      this.errMessage = "Kindly Select Country!";
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
      return true;
    }

    if (this.companyForm.invalid) {
      return
    }
    else {
      this.data.updateCompanyProfile(this.companyForm.value).subscribe(res => {
        if (res.status == 201) {
          this.responseMessage = res.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
        }
        else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      }, err => {
        this.errMessage = err.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      })
    }
  }


  keyToggle(id) {
    this.userProfile.forEach(element => {
      if (element.iduser == id) {
        if (element.pswd == 'password') {
          element.pswd = 'text';
          element.pShow = true;
        } else {
          element.pswd = 'password';
          element.pShow = false;
        }
      }
    });
  }


  textMessageFunc(msgText) {
    this.responseMessage = "Copied to Clipboard";
    setTimeout(() => {
      this.responseMessage = "";
    }, 5000);
  }


  verifyMobile(contact) {
    this.submitted1 = true;
    // if(this.profileForm.invalid){
    //   this.errMessage = "Contact Number Invalid ";
    //   setTimeout(() => {
    //     this.errMessage = "";
    //   }, 5000);
    // } 
    // else{
    const dialogRef = this.dialog.open(OtpverifyComponent, {
      data: { contact: contact },
      disableClose: true
    });
    dialogRef.componentInstance.addCardClicked.subscribe(result => {
      if (result.status == 201) {
        this.responseMessage = result.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
      }
      else {
        this.errMessage = result.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    });
    dialogRef.afterClosed().subscribe(result => {
      this.disabled = false;
      this.responseMessage = result.message;
      this.getUsers();
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    });
    // }
  }

  specialNumber(event: any): boolean {
    if (this.selectedItems[0] == "Canada") {
      this.zipLength = 10;
      let Post: any = this.companyForm.get("postal_code");
      Post.setValidators([Validators.required, Validators.minLength(0), Validators.maxLength(this.zipLength)]);
      Post.updateValueAndValidity();
      var regex = new RegExp("^[0-9a-zA-Z \b]+$");
      var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
      if (!regex.test(key)) {
        // event.preventDefault();
        return false;
      }
    }
    if (this.selectedItems[0] == "US") {
      this.zipLength = 5;
      let Post: any = this.companyForm.get("postal_code");
      Post.setValidators([Validators.required, Validators.minLength(this.zipLength), Validators.maxLength(this.zipLength)]);
      Post.updateValueAndValidity();

      const charCode = (event.which) ? event.which : event.keyCode;
      if (charCode > 31 && (charCode < 48 || charCode > 57)) {
        return false;
      }
      return true;
    }
  }

  editAddress(address) {
    const dialogRef = this.dialog.open(AddressComponent, {
      data: address,
      disableClose: true
    });

    dialogRef.afterClosed().subscribe(result => {
      this.disabled = false;
      if (result.error == 0)
        this.responseMessage = result.message;
      else
        this.errMessage = result.message;
      setTimeout(() => {
        this.responseMessage = "";
        this.errMessage = "";
        this.getBillingAdd();
      }, 5000);
    });
  }

  updatePlan() {
    this.tariffSubbmitted = true;
    if (this.tariffForm.invalid) {
      return
    }
    else {
      this.data.updateTariff(this.tariffForm.value).subscribe(res => {
        if (res.status == 201) {
          $("#exampleModal").hide();
          $(".modal-backdrop").remove();
          this.isPlan = false;
          this.responseMessage = res.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
          location.reload();
        }
        else {
          this.errMessage = res.errMessage;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      }, err => {
        this.errMessage = err.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      })
    }
  }

  trfId(trfId) {
    this.tariffForm.patchValue({
      tariff1: trfId
    });
    this.fixedTrf = trfId
  }

  addClick(plan) {
    if (this.resellerIduser < 0 && this.resellerIduser != null && this.resellerIduser != undefined) {
      this.active.style1 = "";
      this.active.style2 = "";
      this.active.style3 = "";
      this.active.style4 = "border: 3px solid #43ad5b; cursor: pointer;";
    } else {
      if (plan == "LAUNCH_PLAN") {
        this.active.style1 = "border: 3px solid #43ad5b; cursor: pointer;";
        this.active.style2 = "";
        this.active.style3 = "";
        this.active.style4 = "";
        this.tariffForm.patchValue({
          tariff1: 142
        });
      }
      else if (plan == "GROWTH_PLAN") {
        this.active.style1 = "";
        this.active.style2 = "border: 3px solid #43ad5b; cursor: pointer;";
        this.active.style3 = "";
        this.active.style4 = "";
        this.tariffForm.patchValue({
          tariff1: 143
        });
      }
      else if (plan == "SCALE_PLAN") {
        this.active.style1 = "";
        this.active.style2 = "";
        this.active.style3 = "border: 3px solid #43ad5b; cursor: pointer;";
        this.active.style4 = "";
        this.tariffForm.patchValue({
          tariff1: 145
        });
      }
    }
  }

  addBalance() {
    const dialogRef = this.dialog.open(BalanceComponent, {
      data: { balance: this.balanceData, userProfile: this.userProfile, address: this.billingAddress },
      disableClose: true
    });
    dialogRef.componentInstance.submitClicked.subscribe(result => {
      this.errMessage = result;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });
    dialogRef.afterClosed().subscribe(result => {
      if (result.reload) {
        this.disabled = false;
        window.location.reload();
        this.responseMessage = result.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
      }
      else {
        this.errMessage = result.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    });
  }

  callCheck() {
    this.returnsms = false;
  }

  onYes() {
    if (!this.checkdelete) {
      this.returnsms = true;
      return;
    }
    else {
      if (this.balance >= 0) {
        this.closebutton.nativeElement.click();
        this.responseMessage = "Your account's step one getting successfully deleted!";
        setTimeout(() => {
          this.responseMessage = "";
        }, 3000);
        setTimeout(() => {
          // this.authService.logout();
          this.router.navigateByUrl('/delete-process');
        }, 4000);
      }
      else {
        setTimeout(() => {
          this.responseMessage = "Your Balance Is Low";
        }, 3000);
      }
    }
  }
  resetCheckbox() {
    this.checkdelete = false;
  }
  getCards(data: any) {
    this.data.stripeCards().subscribe(res => {
      if (res.status == 200) {
        this.stripeCards = res.data;
        let cardCounting: any = 0;
        let now = new Date();
        let year = Number("" + now.getFullYear());
        let month: any = Number("" + (now.getMonth() + 1)); if (month.length == 1) { month = "0" + month; }
        this.stripeCards.forEach(element => {
          let DefaultCardMonth = Number(element.exp_month);
          let DefaultCardYear = Number(element.exp_year);
          if ((DefaultCardMonth < month && DefaultCardYear < year) || (DefaultCardYear == year && DefaultCardMonth < month) || (DefaultCardMonth > month && DefaultCardYear < year) || (DefaultCardMonth == month && DefaultCardYear < year)) {
            cardCounting = cardCounting + 1;
            if (this.stripeCards.length == cardCounting) {
              this.invalidCard = true;
            }
          }
          if (element.default == "true" || element.default == true) {
            this.cardNumber = element.last4
          }
        });
        if (data) {
          this.expireDefaultCard = false;
          this.notAuthorization = false;
          this.generateInvoiceErr();
        }
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    });
  }

  generateInvoiceErr() {
    let now = new Date();
    let year = Number("" + now.getFullYear());
    let month: any = Number("" + (now.getMonth() + 1)); if (month.length == 1) { month = "0" + month; }
    this.stripeCards.forEach(element => {
      if (element.default == "true" || element.default == true) {
        let DefaultCardMonth = Number(element.exp_month);
        let DefaultCardYear = Number(element.exp_year);
        if ((DefaultCardMonth < month && DefaultCardYear < year) || (DefaultCardYear == year && DefaultCardMonth < month) || (DefaultCardMonth > month && DefaultCardYear < year) || (DefaultCardMonth == month && DefaultCardYear < year)) {
          this.expireDefaultCard = true;
          this.errMessage = "Your Card Is Expired Please Change Your Card";
          this.stripeCardId = element.idstripecard;
        }
        if (element.card_pdf == null || element.card_pdf == "null" || element.card_pdf == undefined || element.card_pdf == "undefined" || element.card_pdf == '' || !element.card_pdf.includes('card_pdf')) {
          this.notAuthorization = true;
          this.stripeCardId = element.idstripecard;
          this.errMessage = "Your Card Is Not Authorized  Please Change Your Card";
        }
        // if(this.expireDefaultCard || this.notAuthorization){
        //   this.redError = true;
        // }
        // else{
        //   this.redError = false;
        // }       
      }
    });
    setTimeout(() => {
      this.errMessage = "";
    }, 5000);
  }

  addcard() {
    const dialogRef = this.dialog.open(AddCardComponent, {
      data: {},
      disableClose: true,
    });
    dialogRef.componentInstance.addCardClicked.subscribe(result => {
      if (result.status == 200) {
        this.responseMessage = result.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
      }
      else {
        this.errMessage = result.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    });
  }

  finalinvoice() {
    this.isLoading = true;
    const dialogRef = this.dialog.open(FinalInvoiceComponent, {
      data: {},
      disableClose: true
    });
    dialogRef.componentInstance.submitClicked.subscribe(result => {
      if (result.status == 200) {
        this.finalinvoiceGen = true;
        this.responseMessage = result.message;
        setTimeout(() => {
          this.isLoading = false;
        }, 3000);
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
      }
      else {
        this.errMessage = result.message;
        this.isLoading = false;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    });
    dialogRef.afterClosed().subscribe(result => {
      this.disabled = false;
      // window.location.reload();
    });
  }
  @HostListener("window:beforeunload", ["$event"]) unloadHandler(event: Event) {
    if (this.finalinvoiceGen) {
      localStorage.clear();
      sessionStorage.clear();
    }
  }
  ngOnDestroy() {
    this.closePackage.nativeElement.click();
    this.creditcard.nativeElement.click();
  }
}
