import { NgModule } from '@angular/core';
import { Routes, RouterModule } from '@angular/router';
import { UsermanagementComponent } from './usermanagement/usermanagement.component';
import { DeleteuserComponent } from './deleteuser/deleteuser.component';
import { SupplieruserComponent } from './supplieruser/supplieruser.component';
import { UserprofileComponent } from './profile/userprofile/userprofile.component';
import { UsersettingComponent } from './profile/usersetting/usersetting.component';
import { MyratesComponent } from './myrates/myrates.component';
import { CustomerrateComponent } from './customerrate/customerrate.component';
import { EdituserComponent } from './edituser/edituser.component';
import { SubusersComponent } from './subusers/subusers.component';
import { VerifyprofileComponent } from './profile/verifyprofile/verifyprofile.component';
import { BalanceComponent } from './profile/balance/balance.component';
import { DomainBlockerComponent } from './domain-blocker/domain-blocker.component';
import { CreditCardAuthComponent } from './credit-card-auth/credit-card-auth.component';
import { AccountActionComponent } from './account-action/account-action.component';
import { NewAccountComponent } from './new-account/new-account.component';
import { InvoiceCardAuthComponent } from './profile/invoice-card-auth/invoice-card-auth.component';

const routes: Routes = [

    {
        path: '',
        children: [
            {
                path: '',
                component: UsermanagementComponent,
                data: {
                    title: 'Dashboard',
                    urls: [
                        {
                            title: 'Dashboard',
                            url: '/dashboards/dashboard'
                        },
                        {
                            title: 'Dashboard'
                        }
                    ]
                }
            },
            {
                path: 'user-details',
                component: UsermanagementComponent,
                data: {
                    title: 'Accounts',
                    urls: [
                        {
                            title: 'Accounts',
                            //   url: 'user'
                        },
                        {
                            title: 'User Details'
                        }
                    ]
                }
            },
            { 
                path: 'user-details',
                children: [
                  {
                    path: 'idservice/:id',
                    component: UsermanagementComponent,
                    data: {
                      title: 'Accounts',
                      urls: [
                        { title: 'Accounts' },
                        { title: 'User Details' }
                      ]
                    }
                  },
                  {
                    path: 'idtariff/:id',
                    component: UsermanagementComponent,
                    data: {
                      title: 'Accounts',
                      urls: [
                        { title: 'Accounts' },
                        { title: 'User Details' }
                      ]
                    }
                  }
                ]
            },
            {
                path: 'new-account',
                component: NewAccountComponent,
                data: {
                    title: 'New Accounts',
                    urls: [
                        {
                            title: 'New Account',
                            //   url: 'user'
                        },
                        {
                            title: 'New Account'
                        }
                    ]
                }
            },
            {
                path: 'delete-user-details',
                component: DeleteuserComponent,
                data: {
                    title: 'Deleted Accounts',
                    urls: [
                        {
                            title: 'Deleted Accounts',
                            //   url: 'user'
                        },
                        {
                            title: 'Delete User Details'
                        }
                    ]
                }
            },
            {
                path: 'user-profile',
                component: UserprofileComponent,
                data: {
                    title: 'Profile',
                    urls: [
                        {
                            title: 'User',
                            // url: 'user-profile'
                        },
                        {
                            title: 'User Profile '
                        }
                    ]
                }
            },

            {
                path: 'user-profile/:id',
                component: UserprofileComponent,
                data: {
                    title: 'Profile',
                    urls: [
                        {
                            title: 'User',
                            // url: 'user-profile'
                        },
                        {
                            title: 'User Profile '
                        }
                    ]
                }
            },

            {
                path: 'sub-users/:id',
                component: SubusersComponent,
                data: {
                    title: 'Sub Users',
                    urls: [
                        {
                            title: 'User',

                        },
                        {
                            title: 'Sub Users '
                        }
                    ]
                }
            },
            {
                path: "edit-user/:id",
                component: EdituserComponent,
                data: {
                    title: "Edit User",
                    urls: [
                        {
                            title: 'Edit User',
                            // url: 'user-profile'
                        },
                        {
                            title: 'Edit User'
                        }
                    ]
                }
            },
            {
                path: 'my-rates',
                component: MyratesComponent,
                data: {
                    title: 'Rate List',
                    urls: [
                        {
                            title: 'Accounts',
                            // url: 'my-rates'
                        },
                        {
                            title: 'Rate List'
                        }
                    ]
                }
            },

            {
                path: 'myrates',
                component: CustomerrateComponent,
                data: {
                    title: 'Rate List',
                    urls: [
                        {
                            title: 'Accounts',
                            // url: 'my-rates'
                        },
                        {
                            title: 'Rate List'
                        }
                    ]
                }
            },

            {
                path: 'user-setting',
                component: UsersettingComponent,
                data: {
                    title: 'Accounts',
                    urls: [
                        {
                            title: 'Sub Account',
                            // url: 'user-setting'
                        },
                        {
                            title: 'User List'
                        }
                    ]
                }
            },
            {
                path: 'invoice-card-auth',
                component: InvoiceCardAuthComponent,
                data: {
                    title: 'Credit Card Authorization',
                }
            },
            {
                path: 'invoice-card-auth/:id',
                component: InvoiceCardAuthComponent,
                data: {
                    title: 'Credit Card Authorization',
                }
            },
            {
                path: 'supplier-user',
                component: SupplieruserComponent,
                data: {
                    title: 'User Management',
                    urls: [
                        {
                            title: 'Accounts',
                            // url: 'supplier-user'
                        },
                        {
                            title: 'Supplier User'
                        }
                    ]
                }
            },
            {
                path: 'credit-card-authorization',
                component: CreditCardAuthComponent,
                data: {
                    title: 'Credit Card Authorization',
                }
            },

            {
                path: 'balance',
                component: BalanceComponent,
                data: {
                    title: "Balance"
                }
            },
            {
                path: 'verify-profile',
                component: VerifyprofileComponent,
                data: {
                    title: "User Profile"
                }
            },
            {
                path: 'verify-profile/:id',
                component: VerifyprofileComponent,
                data: {
                    title: "User Profile"
                }
            },
            {
                path: 'account-action',
                component: AccountActionComponent,
                data: {
                    title: 'account-action',
                }
            },
            {
                path: 'domain-block',
                component: DomainBlockerComponent,
                data: {
                    title: 'Domain block',
                    urls: [
                        {
                            title: 'Domain block',
                            // url: 'supplier-user'
                        },
                        {
                            title: 'Domain block'
                        }
                    ]
                }
            },
        ]
    }
];

@NgModule({
    imports: [RouterModule.forChild(routes)],
    exports: [RouterModule]
})
export class UsermanagementRoutingModule { }
