import { Component, ViewChild, Input, ElementRef,TemplateRef, } from '@angular/core';
import { Validators, FormBuilder, FormControl, FormGroup, ValidatorFn, AbstractControl } from '@angular/forms';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { AdddialogComponent } from '../usermanagement/adddialog/adddialog.component';
import { MatDialog } from '@angular/material/dialog';
import { usermanagement, usermanagementForm } from '../user.class';
import { UsermanagementService } from '../usermanagement.service'
import { ActivatedRoute, ParamMap, Router } from '@angular/router';
import { BehaviorSubject, Observable } from 'rxjs';
import { environment } from 'src/environments/environment';
import { MatAccordion } from '@angular/material/expansion';
import { BillingService } from 'src/app/billing/billing.service';
import { NgbActiveModal } from '@ng-bootstrap/ng-bootstrap';
import { I } from '@angular/cdk/keycodes';
import { SuspendedServicesComponent } from '../suspended-services/suspended-services.component';
import { TariffService } from 'src/app/tariff/tariff.service';
declare var $: any;

@Component({
	selector: 'app-usermanagement',
	templateUrl: './usermanagement.component.html',
	styleUrls: ['./usermanagement.component.css']
})

export class UsermanagementComponent extends AppComponentClass<usermanagement, usermanagementForm> {

	@ViewChild(MatAccordion) accordion: MatAccordion;
	@Input() usertype: Observable<boolean>;
	@Input() curuserid?: number = -1;
	@ViewChild ('informationmodal') informationmodal : ElementRef;
	@ViewChild('addressTab') addressTab: ElementRef;
	@ViewChild ('modalpdf') modalpdf : ElementRef;
	@ViewChild ('addamountmodule') addamountmodule : ElementRef;
	@ViewChild('billingMessagemodal') billingMessagemodal: ElementRef;
	@ViewChild('deleteacountmodal') deleteacountmodal: ElementRef;
	searchText = { count: 0 };
	filtre: string;
	p: number = 1;
	toggleValue = "Customer";

	private userlist$ = new BehaviorSubject<any>([{ iduser: -1, first_name: "", last_name: "", user_name: "", email: "", contact_number: "", password: "", profile_pic: "", pShow: false, pswd: "password" }]);
	userlist: any = this.userlist$.asObservable();


	private billingaddr$ = new BehaviorSubject<any>([{ "idbilling_address": -1, "idaccount": -1, "first_name": "", "last_name": "", "contact": "", "email": "", "address1": "", "address2": "", "city": "", "state": "", "postal_code": "", "country": "" }]);
	billingaddr: any = this.billingaddr$.asObservable();

	//hedding = "Add User";
	list: any;
	list1: any;
	record: any;
	user_id: any;
	account_id: any;
	dids: any[];
	userlength: any;
	filterForm: any;
	campaigns: any;
	planname: string;
	tmplist: any;
	price: string;
	ismonthly: boolean;
	//userlist: any = [];
	userlistFull: any = [];
	//public supplier : boolean = false;
	public __supplier = new BehaviorSubject<boolean>(false);
	public supplier = this.__supplier.asObservable();
	listdata: any;
	ratemanagedata: any = [];
	rateData: any = [];
	// defaultSelect : any = 1;
	sessData: any;
	defaultUser: any;
	page = 1;
	count = 0;
	tableSize = 50;
	tableSizes = [50, 100, 150];
	public show: boolean = false;
	public toggle_cust: boolean = true;
	public userlistheader: any;
	public subuserlistheader: any;
	public buttonName: any = "Add";
	public usermanagementForm: FormGroup;
	public submitted: boolean = false;
	filterTerm: string;
	public dis_toggle: boolean = false;
	fileToUpload: File = null;
	file: any;
	headers: any;
	newFeatures: Observable<any>;
	row: any;
	suppliers: any;
	ids: any = [];
	public show1: boolean = true;
	responseMessage = "";
	public DidUpload = environment.SERVER + "uploads/document_upload";
	groupID: any;
	countUser: any;
	password: any;
	pShow = false;
	rechargeForm: FormGroup;
	billingAddress: any;

	tab1$ = new BehaviorSubject<any>("");
	tab1 = this.tab1$.asObservable();
	tab1Value = "";
	tab2$ = new BehaviorSubject<any>("");
	tab2 = this.tab2$.asObservable();
	tab2Value = "";
	tab3$ = new BehaviorSubject<any>("");
	tab3 = this.tab3$.asObservable();
	tab3Value = "";
	tab4$ = new BehaviorSubject<any>("");
	tab4 = this.tab4$.asObservable();
	tab4Value = "";
	tab5$ = new BehaviorSubject<any>("");

	inboundForm: FormGroup;
	outboundForm: FormGroup;

	public __hedding = new BehaviorSubject<string>("Users List");
	public hedding = this.__hedding.asObservable();
	filteredItems: any;
	errMessage: any = "";
	userProfile: any = [];
	balance: any;
	balanceData: any;
	userPro: any = [];
	stylecls: string;
	styleclsmob: string;
	styleclseml: string;
	styleclspln: string;
	styleclsdid: string;
	styleclssms: string;
	styleclsvoice: string;
	subCustomer: any = [];
	onboardingstatus: string;
	vstspln: string;
	vstseml: string;
	vstsmob: string;
	tooltp: string;
	fullname: any;
	customerName: string;
	styleclsbadd: string;
	vstsbadd: string;
	isbilling: any;
	color: any;
	msg: any;
	BilValue: any;
	idaccount: any;
	iduser: any;
	isActiveEnable: any;
	isActiveDisable: any;
	is_billing: any;
	returnsms: boolean = false;
	data1: any;
	checkdelete: boolean = false;
	isDeleted: any = '2';

	@ViewChild('closebutton') closebutton;
	userdata: any;
	billingMessage: string = "";
	kycPdfDetails: any = [];
	showKycPdf: any;
	showcardPdf: any;
	kycStatus: any;
	KYCiduser: any;
	Kycidaccount: any;
	federalPdfDetails: any = [];
	showfederalPdf: any;
	cardPdfDetails: any = [];
	federalPDF: any;
	rejectFederalStatus: any;
	federalStatus: any;
	selectVal: boolean;
	noSelectVal: boolean;
	styleclscard: string;
	vstscard: string;
	featureServiceData: any;
	IDaccount: any;
	trustscore: any;
	Trust_Score: any;
	showFilter: boolean = false;
	filterUser: FormGroup;
	preferenceServices: any = [];
	regTariffs: any = [];
	Users: any = [];
	customer: any;
	id : any ; 
	isIdServiceRoute: boolean = false;
	isIdTariffRoute: boolean = false;
	public custoDfilter: FormGroup;
	reloaduserlist: any = [];
	constructor(public data: UsermanagementService, public router: Router, private route: ActivatedRoute, private tariffService: TariffService,
		public fb: FormBuilder, public dialog: MatDialog, private billing: BillingService, private el: ElementRef
	) {
		super(data, router, fb);
	}

	ngOnInit(): void {

		this.rechargeForm = this.fb.group({
			// amount: new FormControl(null, [Validators.required, Validators.min(1),
			// 	 Validators.max(50000000), Validators.pattern(/^\d*(?:[.,]\d{1,2})?$/)]),
			amount: new FormControl(null, [Validators.required, Validators.min(1),
			Validators.max(50000000)]),
			idaccount: new FormControl(''),
			email: new FormControl(''),
			description: new FormControl('', [Validators.required, Validators.minLength(10), Validators.maxLength(255)]),
			currentDateTime: new FormControl(this.current_datetime()),
			paymentType: new FormControl('2', [Validators.required])
		});
		this.filterUser = this.fb.group({
			to_date: [''],
			from_date: [''],
			service: [''],
			regTariff: [''],
			idaccount: [''],
			onboarding: ['']
		});

		this.route.params.subscribe(params => {
			this.id = +params['id'];
			this.isIdServiceRoute = this.route.snapshot.routeConfig.path.includes('idservice');
			this.isIdTariffRoute = this.route.snapshot.routeConfig.path.includes('idtariff');
	  
			if (this.isIdServiceRoute) {
				console.log('Service ID:', this.id);
				this.showAccountfilter()
			    this.filterUser.get('service').setValue(this.id);
				this.applyUserFilter();
			  
			} 
			else if (this.isIdTariffRoute) {			 
			  console.log('Tariff ID:', this.id);
			  this.showAccountfilter()
			  this.filterUser.get('regTariff').setValue(this.id);
			  this.applyUserFilter();
			}

			else{

				this.GetUsers()
			}
		  });
		this.password = "password";

		this.sessData = JSON.parse(sessionStorage.getItem("isLoggedIn"));
		this.defaultUser = this.sessData.default;

		// @subscribing form group
		let curaccount: any = JSON.parse(sessionStorage.getItem("isLoggedIn"));

		this.supplier.subscribe(res => {
		});

		this.newFeatures = this.data.getFeature();

		this.data.getuserheader().subscribe((result) => {
			this.userlistheader = result.adminHeader;
		});

		// To load the users list
		// this.GetUsers()
		// To load the users this.down()

		this.data.getSuppliers().subscribe(supplier => {
			this.suppliers = supplier.data[0];
			//this.show=false;
		});


		this.data.solution.subscribe(res => {
			if (res != null) {
				this.cdata = new usermanagementForm(res);
				if (curaccount.type == 1) {
					this.cdata.idaccount = -1;
					this.cdata.iduser = -1;
				}
				if (curaccount.type == 2) {
					this.cdata.idaccount = curaccount.idaccount;
					this.cdata.iduser = -1;
				}
				if (curaccount.type == 3) {
					this.cdata.idaccount = curaccount.idaccount;
					this.cdata.iduser = -1;
				}
				this.keyfield = res.id;
				this.usermanagementForm = this.cdata.makeform(this.fb);
			} else {
				this.cdata = new usermanagementForm(null);
				this.keyfield = -1;
				this.usermanagementForm = this.cdata.makeform(this.fb);
			}
		});

		this.data.getrecord().subscribe((result) => {
			this.record = result[0].headers_details;
			this.list1 = result[0].profile_details;
		})

		this.data.gettier().subscribe((result) => {
			this.listdata = result[0].headers;
			this.row = result[0].invoice;
		});

		this.data.getrecord().subscribe((result) => {
			this.headers = result[0].headers_details;
			this.list = result[0].profile_details;
		});

		this.data.getKycPdfData().subscribe((res) => {
			this.kycPdfDetails = res.data;
		})

		this.data.getfederalPdfData().subscribe((res) => {
			this.federalPdfDetails = res.data;
		})

		this.data.getCardPdfForAdmin().subscribe((res) => {
			this.cardPdfDetails = res.data;
		})

		this.data.getFederalPDFAccount().subscribe(res => {
			this.federalPDF = res.data;
		});

		this.data.getfeatureService().subscribe((res) => {
			this.featureServiceData = res.data;
		});

		this.data.trustScore().subscribe((res) => {
			this.Trust_Score = res.data;
		});
		this.tariffService.getPreferenceService().subscribe(res => {
			this.preferenceServices = res.data;
		}, err => {
			console.log(err.message);
		});

		// Get tariffs
		this.tariffService.getTariffs().subscribe(res => {
			this.regTariffs = res.data;
		}, err => {
			console.log(err.message);
		});
		// this.route.params.subscribe(params => {
		// 	this.selectedIdTariff = +params['idtariff'];
		// 	console.log(this.selectedIdTariff,"idd");
		// 	this.filterUser.get('regTariff').setValue(this.selectedIdTariff);
		// });

	}

	sendMessage(): void {
		this.data.sendUpdate('updated service!');
	}

	/**
	 * It will load the user's list
	 */

	GetUsers(): void {
		this.data.getUsers("main").subscribe(res => {
			$('#basic-datatables07').dataTable().fnClearTable();
			$('#basic-datatables07').dataTable().fnDraw();
			$('#basic-datatables07').dataTable().fnDestroy();
			this.userlist = res.data[0];
			this.userlistFull = [];
			this.userlist.forEach(element => {
				if (element.is_deleted == 0) {
					this.userlistFull.push(element);
					this.reloaduserlist= this.userlistFull;
				}
			});
			// let users = res.data[0];
			// let user = users[0];
			// this.fullname = user.user_name;
			$.getScript('./assets/table.js');
			this.userlistFull.forEach(element => {
				if (element.is_billing == '0') {
					element.color = 'green';
					element.msg = 'Billing is Enabled';
				} else {
					element.color = 'red';
					element.msg = 'Billing is Disabled'
				}
				element.pShow = false;
				element.pswd = "password";

				if (element.isAddress != 'true' || element.isEmailVerify != 'true' || element.isMobileVerify != 'true' || element.isPlan != 'true') {
					element.onboardingstatus = "red";
					element.tooltp = "On-Boarding In Process";
				} else if (element.newUser_status == 1 && element.isCard != "true") {
					element.onboardingstatus = "red";
					element.tooltp = "On-Boarding In Process";
				}
				else {
					element.onboardingstatus = "green";
					element.tooltp = "On-Boarding Complete";
				}

				// if (element.isAddress == 'true' && element.isEmailVerify == 'true' && element.isMobileVerify == 'true' && element.isPlan == 'true') {
				// 	element.onboardingstatus = "green";
				// 	element.tooltp = "On-Boarding Complete";
				// } else {
				// 	element.onboardingstatus = "red";
				// 	element.tooltp = "On-Boarding In Process";
				// }
			});
			this.countUser = res.data[0];
		});



	}


	/**
	 * Account Morphing
	 * It will make login into new tab of selected customer
	 */
	loginUser(data: any) {
		let userLogin = { username: data.user_name, password: data.password, typeCheck: 'admin_checking', sessionType: "MORPHING" };
		this.data.userLogin(userLogin).subscribe(res => {
			if (res.authkey) {
				let userData = res;
				this.router.navigate([], { state: { userData: userData } }).then(result => {
					window.open(window.location.origin + '/#/dashboards/dashboard/' + userData.authkey, '_blank');
				});
			}
			else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		});
	}

	keyToggle(id) {
		this.userlist.forEach(element => {
			if (element.iduser == id) {
				if (element.pswd == 'password') {
					element.pswd = 'text';
					element.pShow = true;
				} else {
					element.pswd = 'password';
					element.pShow = false;
				}
			}
		});
	}

	textMessageFunc(msgText) {
		this.responseMessage = "Copied to Clipboard";
		setTimeout(() => {
			this.responseMessage = "";
		}, 5000);
	}

	CheckNULL(data) {
		if (data == null)
			return 0;
		else
			return data;
	}

	SaveRates(rdata: any) {
		let str = "";
		rdata.forEach(element => {
			str += element.key + "-" + this.CheckNULL(element.data.usage) + "-" + this.CheckNULL(element.data.recurringmrc) + "-" + this.CheckNULL(element.data.setup) + "-" + this.CheckNULL(element.data.portinnrc) + "-" + this.CheckNULL(element.data.portoutnrc) + "-" + this.CheckNULL(element.data.disconnect) + ",";
		});
		str = str.slice(0, -1);
		this.data.saveRates(str).subscribe(res => {
		});
	}


	/**
	 * To open the wallet recharge dialog
	 */
	adminRecharge(data: any): void {
		this.customerName = data.first_name + " " + data.last_name;
		this.rechargeForm.patchValue({
			idaccount: data.idaccount,
			email: data.email
		});
	}


	/**
	 * To recharge the custom'r wallet manually
	 */
	onRecharge(): any {
		this.submitted = true;
		if (this.rechargeForm.invalid) {
			return
		}
		else {
			if (confirm("Please Confirm Amount: $" + this.rechargeForm.value.amount)) {
				this.data.AdminRecharge(this.rechargeForm.value).subscribe(res => {
					this.submitted = false
					if (res.status == 201) {
						// To re-render the user's data		
						this.GetUsers()
						this.rechargeForm.reset();
						this.rechargeForm.patchValue({
							paymentType: 2
						})
						// this.closebutton.nativeElement.click();
						this.responseMessage = res.message;
						setTimeout(() => {
							this.responseMessage = "";
						}, 5000);
					}
					else {
						this.errMessage = res.message;
						setTimeout(() => {
							this.responseMessage = "";
						}, 5000);
					}
					this.closeModal();
				});
			}
			else {
				return
			}
		}
	}

	resetFrm() {
		this.submitted = false
		this.rechargeForm.reset();
		this.rechargeForm.patchValue({
			paymentType: 2
		})
	}

	closeModal(): void {
		const modalElement: HTMLElement | null =
			this.el.nativeElement.querySelector('.recharge-modal-sm');
		if (modalElement) {
			modalElement.classList.remove('show');
			modalElement.style.display = 'none';
		}

		const modalBackdrop: HTMLElement | null =
			document.querySelector('.modal-backdrop');
		if (modalBackdrop) {
			modalBackdrop.remove();
		}
		document.body.classList.remove('modal-open');
	}


	editdata(tabs: any, iduser: any) {
		switch (tabs) {
			case 1: {
				this.tab1Value = "active";
				this.tab2Value = "";
				this.tab3Value = "";
				this.tab4Value = "";
				break;
			}
			case 2: {
				this.tab1Value = "";
				this.tab2Value = "active";
				this.tab3Value = "";
				this.tab4Value = "";
				break;
			}
			case 3: {
				this.tab1Value = "";
				this.tab2Value = "";
				this.tab3Value = "active";
				this.tab4Value = "";
				break;
			}
			case 4: {
				this.tab1Value = "";
				this.tab2Value = "";
				this.tab3Value = "";
				this.tab4Value = "active";
				break;
			}
		}
		this.data.getSingleUsersForAdmin(iduser).subscribe(res => {
			if (res.status == 200) {
				//this.userlist$.next(res.data[0]);
				this.userProfile = [];
				this.userProfile = res.data[0];
				this.userPro = res.data1[0];
				if (this.userPro.isMobileVerify == 'true') {
					this.styleclsmob = 'green fa fa-check';
					this.vstsmob = 'Verified';
				} else {
					this.styleclsmob = 'red fa fa-times';
					this.vstsmob = 'Not Verified';
				}
				if (this.userPro.isEmailVerify == 'true') {
					this.styleclseml = 'green fa fa-check';
					this.vstseml = 'Verified';
				} else {
					this.styleclseml = 'red fa fa-times';
					this.vstseml = 'Not Verified';
				}
				if (this.userPro.isPlan == 'true') {
					this.styleclspln = 'green fa fa-check';
					this.vstspln = 'Verified';
				} else {
					this.styleclspln = 'red fa fa-times';
					this.vstspln = 'Not Verified';
				}
				if (this.userPro.isAddress == 'true') {
					this.styleclsbadd = 'green fa fa-check';
					this.vstsbadd = 'Verified';
				} else {
					this.styleclsbadd = 'red fa fa-times';
					this.vstsbadd = 'Not Verified';
				}
				if (this.userPro.isCard == 'true') {
					this.styleclscard = 'green fa fa-check';
					this.vstscard = 'Verified';
				} else {
					this.styleclscard = 'red fa fa-times';
					this.vstscard = 'Not Verified';
				}

				if (this.userPro.did == 'yes') {
					this.styleclsdid = 'green fa fa-check';
				} else {
					this.styleclsdid = 'red fa fa-times';
				}
				if (this.userPro.sms == 'yes') {
					this.styleclssms = 'green fa fa-check';
				} else {
					this.styleclssms = 'red fa fa-times';
				}
				if (this.userPro.voice == 'yes') {
					this.styleclsvoice = 'green fa fa-check';
				} else {
					this.styleclsvoice = 'red fa fa-times';
				}
				this.data.getuserheader().subscribe((result) => {
					this.subuserlistheader = result.headers_sub_details1;
				});

				this.data.getCustSubListUsers({ idaccount: this.userProfile.idaccount, iduser: iduser, type: "profile" }).subscribe((result: any) => {
					//this.subCustomer = result.data[0];
					$('#basic-datatableses').dataTable().fnClearTable();
					$('#basic-datatableses').dataTable().fnDraw();
					$('#basic-datatableses').dataTable().fnDestroy();
					$.getScript('./assets/table.js');
					this.subCustomer = result.data[0];
				}, err => {
					console.log(err.message);
				});

				// this.userProfile.forEach(element => {
				// element.pShow = false;
				// element.pswd = "password";
				// });
			}
			else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.errMessage = err.message;
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		});

	}

	dismissModal() {
		this.show = false;
		this.addressTab.nativeElement.click();
		this.tab1Value = "active";
		//this.ngOnInit();
	}

	adduser(iduser, type, account, newUser_status) {
		const dialogRef = this.dialog.open(AdddialogComponent, {
			width: '600px', disableClose: true,
			data: { iduser: iduser, type: type, idaccount: account, newUser_status: newUser_status, dialogtype: 1, savetype: 1 }
		});

		dialogRef.afterClosed().subscribe(res => {
			if (res == 1) {
				this.responseMessage = res.message;
				setTimeout(() => {
					this.responseMessage = "";
				}, 5000);
			}
		})

	}

	deleteUser(iduser, idaccount) {
		let sdata = { "iduser": iduser, "sesidaccount": idaccount, "isDeleted": 1 }
		if (confirm("Are you sure you want delete data!")) {
			this.data.onDeleteAccount(sdata).subscribe(result => {
				this.responseMessage = result.message;
				setTimeout(() => {
					this.responseMessage = "";
				}, 5000);
				window.location.reload();
			})
		} else {
			"Cancel!";
		}
	}

	toggle() {
		this.show = !this.show;
		if (this.show) {
			this.buttonName = "Close";
			this.__hedding.next("Add Customer");
			this.ngOnInit();
		}
		else {
			this.buttonName = "Add";
			this.__hedding.next("User List");
			this.ngOnInit();
		}
	}

	ResetFrm() {
		// this.isActiveEnable = '';
		// this.isActiveDisable = '';
	}

	// to update the payment status
	onPaymentStatusChange(event: any, idaccount: any): void {
		this.IDaccount = idaccount;
		this.trustscore = event.target.value;

		this.sendpayment();
	}

	sendpayment() {
		let payLoad = JSON.stringify({
			idaccount: this.IDaccount,
			trustscore: this.trustscore
		})
		this.data.Sendpayment(payLoad).subscribe(res => {
			if (res.status == 200) {
				this.responseMessage = res.message;
				setTimeout(() => {
					this.responseMessage = "";
				}, 5000);
			}
			else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.errMessage = err.message;
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		});

	}

	BillingValue(val: any) {
		this.billingMessage = "";
		if (val == 0) {
			this.billingMessage = "Do you want to disable for billing";
		}
		if (val == 1) {
			this.billingMessage = "Do you want to enable for billing";
		}
		this.BilValue = val;
	}

	sendAccount(iduser: any, idaccount: any, is_billing: any) {
		this.iduser = iduser;
		this.idaccount = idaccount;
		this.is_billing = is_billing;
		setTimeout(() => {
			if (this.is_billing == '0') {
				// this.isActiveEnable = 'nav-link active show';
				// this.isActiveDisable = '';
				this.billingMessage = "Do you want to disable for billing"
				// this.selectVal = true;
				// this.noSelectVal = false;
				document.getElementById("enableId").click();
			} else {
				// this.isActiveEnable = '';
				// this.isActiveDisable = 'nav-link active show';
				this.billingMessage = "Do you want to enable for billing"
				// this.selectVal = false;
				// this.noSelectVal = true;
				document.getElementById("disableId").click();

			}
			console.log('selectVal', this.selectVal, 'noSelectVal=>', this.noSelectVal, 'isActiveEnable=>', this.isActiveEnable, 'isActiveDisable=>', this.isActiveDisable)
		}, 0);

	}

	downloadPdf(iduser: any, idaccount: any) {
		this.federalStatus = '';
		this.iduser = iduser;
		this.idaccount = idaccount;
		let findedData = this.kycPdfDetails.find(i => i.iduser == this.iduser && i.kyc_verify_status == '1');
		if (findedData != undefined) {
			this.showKycPdf = findedData.value
		}
		else {
			this.showKycPdf = false
		}
		// let findUserCardPdf = this.userlistFull.find(j => j.iduser == this.iduser);
		// if (findUserCardPdf != undefined) {
		// 	this.showcardPdf = findUserCardPdf.card_pdf
		// }
		// else {
		// 	this.showcardPdf = false
		// }
		let findCardData = this.cardPdfDetails.find(x => x.idaccount == this.idaccount && x.card_pdf !== '');
		if (findCardData != undefined) {
			this.showcardPdf = findCardData.card_pdf;
		}
		else {
			this.showcardPdf = false;
		}

		let findfederaldData = this.federalPDF.find(k => k.iduser == this.iduser && k.federal_status == '1');
		if (findfederaldData != undefined) {
			this.showfederalPdf = findfederaldData.pdf;
			this.federalStatus = findfederaldData.federal_status;

		}
		else {
			let findrejectfederaldData = this.federalPDF.find(j => j.iduser == this.iduser && j.federal_status == '4');
			if (findrejectfederaldData != undefined) {
				this.showfederalPdf = findrejectfederaldData.pdf;
				this.federalStatus = findrejectfederaldData.federal_status;

			}
			else {
				this.showfederalPdf = false;
			}
		}


	}

	billingEnable() {
		let bVal = this.BilValue
		let data = {
			bVal: bVal,
			idaccount: this.idaccount
		}
		this.data.billingEnable(data).subscribe((res) => {
			if (res.status == 201) {
				this.responseMessage = res.message;
				setTimeout(() => {
					this.responseMessage = "";
				}, 5000);
				window.location.reload();
			}
			else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.responseMessage = err.message;
			setTimeout(() => {
				this.responseMessage = "";
			}, 5000);
		});
	}

	// @to edit the record
	editRow(data: any): void {
		data["dialogtype"] = 2;
		data["savetype"] = 1;
		const dialogRef = this.dialog.open(AdddialogComponent, {
			width: '600px', disableClose: true,
			data
		});

		dialogRef.afterClosed().subscribe(res => {
			if (res == 1)
				this.data.getUsers("main").subscribe(res => {
					this.userlist = res.data[0];
				});
		});
	}

	change() {
		this.__supplier.next(this.toggle_cust);
		this.toggle_cust = !this.toggle_cust;
		if (this.toggle_cust) {
			this.toggleValue = "Customer";
			this.show1 = true;
		}
		else {
			this.toggleValue = "Supplier";
			this.show1 = false;
		}
		if (this.toggle_cust) {
			this.__hedding.next("Add Customer");
		}
		else {
			this.__hedding.next("Add Supplier");
		}
	}

	onUpload(event) {
	}
	
	startDate() {
		let now = new Date();
		let year = "" + now.getFullYear();
		let month = "" + (now.getMonth() + 1); if (month.length == 1) { month = "0" + month; }
		let day = "" + now.getDate(); if (day.length == 1) { day = "0" + day; }
		let hour = "" + now.getHours(); if (hour.length == 1) { hour = "0" + hour; }
		let minute = "" + now.getMinutes(); if (minute.length == 1) { minute = "0" + minute; }
		let second = "" + now.getSeconds(); if (second.length == 1) { second = "0" + second; }
		return year + '-' + month + "-" + "01";
	}

	current_datetime() {
		let now = new Date();
		let year = "" + now.getFullYear();
		let month = "" + (now.getMonth() + 1); if (month.length == 1) { month = "0" + month; }
		let day = "" + now.getDate(); if (day.length == 1) { day = "0" + day; }
		let hour = "" + now.getHours(); if (hour.length == 1) { hour = "0" + hour; }
		let minute = "" + now.getMinutes(); if (minute.length == 1) { minute = "0" + minute; }
		let second = "" + now.getSeconds(); if (second.length == 1) { second = "0" + second; }
		return year + "-" + month + "-" + day //+ " " + hour + ":" + minute + ":" + second;
	}

	showAllCampData(idaccount, iduser) {
		this.user_id = iduser;
		this.account_id = idaccount;

		let payLoad = JSON.stringify({
			idaccount: idaccount,
			iduser: iduser
		})
		// get campaign
		this.campaigns = '';
		this.data.getCampaignForReview(payLoad).subscribe(result => {
			if (result.status == 200) {
				this.campaigns = result.data.length;
			}
			else {
				this.errMessage = result.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		});

		// get plan
		this.planname = '';
		this.data.getSubscriptionPlan(payLoad).subscribe(result => {
			if (result.status == 200) {
				this.tmplist = result.data[0];
				if (this.tmplist != undefined) {
					switch (this.tmplist.idtariff) {
						case 142:
						case "142":
							{
								this.planname = "LAUNCH PLAN";
								this.price = "Pay As You Go"
							}
							break;
						case 143:
						case "143":
							{
								this.planname = "GROWTH PLAN";
								this.price = "99";
								this.ismonthly = true;
							}
							break;
						case 145:
						case "145":
							{
								this.planname = "SCALE PLAN";
								this.price = "2499";
								this.ismonthly = true;
							}
							break;
						default:
							this.planname = "CUSTOM PLAN";
							break;
					}
				}
			}
			else {
				this.errMessage = result.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		});

		//Balance
		this.balance = '';
		this.data.getcustBalance({ idaccount: idaccount, iduser: iduser }).subscribe(response => {
			if (response.status == 200) {
				if (response.data.length > 0) {
					this.balance = response.data[0].balance;
				}
			}
			else {
				this.errMessage = response.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.errMessage = err.message;
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		});

		//subCustomer
		this.userlength = '';
		this.data.getSubListUsers({ idaccount: idaccount, iduser: iduser, type: "profile" }).subscribe((result: any) => {
			if (result.status == 200) {
				this.userlength = result.data[0].length;
			}
		});

		// Dids
		this.dids = [];
		this.filterForm = this.fb.group({
			selectedUser: this.user_id + '-' + this.account_id
		});
		this.dids[0] = 'comming...';
		this.data.custDidsCount(this.filterForm.value).subscribe(res => {
			if (res.status == 200) {
				this.dids = res.data.length;
			}
		});

	}

	callCheck() {
		this.returnsms = false;
	}

	resetCheckbox() {
		this.checkdelete = false;
	}

	onYes() {
		if (!this.checkdelete) {
			this.returnsms = true;
			return;
		}
		else {
			this.data.getSingleUsersForAdmin(this.user_id).subscribe(res => {
				if (res.status == 200) {
					this.userdata = res.data1[0];

					if ((this.userdata.isAddress == 'true' && this.userdata.isEmailVerify == 'true') && (this.userdata.isMobileVerify == 'true' && this.userdata.isPlan == 'true')) {
						this.isDeleted = 1;
						this.data1 = {
							sesiduser: this.user_id,
							sesidaccount: this.account_id,
							isDeleted: this.isDeleted
						}
						this.deleteCustomeAc();
					}
					else {
						this.isDeleted = 2;
						this.data1 = {
							sesiduser: this.user_id,
							sesidaccount: this.account_id,
							isDeleted: this.isDeleted
						}
						this.deleteFinalAc();
					}
				}
			});
		}
	}
	deleteCustomeAc() {
		this.data.onDeleteAccount(this.data1).subscribe((res) => {
			if (res.status == 201) {
				document.getElementById("DeleteAccountModal").click();
				// this.ngOnInit();
				this.responseMessage = res.message
				setTimeout(() => {
					this.responseMessage = "";
					window.location.reload();
				}, 3000);
			}
			else {
				this.errMessage = res.message
				setTimeout(() => {
					this.errMessage = "";
				}, 4000);
			}
		});
	}
	deleteFinalAc() {
		this.data.onFinalDeleteAccount(this.data1).subscribe((res) => {
			if (res.status == 201) {
				document.getElementById("DeleteAccountModal").click();
				// this.ngOnInit();
				window.location.reload();
				this.responseMessage = "You have successfully deleted this account!";
				setTimeout(() => {
					this.responseMessage = "";
				}, 3000);
			}
		});
	}

	getAmount(e: any) {
		this.amount = e.target.value;
		this.rechargeForm.patchValue({
			amount: this.amount
		});
		let data = e.target.value;
		e.target.value = (data.indexOf(".") >= 0) ? (data.substr(0, data.indexOf(".")) + data.substr(data.indexOf("."), 2)) : data;
		return;
	}

	getKycstatus(data: any, iduser, idaccount) {
		this.kycStatus = data;
		this.KYCiduser = iduser;
		this.Kycidaccount = idaccount;
	}


	pdfReview(iduser, idaccount) {
		this.router.navigate(['kyc/kyc-details', iduser + '-' + idaccount])
			.then(() => {
				location.reload();
			})
	}

	federalReview(iduser, idaccount) {
		this.router.navigate(['federal/federal-details', iduser + '-' + idaccount])
			.then(() => {
				location.reload();
			})
	}

	/*Kyc Verify function*/
	verifyKyc() {
		let data = {
			idaccount: this.Kycidaccount,
			iduser: this.KYCiduser
		}
		this.data.kycVerify(data).subscribe((res) => {
			if (res.status == 201) {
				this.kycStatus = 1;
				this.responseMessage = res.message;
				setTimeout(() => {
					document.getElementById("closeKycModal").click();
					this.responseMessage = "";
				}, 5000);
				window.location.reload();
			}
			else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.responseMessage = err.message;
			setTimeout(() => {
				this.responseMessage = "";
			}, 5000);
		});
	}

	// To dawnload all pdf
	downloadPDF(e) {
		fetch(e).then(resp => resp.arrayBuffer()).then(resp => {
			// set the blog type to final pdf
			const file = new Blob([resp], { type: 'application/pdf' });
			// process to auto download it
			const fileURL = URL.createObjectURL(file);
			const link = document.createElement('a');
			link.href = fileURL;
			link.download = e.split('federal_pdf/')[1] || e.split('kyc_pdf/')[1] || e.split('card_pdf/')[1];
			link.click();
		});
	}
	suspendedDialog(featureServiceData, idaccount): void {
		const dialogRef = this.dialog.open(SuspendedServicesComponent, {
			width: '50px',
			data: { serviceData: featureServiceData, idaccount: idaccount }
		});
		dialogRef.afterClosed().subscribe(res => {
			if (res.status == 200) {
				this.responseMessage = res.message;
				setTimeout(() => {
					this.responseMessage = "";
				}, 5000);
			}
			else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		});
	}
	filterByUser(e) {
		this.custoDfilter.patchValue({
		  selectedUser: e.target.value
		});
	  }
	showAccountfilter() {
		// this.showFilter = !this.showFilter;
		console.log("this.showFilterthis.showFilter",this.showFilter);
		
		if (this.showFilter == false) {
			this.showFilter = true;
			console.log("this.showFilter8766666=>",this.showFilter);
			
		}
		else {
			console.log("this.showFilter fal=>",this.showFilter);
			
			this.showFilter = false;
		}
	}
	OnchangeTab(){
		if(this.isIdTariffRoute || this.isIdServiceRoute){
			this.router.navigate(['/user/user-details']);
		}
	}
	applyUserFilter(){
		if(this.filterUser.invalid){
			return
		}
		else{
		    console.log("this.filterUser.value" ,this.filterUser.value);
			this.data.UserFilter(JSON.stringify(this.filterUser.value)).subscribe((res) => {
				if (res.status == 201) {
					$('#basic-datatables07').dataTable().fnClearTable();
					$('#basic-datatables07').dataTable().fnDraw();
					$('#basic-datatables07').dataTable().fnDestroy();
					this.userlist = res.data;
					console.log("userlist",this.userlist);
			
					this.userlistFull = [];
					this.userlist.forEach(element => {
					if (element.is_deleted == 0) {
					this.userlistFull.push(element);
					}
					});
			
					$.getScript('./assets/table.js');

					
					this.userlistFull.forEach(element => {
						if (element.is_billing == '0') {
							element.color = 'green';
							element.msg = 'Billing is Enabled';
						} else {
							element.color = 'red';
							element.msg = 'Billing is Disabled'
						}
						element.pShow = false;
						element.pswd = "password";
		
						if (element.isAddress != 'true' || element.isEmailVerify != 'true' || element.isMobileVerify != 'true' || element.isPlan != 'true') {
							element.onboardingstatus = "red";
							element.tooltp = "On-Boarding In Process";
						} else if (element.newUser_status == 1 && element.isCard != "true") {
							element.onboardingstatus = "red";
							element.tooltp = "On-Boarding In Process";
						}
						else {
							element.onboardingstatus = "green";
							element.tooltp = "On-Boarding Complete";
						}
		
					});
					this.responseMessage = res.message;
					setTimeout(() => {
						this.responseMessage = "";
					}, 5000);
				}
				else {
					this.errMessage = res.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			});	
		}
	}
	messageshow() {
		const from_date = this.filterUser.get('from_date').value;
		const to_date = this.filterUser.get('to_date').value;
		const currentDate = new Date();
		if ((!from_date && !to_date)) {
		} else if ((from_date == null || !from_date) && (to_date != null)) {
		  this.filterUser.get('from_date').setErrors({ 'dateRange': 'Please select From Date' });
		} else if ((from_date != null) && (to_date == null || !to_date)) {
		  this.filterUser.get('to_date').setErrors({ 'dateRange': 'Please select To Date' });
		} else if (from_date && to_date && new Date(to_date) < new Date(from_date)) {
		  this.filterUser.get('to_date').setErrors({ 'dateRange': 'To date cannot be smaller than from date' });
		  return;
		} else if (to_date && new Date(to_date) > currentDate) {
		  this.filterUser.get('to_date').setErrors({ 'dateRange': 'To date cannot be greater than current date' });
		  return;
		} else if (from_date && new Date(from_date) > currentDate) {
		  this.filterUser.get('from_date').setErrors({ 'dateRange': 'From date cannot be greater than current date' });
		  return;
		} else {
		  this.filterUser.get('from_date').setErrors(null);
		  this.filterUser.get('to_date').setErrors(null);
		}
	}
	resetUserFilter() {
		this.filterUser.reset();
		this.router.navigate(['/user/user-details']);
		this.GetUsers();
	  }
	ngOnDestroy(){
		this.informationmodal.nativeElement.click();
		this.modalpdf.nativeElement.click();
		this.addamountmodule.nativeElement.click();
		this.billingMessagemodal.nativeElement.click();
		this.deleteacountmodal.nativeElement.click();
		
	  }

}
