import { Pipe, PipeTransform } from '@angular/core';

@Pipe({ name: 'UserType' })
export class UserType implements PipeTransform {
   transform(details: number): string {
    switch(details){
      case 1:
        return "Admin";
      case 12:
        return "Sub-Admin";
      case 2:
        return "Customer";
      case 22:
        return "Sub-Customer";
      case 3:
        return "Supplier";
      case 32: 
        return "Sub-Supplier";
      case 4: 
        return "Reseller";
      case 42: 
        return "Sub-Reseller";
    }
  }
}


@Pipe({ name: 'ParamTitle' })
export class ParamTitle implements PipeTransform {
   transform(details: string): string {
    return details.replace(new RegExp('_'), " ").toUpperCase();
  }
}