import { Injectable } from '@angular/core';
import { HttpRequest, HttpHandler, HttpEvent, HttpInterceptor } from '@angular/common/http';
import { Observable } from 'rxjs';
 
@Injectable()
export class JwtInterceptor implements HttpInterceptor {

    constructor() { }

    intercept(request: HttpRequest<any>, next: HttpHandler): Observable<HttpEvent<any>> {
        // add auth header with jwt if user is logged in and request is to api url
        const currentUser = sessionStorage.getItem("authkey");
        const isLoggedIn = sessionStorage.getItem("isLoggedIn");
        // console.log(currentUser.authkey);
        if (isLoggedIn || isLoggedIn != undefined) {
            request = request.clone({
                setHeaders: {
                    Authorization: currentUser
                }
            });
        }
        return next.handle(request);
    }
}