import { Component, ElementRef, ViewChild } from '@angular/core';
import { FormBuilder, FormGroup, FormArray, Validators } from '@angular/forms';
import { ConnectionsService } from '../connections.service';
import { MatAccordion } from '@angular/material/expansion';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { Router } from '@angular/router';
import { BehaviorSubject, Observable } from 'rxjs';
import { CapmaignserviceService } from 'src/app/campaign/capmaignservice.service';
import { AgentserviceService } from 'src/app/agents/agentservice.service';
import { threadId } from 'worker_threads';
import { exit } from 'process';
declare var $: any;

@Component({
	selector: 'app-connection',
	templateUrl: './connection.component.html',
	styleUrls: ['./connection.component.css']
})

export class ConnectionComponent extends AppComponentClass<any, any> {
	filterMetadata = { count: 0 };
	filtre: string;
	@ViewChild(MatAccordion) accordion: MatAccordion;
	@ViewChild('connectionmodal') connectionmodal:  ElementRef;
	@ViewChild('helpmodal') helpmodal:  ElementRef;
	@ViewChild('sipconnectionmodal') sipconnectionmodal:  ElementRef;
	searchText = { count: 0 };

	formField: Observable<any>;
	p: number = 1;
	rowdata: any;
	listdata: any;
	// defaultSelect : any = 1;
	page = 1;
	count = 0;
	tableSize = 25;
	tableSizes = [25, 50, 100];
	show: boolean = false;
	outboundtab: boolean = false;
	header: any;
	buttonName: any = "Add";
	connectionForm: FormGroup;
	IPForm: FormGroup;
	submitted: boolean = false;
	filterTerm: string;
	password = "password";
	pShow = false;
	IPArr: FormArray;
	ipShow: boolean = false;
	textMessage: any;
	msgHideAndShow: boolean = false;
	urlForm: FormGroup;
	FQDNForm: FormGroup;
	forwordForm: FormGroup;
	inboundForm: FormGroup;
	outboundForm: FormGroup;
	connection: any;
	connectionId: any;
	tech_prefix: any;
	connectionType: any;
	expertSettingForm: FormGroup;
	smsinboundForm: FormGroup;
	smsoutboundForm: FormGroup;
	idip_address: any;
	urls: any = [];
	sdata: any = [];
	hdata: any;
	type: any;
	connectionName: any;
	update_connection: any = {
		name: '',
		idendpoint: "",
		idaccount: ""
	}
	update_conn: any;
	rdata: any;
	ediConn: any;
	user: any;
	inbound: any;
	outbound: any;
	responseMessage = "";
	connection_key: any;
	inbound_key: any;
	outbound_key: any;
	formField1: any;
	Status: any;
	newarr: any[] = [];
	id_ipaddress: any;
	ipAddress: any;
	sms_inbound_key: any;
	sms_outbound_key: any;
	smsOutbound: any;
	smsInbound: any;
	brandData: any = [];
	campData: any = [];
	isSelected: boolean = false;
	countConn: any;
	tab1$ = new BehaviorSubject<any>("");
	tab1 = this.tab1$.asObservable();
	tab1Value = "";
	tab2$ = new BehaviorSubject<any>("");
	tab2 = this.tab1$.asObservable();
	tab2Value = "";
	tab3$ = new BehaviorSubject<any>("");
	tab3 = this.tab1$.asObservable();
	tab3Value = "";
	tab4$ = new BehaviorSubject<any>("");

	isSIP$ = new BehaviorSubject<string>("Select");
	isSip = this.isSIP$.asObservable();

	isSelect$ = new BehaviorSubject<boolean>(false);
	isSelect = this.isSelect$.asObservable();

	isDropdown$ = new BehaviorSubject<boolean>(false);
	isDropdown = this.isSelect$.asObservable();

	groups: any = [];
	agents: any = [];
	errMessage: any = "";
	userType: any = "";
	header1: any;
	header2: any;
	header3: any;
	record: string;
	arrayHash: any = [];
	valStr: any;
	preSub: Boolean;
	idendpt: any;
	passStr: any;
	formNew: FormGroup;
	passErrText: any;
	tech_pre: void;
	connectionFormTechPrefix: FormGroup;
	connectionFormName: FormGroup;
	connectionFormUserPass: FormGroup;
	connectionFormInboundCall: FormGroup;
	isEnable: Boolean = false;
	submittedip: boolean = false;
	submittedtp: boolean = false;
	selectt: boolean = false;
	displayselect: boolean = true;
	isPort: boolean;
	constructor(public data: ConnectionsService, private campService: CapmaignserviceService,
		private agentService: AgentserviceService, public router: Router, public fb: FormBuilder) {
		super(data, router, fb);
        
		let session = JSON.parse(sessionStorage.getItem("isLoggedIn"));
		this.userType = session.type;
	}

	ngOnInit(): void {
		this.passErrText = "";
		this.preSub = false;
		this.agentService.getGroups().subscribe(res => {
			if (res.status == 200) {
				this.groups = res.data;
			}
			else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.errMessage = err.message;
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		});

		this.agentService.getAgents().subscribe(res => {
			if (res.status == 200) {
				this.agents = res.data;
			}
			else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.errMessage = err.message;
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		});

		this.campService.getBrand().subscribe(res => {
			if (res.status == 200) {
				this.brandData = res.data;
			}
			else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.errMessage = err.message;
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		});

		this.expertSettingForm = this.fb.group({
			idendpoint: [],
			Encode: [''],
			DTMF_type: [''],
			enable_on_net: [''],
			enable_comfort: ['']
		});

		this.connectionForm = this.fb.group({
			id: [''],
			idendpoint: [''],
			connection_key: [''],
			connectionName: ['', [Validators.required , Validators.pattern(/^\s*\S.*$/)]],
			username: [''],
			password: [''],
			type: [''],
			tech_prefix: [''],
			forward_type: [''],
			forward: [''],
			brand: [''],
			campaign: ['']
		});

		this.connectionFormName = this.fb.group({
			id: [''],
			idendpoint: ['', [Validators.required]],
			connectionName: ['', [Validators.required , Validators.pattern(/^\s*\S.*$/)]],
		});

		this.connectionFormTechPrefix = this.fb.group({
			id: [''],
			idendpoint: ['', [Validators.required]],
			tech_prefix: ['', [Validators.minLength(2), Validators.maxLength(6), Validators.pattern('[0-9]+[#]?')]],
		});

		this.connectionFormUserPass = this.fb.group({
			id: [''],
			idendpoint: ['', [Validators.required]],
			username: ['', [Validators.required, Validators.pattern('^$|^[A-Za-z0-9_-]+')]],
			password: ['', [Validators.required, Validators.minLength(8)]],
		});
		this.connectionFormInboundCall = this.fb.group({
			idendpoint: ['', [Validators.required]],
			forward: ['', [Validators.required]],
			forward_type: ['', [Validators.required]],
			port: [''],
		});
		this.connectionFormInboundCall.get('forward_type').valueChanges.subscribe(value => {
			const portControl = this.connectionFormInboundCall.get('port');
			if (value === '1' || value === '2') {
				portControl.clearValidators(); 
			} else {
				portControl.setValidators([Validators.required, Validators.minLength(4)]); 
			}
			portControl.updateValueAndValidity(); 
		});
		this.FQDNForm = this.fb.group({
			idendpoint: [this.connectionId],
			type: [''],
			user: ['']
		});

		this.smsinboundForm = this.fb.group({
			idendpoint: [],
			type: ['sms_inbound'],
			url: ['']
		});

		this.smsoutboundForm = this.fb.group({
			idendpoint: [],
			type: ['sms_outbound'],
			delivery_url: ['']
		})

		this.inboundForm = this.fb.group({
			idendpoint: [],
			dnis: [],
			ani: [],
			ringback_timeout: [],
			answer_timeout: [],
			//channel_limit: [],
			sip_uri: [],
			media_type: [],
			enable_sip_compact: [],
			enable_privacy_zone: [],
			enable_prack: [],
			recording: []
		});

		this.outboundForm = this.fb.group({
			idendpoint: [],
			caller_id: [],
			custom: [],
			country: [],
			//channel_limit: [],
			initiated_by: [],
			voice_profile: [],
			media_type: [],
			ringback: [],
			tone: [],
			type: [],
			recording: [],
			uuid_detail: [],
			amd: [true]
		});

		this.IPForm = this.fb.group({
			IPArr: this.fb.array([])
		});

		// @resetting form data
		this.addsip()

		this.password = "password";
		this.data.getConnection().subscribe(response => {
			if (response.status == 200) {
				if (response.data.length > 0) {
					this.connection = response.data;
					$('#basic-datatabless2').dataTable().fnClearTable();
					$('#basic-datatabless2').dataTable().fnDraw();
					$('#basic-datatabless2').dataTable().fnDestroy();
					$.getScript('./assets/table.js');
					this.countConn = this.connection.length;
					this.connection.forEach(element => {
						element.pShow = false;
						element.pswd = "password";
					});
					this.Status = response.data[0].status;
				}
			}
			else {
				this.errMessage = response.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.errMessage = err.message;
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		});

		this.data.getRoutingConnection().subscribe(result => {
			if (result.status == 200) {
				this.rdata = typeof result.data != 'undefined' && result.data ? result.data : [];
			}
			else {
				this.errMessage = result.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.errMessage = err.message;
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		});

		this.data.getconnectiondetails().subscribe((result) => {
			this.header = result[0].headers_details;
			if (this.userType == '2' || this.userType == '1') {
				this.header.splice(0, 0, "User")
			}
			this.formField1 = result[0].formControls;
			let tmp = [];
			this.formField1.forEach(element => {
				tmp["idhooksetting_" + element.ID] = []
				tmp["ID_" + element.ID] = [element.ID],
					tmp["type_" + element.ID] = [element.type1],
					tmp["idendpoint_" + element.ID] = [this.connectionId],
					tmp["url_" + element.ID] = []
			});
			this.urlForm = this.fb.group(tmp);
		});


		this.data.connectionhelp().subscribe((result) => {
			this.header1 = result.header1[0];
			this.header2 = result.header2[0];
			this.header3 = result.header3[0];
		});
	}

	onBrand(event) {
		this.campService.onGetCampaigns(event.target.value).subscribe(res => {
			if (res.status == 200) {
				this.campData = res.data;
				this.isSelected = true;
			}
			else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.responseMessage = err.message;
			setTimeout(() => {
				this.responseMessage = "";
			}, 5000);
		});
	}
	onKeyUpEvent(event: any) {
		this.arrayHash = [];
		this.valStr = event.target.value;
		for (var i = 0; i < this.valStr.length; i++) {
			if (this.valStr.charAt(i) == "#") {
				this.arrayHash.push(this.valStr.charAt(i));
				if (this.arrayHash.length > '1') {
					this.preSub = false;
				}
				else {
					if (this.arrayHash.length == '1') {
						this.arrayHash.push(this.valStr.charAt(i));

						this.preSub = false;
					}
					else {
						this.preSub = false;
					}
				}
			} else {
				this.preSub = false;
			}
		}
	}

	// Dynamic Form
	saveForm(data: any) {
		this.show = true;
	}
	myPassword(value) {
		var passw = /^(?=.*\d)(?=.*[a-z])(?=.*[A-Z]).{8,30}$/;
		if (value.match(passw)) {
			this.passErrText = "";
		} else {
			this.passErrText = "Password must be Minimum 8 characters, At least one Uppercase Letter and At least one Number !";
		}
	}
	onSaveConnection() {
		this.submitted = true;
		if (!this.connectionForm.value.connectionName.trim()) {
			return;
		}
		else {
			this.data.saveConnection(this.connectionForm.value).subscribe(response => {
				if (response.status == 201) {
					this.show = true;
					this.connectionId = response.data.idendpoint;
					let tmp = [];
					this.formField1.forEach(element => {
						tmp["idhooksetting_" + element.ID] = []
						tmp["ID_" + element.ID] = [element.ID]
						tmp["type_" + element.ID] = [element.type1]
						tmp["idendpoint_" + element.ID] = [this.connectionId],
							tmp["url_" + element.ID] = []
					});
					this.urlForm = this.fb.group(tmp);
					this.connection_key = response.data.connection_key;
					this.connectionName = response.data.name;

					this.connectionFormName.patchValue({
						connection_key: response.data.connection_key,
						idendpoint: response.data.idendpoint,
						connectionName: response.data.name
					});
					this.connectionFormTechPrefix.patchValue({
						connection_key: response.data.connection_key,
						idendpoint: response.data.idendpoint,
						tech_prefix: response.data.tech_prefix,
					});
					this.connectionFormUserPass.patchValue({
						connection_key: response.data.connection_key,
						idendpoint: response.data.idendpoint,
						username: response.data.username,
						password: response.data.password
					});
					this.connectionFormInboundCall.patchValue({
						connection_key: response.data.connection_key,
						idendpoint: response.data.idendpoint,
						forward: response.data.forward,
						forward_type: response.data.forward_type,
						port: response.data.port == null ? '5060' : ''
					});
					this.connectionForm.patchValue({
						connection_key: response.data.connection_key,
						idendpoint: response.data.idendpoint,
						connectionName: response.data.name,
						forward: response.data.forward,
						forward_type: response.data.forward_type
					});
					// this.connectionForm.patchValue({
					// 	connection_key: response.data.connection_key,
					// 	idendpoint: response.data.idendpoint,
					// 	connectionName: response.data.name,
					// 	username: response.data.username,
					// 	password: response.data.password,
					// 	tech_prefix: response.data.tech_prefix,
					// });

					this.FQDNForm.patchValue({
						idendpoint: this.connectionId,
					});
					this.expertSettingForm.patchValue({
						idendpoint: this.connectionId,
					});

					this.IPForm = this.fb.group({
						IPArr: this.fb.array([this.addNewIPFormGroup()])
					});

					this.IPArr = this.IPForm.get('IPArr') as FormArray;
					if (this.IPArr.length > 0) {
						this.isEnable = true;
					} else {
						this.isEnable = false;
					}

					//this.submitted = false;
					this.responseMessage = response.message;
					// this.ngOnInit();
					setTimeout(() => {
						this.responseMessage = "";
					}, 5000);
				}
				else {
					this.errMessage = response.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			}, err => {
				this.errMessage = err.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			});
		}
	}

	onType(event) {
		this.submitted=false;
		this.connectionType = event.target.innerHTML;
	}

	updateInbound() {
		this.data.updateInbound(this.inboundForm.value).subscribe(response => {
			if (response.status == 201) {
				this.responseMessage = response.message;
				setTimeout(() => {
					this.responseMessage = "";
				}, 5000);
			}
			else {
				this.errMessage = response.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.errMessage = err.message;
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		});
	}

	updateOutbound() {
		this.data.updateOutbound(this.outboundForm.value).subscribe(response => {
			if (response.status == 201) {
				this.responseMessage = response.message;
				setTimeout(() => {
					this.responseMessage = "";
				}, 5000);
			}
			else {
				this.errMessage = response.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.errMessage = err.message;
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		});
	}

	onUpdateConnectionName() {
		//this.submitted = true;
		if (this.connectionFormName.invalid) {
			this.submitted = true;
		}
		else {
			this.data.updateConnectionName(this.connectionFormName.value).subscribe(response => {
				if (response.status == 201) {
					this.show = true;
					//this.submitted = false;
					this.responseMessage = response.message;
					setTimeout(() => {
						this.responseMessage = "";
					}, 5000);
				}
				else {
					this.errMessage = response.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			}, err => {
				this.errMessage = err.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			});
		}
	}
	onUpdateConnInboundCall() {
		// this.submitted = true;
		if (this.connectionFormInboundCall.invalid) {
			this.submitted =true;			
			return false;
		}
		else {
			this.data.updateConnInboundCall(this.connectionFormInboundCall.value).subscribe(response => {				
				if (response.status == 201) {
					this.show = true;
					//this.submitted = false;
					this.responseMessage = response.message;
					setTimeout(() => {
						this.responseMessage = "";
					}, 5000);
				}
				else {
					this.errMessage = response.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			}, err => {
				this.errMessage = err.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			});
		}
	}

	onUpdateConnection() {
		//this.submitted = true;
		if (this.connectionForm.invalid) {
			return;
		}
		else {
			this.data.updateConnection(this.connectionForm.value).subscribe(response => {
				if (response.status == 201) {
					this.show = true;
					this.responseMessage = response.message;
					setTimeout(() => {
						this.responseMessage = "";
					}, 5000);
				}
				else {
					this.errMessage = response.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			});
		}
	}
	onUpdateUserPass() {
		//this.submitted = true;
		var passw = /^(?=.*\d)(?=.*[a-z])(?=.*[A-Z]).{8,30}$/;
		if (!this.connectionFormUserPass.value.password.match(passw)) {
			// this.passErrText = 'At least one Uppercase Letter and At least one Number!';
			this.passErrText = 'At least One Uppercase Letter, One Lowercase Letter and At least One Number!';
			return false;
		}
		if (this.connectionFormUserPass.invalid) {
			return false;
		} else {
			this.data.updateConnUserPass(this.connectionFormUserPass.value).subscribe(response => {
				if (response.status == 201) {
					this.show = true;
					this.responseMessage = response.message;
					setTimeout(() => {
						this.responseMessage = "";
					}, 5000);
					this.passErrText = '';
				}
				else {
					this.errMessage = response.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			});
		}
	}

	onUpdateTechPreFix() {
		this.submittedtp = true;
		if (this.connectionFormTechPrefix.invalid) {
			return false;
		} else {
			this.data.updateConnTechPre(this.connectionFormTechPrefix.value).subscribe(response => {
				if (response.status == 201) {
					this.show = true;
					this.responseMessage = response.message;
					setTimeout(() => {
						this.responseMessage = "";
					}, 5000);
				}
				else {
					this.errMessage = response.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			});
		}
	}

	save_smsIbound() {
		this.data.save_smsinbound(this.smsinboundForm.value).subscribe(response => {
			if (response.status == 201) {
				this.responseMessage = response.message;
				setTimeout(() => {
					this.responseMessage = "";
				}, 5000);
			}
			else {
				this.errMessage = response.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.errMessage = err.message;
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		})
	}

	save_smsOutbound() {
		this.data.save_smsoutbound(this.smsoutboundForm.value).subscribe(response => {
			if (response.status == 201) {
				this.responseMessage = response.message;
				setTimeout(() => {
					this.responseMessage = "";
				}, 5000);
			}
			else {
				this.errMessage = response.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.errMessage = err.message;
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		})
	}

	passwordToggle1(id) {
		this.connection.forEach(element => {
			if (element.idendpoint == id) {
				if (element.pswd == 'password') {
					element.pswd = 'text';
					element.pShow = true;

				} else {
					element.pswd = 'password';
					element.pShow = false;
				}
			}
		});
	}

	onToggle(event, id) {
		this.data.updateStatus(event.checked, id).subscribe(res => {
			if (res.status == 201) {
				this.ngOnInit();
				this.responseMessage = res.message;
				setTimeout(() => {
					this.responseMessage = "";
				}, 5000);
			}
			else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.errMessage = err.message;
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		})
	}

	passwordToggle() {
		if (this.password === 'password') {
			this.password = 'text';
			this.pShow = true;
		} else {
			this.password = 'password';
			this.pShow = false;
		}
	}

	// Dynamic Form

	textMessageFunc(msgText) {
		this.responseMessage = msgText + " Copied to Clipboard";
		this.msgHideAndShow = true;
		setTimeout(() => {
			this.responseMessage = "";
			this.msgHideAndShow = false;
		}, 5000);
	}

	copyInputText(copyText) {
		copyText.select();
		document.execCommand('copy');
		copyText.setSelectionRange(0, 0);
		this.textMessageFunc('Text');
	}


	addNewIPFormGroup() {
		return this.fb.group({
			id_ipaddress: [],
			idendpoint: [this.connectionId],
			type: [this.connectionType],
			ip: ['', [Validators.required,
			Validators.pattern('(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)')]],
		})
	}

	// addItem() {
	// 	if(this.IPControls.invalid){
	// 		return; 
	// 	}
	// 	else{
	// 		this.IPArr = this.IPForm.get('IPArr') as FormArray;
	// 		this.IPArr.push(this.addNewIPFormGroup());
	// 	}
	// }

	addItem() {
		if (this.IPControls.invalid) {
			// this.isEnable = true;
			this.IPControls.markAllAsTouched()
			// return;
		}
		else {
			this.IPArr = this.IPForm.get('IPArr') as FormArray;
			this.IPArr.push(this.addNewIPFormGroup());
			if (this.IPArr.length > 0) {
				this.isEnable = true;
				this.IPControls.markAsPristine();
				this.IPControls.markAsUntouched();
			} else {
				this.isEnable = false;
			}

		}
	}

	get IPControls(): FormArray {
		return this.IPForm.get('IPArr') as FormArray;
	}

	deleteIPFormGroup(index: number, ipValue: string) {
		this.submittedip = false;
		let add: any = this.IPForm.get('IPArr') as FormArray;
		add.removeAt(index);
		let ips: any = this.ipAddress.find(el => el.ip === ipValue);
		if (add.value.length > 0) {
			this.isEnable = true;
		} else {
			this.isEnable = false;
		}
		this.data.deleteIP(ips.id_ipaddress).subscribe(res => {
			if (res.status == 201) {
				this.responseMessage = res.message;
				setTimeout(() => {
					this.responseMessage = "";
				}, 5000);
			}
			else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.errMessage = err.message;
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		});
	}

	deleteIPFormGroup1(index: number, ip) {
		this.submittedip = false;
		let add: any = this.IPForm.get('IPArr') as FormArray;
		add.removeAt(index);

		let ips: any = this.ipAddress.find(el => el.ip == ip.value);
		if (add.value.length > 0) {
			this.isEnable = true;
		} else {
			this.isEnable = false;
		}
		this.data.deleteIP(ips.id_ipaddress).subscribe(res => {
			if (res.status == 201) {
				this.responseMessage = res.message;
				setTimeout(() => {
					this.responseMessage = "";
				}, 5000);
			}
			else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.errMessage = err.message;
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		});

	}
	
	onSaveIP() {
		this.submittedip = true;
		if (this.IPForm.invalid) {
		this.submittedip = true;
			// return;
		}
		else {
			// console.log(this.IPForm.value)
			// if(!this.IPForm.value.IPArr[0].id_ipaddress){
			// 	console.log(this.IPForm.value.IPArr[0].id_ipaddress);
			// 	this.data.saveIp(this.IPForm.value).subscribe(response => {
			// 		console.log(response);
			// 	});
			// }
			// else{

			// console.log(this.IPForm.value.IPArr[0].id_ipaddress);
			this.data.updateIP(this.IPForm.value).subscribe(result => {
				this.IPArr = this.fb.array([]);
				this.ipAddress = result.dataip;
				
				if (result.status == 201) {
					this.ipAddress.forEach(element => {
						this.IPArr.push(this.fb.group(element));
					});
		            this.submittedip = false;
					this.isEnable = true;
					this.responseMessage = result.message;
					setTimeout(() => {
						this.responseMessage = "";
					}, 5000);
				}
				else {
					this.errMessage = result.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			}, err => {
				this.errMessage = err.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			});
		}
	}

	onSaveTech() {
		this.data.updateConnection(this.connectionForm.value).subscribe(response => {
			if (response.status == 201) {
				this.ngOnInit();
				this.responseMessage = response.message;
				setTimeout(() => {
					this.responseMessage = "";
				}, 5000);
			}
			else {
				this.errMessage = response.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.errMessage = err.message;
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		});
	}

	deleteConnection(index, data) {
		if (confirm("Are you sure you want delete data!")) {
			this.data.delete_connection(data.idendpoint).subscribe(response => {
				if (response.status == 201) {
					this.connection.splice(index, 1);
					this.responseMessage = response.message;
					setTimeout(() => {
						this.responseMessage = "";
					}, 5000);
					this.ngOnInit();
				}
				else {
					this.errMessage = response.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			}, err => {
				this.errMessage = err.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			});
		}
		else {
			"Cancel!"
		}
	}

	onSaveUrls() {
		let response: any = [];
		response[0] = [];
		response[1] = [];
		response[2] = [];
		response[3] = [];
		for (let key of Object.keys(this.urlForm.value)) {
			let tmp = key.split('_');
			response[tmp[1]].push({ field: tmp[0], value: this.urlForm.value[key] });
		}
		response.splice(3, 1);
		this.data.updateUrls(response).subscribe(response => {
			if (response.status == 201) {
				this.responseMessage = response.message;
				setTimeout(() => {
					this.responseMessage = "";
				}, 5000);
			}
			else {
				this.errMessage = response.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.errMessage = err.message;
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		});
	}

	resetUrl(){
		this.urlForm.get('url_0').setValue('');
		this.urlForm.get('url_1').setValue('');
		this.urlForm.get('url_2').setValue('');
	}
	
	onUpdateUrls() {
		let response: any = [];
		response[0] = [];
		response[1] = [];
		response[2] = [];
		response[3] = [];

		for (let key of Object.keys(this.urlForm.value)) {
			let tmp = key.split('_');
			response[tmp[1]].push({ field: tmp[0], value: this.urlForm.value[key] });
		}
		response.splice(3, 1);
		this.data.updateUrls(response).subscribe(response => {
			if (response.status == 201) {
				this.responseMessage = response.message;
				setTimeout(() => {
					this.responseMessage = "";
				}, 5000);
			}
			else {
				this.errMessage = response.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.errMessage = err.message;
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		});
	}

	onExpertSetting() {
		const formValue = this.expertSettingForm.value;
		formValue.Encode = formValue.Encode ? formValue.Encode : 'false';
		formValue.enable_comfort = formValue.enable_comfort ? formValue.enable_comfort : 'false';
		formValue.enable_on_net = formValue.enable_on_net ? formValue.enable_on_net : 'false';
		this.data.update_expertSetting(formValue).subscribe(response => {
			if (response.status == 201) {
				this.responseMessage = response.message;
				setTimeout(() => {
					this.responseMessage = "";
				}, 5000);
				window.location.reload();
			}
			else {
				this.errMessage = response.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.errMessage = err.message;
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		});
	}

	onUpdateExpertSetting() {
		this.data.update_expertSetting(this.expertSettingForm.value).subscribe(response => {
			if (response.status == 201) {
				this.responseMessage = response.message;
				setTimeout(() => {
					this.responseMessage = "";
				}, 5000);
				this.ngOnInit();
			}
			else {
				this.errMessage = response.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.errMessage = err.message;
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		});
	}

	saveFQDN() {
		this.data.updatefqdn(this.FQDNForm.value).subscribe(response => {
			if (response.status == 201) {
				this.responseMessage = response.message;
				setTimeout(() => {
					this.responseMessage = "";
				}, 5000);
			}
			else {
				this.errMessage = response.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.errMessage = err.message;
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		});
	}

	onUpdateFQDN() {
		this.data.updatefqdn(this.FQDNForm.value).subscribe(response => {
			if (response.status == 201) {
				this.responseMessage = response.message;
				setTimeout(() => {
					this.responseMessage = "";
				}, 5000);
			}
			else {
				this.errMessage = response.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.errMessage = err.message;
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		});
	}

	saveForward() {
		// this.submitted=true;
		if (this.connectionFormInboundCall.invalid) {
			this.submitted=true;			
			return false;
		}
		else {
			this.data.updateConnInboundCall(this.connectionFormInboundCall.value).subscribe(response => {				
				this.displayselect = false;
				if (response.status == 201) {
					this.responseMessage = response.message;
					setTimeout(() => {
						this.responseMessage = "";
					}, 5000);
				}
				else {
					this.errMessage = response.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			}, err => {
				this.errMessage = err.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			});
		}
	}

	toggle() {
		this.show = !this.show;
		// CHANGE THE NAME OF THE BUTTON.
		if (this.show) this.buttonName = "Close";
		else this.buttonName = "Add";
	}



	addsip() {
		this.update_conn = this.update_connection
		this.ediConn = {};
		this.type = "";
		this.user = "";
	}
	editdata(data: any, tabs) {
		if (data != 'data') {
			this.idendpt = data.idendpoint;
			this.data.getUrl(data.idendpoint).subscribe(res1 => {

				if (res1.data.length <= 2) {

					this.data.setUrl(data.idendpoint).subscribe(res => {

					});
				}

			});

			switch (tabs) {
				case 1: {
					this.tab1Value = "active";
					this.tab2Value = "";
					this.tab3Value = "";
					break;
				}
				case 2: {
					this.tab1Value = "";
					this.tab2Value = "active";
					this.tab3Value = "";
					break;
				}
				case 3: {
					this.tab1Value = "";
					this.tab2Value = "";
					this.tab3Value = "active";
					break;
				}
			}

			if (data != 'data') {
				//this.passStr = data.username;
				var replacePass = data.username.replace(/[@#]/g, "_");
				this.formNew = this.fb.group({
					idendpoint: data.idendpoint,
					password: replacePass
				});
				this.data.updatePassword(this.formNew.value).subscribe(res => { });

				this.update_conn = data;
				this.connectionFormName.patchValue({
					idendpoint: data.idendpoint,
					connectionName: data.name
				});
				this.connectionFormTechPrefix.patchValue({
					idendpoint: data.idendpoint,
					tech_prefix: data.tech_prefix
				});
				this.connectionFormUserPass.patchValue({
					idendpoint: data.idendpoint,
					username: replacePass,
					password: data.password
				});
				this.expertSettingForm.patchValue({
					idendpoint: data.idendpoint
				});

				this.FQDNForm.patchValue({
					idendpoint: data.idendpoint
				});



				this.smsinboundForm.patchValue({
					idendpoint: data.idendpoint
				});

				this.smsoutboundForm.patchValue({
					idendpoint: data.idendpoint
				});

				this.inboundForm.patchValue({
					idendpoint: data.idendpoint
				});

				this.outboundForm.patchValue({
					idendpoint: data.idendpoint
				});

				this.ediConn = {}

				this.connectionId = data.idendpoint;

				this.data.getIP(data.idendpoint).subscribe(res => {
					if (res.status == 200) {
						this.ipAddress = res.data;
						this.IPArr = this.IPForm.get('IPArr') as FormArray;
						this.ipAddress.forEach(element => {
							this.IPArr.push(this.fb.group(element));
						});
						if (this.IPArr.length > 0) {
							this.isEnable = true;
						} else {
							this.isEnable = false;
						}
					}
					else {
						this.errMessage = res.message;
						setTimeout(() => {
							this.errMessage = "";
						}, 5000);
					}
				})

				this.data.get_expertSetting(data.idendpoint).subscribe(result => {
					if (result.status == 200) {
						this.hdata = result.data[0];
						let encode_header: boolean = this.hdata.encode_header == 'true' ? true : false;
						let enable_on_net: boolean = this.hdata.enable_on_net == 'true' ? true : false;
						let comfort_noise: boolean = this.hdata.comfort_noise == 'true' ? true : false;
						if (this.hdata) {
							this.expertSettingForm.patchValue({
								Encode: encode_header,
								DTMF_type: this.hdata.DTMF_type,
								enable_on_net: enable_on_net,
								enable_comfort: comfort_noise
							});
						}
					}
					else {
						this.errMessage = result.message;
						setTimeout(() => {
							this.errMessage = "";
						}, 5000);
					}
				});

				this.data.getInbound(data.idendpoint).subscribe(response => {
					if (response.status == 200) {
						this.inbound = response.data[0];
						this.inbound_key = this.inbound.inbound_key;
						let recording: boolean = this.inbound.recording == 'true' ? true : false;
						let enable_sip_compact: boolean = this.inbound.enable_sip_compact == 'true' ? true : false;
						let enable_privacy_zone: boolean = this.inbound.enable_privacy_zone == 'true' ? true : false;
						let enable_prack: boolean = this.inbound.enable_prack == 'true' ? true : false;


						this.inboundForm.patchValue({
							dnis: this.inbound.dnis,
							ani: this.inbound.ani,
							ringback_timeout: this.inbound.ringback_timeout,
							answer_timeout: this.inbound.answer_timeout,
							//channel_limit: this.inbound.channel_limit,
							sip_uri: this.inbound.sip_uri,
							media_type: this.inbound.media_type,
							enable_sip_compact: enable_sip_compact,
							enable_privacy_zone: enable_privacy_zone,
							enable_prack: enable_prack,
							recording: recording

						});

					}
					else {
						this.errMessage = response.message;
						setTimeout(() => {
							this.errMessage = "";
						}, 5000);
					}
				});

				this.data.getOutbound(data.idendpoint).subscribe(response => {
					if (response.status == 200) {
						this.outbound = response.data[0];
						this.outbound_key = this.outbound.outbound_key;
						let enable_ringback: boolean = this.outbound.enable_ringback == 'true' ? true : false;
						let tone: boolean = this.outbound.generate_ringback == 'true' ? true : false;
						let recording: boolean = this.outbound.recording == 'true' ? true : false;
						this.outboundForm.patchValue({
							caller_id: this.outbound.caller_id,
							type: this.outbound.type,
							country: this.outbound.country,
							//channel_limit: this.outbound.channel_limit,
							initiated_by: this.outbound.initiated_by,
							voice_profile: this.outbound.voice_profile,
							media_type: this.outbound.media_type,
							ringback: enable_ringback,
							tone: tone,
							recording: recording,
							uuid_detail: this.outbound.uuid_detail,
							amd: this.outbound.amd
						});
					}
					else {
						this.errMessage = response.message;
						setTimeout(() => {
							this.errMessage = "";
						}, 5000);
					}
				});

				this.FQDNForm.patchValue({
					type: this.ediConn.FQDN_type,
					user: this.ediConn.FQDN_user
				});

				let editConn = this.connection.find(el =>
					el.idendpoint === data.idendpoint
				);
				this.connectionFormInboundCall.patchValue({
					idendpoint: data.idendpoint,
					forward: editConn.forward,
					forward_type: editConn.forward_type,
					port: editConn.port == null ? '5060' : editConn.port
				});
				this.connectionForm.patchValue({
					idendpoint: data.idendpoint,
					connectionName: editConn.name,
					forward: editConn.forward,
					forward_type: editConn.forward_type
				});

				if (editConn.forward_type == 1) {
					this.isSIP$.next("Sip Uri");
					this.connectionFormInboundCall.get("forward").setValidators([Validators.required,
					Validators.pattern("^(?=.*?[a-z A-Z])(?=.*?[a-z A-Z])(?=.*?[0-9  !\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~€£¥₩])(?=.*?[a-z A-Z 0-9]).{8,}$")]);

				}
				else if (editConn.forward_type == 2) {
					this.isSIP$.next("Number");
					this.connectionFormInboundCall.get("forward").setValidators([Validators.required, Validators.pattern("^((\\+91-?)|0)?[0-9]{10}$")])
				}
				else if (editConn.forward_type == 3) {
					this.isSIP$.next("IP Address");
					this.connectionFormInboundCall.get("forward").setValidators([Validators.required, Validators.pattern("(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)")]);
				}
				else if (editConn.forward_type == 4) {
					this.isSIP$.next("Group");
					this.connectionFormInboundCall.get("forward").setValidators([Validators.required]);
				}
				else if (editConn.forward_type == 5) {
					this.isSIP$.next("Extension");
					this.connectionFormInboundCall.get("forward").setValidators([Validators.required]);
				}
				else if (editConn.forward_type == 6) {
					this.isSIP$.next("A");
					this.connectionFormInboundCall.get("forward").setValidators([Validators.required]);
				}
				else if (editConn.forward_type == 7) {
					this.isSIP$.next("SRV");
					this.connectionFormInboundCall.get("forward").setValidators([Validators.required]);
				}
				else {
					this.isSIP$.next("Select");
					this.connectionFormInboundCall.get("forward").reset();
					this.connectionFormInboundCall.get("forward").setValidators([Validators.required,
					Validators.pattern("(?:[A-Za-z][A-Za-z0-9+.-]*:\/{2})?(?:(?:[A-Za-z0-9-._~]|%[A-Fa-f0-9]{2})+(?::([A-Za-z0-9-._~]?|[%][A-Fa-f0-9]{2})+)?@)?(?:[A-Za-z0-9](?:[A-Za-z0-9-]*[A-Za-z0-9])?\\.){1,126}[A-Za-z0-9](?:[A-Za-z0-9-]*[A-Za-z0-9])?(?::[0-9]+)?(?:\/(?:[A-Za-z0-9-._~]|%[A-Fa-f0-9]{2})*)*(?:\\?(?:[A-Za-z0-9-._~]+(?:=(?:[A-Za-z0-9-._~+]|%[A-Fa-f0-9]{2})+)?)(?:&|;[A-Za-z0-9-._~]+(?:=(?:[A-Za-z0-9-._~+]|%[A-Fa-f0-9]{2})+)?)*)?")])
					this.selectt = true;
				}
			}
		}
		// brand: editConn.brandId,
		// campaign: editConn.campaignId
	}
	onHoookSClick() {
		this.data.getUrl(this.idendpt).subscribe(res => {
			if (res.status == 200) {
				let tmp = [];
				if (res.data.length > 0) {
					res.data.forEach(element => {
						if (element.type == "sms-status") {
							this.sms_outbound_key = element.sms_key;
							this.smsOutbound = element.url;
						}
						if (element.type == "sms-received") {
							this.sms_inbound_key = element.sms_key;
							this.smsInbound = element.url;
						}
						tmp["idhooksetting_" + element.priority] = [element.idhooksetting]
						tmp["ID_" + element.priority] = [element.priority]
						tmp["type_" + element.priority] = [element.type]
						tmp["idendpoint_" + element.priority] = [this.connectionId],
							tmp["url_" + element.priority] = [element.url]
					});
					this.urlForm = this.fb.group(tmp);
				}
				else {
					this.formField1.forEach(element => {
						tmp["idhooksetting_" + element.ID] = []
						tmp["ID_" + element.ID] = [element.ID],
							tmp["type_" + element.ID] = [element.type1],
							tmp["idendpoint_" + element.ID] = [this.connectionId],
							tmp["url_" + element.ID] = []
					});
					this.urlForm = this.fb.group(tmp);
				}
			}
			else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		});
	}
	setAsDefault(idendpoint, iduser) {
		let data = idendpoint + '-' + iduser;
		this.data.setDefault(data).subscribe(res => {
			if (res.status == 201) {
				this.responseMessage = res.message;
				setTimeout(() => {
					this.responseMessage = "";
				}, 5000);
				this.ngOnInit();
			}
			else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		});
	}

	onForwardType(e) {
		if (e.target.value == 0) {
			this.isSIP$.next("Select");
			this.connectionFormInboundCall.get("forward").reset();
			this.connectionFormInboundCall.get("forward").setValidators([Validators.required,
			Validators.pattern("(?:[A-Za-z][A-Za-z0-9+.-]*:\/{2})?(?:(?:[A-Za-z0-9-._~]|%[A-Fa-f0-9]{2})+(?::([A-Za-z0-9-._~]?|[%][A-Fa-f0-9]{2})+)?@)?(?:[A-Za-z0-9](?:[A-Za-z0-9-]*[A-Za-z0-9])?\\.){1,126}[A-Za-z0-9](?:[A-Za-z0-9-]*[A-Za-z0-9])?(?::[0-9]+)?(?:\/(?:[A-Za-z0-9-._~]|%[A-Fa-f0-9]{2})*)*(?:\\?(?:[A-Za-z0-9-._~]+(?:=(?:[A-Za-z0-9-._~+]|%[A-Fa-f0-9]{2})+)?)(?:&|;[A-Za-z0-9-._~]+(?:=(?:[A-Za-z0-9-._~+]|%[A-Fa-f0-9]{2})+)?)*)?")])
		}
		else if (e.target.value == 1) {
			this.isSIP$.next("Sip Uri");
			let port: any = this.connectionFormInboundCall.get('port');
			port.setValidators([]);
			port.updateValueAndValidity();

			this.connectionFormInboundCall.get("forward").reset();
			this.connectionFormInboundCall.get("forward").setValidators([Validators.required,
			Validators.pattern("^(?=.*?[a-z A-Z])(?=.*?[a-z A-Z])(?=.*?[0-9  !\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~€£¥₩])(?=.*?[a-z A-Z 0-9]).{8,}$")
		])

		}
		else if (e.target.value == 2) {
			this.isSIP$.next("Number");
			let port: any = this.connectionFormInboundCall.get('port');
			port.setValidators([]);
			port.updateValueAndValidity();
			this.connectionFormInboundCall.get("forward").reset();
			this.connectionFormInboundCall.get("forward").setValidators([Validators.required, Validators.pattern("^((\\+91-?)|0)?[0-9]{10}$")])
		}
		else if (e.target.value == 3) {
			this.isSIP$.next("IP Address");
			this.connectionFormInboundCall.get("port").setValidators([Validators.required,Validators.minLength(4)]);
			this.connectionFormInboundCall.get("forward").reset();
			this.connectionFormInboundCall.get("forward").setValidators([Validators.required, Validators.pattern("(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)")]);
		}
		else if (e.target.value == 4) {
			this.isSIP$.next("Group");
			this.connectionFormInboundCall.get("port").setValidators([]);
			this.connectionFormInboundCall.get("forward").reset();
			this.connectionFormInboundCall.get("forward").setValidators([Validators.required]);
		}
		else if (e.target.value == 5) {
			this.isSIP$.next("Extension");
			this.connectionFormInboundCall.get("forward").reset();
			this.connectionFormInboundCall.get("forward").setValidators([Validators.required]);
		}
		else if (e.target.value == 6) {
			this.isSIP$.next("A");
			this.connectionFormInboundCall.get("port").setValidators([Validators.required,Validators.minLength(4)]);
			this.connectionFormInboundCall.get("forward").reset();
			this.connectionFormInboundCall.get("forward").setValidators([Validators.required]);
		}
		else if (e.target.value == 7) {
			this.isSIP$.next("SRV");
			this.connectionFormInboundCall.get("port").setValidators([Validators.required,Validators.minLength(4)]);
			this.connectionFormInboundCall.get("forward").reset();
			this.connectionFormInboundCall.get("forward").setValidators([Validators.required]);
		}
		this.submitted=false;
	}

	get f() {
		return this.connectionForm.controls;
	}

	dismissModal() {
		this.show = false;
		this.tab1Value = "";
		this.tab2Value = "";
		this.tab3Value = "";
		this.connectionName = "";
		this.smsoutboundForm.reset();
		this.connectionForm.reset()
		this.inboundForm.reset();
		this.outboundForm.reset();
		this.smsinboundForm.reset();
		window.location.reload();
		this.ngOnInit();
	}

	onOpen(){
		this.submitted=false
		this.connectionForm.reset()
		}
		ngOnDestroy(){
			this.connectionmodal.nativeElement.click();
			this.helpmodal.nativeElement.click();
			this.sipconnectionmodal.nativeElement.click();
		  }
}