import { Component, ElementRef, Inject, OnInit, ViewChild } from '@angular/core';
import { KycService } from '../kyc.service';
import { ActivatedRoute, ParamMap, Router } from '@angular/router';
import { DatePipe, DOCUMENT,Location } from '@angular/common';
import { environment } from 'src/environments/environment';
import { HttpClient, HttpRequest, HttpResponse } from '@angular/common/http';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import * as pdfMake from 'pdfmake/build/pdfmake.js';
import * as pdfFonts from 'pdfmake/build/vfs_fonts.js';
pdfMake.vfs = pdfFonts.pdfMake.vfs;
(pdfMake as any).vfs = pdfFonts.pdfMake.vfs;


declare var $: any;

@Component({
  selector: 'app-kyc-pdf',
  templateUrl: './kyc-pdf.component.html',
  styleUrls: ['./kyc-pdf.component.css']
})
export class KycPdfComponent implements OnInit {

  @ViewChild('htmlTable') pdfTable: ElementRef;
  @ViewChild('htmlTable', { static: false }) content!: ElementRef;
  @ViewChild('closebutton') closebutton: ElementRef;
  @ViewChild('closebuttonreject') closebuttonreject: ElementRef;
  @ViewChild('CancelKYC') CancelKYC: ElementRef;
  public kycUpload = environment.SERVER + "uploads/kyc_upload";
  groupID: any
  pdfQues: any;
  pdfDetails: any = [];
  errMessage: any;
  voice = "Voice Services"
  message = "Messaging Services"
  date: any;
  filesdata: any;
  userType: string;
  responseMessage = "";
  sesiduser: any;
  idaccount: any;
  iduser: any;
  username: any;
  YourInformation: any = [];
  dba: any;
  business_type: any;
  Federal_tax_id: any;
  Physical_headquarter_address: any;
  Billing_address: any;
  website_address: any;
  Social_media: any;
  Customer_legal_name: any;
  billing_name: any;
  billing_email: any;
  billing_phone: any;
  Compliance_name: any;
  Compliance_email: any;
  Compliance_phone: any;
  Operations_name: any;
  Operations_email: any;
  Operations_phone: any;
  serviceFormQues: any = [];
  messageFormQues: any = [];
  kycSignature: any;
  kycSignatureTitle: any;
  kycSignatureName: any;
  voiceService: any = [];
  messageService: any = [];
  kycDate: any;
  body: any = [];
  body1: any = [];
  questionData: any = [];
  ques: any = [];
  ques1: any;
  ans1: string;
  subques1: any;
  ques2: any;
  ans2: string;
  ques3: any;
  ans3: string;
  ques4: any;
  ans4: string;
  ques5: any;
  ans5: string;
  ques6: any;
  ans6: any;
  ques7: any;
  ans7: string;
  msgques1: any;
  msgans1: string;
  msgsubques1: any;
  msgques2: any;
  msgans2: string;
  msgques3: any;
  msgans3: string;
  msgsubques2: any;
  msgques4: any;
  msgans4: string;
  messageQues: any = [];
  pdf: any;
  subques3: any;
  urliduser: string;
  urlidaccount: string;
  kycStatus: number;
  ques12: any;
  ans12: string;
  subques12: any;
  ques13: any;
  ans13: string;
  subques13: any;
  subans13: string;
  sub1ques13: any;
  ques14: any;
  ans14: string;
  ques15: any;
  ans15: string;
  subques15: any;
  subans15: any;
  ans16: string;
  ques16: any;
  subans16: string;
  subques16: any;
  ans17: string;
  ques17: any;
  subques17: any;
  subans17: string;
  ques18: any;
  ans18: string;
  ques20: any;
  ans20: string;
  msgans22: string;
  msgques22: any;
  submsgques22: any;
  msgques23: any;
  msgans23: string;
  msgques24: any;
  msgans24: string;
  submsgques24: any;
  msgques25: any;
  msgans25: string;
  msgques27: any;
  msgans27: string;
  getStatus: any;
  kycHeader: any;
  kycRes: number;
  updateBtn: boolean;
  subques4: any;
  subans3: any;
  subans4: any;
  kyc_status: any;
  kyc_color: any;
  federal_status: any ="";
  federal_color: any ="";
  show_kyc_status: any;
  ipAddress: any;

  constructor(public data: KycService, private route: ActivatedRoute,private location:Location,protected userSerive: UsermanagementService, public router: Router, @Inject(DOCUMENT) private document: Document, public _http: HttpClient,private datePipe: DatePipe) {
    this.userType = sessionStorage.getItem('type');
    let isLoggedIn = JSON.parse(sessionStorage.getItem('isLoggedIn'));
  }

  ngOnInit(): void {
    let isLoggedIn = sessionStorage.getItem("isLoggedIn");
    this.sesiduser = JSON.parse(isLoggedIn);
    this.idaccount = this.sesiduser.idaccount;
    this.iduser = this.sesiduser.iduser;
    this.username = this.sesiduser.username;
    let idu: any;
    let ida: any;
    this.route.paramMap.subscribe((params: ParamMap) => {
      let userData = params.get('id');
      if(userData){
        let splitUser = userData.split('-');
        idu = splitUser[0];
        ida = splitUser[1];
      }
    })

    if(idu && idu !== undefined && idu !== null && ida && ida !== undefined && ida !== null) {
      this.urliduser = idu;
      this.urlidaccount = ida;
      this.getUserDetailForAdmin();
    }
    else{
      this.urliduser = this.iduser;
      this.urlidaccount = this.idaccount;
      this.getUserDetail();
    }
    this.getallData(this.urliduser, this.urlidaccount);
      /*Service for kyc response*/ 
    // this.userSerive.getKycHeader().subscribe(res => {
    //   if (res.status == 200) {
    //     this.kycHeader = res.data;
    //     this.kycRes = res.data[0].kyc_verify_status;
    //     console.log("this.kycRes=>",this.kycRes);
    //     if(this.kycRes == 3){
    //       this.updateBtn=true;
    //       console.log("reject=>",this.kycRes);
    
    //     }
    //   }
    // });
  
    
  }

  getUserDetail(){
    this.userSerive.getSingleUsers().subscribe(res => {
      // To KYC Status
     this.kyc_status = res.data1[0].kyc_verify_status;     
      switch(this.kyc_status){
        case 0 : this.show_kyc_status = "Unverified"; this.kyc_color ="rgb(236 41 52)"; break;
        case 1 : this.show_kyc_status = "Verified"; this.kyc_color ="#2aab5b"; break;
        case 2 : this.show_kyc_status = "Verification Pending"; this.kyc_color ="#e6b125"; break;
        case 3 : this.show_kyc_status = "Reject"; this.kyc_color ="rgb(236 41 52)"; break;
        case 4 : this.show_kyc_status = "Cancelled"; this.kyc_color ="rgb(236 41 52)"; break;
      }
      if(this.kyc_status==0 || this.kyc_status==3 || this.kyc_status==4)
      {
        this.router.navigate(['/kyc/kyc'])
            .then(() => {
              location.reload();
            })
      }
      // To Federal Status
      this.federal_status = res.data1[0].federal_status;
      switch(this.federal_status){
        case 0 : this.federal_status = "Inactive"; this.federal_color ="rgb(236 41 52)"; break;
        case 1 : this.federal_status = "Active"; this.federal_color ="#2aab5b"; break;
        case 2 : this.federal_status = "Pending to Active"; this.federal_color ="#e6b125"; break;
        case 3 : this.federal_status = "Reject"; this.federal_color ="rgb(236 41 52)"; break;
        case 4 : this.federal_status = "Cancel"; this.federal_color ="rgb(236 41 52)"; break;
      }
    })
  }

  getUserDetailForAdmin()
  {
      this.userSerive.getSingleUsersForAdmin(this.urliduser).subscribe(res => {
            // To KYC Status
          this.kyc_status = res.data1[0].kyc_verify_status;     
          switch(this.kyc_status){
            case 0 : this.show_kyc_status = "Unverified"; this.kyc_color ="rgb(236 41 52)"; break;
            case 1 : this.show_kyc_status = "Verified"; this.kyc_color ="#2aab5b"; break;
            case 2 : this.show_kyc_status = "Verification Pending"; this.kyc_color ="#e6b125"; break;
            case 3 : this.show_kyc_status = "Reject"; this.kyc_color ="rgb(236 41 52)"; break;
          }
          if(this.kyc_status==0 || this.kyc_status==3)
          {
            this.router.navigate(['/kyc/kyc'])
                .then(() => {
                  location.reload();
                })
          }
          // To Federal Status
          this.federal_status = res.data1[0].federal_status;
          switch(this.federal_status){
            case 0 : this.federal_status = "Inactive"; this.federal_color ="rgb(236 41 52)"; break;
            case 1 : this.federal_status = "Active"; this.federal_color ="#2aab5b"; break;
            case 2 : this.federal_status = "Pending to Active"; this.federal_color ="#e6b125"; break;
            case 3 : this.federal_status = "Reject"; this.federal_color ="rgb(236 41 52)"; break;
          }
      })
  }
  getallData(iduser, idaccount) {
    this.data.getallData({ iduser: iduser, idaccount: idaccount }).subscribe(res => {
      this.pdfDetails = res.data;
      if(this.pdfDetails[0].update_date==null || this.pdfDetails[0].update_date=='' || this.pdfDetails[0].update_date==undefined){
        this.kycDate=this.pdfDetails[0].kyc_date
      }
      else{
         this.kycDate=this.pdfDetails[0].update_date
      }
      this.pdfDetails.forEach((element) => {
        if (element.form_type == 'YourInformation') {
          if (element.key == 'Customer_legal_name') {
            this.Customer_legal_name = element.value;
          }
          if (element.key == 'Dba_trade_name') {
            this.dba = element.value;
          }
          if (element.key == 'business_type') {
            this.business_type = element.value;
          }
          if (element.key == 'Federal_tax_id') {
            this.Federal_tax_id = element.value;
          }
          if (element.key == 'Physical_headquarter_address') {
            this.Physical_headquarter_address = element.value;
          }
          if (element.key == 'Billing_address') {
            this.Billing_address = element.value;
          }
          if (element.key == 'website_address') {
            this.website_address = element.value;
          }
          if (element.key == 'Social_media') {
            this.Social_media = element.value;
          }
        }
        if (element.form_type == 'yourContact') {
          if (element.key == 'billing_name') {
            this.billing_name = element.value;
          }
          if (element.key == 'billing_email') {
            this.billing_email = element.value;
          }
          if (element.key == 'billing_phone') {
            this.billing_phone = element.value;
          }
          if (element.key == 'Compliance_name') {
            this.Compliance_name = element.value;
          }
          if (element.key == 'Compliance_email') {
            this.Compliance_email = element.value;
          }
          if (element.key == 'Compliance_phone') {
            this.Compliance_phone = element.value;
          }
          if (element.key == 'Operations_name') {
            this.Operations_name = element.value;
          }
          if (element.key == 'Operations_email') {
            this.Operations_email = element.value;
          }
          if (element.key == 'Operations_phone') {
            this.Operations_phone = element.value;
          }
        }

        if (element.form_type == 'voiceService') {
          this.voiceService.push(element);
          if (element.customer_type == 'end_user') {
            if (element.key == 'voice_question1_1') {
              this.ques1 = element;
              if (this.ques1.value == '1') {
                this.ans1 = 'Yes'
              } else if(this.ques1.value == '2') {
                this.ans1 = 'No'
              }
              else{
                this.ans1 = 'N/A'
              }
            }
            if (element.key == 'sub_voice_question1_1') {
              this.subques1 = element!==undefined ? element:'N/A';
            }
            if (element.key == 'voice_question2_2') {
              this.ques2 = element;
              if (this.ques2.value == '1') {
                this.ans2 = 'Yes'
              }
              else if (this.ques2.value == '2') {
                this.ans2 = 'No'
              }
               else {
                this.ans2 = 'N/A'
              }
            }
            if (element.key == 'voice_question3_3') {
              this.ques3 = element;
              if (this.ques3.value == '1') {
                this.ans3 = 'Yes'
              }
              else if (this.ques3.value == '2') {
                this.ans3 = 'No'
              }
               else {
                this.ans3 = 'N/A'
              }
            }
            if (element.key == 'sub_desc_question3_3') {
              this.subques3 = element;
              if (this.subques3.value == '1') {
                this.subans3 = 'Yes'
              }
              else if (this.subques3.value == '2') {
                this.subans3 = 'No'
              }
               else {
                this.subans3 = 'N/A'
              }
            }
            if (element.key == 'voice_question4_4') {
              this.ques4 = element;
              if (this.ques4.value == '1') {
                this.ans4 = 'Yes'
              }
              else if (this.ques4.value == '2') {
                this.ans4 = 'No'
              }
               else {
                this.ans4 = 'N/A'
              }
            }
            if (element.key == 'sub_desc_question4_4') {
              this.subques4 = element
              if (this.subques4.value == '1') {
                this.subans4 = 'Yes'
              }
              else if (this.subques4.value == '2') {
                this.subans4 = 'No'
              }
               else {
                this.subans4 = 'N/A'
              }
              
            }
            if (element.key == 'voice_question5_5') {
              this.ques5 = element;
              if (this.ques5.value == '1') {
                this.ans5 = 'Yes'
              }
              else if (this.ques5.value == '2') {
                this.ans5 = 'No'
              }
               else {
                this.ans5 = 'N/A'
              }
            }
            if (element.key == 'voice_question6_6') {
              this.ques6 = element;
              if (this.ques6.value == '1') {
                this.ans6 = 'Yes'
              }
              else if (this.ques6.value == '2') {
                this.ans6 = 'No'
              }
              else {
                this.ans6 = 'N/A'
              }
            }
            if (element.key == 'voice_question7_7') {
              this.ques7 = element;
              if (this.ques7.value == '1') {
                this.ans7 = 'Yes'
              }
              else if (this.ques7.value == '2') {
                this.ans7 = 'No'
              }
               else {
                this.ans7 = 'N/A'
              }
            }
          }
          if (element.customer_type == 'reseller') {
            if (element.key == 'voice_question1_12') {
              this.ques12 = element;
              if (this.ques12.value == '1') {
                this.ans12 = 'Yes'
              }
              else if (this.ques12.value == '2') {
                this.ans12 = 'No'
              }
               else {
                this.ans12 = 'N/A'
              }
            }
            if (element.key == 'sub_list_question1_12') {
              this.subques12 = element;
            }
            if (element.key == 'voice_question2_13') {
              this.ques13 = element;
              if (this.ques13.value == '1') {
                this.ans13 = 'Yes'
              } 
              else if (this.ques13.value == '2') {
                this.ans13 = 'No'
              } 
              else {
                this.ans13 = 'N/A'
              }
            }
            if (element.key == 'sub_check_question2_13') {
              this.subques13 = element;
              if (this.subques13.value == '1') {
                this.subans13 = 'Yes'
              }
              else if (this.subques13.value == '2') {
                this.subans13 = 'No'
              }
               else {
                this.subans13 = 'N/A'
              }
            }
            if (element.key == 'sub_desc5_question2_13') {
              this.sub1ques13 = element;
            }
            if (element.key == 'voice_question3_14') {
              this.ques14 = element;
              if (this.ques14.value == '1') {
                this.ans14 = 'Yes'
              }
              else if (this.ques14.value == '2') {
                this.ans14 = 'No'
              }
               else {
                this.ans14 = 'N/A'
              }
            }
            if (element.key == 'voice_question4_15') {
              this.ques15 = element;
              if (this.ques15.value == '1') {
                this.ans15 = 'Yes'
              }
              else if (this.ques15.value == '2') {
                this.ans15 = 'No'
              }
              else {
                this.ans15 = 'N/A'
              }
            }
            if (element.key == 'sub_check_question4_15') {
              this.subques15 = element;
              if (this.subques15.value == '1') {
                this.subans15 = 'Yes'
              }
              else if (this.subques15.value == '2') {
                this.subans15 = 'No'
              }
               else {
                this.subans15 = 'N/A'
              }
            }
            if (element.key == 'voice_question5_16') {
              this.ques16 = element;
              if (this.ques16.value == '1') {
                this.ans16 = 'Yes'
              } 
              else if (this.ques16.value == '2') {
                this.ans16 = 'No'
              } 
              else {
                this.ans16 = 'N/A'
              }
            }
            if (element.key == 'sub_check_question5_16') {
              this.subques16 = element;
              if (this.subques16.value == '1') {
                this.subans16 = 'Yes'
              }
              else if (this.subques16.value == '2') {
                this.subans16 = 'No'
              }
               else {
                this.subans16 = 'N/A'
              }
            }
            if (element.key == 'voice_question6_17') {
              this.ques17 = element;
              if (this.ques17.value == '1') {
                this.ans17 = 'Yes'
              }
              else if (this.ques17.value == '2') {
                this.ans17 = 'No'
              }
               else {
                this.ans17 = 'N/A'
              }
            }
            if (element.key == 'sub_check_question6_17') {
              this.subques17 = element;
              if (this.subques17.value == '1') {
                this.subans17 = 'Yes'
              }
              else if (this.subques17.value == '2') {
                this.subans17 = 'No'
              }
               else {
                this.subans17 = 'N/A'
              }
            }
            if (element.key == 'voice_question7_18') {
              this.ques18 = element;
              if (this.ques18.value == '1') {
                this.ans18 = 'Yes'
              }
              else if (this.ques18.value == '2') {
                this.ans18 = 'No'
              }
               else {
                this.ans18 = 'N/A'
              }
            }
            if (element.key == 'voice_question9_20') {
              this.ques20 = element;
              if (this.ques20.value == '1') {
                this.ans20 = 'Yes'
              }
              else if (this.ques20.value == '2') {
                this.ans20 = 'No'
              }
               else {
                this.ans20 = 'N/A'
              }
            }
          }
        }
        if (element.form_type == 'messageService') {
          this.messageService.push(element);
          if (element.customer_type == 'end_user') {
            if (element.key == 'msg_question1_8') {
              this.msgques1 = element;
              if (this.msgques1.value == '1') {
                this.msgans1 = 'Yes'
              }
              else if (this.msgques1.value == '2') {
                this.msgans1 = 'No'
              }
               else {
                this.msgans1 = 'N/A'
              }
            }
            if (element.key == 'sub_msg_question1_8') {
              this.msgsubques1 = element;
            }
            if (element.key == 'msg_question2_9') {
              this.msgques2 = element;
              if (this.msgques2.value == '1') {
                this.msgans2 = 'Yes'
              }
             else if (this.msgques2.value == '2') {
                this.msgans2 = 'No'
              }
               else {
                this.msgans2 = 'N/A'
              }
            }
            if (element.key == 'sub_desc_question3_10') {
              this.msgsubques2 = element;
            }
            if (element.key == 'msg_question3_10') {
              this.msgques3 = element;
              if (this.msgques3.value == '1') {
                this.msgans3 = 'Yes'
              }
              else if (this.msgques3.value == '2') {
                this.msgans3 = 'No'
              }
               else {
                this.msgans3 = 'N/A'
              }
            }
            if (element.key == 'msg_question4_11') {
              this.msgques4 = element;
              if (this.msgques4.value == '1') {
                this.msgans4 = 'Yes'
              }
              else if (this.msgques4.value == '2') {
                this.msgans4 = 'No'
              }
               else {
                this.msgans4 = 'N/A'
              }
            }
          }
          if (element.customer_type == 'reseller') {
            if (element.key == 'msg_question1_22') {
              this.msgques22 = element;
              if (this.msgques22.value == '1') {
                this.msgans22 = 'Yes'
              }
              else if (this.msgques22.value == '2') {
                this.msgans22 = 'No'
              }
               else {
                this.msgans22 = 'N/A'
              }
            }
            if (element.key == 'sub_msg_question1_22') {
              this.submsgques22 = element;
            }
            if (element.key == 'msg_question2_23') {
              this.msgques23 = element;
              if (this.msgques23.value == '1') {
                this.msgans23 = 'Yes'
              }
              else if (this.msgques23.value == '2') {
                this.msgans23 = 'No'
              }
               else {
                this.msgans23 = 'N/A'
              }
            }
            if (element.key == 'msg_question3_24') {
              this.msgques24 = element;
              if (this.msgques24.value == '1') {
                this.msgans24 = 'Yes'
              }
              else if (this.msgques24.value == '2') {
                this.msgans24 = 'No'
              }
               else {
                this.msgans24 = 'N/A'
              }
            }
            if (element.key == 'sub_desc_question3_24') {
              this.submsgques24 = element;
            }
            if (element.key == 'msg_question4_25') {
              this.msgques25 = element;
              if (this.msgques25.value == '1') {
                this.msgans25 = 'Yes'
              }
             else if (this.msgques25.value == '2') {
                this.msgans25 = 'No'
              } else {
                this.msgans25 = 'N/A'
              }
            }
            if (element.key == 'msg_question6_27') {
              this.msgques27 = element;
              if (this.msgques27.value == '1') {
                this.msgans27 = 'Yes'
              }
              else if (this.msgques27.value == '2') {
                this.msgans27 = 'No'
              } else {
                this.msgans27 = 'N/A'
              }
            }
          }
        }
        if (element.form_type == 'kycSignature') {
          if (element.key == 'kyc_signature_name') {
            this.kycSignatureName = element.value;
          }
          if (element.key == 'kyc_signature_title') {
            this.kycSignatureTitle = element.value;
          }
          if (element.key == 'kyc_signature') {
            this.kycSignature = element.value;
          }
        }
        // this.kycDate = element.kyc_date;
        this.ipAddress = element.ipAddress;
      })
      this.getServices();
    })
  }

  getServices() {
    this.voiceService.forEach(element => {
      if (element.question_type !== 5) {
        element.sub_question = JSON.parse(element.sub_question)
      }
    });
    this.messageService.forEach(element => {
      element.sub_question = JSON.parse(element.sub_question)
    });
  }

  EndUserPDF() {
    var target = environment.SERVER + "kyc_upload";
    var _http = this._http
    let payload = JSON.stringify({
      type: 'kyc_pdf',
      name: this.username,
      iduser: this.urliduser,
      idaccount: this.urlidaccount,
      kyc_status: this.kycStatus
    })
    const documentDefinition = {
      watermark:
        { text: 'Signalmash Approved KYC', color: 'blue', opacity: 0.2, bold: true, italics: false },
      content: [
        {
          columns: [
            {
              image: 'data:image/png;base64,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',
              width: 155,
              height: 42,
            },
            {
              width: '25%',
              text: ' ',
            },
            {
              image: 'data:image/png;base64,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',
              width: 175,
              height: 50
            }
          ],
          columnGap: 50
        },
        {
          columns: [
            {
              width: '25%',
              text: '\n\n\n',
            },
            {
              width: '87%',
              text: 'Know Your Customer (KYC)',
              style: 'mr',
            }
          ],
        },
        {
          columns: [
            {
              width: '25%',
              text: 'Your Information',
              style: 'header',
            }
          ],
        },
        {
          columns: [
            {
              width: '60%',
              text: '\nCustomer Legal Name :',
              style: 'note1',
            },
            {
              width: '50%',
              text: `\n${this.Customer_legal_name}`,
              style: 'note1',
            }
          ],
        },
        {
          columns: [
            {
              width: '60%',
              text: '\nDBA/Trade Name(s) :',
              style: 'note1',
            },
            {
              width: '50%',
              text: `\n${this.dba}`,
              style: 'note1',
            }
          ],
        },
        {
          columns: [
            {
              width: '60%',
              text: '\nType Of Business :',
              style: 'note1',
            },
            {
              width: '50%',
              text: `\n${this.business_type}`,
              style: 'note1',
            }
          ],
        },
        {
          columns: [
            {
              width: '60%',
              text: '\nFederal Tax ID No. (FEIN) or foreign business license number :',
              style: 'note1',
            },
            {
              width: '50%',
              text: `\n${this.Federal_tax_id}`,
              style: 'note1',
            }
          ],
        },
        {
          columns: [
            {
              width: '60%',
              text: '\nPhysical Headquarters Address :',
              style: 'note1',
            },
            {
              width: '50%',
              text: `\n${this.Physical_headquarter_address}`,
              style: 'note1',
            }
          ],
        },
        {
          columns: [
            {
              width: '60%',
              text: '\nBilling Address :',
              style: 'note1',
            },
            {
              width: '50%',
              text: `\n${this.Billing_address}`,
              style: 'note1',
            }
          ],
        },
        {
          columns: [
            {
              width: '60%',
              text: '\nWebsite address :',
              style: 'note1',
            },
            {
              width: '50%',
              text: `\n${this.website_address}`,
              style: 'note1',
            }
          ],
        },
        {
          columns: [
            {
              width: '60%',
              text: '\nSocial Media addresses :',
              style: 'note1',
            },
            {
              width: '50%',
              text: `\n${this.Social_media}\n\n\n`,
              style: 'note1',
            }
          ],
        },
        {
          columns: [
            {
              width: '25%',
              text: 'Your Contacts\n\n',
              style: 'header',
            }
          ],
        },
        {
          table: {
            headerRows: 1,
            widths: ['30%', '*'],

            body: [
              [{ text: 'Description', style: 'anotherStyle' }, { text: 'Contact Detail Information', style: 'anotherStyle' },],
              [{ text: 'Billing Contact Name', bold: true }, `${this.billing_name}`,],
              [{ text: 'Billing Contact Email', bold: true }, `${this.billing_email}`,],
              [{ text: 'Billing Contact Phone', bold: true }, `${this.billing_phone}`,],
              [{ text: 'Compliance Contact Name', bold: true }, `${this.Compliance_name}`,],
              [{ text: 'Compliance Contact Email', bold: true }, `${this.Compliance_email}`,],
              [{ text: 'Compliance Contact Phone', bold: true }, `${this.Compliance_phone}`,],
              [{ text: 'Operations Contact Name', bold: true }, `${this.Operations_name}`,],
              [{ text: 'Operations Contact Email', bold: true }, `${this.Operations_email}`,],
              [{ text: 'Operations Contact Phone', bold: true }, `${this.Operations_phone}`,],
            ]
          }
        },
        {
          columns: [
            {
              width: '25%',
              text: '\n\nYour Services\n',
              style: 'header',
            }
          ],
        },
        {
          columns: [
            {
              width: '25%',
              text: `${this.voice}\n\n`,
              bold: true,
              //ul:true
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `${this.ques1.question}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `-${this.ans1}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `\n${this.subques1.question_description}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `-${this.subques1.value}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `\n${this.ques2.question}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `-${this.ans2}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `\n${this.ques3.question}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `-${this.ans3}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `\n${this.subques3.question_description}`,
              style: 'note'
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `-${this.subans3}`,
              style: 'note'
            },
          ],
        }, 
        /* {
          columns: [
            {
              width: '100%',
              text: `\n${this.subques3.question_description}`,
            }
          ],
        }, */
        // {
        //   columns: [
        //     {
        //       width: '100%',
        //       text: `-${this.subques3.value}`,
        //     }
        //   ],
        // },
        {
          columns: [
            {
              width: '100%',
              text: `\n${this.ques4.question}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `-${this.ans4}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `\n${this.subques4.question_description}`,
              style: 'note'
            },
          ],
        },
         {
          columns: [
            {
              width: '100%',
              text: `-${this.subans4}`,
            }
          ],
        },
        {
          columns: [
            {
              width: 'auto',
              text: `\n${this.ques5.question}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `-${this.ans5}`,
            }
          ],
        },
        {
          columns: [
            {
              width: 'auto',
              text: `\n${this.ques6.question}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `-${this.ans6}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `\n${this.ques6.question_description}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `\n${this.ques7.question.split('<a href="')[0]}`,
              style: 'note'
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `${this.ques7.question.split('<a href="')[1].split('" target')[0]}`,
              link: `${this.ques7.question.split('<a href="')[1].split('" target')[0]}`,
              style: 'note2'
            },
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `-${this.ans7}`,
            }
          ],
        },
        /* {
          columns: [
            {
              width: 'auto',
              text: `\n${this.ques7.question}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `-${this.ans7}`,
            }
          ],
        }, */
        {
          columns: [
            {
              width: '25%',
              text: `\n${this.message}\n\n`,
              bold: true,
            }
          ],
        },
        {
          columns: [
            {
              width: 'auto',
              text: `${this.msgques1.question}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `-${this.msgans1}`,
            }
          ],
        },
        {
          columns: [
            {
              width: 'auto',
              text: `\n${this.msgsubques1.question_description}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `-${this.msgsubques1.value}`,
            }
          ],
        },
        {
          columns: [
            {
              width: 'auto',
              text: `\n${this.msgques2.question}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `-${this.msgans2}`,
            }
          ],
        },
        {
          columns: [
            {
              width: 'auto',
              text: `\n${this.msgques3.question}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `-${this.msgans3}`,
            }
          ],
        },
        {
          columns: [
            {
              width: 'auto',
              text: `\n${this.msgsubques2.question_description}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `-${this.msgsubques2.value}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `\n${this.msgques4.question.split('<a href="')[0]}`,
              style: 'note'
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `${this.msgques4.question.split('<a href="')[1].split('" target')[0]}`,
              link: `${this.msgques4.question.split('<a href="')[1].split('" target')[0]}`,
              style: 'note2'
            },
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `-${this.msgans4}`,
            }
          ],
        },
        /* {
          columns: [
            {
              width: 'auto',
              text: `\n${this.msgques4.question}`,  
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `-${this.msgans4}`,
            }
          ],
        }, */
        // {
        //   columns: [
        //     {
        //       width: '100%',
        //       text: `\n${this.msgques4.question_description}\n`,
        //     }
        //   ],
        //},
        {
          columns: [
            {
              width: '25%',
              text: '',
            },
            {
              width: '87%',
              text: 'SIGNATURE & CERTIFICATION',
              style: 'mr',
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: '\nThe undersigned certifies that s/he is an officer of the Customer, as applicable, with authority to enter into Agreements on behalf of Customer, represents and warrants that the information contained within this document is truthful and accurate and further agrees to the Signalmash.',
            },
          ],
        },
        {
          columns: [
            {
              width: '32%',
              text: 'Terms & Conditions of Service',
              link: 'https://signalmash.com/terms-of-service/',
              style: 'note2'
            },
            {
              width: '5%',
              text: 'and',
              style: 'note'
            },
            {
              text: 'Acceptable Use Policy.',
              link: 'https://signalmash.com/acceptable-use-policy/',
              style: 'note2'
            },
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: '\nThe undersigned further certifies that the Customer has knowledge of the U.S. laws prohibiting the generation and transmission of illegal, harassing or otherwise unwanted voice calls, including but not limited to the Telephone Consumer Protection Act, Truth in Caller ID Act, Telemarketing Sales Rule, Wire Fraud Statutes and the CAN-SPAM Act. The undersigned hereby confirms that Customer complies with these laws and consents to disclosure by Signalmash, at Signalmash® sole discretion, of the details contained within this document along with any other requested Customer information in response to any inquires regarding potential conduct violations related to customers use of Signalmash services.',
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: '\nSignalmash also reserves the right to randomly record segments of originating and terminating calls from the Signalmash’s platform in order to insure lawful use.  Signalmash will never use this data unless required by law enforcement.',
            },
          ],
        },
        {
          columns: [
            {
              width: '12%',
              text: 'Please see ',
              style: 'note'
            },
            {
              width: '15%',
              text: 'Privacy Policy ',
              link: 'https://signalmash.com/privacy-policy/',
              style: 'note2'
            },
            {
              width: '46%',
              text: ' to learn how Signamash protects your data.',
              style: 'note'
            },
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: '\nI verify that I am authorized to legally bind the Customer by my Signature.',
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `\nName : ${this.kycSignatureName}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `\nTitle : ${this.kycSignatureTitle}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '12%',
              text: '\n\nSignature : ',
            },
            {
              image: `${this.kycSignature}`,
              width: 155,
              height: 42,
            },
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `\nDate : ${this.datePipe.transform(this.kycDate,"yyyy-MM-dd")}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `\nIP Address : ${this.ipAddress}`,
            }
          ],
        },


      ],
      styles: {
        header: {
          fontSize: 16,
          bold: true,
          color: '#0339fc'
        },
        header1: {
          fontSize: 13,
          bold: true,
          color: '#0339fc'
        },
        header2: {
          fontSize: 12,
          bold: true,
          color: '#0339fc'
        },
        column: {
          background: '#0339fc',

        },
        note: {
          margin: [0, 0, 0, 0],

        },
        note1: {
          fontSize: 10,
        },
        note2: {
          // fontSize: 12,
          margin: [0, 0, 0, 0],
          color: 'blue'
        },
        mr: {
          fontSize: 18,
          bold: true,
          color: '#0339fc',
          margin: [0, 18, 0, 0],
        },
        anotherStyle: {
          //italics: true,
          alignment: 'left',
          bold: 'true'
        },

      }
    };
    //pdfMake.createPdf(documentDefinition).download(`bhardwaj`);


    const pdfDocGenerator = pdfMake.createPdf(documentDefinition);
    pdfDocGenerator.getBlob((blob) => {
      const pdfBlob = new Blob([blob], { type: 'application/pdf' });
      const fd = new FormData();
      fd.append("UPLOAD", pdfBlob, 'pdf');
      fd.append('payload', payload)
      fd.append('type', 'kyc_pdf')
      const req = new HttpRequest('POST', target, fd, {
        reportProgress: true
      });
      _http.request(req).subscribe((res: any) => {
      })
    });
  }

  ResellerPDF() {
    var target = environment.SERVER + "kyc_upload";
    var _http = this._http
    let payload = JSON.stringify({
      type: 'kyc_pdf',
      name: this.username,
      idaccount: this.urlidaccount,
      iduser: this.urliduser,
      kyc_status: this.kycStatus
    })
    const documentDefinition = {
      watermark:
        { text: 'Signalmash Approved KYC', color: 'blue', opacity: 0.2, bold: true, italics: false },
      content: [
        {
          columns: [
            {
              image: 'data:image/png;base64,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',
              width: 155,
              height: 42,
            },
            {
              width: '25%',
              text: ' ',
            },
            {
              image: 'data:image/png;base64,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',
              width: 175,
              height: 50
            }
          ],
          columnGap: 50
        },
        {
          columns: [
            {
              width: '25%',
              text: '\n\n\n',
            },
            {
              width: '87%',
              text: 'Know Your Customer (KYC)',
              style: 'mr',
            }
          ],
        },
        {
          columns: [
            {
              width: '25%',
              text: 'Your Information',
              style: 'header',
            }
          ],
        },
        {
          columns: [
            {
              width: '60%',
              text: '\nCustomer Legal Name :',
              style: 'note1',
            },
            {
              width: '50%',
              text: `\n${this.Customer_legal_name}`,
              style: 'note1',
            }
          ],
        },
        {
          columns: [
            {
              width: '60%',
              text: '\nDBA/Trade Name(s) :',
              style: 'note1',
            },
            {
              width: '50%',
              text: `\n${this.dba}`,
              style: 'note1',
            }
          ],
        },
        {
          columns: [
            {
              width: '60%',
              text: '\nType Of Business :',
              style: 'note1',
            },
            {
              width: '50%',
              text: `\n${this.business_type}`,
              style: 'note1',
            }
          ],
        },
        {
          columns: [
            {
              width: '60%',
              text: '\nFederal Tax ID No. (FEIN) or foreign business license number :',
              style: 'note1',
            },
            {
              width: '50%',
              text: `\n${this.Federal_tax_id}`,
              style: 'note1',
            }
          ],
        },
        {
          columns: [
            {
              width: '60%',
              text: '\nPhysical Headquarters Address :',
              style: 'note1',
            },
            {
              width: '50%',
              text: `\n${this.Physical_headquarter_address}`,
              style: 'note1',
            }
          ],
        },
        {
          columns: [
            {
              width: '60%',
              text: '\nBilling Address :',
              style: 'note1',
            },
            {
              width: '50%',
              text: `\n${this.Billing_address}`,
              style: 'note1',
            }
          ],
        },
        {
          columns: [
            {
              width: '60%',
              text: '\nWebsite address :',
              style: 'note1',
            },
            {
              width: '50%',
              text: `\n${this.website_address}`,
              style: 'note1',
            }
          ],
        },
        {
          columns: [
            {
              width: '60%',
              text: '\nSocial Media addresses :',
              style: 'note1',
            },
            {
              width: '50%',
              text: `\n${this.Social_media}\n\n\n`,
              style: 'note1',
            }
          ],
        },
        {
          columns: [
            {
              width: '25%',
              text: 'Your Contacts\n\n',
              style: 'header',
            }
          ],
        },
        {
          table: {
            headerRows: 1,
            widths: ['30%', '*'],

            body: [
              [{ text: 'Description', style: 'anotherStyle' }, { text: 'Contact Detail Information', style: 'anotherStyle' },],
              [{ text: 'Billing Contact Name', bold: true }, `${this.billing_name}`,],
              [{ text: 'Billing Contact Email', bold: true }, `${this.billing_email}`,],
              [{ text: 'Billing Contact Phone', bold: true }, `${this.billing_phone}`,],
              [{ text: 'Compliance Contact Name', bold: true }, `${this.Compliance_name}`,],
              [{ text: 'Compliance Contact Email', bold: true }, `${this.Compliance_email}`,],
              [{ text: 'Compliance Contact Phone', bold: true }, `${this.Compliance_phone}`,],
              [{ text: 'Operations Contact Name', bold: true }, `${this.Operations_name}`,],
              [{ text: 'Operations Contact Email', bold: true }, `${this.Operations_email}`,],
              [{ text: 'Operations Contact Phone', bold: true }, `${this.Operations_phone}`,],
            ]
          }
        },
        {
          columns: [
            {
              width: '25%',
              text: '\n\nYour Services\n',
              style: 'header',
            }
          ],
        },
        {
          columns: [
            {
              width: '25%',
              text: `${this.voice}\n\n`,
              bold: true,
              //ul:true
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `${this.ques12.question}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `-${this.ans12}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `\n${this.subques12.question_description}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `-${this.subques12.value}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `\n${this.ques13.question}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `-${this.ans13}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `\n${this.subques13.question_description}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `-${this.subans13}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `\n${this.sub1ques13.sub_question}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `-${this.sub1ques13.value}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `\n${this.ques14.question}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `-${this.ans14}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `\n${this.ques15.question}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `-${this.ans15}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `\n${this.subques15.question_description}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `-${this.subans15}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `\n${this.ques16.question}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `-${this.ans16}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `\n${this.subques16.question_description}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `-${this.subans16}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `\n${this.ques17.question}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `-${this.ans17}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `\n${this.subques17.question_description}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `-${this.subans17}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `\n${this.ques18.question.split('<a href="')[0]}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `${this.ques18.question.split('<a href="')[1].split('" target')[0]}}`,
              link: `${this.ques18.question.split('<a href="')[1].split('" target')[0]}`,
              style: 'note2'
            },
          ],
        },
        // {
        //   columns: [
        //     {
        //       width: '100%',
        //       text: `${this.ques18.question.split('<a href="')[1].split('" target')[0]}`,
        //       link: `${this.ques18.question.split('<a href="')[1].split('" target')[0]}`,
        //       style: 'note2'
        //     },
        //   ],
        // },
        {
          columns: [
            {
              width: '100%',
              text: `-${this.ans18}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `\n${this.ques20.question.split('<a href="')[0]}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `${this.ques20.question.split('<a href="')[1].split('" target')[0]}`,
              link: `${this.ques20.question.split('<a href="')[1].split('" target')[0]}`,
              style: 'note2'
            },
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `-${this.ans20}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '25%',
              text: `\n${this.message}\n\n`,
              bold: true,
            }
          ],
        },
        {
          columns: [
            {
              width: 'auto',
              text: `${this.msgques22.question}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `-${this.msgans22}`,
            }
          ],
        },
        {
          columns: [
            {
              width: 'auto',
              text: `\n${this.submsgques22.question_description}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `-${this.submsgques22.value}`,
            }
          ],
        },
        {
          columns: [
            {
              width: 'auto',
              text: `\n${this.msgques23.question}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `-${this.msgans23}`,
            }
          ],
        },
        {
          columns: [
            {
              width: 'auto',
              text: `\n${this.msgques24.question}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `-${this.msgans24}`,
            }
          ],
        },
        {
          columns: [
            {
              width: 'auto',
              text: `\n${this.submsgques24.question_description}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `-${this.submsgques24.value}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `\n${this.msgques25.question.split('<a href="')[0]}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `${this.msgques25.question.split('<a href="')[1].split('" target')[0]}`,
              link: `${this.msgques25.question.split('<a href="')[1].split('" target')[0]}`,
              style: 'note2'
            },
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `-${this.msgans25}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `\n${this.msgques27.question.split('<a href="')[0]}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `${this.msgques27.question.split('<a href="')[1].split('" target')[0]}`,
              link: `${this.msgques27.question.split('<a href="')[1].split('" target')[0]}`,
              style: 'note2'
            },
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `-${this.msgans27}\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n`,
            }
          ],
        },
        {
          columns: [
            {
              width: '25%',
              text: '',
            },
            {
              width: '87%',
              text: 'SIGNATURE & CERTIFICATION',
              style: 'mr',
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: '\nThe undersigned certifies that s/he is an officer of the Customer, as applicable, with authority to enter into Agreements on behalf of Customer, represents and warrants that the information contained within this document is truthful and accurate and further agrees to the Signalmash.',
            },
          ],
        },
        {
          columns: [
            {
              width: '32%',
              text: 'Terms & Conditions of Service',
              link: 'https://signalmash.com/terms-of-service/',
              style: 'note2'
            },
            {
              width: '5%',
              text: 'and',
              style: 'note'
            },
            {
              text: 'Acceptable Use Policy.',
              link: 'https://signalmash.com/acceptable-use-policy/',
              style: 'note2'
            },
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: '\nThe undersigned further certifies that the Customer has knowledge of the U.S. laws prohibiting the generation and transmission of illegal, harassing or otherwise unwanted voice calls, including but not limited to the Telephone Consumer Protection Act, Truth in Caller ID Act, Telemarketing Sales Rule, Wire Fraud Statutes and the CAN-SPAM Act. The undersigned hereby confirms that Customer complies with these laws and consents to disclosure by Signalmash, at Signalmash® sole discretion, of the details contained within this document along with any other requested Customer information in response to any inquires regarding potential conduct violations related to customers use of Signalmash services.',
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: '\nSignalmash also reserves the right to randomly record segments of originating and terminating calls from the Signalmash’s platform in order to insure lawful use.  Signalmash will never use this data unless required by law enforcement.',
            },
          ],
        },
        {
          columns: [
            {
              width: '12%',
              text: 'Please see ',
              style: 'note'
            },
            {
              width: '15%',
              text: 'Privacy Policy ',
              link: 'https://signalmash.com/privacy-policy/',
              style: 'note2'
            },
            {
              width: '46%',
              text: ' to learn how Signamash protects your data.',
              style: 'note'
            },
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: '\nI verify that I am authorized to legally bind the Customer by my Signature.',
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `\nName : ${this.kycSignatureName}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `\nTitle : ${this.kycSignatureTitle}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '12%',
              text: '\n\nSignature : ',
            },
            {
              image: `${this.kycSignature}`,
              width: 155,
              height: 42,
            },
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `\nDate : ${this.datePipe.transform(this.kycDate,"yyyy-MM-dd")}`,
            }
          ],
        },
        {
          columns: [
            {
              width: '100%',
              text: `\nIP Address : ${this.ipAddress}`,
            }
          ],
        },
      ],
      styles: {
        header: {
          fontSize: 16,
          bold: true,
          color: '#0339fc'
        },
        header1: {
          fontSize: 13,
          bold: true,
          color: '#0339fc'
        },
        header2: {
          fontSize: 12,
          bold: true,
          color: '#0339fc'
        },
        column: {
          background: '#0339fc',

        },
        note: {
          margin: [0, 0, 0, 0],

        },
        note1: {
          fontSize: 10,
        },
        note2: {
          // fontSize: 12,
          margin: [0, 0, 0, 0],
          color: 'blue'
        },
        mr: {
          fontSize: 18,
          bold: true,
          color: '#0339fc',
          margin: [0, 18, 0, 0],
        },
        anotherStyle: {
          //italics: true,
          alignment: 'left',
          bold: 'true'
        },

      }
    };
    //pdfMake.createPdf(documentDefinition).download(`bhardwaj`);


    const pdfDocGenerator = pdfMake.createPdf(documentDefinition);
    pdfDocGenerator.getBlob((blob) => {
      const pdfBlob = new Blob([blob], { type: 'application/pdf' });
      const fd = new FormData();
      fd.append("UPLOAD", pdfBlob, 'pdf');
      fd.append('payload', payload)
      fd.append('type', 'kyc_pdf')
      const req = new HttpRequest('POST', target, fd, {
        reportProgress: true
      });
      _http.request(req).subscribe((res: any) => {
      })
    });
  }
  /*Kyc Verify function*/
  verifyKyc() {
    let data = {
      idaccount: this.urlidaccount,
      iduser: this.urliduser
    }
    this.data.kycVerify(data).subscribe((res) => {
      if (res.status == 201) {
        this.kycStatus = 1;
        this.data.getkycstatus(data).subscribe(res => {
          this.getStatus = res.data[0];
          if (this.getStatus.customer_type == 'end_user') {
            this.EndUserPDF();
          }
          else if (this.getStatus.customer_type == 'reseller') {
            this.ResellerPDF();
          }
        })
        this.responseMessage = res.message;
        setTimeout(() => {
          this.responseMessage = "";
          document.getElementById("verifyCloseBtn").click();
          this.location.back()
        }, 5000);
       
        // this.router.navigate(['user/user-details'])
        //   .then(() => {
        //     location.reload();
        //   })
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.responseMessage = err.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    });
  }

  rejectKyc() {
    let data = {
      idaccount: this.urlidaccount,
      iduser: this.urliduser
    }
    this.data.rejectKycStatus(data).subscribe((res) => {
      if (res.status == 201) {
        this.kycStatus = 3;
        this.responseMessage = res.message;
        this.data.getkycstatus(data).subscribe(res => {
          this.getStatus = res.data[0];
          if (this.getStatus.customer_type == 'end_user') {
            this.EndUserPDF();
          }
          else if (this.getStatus.customer_type == 'reseller') {
            this.ResellerPDF();
          }
        });
        setTimeout(() => {
          this.responseMessage = "";
          document.getElementById("rejectCloseBtn").click();
          this.location.back();
        }, 5000);
      
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }

    })
  }
  cancelKYC() {
    let data = {
      idaccount: this.urlidaccount,
      iduser: this.urliduser,
      kyc_status: 4
    }
    this.data.cancelKycStatus(data).subscribe((res) => {
      if (res.status == 201) {
        this.kycStatus = 4;
        this.responseMessage = res.message;
        this.data.getkycstatus(data).subscribe(res => {
          this.getStatus = res.data[0];
          if (this.getStatus.customer_type == 'end_user') {
            this.EndUserPDF();
          }
          else if (this.getStatus.customer_type == 'reseller') {
            this.ResellerPDF();
          }
        })
        setTimeout(() => {
          this.responseMessage = "";
          document.getElementById("cancelCloseBtn").click();
          this.location.back();
        }, 5000);
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.responseMessage = err.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    });
  }

  backPage() {
    this.location.back()
    // this.router.navigate(['user/user-details'])
    //   .then(() => {
    //     location.reload(); 
    //   })

  }

  // updateKycForm(types)
  // {
  //    this.router.navigate(['kyc/kyc', types])
  //     .then(() => {
  //       location.reload(); 
  //     })
  // }

  ngOnDestroy(){
    this.closebutton.nativeElement.click();
    this.closebuttonreject.nativeElement.click();
    this.CancelKYC.nativeElement.click();
  }
}
