import { HttpClient, HttpRequest } from '@angular/common/http';
import { Component, ElementRef, OnInit, ViewChild, ViewEncapsulation } from '@angular/core';
import { FormBuilder, FormGroup, FormArray, Validators, ValidatorFn, ValidationErrors, AbstractControl } from '@angular/forms';
import { MatStepper } from '@angular/material/stepper';
import { ActivatedRoute, ParamMap, Router } from '@angular/router';
import { IDropdownSettings } from 'ng-multiselect-dropdown';
import { element } from 'protractor';
import { BehaviorSubject, Observable } from 'rxjs';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import { environment } from 'src/environments/environment';
import { NewCamapignService } from '../new-camapign.service';
declare var $: any;
@Component({
  selector: 'app-registernew-campaign',
  templateUrl: './registernew-campaign.component.html',
  styleUrls: ['./registernew-campaign.component.css'],
  encapsulation: ViewEncapsulation.None
})
export class RegisternewCampaignComponent implements OnInit {
  @ViewChild('stepper') stepper: MatStepper;
  @ViewChild('discretionmodal') discretionmodal: ElementRef;
  @ViewChild('vettingidentifiermodal') vettingidentifiermodal: ElementRef;
  @ViewChild('textmodals') textmodals: ElementRef;
  @ViewChild('videomodals') videomodals: ElementRef;
  @ViewChild('audiomodals') audiomodals: ElementRef;
  @ViewChild('docsmodals') docsmodals: ElementRef;
  @ViewChild('imagemodal') imagemodal: ElementRef;
  @ViewChild('pdfmodals') pdfmodals: ElementRef;

  public brandData: any;
  public yes: boolean = false;
  openeye: boolean = false;
  outoption: boolean = false;
  opthelp: boolean = false;
  open_optout: boolean = false;
  open_opthelp: boolean = false;
  isVisible: any;
  isSelected: boolean = true;
  campaignCases: any = [];
  campaignMno: any = [];
  conntPartner: any = [];
  resellerDetls: any = [];
  brandList: any = [];
  brandRef: any;
  mnoRegcas: any = [];
  standardCampaign: any = [];
  specialCampaign: any = [];
  status: boolean = false;
  subUseCases: any = [];
  campaignForm: FormGroup;
  usecase: any = [];
  brand_key: any;
  selectedSubCases: any = [];
  selectedVertical: any;
  isDisable: boolean = false;
  responseMessage = "";
  campaign_name: string;
  brand: any;
  brandId: any;
  brandVertical: any = [];
  brandName: any;
  brandNameId: any;
  campData: any = [];
  isDisabled: boolean = false;
  minSubUsecases: any;
  errMessage: any = "";
  submitted: boolean = false;
  searchText: any;
  autoRenewal: boolean = false;
  camp: any;
  opt_out: any;
  opt_outhelp: any;
  iduser: any;
  mnoIds: any = [];
  dropdownSettings: IDropdownSettings = {};
  closeDropdownSelection = true;
  checked: boolean = false;
  disabled = false;
  selectedItems: any[];
  carrierListOrMnos: Boolean;
  dataMno: any;
  dataBid: string;
  useCase: any;
  entityType: any;
  displaySole: boolean = false;
  displayNpvt: boolean = false;
  displayG: boolean = false;
  displayPvt: boolean = false;
  displayPub: boolean = false;
  displayNon: boolean = false;
  brandListById: any;
  mnoButton: any = true;
  selectedBrand: boolean = true;
  mnoQualify: any = [];
  mnoQualifyChecked: boolean;
  M2MSubmitted: boolean = false;
  //public mediaForm: FormGroup;
  img: File;
  payLoad: { fileName: any; mimeType: any; };
  showImgName: any;
  getAllMultiMediaFile: any = [];
  multimediaErr: string;
  m2mEnableCase: boolean = false;
  InputBtn: boolean = true;
  removeData: any = [];
  uploadImage: any = [];
  identityStatus: any;
  NextDisable: boolean = false;
  ErrDisplay: boolean = false;
  featureServiceData: any;
  userType: any;
  idaccount: any;
  isDisabledServiceStatus: boolean;
  optInEye: boolean = true;
  optOutEye: boolean = true;
  optHelpEye: boolean = true;
  enabled: boolean = true;

  serviceMessage: any = 'Campaign service has been suspended. More information please contact support';
  enableCase2fa: boolean = false;
  selectedFile: File[] = [];
  fileData: any;
  uploadBtn: boolean = true;
  displayedFilesCount: number = 0;
  requestBtn: boolean = false;
  key: string;
  selectedFiles: any = [];
  lastId: any = [];
  checkPolitical: boolean = false;
  caseType: boolean = false;
  mnoCheckboxHide: boolean = false;
  smCampKey: any = '';
  existCamp: any;
  parentSmCampKey: any;
  brandstatus: any;
  campkey: any;
  campaignstatus: any;
  redExistCamp: any;
  isRedundantCampaignCreated: boolean = false;
  oldbrandId: any;
  campDetails: any = [];
  oldMno: any = [];
  firstpage: boolean = false;
  provisionStatus: any;
  smCampaignKey: any = '';
  subUsecase: any;
  campaigntype: any;
  keyword_not: boolean = false;
  help_not: boolean = false;
  constructor(private campaignService: NewCamapignService, public newCapaignservice: NewCamapignService, public userService: UsermanagementService,
    public fb: FormBuilder, public _http: HttpClient, private route: ActivatedRoute, public router: Router) { }

  ngOnInit() {
    this.userService.getfeatureServiceStatus().subscribe(res => {
      this.featureServiceData = res.data.find(x => x.fs_id == '7');
      if (this.featureServiceData !== undefined && this.featureServiceData.as_status == 1) {
        this.isDisabledServiceStatus = false;

      } else {
        this.isDisabledServiceStatus = true;
        this.showMsg();

      }

    });
    this.carrierListOrMnos = false
    this.displaySole = true;
    this.campaignForm = this.fb.group({
      brandId: [],
      usecase: [],
      subUsecases: [],
      embeddedLink: ['', [Validators.required]],
      embeddedPhone: ['', [Validators.required]],
      affiliateMarketing: [false],
      termsAndConditions: ['', [Validators.required]],
      numberPool: ['', [Validators.required]],
      ageGated: ['', [Validators.required]],
      directLending: ['', [Validators.required]],
      subscriberOptin: ['', [Validators.required]],
      subscriberOptout: ['', [Validators.required]],
      subscriberHelp: ['', [Validators.required]],
      sample1: ['', [Validators.required, Validators.minLength(20), Validators.maxLength(1024)]],
      sample2: ['', [Validators.required, Validators.minLength(20), Validators.maxLength(1024)]],
      sample3: ['', [Validators.minLength(20), Validators.maxLength(1024)]],
      sample4: ['', [Validators.minLength(20), Validators.maxLength(1024)]],
      sample5: ['', [Validators.minLength(20), Validators.maxLength(1024)]],
      messageFlow: ['', [Validators.required, Validators.minLength(40), Validators.maxLength(4096)]],
      description: ['', [Validators.required, Validators.minLength(40), Validators.maxLength(4096)]],
      helpMessage: [''],
      mnoIds: [''],
      autoRenewal: [true],
      optinKeywords: [],
      optoutKeywords: [''],
      helpKeywords: [''],
      optinMessage: [''],
      optoutMessage: [''],
      rate: [],
      campaignKey: [],
      sampleMediaLastId: [],
      smCampaignKey: [''],
      provisionStatus: [],
    });
    // this.mediaForm = this.fb.group({
    //   fileName: ['', Validators.required]
    // })
    var navListItems = $('div.setup-panel div button'),
      allWells = $('.setup-content'),
      allNextBtn = $('.nextBtn');

    allWells.hide();

    navListItems.click(function (e) {
      e.preventDefault();
      var $target = $($(this).attr('href')),
        $item = $(this).closest('li');
      $item = $(this);

      if (!$item.hasClass('disabled')) {
        navListItems.removeClass('btn-success').addClass('btn-default');
        $item.addClass('btn-success');
        allWells.hide();
        $target.show();
        $target.find('input:eq(0)').focus();
      }
    });

    allNextBtn.click(function () {
      var curStep = $(this).closest(".setup-content"),
        curStepBtn = curStep.attr("id"),
        nextStepWizard = $('div.setup-panel div button[href="#' + curStepBtn + '"]').parent().next().children("button"),
        curInputs = curStep.find("input[type='text'],input[type='url']"),
        isValid = true;

      $(".form-group").removeClass("has-error");
      for (var i = 0; i < curInputs.length; i++) {
        if (!curInputs[i].validity.valid) {
          isValid = false;
          $(curInputs[i]).closest(".form-group").addClass("has-error");
        }
      }

      if (isValid) nextStepWizard.removeAttr('disabled').trigger('click');
    });

    $('div.setup-panel div button.btn-success').trigger('click');



    this.campaignService.brandVertical().subscribe(res => {
      let tmp: any = [];
      Object.entries(res.data).forEach((ele: any) => {
        let t = ele[1];
        t["name"] = ele[0];
        tmp.push(t);
      });
      this.brandVertical = tmp;
    });

    this.campaignService.getCampaignCases().subscribe(res => {
      this.campaignCases = res.data;
      this.campaignCases.forEach(element => {
        element.isDisable = false;
        element.isDisabled;
      });
      this.campaignCases.forEach(element => {
        if (element.classification == "STANDARD") {
          this.standardCampaign.push(element);
        }
        if (element.classification == "SPECIAL") {
          this.specialCampaign.push(element);
        }
        if (element.validSubUsecase == "true") {
          element.isDisable = false;
          this.subUseCases.push(element);
        }
      });

      let temp: { [k: string]: any } = [];
      this.campaignCases.forEach(element => {
        if (element.validSubUsecase == "false") {
          let t = element;
          t["subUseCases"] = this.subUseCases;
          temp.push(t);
        }
        else {
          temp.push(element);
        }
      });
    })


    this.route.paramMap.subscribe((params: any) => {
      const keys = Object.keys(params.params);
      if (keys.length > 0) {
        if (keys[0] == 'CopyCampId') {
          let data = params.get("CopyCampId").split("-");
          this.smCampKey = data[0];
          this.brandId = data[1];
          this.iduser = data[2];
          this.brandName = data[3].split("_").join(" ");
          this.brandNameId = data[3].split("_").join(" ") + ' - ' + data[1];
          this.searchText = data[3].split("_").join(" ");
          this.existCamp = data[4];
          this.campaigntype = data[5];
          if (this.campaigntype == "Redundant") {
            this.isRedundantCampaignCreated = true;
          }
          this.campaignForm.patchValue({
            brandId: this.brandId
          })
          this.selectedItems = [this.brandNameId];
          this.useCaseSelection(this.brandId);

        }
        else if (keys[0] == 'redundantCampId') {
          let data = params.get("redundantCampId").split("-");
          if (data[5] == 'same_brand') {
            this.smCampKey = data[0];
            this.parentSmCampKey = data[0];
            this.brandId = data[1];
            this.iduser = data[2];
            this.brandName = data[3].split("_").join(" ");
            this.brandNameId = data[3].split("_").join(" ") + ' - ' + data[1];
            this.searchText = data[3].split("_").join(" ");
            this.campkey = data[4];
            this.brandstatus = data[5]
            this.campaignstatus = data[6]
            this.redExistCamp = data[7]
            this.isRedundantCampaignCreated = true;
            this.campaignForm.patchValue({
              brandId: this.brandId
            })
          }
          if (data[5] == 'new_brand') {
            this.smCampKey = data[0];
            this.parentSmCampKey = data[0];
            this.brandId = data[1];
            this.oldbrandId = data[7];
            this.iduser = data[2];
            this.brandName = data[3].split("_").join(" ");
            this.brandNameId = data[3].split("_").join(" ") + ' - ' + data[1];
            this.searchText = data[3].split("_").join(" ");
            this.campkey = data[4];
            this.brandstatus = data[5]
            this.campaignstatus = data[6]
            this.redExistCamp = data[7]
            this.isRedundantCampaignCreated = true;
            this.campaignForm.patchValue({
              brandId: this.brandId
            })
          }
          this.selectedItems = [this.brandNameId];
          this.useCaseSelection(this.brandId);
        }
        else {
          let data = params.get("id").split("-");
          this.brandId = data[0];
          this.iduser = data[1];
          this.brandName = data[2].split("_").join(" ");
          this.brandNameId = data[2].split("_").join(" ") + ' - ' + data[0];
          this.searchText = data[2].split("_").join(" ");
          this.campaignForm.patchValue({
            brandId: this.brandId
          })
          this.selectedItems = [this.brandNameId];
          this.useCaseSelection(this.brandId);
        }
      }
    });
    if (this.redExistCamp === 'Save') {
      this.ngAfterViewInit();
      this.getMNOs()
      this.setMnos()
    }

    /*Show here only brand list ...for registercampaign directly*/
    this.campaignService.getBrand().subscribe(res => {
      res.data.forEach((ele: any, idx: number) => {
        ele.id = idx;
      });
      this.brandList = res.data;
      this.dataBid = JSON.stringify({
        brandId: this.brandId,
      });
      let bids = JSON.parse(this.dataBid);
      if (this.brandId)
        this.changeBrandId(bids);
    })

    this.dropdownSettings = {
      singleSelection: true,
      idField: 'brandId',
      textField: 'brand_name_with_key',
      itemsShowLimit: 3,
      allowSearchFilter: true,
      closeDropDownOnSelection: this.closeDropdownSelection
    };

    this.key = Math.random().toString(36).slice(2);

    // this.getbrandQualifyByAllUseCases(this.brandId);
  }


  // registerCampaignFile()
  // {
  //   if (this.mediaForm.invalid) { 
  //     return false;
  //   }
  //   else {     
  //     this.campaignService.createCampaignFile(this.payLoad).subscribe(res => {
  //      if (res.status == 200) {
  //       this.responseMessage = res.message;
  //       this.showImgName=res.data[0].fileName;
  //       setTimeout(() => {
  //         this.responseMessage = "";
  //       }, 5000);
  //     }
  //     else {
  //       this.responseMessage = res.message;
  //       setTimeout(() => {
  //         this.responseMessage = "";
  //       }, 5000);
  //     }

  //     })
  //   }

  // }

  onFileSelect(event) {
    // this.img = event.target.files[0];
    // this.payLoad={
    //   fileName:this.img.name,
    //   mimeType:this.img.type.split('/')[1],
    // }
    // this.getAllMultiMediaFile.push(this.payLoad);
    // if(this.getAllMultiMediaFile.length > 4)
    // {
    //     this.multimediaErr="Max 5 uploads per campaign is allowed";
    //     this.InputBtn=false;
    // }
    // this.campaignForm.patchValue({
    //   fileName: this.getAllMultiMediaFile
    // });

  }
  delImg(val) {
    //  this.removeData =  this.getAllMultiMediaFile.filter(arr => arr.fileName != val); 
    //   for (var i = this.getAllMultiMediaFile.length - 1; i >= 0; --i) {
    //     if (i == val) {
    //         this.getAllMultiMediaFile.splice(i,1); 
    //     }
    // }
  }
  displayImg() {
    // const reader=new FileReader()
    // reader.readAsDataURL(this.img)
    // reader.onload=()=>{
    //   this.getAllMultiMediaFile.push(reader.result);
    // }

  }

  deselectBrand(e) {
    this.displaySole = true;
    this.displayG = true;
    this.displayPvt = true;
    this.displayPub = true;
    this.displayNpvt = true;
    if (e.brandId) {
      this.selectedBrand = true;
    }
    this.campaignForm.patchValue({
      brandId: '',
      entityType: ''
    });
    this.brandId = [];
    this.entityType = [];
    $(".hidebtn").prop("checked", false);
  }



  hidebttn() {
    this.selectedBrand = false;
  }

  changeBrandId(e) {
    this.campaignService.checkNonProfitBrand(e.brandId).subscribe(res => {
      if (res.status == 200) {
        this.checkPolitical = res.data;
        this.caseType = false;
      }
      else {
        this.caseType = true;
      }
    })

    $(".hidebtn").prop("checked", false);
    // $(".hidebtn").prop( "disabled", false );
    this.specialCampaign.forEach(element => {
      element.status = false;
    })
    this.displaySole = false;
    this.displayG = false;
    this.displayPvt = false;
    this.displayPub = false;
    this.displayNpvt = false;
    if (e.brandId) {
      this.selectedBrand = true;
    }

    this.campaignForm.patchValue({
      brandId: e.brandId
    });
    this.useCaseSelection(e.brandId);


  }

  // useCaseSelection(id?: any) {
  //   this.brandList.find(el => {
  //     if (el.brandId == id) {
  //       this.NextDisable = false;
  //       this.brandId = el.brandId;
  //       this.brandName = el.brand_name;
  //       this.entityType = el.entityType;
  //       this.identityStatus = el.identityStatus 
  //       if(this.identityStatus == "" || this.identityStatus == null || this.identityStatus == undefined || this.identityStatus == 'PENDING'){
  //         this.NextDisable = true;
  //         // this.ErrDisplay = true;
  //         this.errMessage = "Brand registration status pending";
  //         setTimeout(() => {
  //           // this.ErrDisplay = false;
  //           this.errMessage="";
  //         }, 7000);
  //       }
  //       if(this.identityStatus == 'UNVERIFIED'){
  //         this.NextDisable = true;
  //         this.errMessage = "Brand registration status unverified";
  //         setTimeout(() => {
  //           this.errMessage="";
  //         }, 7000);
  //       }
  //     }
  //   });


  //   //  for private cases.... 
  //   if (this.entityType == 'PRIVATE_PROFIT') {
  //     this.displayPvt = true;
  //   }
  //   else {
  //     this.displayPvt = false;
  //   }
  //   // public cases 
  //   if (this.entityType == 'PUBLIC_PROFIT') {
  //     this.displayPub = true;
  //   }
  //   else {
  //     this.displayPub = false;
  //   }
  //   // for sole proprietor...
  //   if (this.entityType == 'SOLE_PROPRIETOR') {
  //     this.displaySole = true;
  //   }
  //   else {
  //     this.displaySole = false;
  //   }
  //   //for non-profit case...
  //   if (this.entityType == 'NON_PROFIT') {
  //     this.displayNpvt = true;
  //   }
  //   else {
  //     this.displayNpvt = false;
  //   }
  //   //for government case
  //   if (this.entityType == 'GOVERNMENT') {
  //     this.displayG = true;
  //   }
  //   else {
  //     this.displayG = false;
  //   }

  // }

  useCaseSelection(id?: any) {
    this.brandList.find(el => {
      if (el.brandId == id) {
        this.NextDisable = false;
        this.brandId = el.brandId;
        this.brandName = el.brand_name;
        this.entityType = el.entityType;
        this.identityStatus = el.identityStatus
        if ((this.identityStatus == "" || this.identityStatus == null || this.identityStatus == undefined || this.identityStatus == 'PENDING') && this.isRedundantCampaignCreated) {
          // this.errMessage = " ";

        }
        else if (this.identityStatus == "" || this.identityStatus == null || this.identityStatus == undefined || this.identityStatus == 'PENDING') {
          this.NextDisable = true;
          // this.ErrDisplay = true;
          this.errMessage = "Brand registration status pending";
          setTimeout(() => {
            // this.ErrDisplay = false;
            this.errMessage = "";
          }, 7000);
        }
        else if (this.identityStatus == 'UNVERIFIED') {
          this.NextDisable = true;
          this.errMessage = "Brand registration status unverified";
          setTimeout(() => {
            this.errMessage = "";
          }, 7000);
        }
      }
    });


    //  for private cases.... 
    if (this.entityType == 'PRIVATE_PROFIT') {
      this.displayPvt = true;
    }
    else {
      this.displayPvt = false;
    }
    // public cases 
    if (this.entityType == 'PUBLIC_PROFIT') {
      this.displayPub = true;
    }
    else {
      this.displayPub = false;
    }
    // for sole proprietor...
    if (this.entityType == 'SOLE_PROPRIETOR') {
      this.displaySole = true;
    }
    else {
      this.displaySole = false;
    }
    //for non-profit case...
    if (this.entityType == 'NON_PROFIT') {
      this.displayNpvt = true;
    }
    else {
      this.displayNpvt = false;
    }
    //for government case
    if (this.entityType == 'GOVERNMENT') {
      this.displayG = true;
    }
    else {
      this.displayG = false;
    }
  }
  onCampaign() {
    this.campData = {
      usecase: this.usecase,
      subUsecases: this.selectedSubCases,
      brandId: this.brandId,

    }
    this.dataMno = JSON.stringify({
      usecase: this.usecase,
      brandId: this.brandId
    });
    this.getMNOs();

    let price: number;
    this.campaignCases.find(el => {
      if (el.name == this.usecase) {
        price = el.rate
      }
    });

    this.campaignForm.patchValue({
      usecase: this.usecase,
      subUsecases: this.selectedSubCases,
      brandId: this.brandId,
      rate: price,
      mnoIds: this.mnoIds
    });
  }

  getbrandQualifyByAllUseCases(bid) {
    this.dataBid = JSON.stringify({
      brandId: bid,
    });
    this.campaignService.brandQualifyByAllUseCases(this.dataBid).subscribe(res => {
      if (res.status == 200) {
        this.responseMessage = res.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
      }
      else {
        this.responseMessage = res.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
      }

    })
  }

  // getMNOs() {
  //   this.campaignService.mnoMetaDataForRegister(this.dataMno).subscribe(res => {
  //     this.campaignMno = [];
  //     if (res.status = 200) {
  //       let mnoDetail = res.data;
  //       if (mnoDetail != undefined) {
  //         //this.mnoIds = Object.keys(mnoDetail)
  //         let length = Object.keys(mnoDetail).length;
  //         for (let i = 0; i < length; i++) {
  //           this.campaignMno.push({ "mnoDetail": Object.values(mnoDetail)[i], "key": Object.keys(mnoDetail)[i] })
  //         }
  //         this.campaignMno.forEach(element => {
  //           if (element.mnoDetail.qualify == true) {
  //             this.mnoIds.push(element.key);
  //           }
  //         });

  //         if (this.mnoIds.length <= 0) {
  //           this.mnoButton = false
  //         }
  //         else {
  //           this.mnoButton = true
  //         }

  //         if (this.campaignMno.length > 0) {
  //           this.carrierListOrMnos = true
  //         }
  //         else {
  //           this.carrierListOrMnos = false
  //         }
  //        if(this.usecase =='M2M' || this.usecase=='SWEEPSTAKE' || this.usecase=='SOCIAL' || this.usecase=='PROXY' || this.usecase=='CARRIER_EXEMPT' || this.usecase=='AGENTS_FRANCHISES'){
  //               this.m2mEnableCase=true;
  //          }
  //          else{
  //           this.m2mEnableCase=false;
  //          }
  //         if(this.usecase =='2FA'){  
  //         this.enableCase2fa=true;
  //         }
  //         else{  
  //         this.enableCase2fa=false;
  //         }
  //         this.campaignForm.patchValue({
  //           mnoIds: this.mnoIds
  //         })
  //         this.responseMessage = res.message;
  //         setTimeout(() => {
  //           this.responseMessage = "";
  //         }, 5000);
  //       }
  //       if (this.campaignMno.length > 0) {
  //         this.carrierListOrMnos = true
  //       }
  //       else {
  //         this.carrierListOrMnos = false
  //       }
  //       this.campaignForm.patchValue({
  //         mnoIds: this.mnoIds
  //       })
  //       this.responseMessage = res.message;
  //       setTimeout(() => {
  //         this.responseMessage = "";
  //       }, 5000);
  //     }
  //     else {
  //       this.responseMessage = res.message;
  //       setTimeout(() => {
  //         this.responseMessage = "";
  //       }, 5000);
  //     }
  //   })
  // }
  getMnoVal(e: any, mnoid: any) {
    if (e.target.checked) {
      this.mnoIds.push(mnoid);
      this.campaignForm.patchValue({
        mnoIds: this.mnoIds
      })
    }
    else {
      this.mnoIds.forEach((value, index) => {
        if (value == mnoid)
          this.mnoIds.splice(index, 1);
        this.campaignForm.patchValue({
          mnoIds: this.mnoIds
        })
      });
    }
    if (this.mnoIds.length <= 0) {
      this.mnoButton = false
    }
    else {
      this.mnoButton = true
    }

  }
  // registerCampaign() { 
  //   if(this.campaignForm.invalid) {
  //     this.M2MSubmitted = true;
  //     return false;
  //   }
  //   else {
  //     this.campaignForm.patchValue({
  //       campaignKey: this.key,
  //       sampleMediaLastId: this.lastId
  //     });    
  //     this.requestBtn =true;
  //     const target = environment.SERVER + "registercampaign";
  //     const formData = new FormData();
  //     var _http = this._http
  //     formData.append('campaignData',JSON.stringify(this.campaignForm.value));     
  //     const req = new HttpRequest('POST', target, formData, {
  //       reportProgress: true
  //     });
  //     _http.request(req).subscribe((res: any) => {
  //         if (res.body) {
  //           if (res.body.status == 201) {
  //             this.responseMessage = res.body.message;
  //             setTimeout(() => {
  //               this.responseMessage = "";
  //               window.location.reload();
  //             }, 5000);   
  //           } else {
  //             this.requestBtn =false;
  //             this.errMessage = res.body.message;
  //             setTimeout(() => {
  //               this.errMessage = "";
  //             }, 5000);
  //           }
  //         }
  //       },
  //       (error: any) => {
  //         this.errMessage = "Campaign is not able to register!";
  //         setTimeout(() => {
  //           this.errMessage = "";  
  //         }, 5000);
  //       }
  //     );
  //   }
  // }

  redundantCampaign() {

    if (this.campaignForm.invalid) {
      this.M2MSubmitted = true;
      return false;
    }
    else {
      this.campaignForm.patchValue({
        // campaignKey: 123456,
        campaignKey: this.campkey,
        sampleMediaLastId: this.lastId,
        provisionStatus: this.provisionStatus
      });
      this.requestBtn = true;
      const target = environment.SERVER + "redundantcampaign";
      const formData = new FormData();
      var _http = this._http
      formData.append('campaignData', JSON.stringify(this.campaignForm.value));

      for (let i = 0; i < this.selectedFile.length; i++) {
        const fileObject: any = this.selectedFile[i];
        if (fileObject.key) {
          formData.append("ATTACHMENTS", fileObject.file, fileObject.file.name);
        } else if (fileObject instanceof File) {
          formData.append("ATTACHMENTS", fileObject, fileObject.name);
        } else {
          console.error("Unsupported file object:", fileObject);
        }
      }
      // Ensure that other data types are correctly appended
      if (this.oldbrandId) {
        formData.append('oldbrandId', this.oldbrandId.toString());
      } else {
        formData.append('oldbrandId', this.brandId.toString());
      }
      formData.append('parentSmCampKey', this.parentSmCampKey.toString());
      formData.forEach((value, key) => {

      });
      const req = new HttpRequest('POST', target, formData, {
        reportProgress: true
      });
      _http.request(req).subscribe((res: any) => {
        if (res.body) {
          if (res.body.status == 201) {
            this.responseMessage = res.body.message;
            this.ngOnInit();
            setTimeout(() => {
              this.responseMessage = "";
              this.router.navigate(['/new-campaign/campaigns']).then(() => {
                location.reload();
              });
            }, 2000);
          } else if (res.body.status == 503) {
            this.requestBtn = false;
            this.errMessage = res.body.message;
            setTimeout(() => {
              this.errMessage = "";
              this.router.navigate(['/new-campaign/campaigns'])
            }, 2000);
          } else {
            this.requestBtn = false;
            this.errMessage = res.body.message;
            setTimeout(() => {
              this.errMessage = "";
            }, 2000);
          }
        }
      },
        (error: any) => {
          this.errMessage = "Campaign is not able to register!";
          setTimeout(() => {
            this.errMessage = "";
            this.router.navigate(['/new-campaign/campaigns']).then(() => {
              location.reload();
            })
          }, 5000);
        }
      );
    }

  }

  copyCampaign() {
    if (this.provisionStatus == '6') {
      this.saveFormWithoutValidation();
    }
    if(this.provisionStatus=='7'){
      this.saveFormWithValidation();
    }
    if (this.campaignForm.invalid) {
      this.M2MSubmitted = true;
      return false;
    } else {
      this.campaignForm.patchValue({
        campaignKey: this.key,
        sampleMediaLastId: this.lastId,
        provisionStatus: this.provisionStatus,
        // smCampaignKey : this.smCampKey
      });
      this.requestBtn = true;
      const target = environment.SERVER + "copycampaign";
      const formData = new FormData();
      var _http = this._http;
      formData.append('campaignData', JSON.stringify(this.campaignForm.value));
      for (let i = 0; i < this.selectedFile.length; i++) {
        const fileObject: any = this.selectedFile[i];
        if (fileObject.key) {
          formData.append("ATTACHMENTS", fileObject.file, fileObject.file.name);
        } else if (fileObject instanceof File) {
          formData.append("ATTACHMENTS", fileObject, fileObject.name);
        } else {
          console.error("Unsupported file object:", fileObject);
        }
      }
      const req = new HttpRequest('POST', target, formData, {
        reportProgress: true
      });
      _http.request(req).subscribe(
        (res: any) => {
          if (res.body) {
            if (res.body.status == 201) {
              this.responseMessage = res.body.message;
              setTimeout(() => {
                this.ngOnInit();
                this.responseMessage = "";
                this.router.navigate(['/new-campaign/campaigns/']).then(() => {
                  location.reload();
                });
              }, 5000);
            } else {
              this.requestBtn = false;
              this.errMessage = res.body.message;
              setTimeout(() => {
                this.errMessage = "";
              }, 5000);
            }
          }
        },
        (error: any) => {
          this.errMessage = "Campaign is not able to register!";
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      );
    }
  }
  saveFormWithoutValidation() {
    Object.keys(this.campaignForm.controls).forEach(key => {
      this.campaignForm.get(key)?.clearValidators();
      this.campaignForm.get(key)?.updateValueAndValidity();
    });
  }

  registerCampaign() {
    if (this.campaignForm.invalid) {
      this.M2MSubmitted = true;
      return false;
    }
    else {
      this.campaignForm.patchValue({
        campaignKey: this.key,
        sampleMediaLastId: this.lastId,
        smCampaignKey: this.smCampaignKey,
        provisionStatus: this.provisionStatus
      });
      this.requestBtn = true;
      const target = environment.SERVER + "registercampaign";
      const formData = new FormData();
      var _http = this._http
      formData.append('campaignData', JSON.stringify(this.campaignForm.value));
      const req = new HttpRequest('POST', target, formData, {
        reportProgress: true
      });
      _http.request(req).subscribe((res: any) => {
        if (res.body) {
          if (res.body.status == 201) {
            this.requestBtn = true;
            this.responseMessage = res.body.message;
            setTimeout(() => {
              this.ngOnInit();
              this.responseMessage = "";
              if (this.provisionStatus == 6) {
                this.router.navigate(['new-campaign/campaigns'])
              }
              else if (this.provisionStatus == 7) {
                window.location.reload();
              }
            }, 5000);
          }
          else {
            this.requestBtn = false;
            this.errMessage = res.body.message;
            setTimeout(() => {
              this.errMessage = "";
              this.router.navigate(['new-campaign/campaigns'])
            }, 5000);
          }
        }
      },
        (error: any) => {
          this.requestBtn = false;
          this.errMessage = "Campaign is not able to register!";
          setTimeout(() => {
            this.errMessage = "";
            this.router.navigate(['new-campaign/campaigns'])
          }, 5000);
        }
      );
    }
  }

  // addSampleMedia() {
  // 	if (this.fileData.files && this.fileData.files.length > 0) {
  // 		const file: File = this.fileData.files[0];
  // 		const fileSize = file.size;
  // 		const maxSizePerFile = 10 * 1024 * 1024;
  // 		if (fileSize > maxSizePerFile) {
  // 			this.errMessage = "Individual file size limit exceeded";
  // 			setTimeout(() => {
  // 				this.errMessage = "";
  // 			}, 5000);
  // 			this.fileData.value = '';
  // 			return;
  // 		}
  // 		const reader = new FileReader();
  // 		reader.readAsDataURL(file);
  // 		const target = environment.SERVER + "campaignPanelFileUploader";
  // 		const formData = new FormData();
  // 		var _http = this._http
  // 		formData.append('key',this.key);
  //     formData.append("ATTACHMENTS", file, file.name);
  // 		this.fileData.value = '';
  // 		const req = new HttpRequest('POST', target, formData, {
  // 			reportProgress: true
  // 		});
  // 		_http.request(req).subscribe(
  // 			(res: any) => {
  // 				if (res.body) {
  // 					if (res.body.status == 200) {
  //             this.lastId.push(res.body.lastId)
  //             this.selectedFile.push(res.body.data[0]);
  //             this.getCampaignFile();
  // 						this.responseMessage = res.body.message;
  // 					} else {
  // 						this.errMessage = res.body.message;
  // 					}
  // 					setTimeout(() => {
  // 						this.responseMessage = "";
  // 						this.errMessage = "";
  // 					}, 5000);
  // 				}
  // 			},
  // 			(error: any) => {
  // 			}
  // 		);
  // 	}
  //   else{
  //     return
  //   }
  // 	// this.mediaForm.reset();
  // }
  addSampleMedia() {
    if (this.fileData.files && this.fileData.files.length > 0) {
      const file: File = this.fileData.files[0];
      const fileSize = file.size;
      const maxSizePerFile = 10 * 1024 * 1024;
      if (fileSize > maxSizePerFile) {
        // this.errMessage = "Individual file size limit exceeded";
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
        this.fileData.value = '';
        return;
      }
      const reader = new FileReader();
      reader.readAsDataURL(file);
      const target = environment.SERVER + "campaignPanelFileUploader";
      const formData = new FormData();
      var _http = this._http
      // formData.append('key',this.key);      
      formData.append('smCampaignKey', this.smCampaignKey);
      formData.append("ATTACHMENTS", file, file.name);
      this.fileData.value = '';
      const req = new HttpRequest('POST', target, formData, {
        reportProgress: true
      });
      _http.request(req).subscribe(
        (res: any) => {
          if (res.body) {
            if (res.body.status == 200) {
              // this.selectedFile = [];
              this.lastId.push(res.body.lastId)
              this.selectedFile.push(res.body.data[0]);
              this.smCampaignKey = res.body.data[0].sm_reference_no;
              this.getCampaignFile();
              this.responseMessage = res.body.message;
            } else {
              this.errMessage = res.body.message;
            }
            setTimeout(() => {
              this.responseMessage = "";
              this.errMessage = "";
            }, 5000);
          }
        },
        (error: any) => {
        }
      );
    }
    else {
      return
    }
    // this.mediaForm.reset();
  }

  getCampaignFile() {
    if (this.selectedFile.length >= 5) {
      this.displayedFilesCount = 5;
      const buttonClick = document.getElementById("file");
      buttonClick.style.pointerEvents = "none";
      this.uploadBtn = true;
      /* this.errMessage = "Total file count limit exceeded.";
      setTimeout(() => {
        this.errMessage = "";
      }, 5000); */
      this.fileData.value = '';
      return;
    }
  }

  onVertical(e) {
    this.selectedVertical = e.target.value;
  }

  changeStatus(e) {
    this.selectedSubCases = [];
    this.isDisabled = false;
    this.isDisable = false;
    this.usecase = [];
    this.usecase = e.target.value;
    this.campaignCases.forEach(element => {
      element.status = false;
      element.isDisabled = false;
      if (this.usecase == element.name) {
        if (element.minSubUsecases == 0) {
          this.isDisabled = true;
        }
      }
      if (e.target.value == element.name) {
        if (element.maxSubUsecases > 0) {
          element.status = true;
          element.isDisabled = true;
          this.minSubUsecases = element.minSubUsecases;
        }
        else {
          this.isDisabled = true;
        }
      }
    });

  }

  onSubCases(e) {
    let mode = false;
    if (e.target.checked) {
      this.selectedSubCases.push(e.target.value);
      let index = this.selectedSubCases.length - 1;
      this.campaignCases.forEach(element => {
        if (element.maxSubUsecases == this.selectedSubCases.length && this.usecase == element.name) {
          this.isDisable = true;
          mode = true;
        }
      });
      if (mode) {
        this.subUseCases.forEach(element => {
          element.isDisabled = true;
        });
        for (let i = 0; i < this.selectedSubCases.length; i++) {
          this.subUseCases.find(el => {
            if (el.name == this.selectedSubCases[i]) {
              el.isDisabled = false;
            }
          });
        }

        // for (let i = 0; i < this.selectedSubCases.length; i++) {
        //   this.subUseCases.forEach(element => {
        //     element.isDisabled = true;
        //     this.subUseCases.find(el => {
        //       if (el.name == this.selectedSubCases[i]) {
        //         el.isDisabled = false;
        //       }
        //     });

        //   });
        // console.log(idx);
        //   if(idx){
        //     this.subUseCases["isDisabled"]=false;
        //   }
        //   else{
        //     this.subUseCases["isDisabled"]=true;
        //   }
        // }
      }
      // this.subUseCases.forEach(element => {
      //     let i = 0;
      //     // element.isDisabled = false;
      //     if(mode && this.selectedSubCases[0] == element.name){
      //       element.isDisabled = false;
      //     }
      //     else if(mode && this.selectedSubCases[i] != element.name){
      //       element.isDisabled = true;
      //     }
      //     i++;
      // });

      if (this.minSubUsecases <= this.selectedSubCases.length) {
        this.isDisabled = true;
      }
    }

    if (!e.target.checked) {
      if (this.minSubUsecases >= this.selectedSubCases.length) {
        this.isDisabled = false;
      }
      // this.subUseCases.forEach(element => {
      //   element.isDisabled = false;
      //   this.subUseCases.find(el => {
      //       if(el.name == this.selectedSubCases[i]){
      //         el.isDisabled = false;
      //       }
      //   });
      // });
      this.subUseCases.forEach(element => {
        element.isDisabled = false;
        // this.subUseCases.find(el => {
        //     if(el.name == this.selectedSubCases[i]){
        //       el.isDisabled = false;
        //     }
        // });
      });
      let i = this.selectedSubCases.findIndex(el => el == e.target.value);
      this.selectedSubCases.splice(i, 1);
    }
  }

  showyes(e: any) {
    if (e == 1) {
      let optmessage: any = this.campaignForm.get('optinMessage');
      optmessage.setValidators([this.minLengthWithoutSpacesValidator(20)]);
      optmessage.updateValueAndValidity();
      this.optInEye = true;
      // this.optOutEye=true;
      // this.optHelpEye=true;

      if (this.yes == false) {
        this.yes = true;
      }

      else {
        this.yes = ! false;
      }
    }
    else if (e == 2) {
      let optoutMessage: any = this.campaignForm.get('optoutMessage');
      optoutMessage.setValidators([Validators.required, this.minLengthWithoutSpacesValidator(20)]);
      optoutMessage.updateValueAndValidity();
      this.optOutEye = true;
      if (this.outoption == false) {
        this.outoption = true;
      }
      else {
        this.outoption = ! false;
      }
    }
    else if (e == 3) {
      let helpMessage: any = this.campaignForm.get('helpMessage');
      helpMessage.setValidators([Validators.required, this.minLengthWithoutSpacesValidator(20)]);
      helpMessage.updateValueAndValidity();
      this.optHelpEye = true;
      if (this.opthelp == false) {
        this.opthelp = true;
      }
      else {
        this.opthelp = ! false;
      }
    }

  }



  opentext(e: any) {
    if (e == 1) {
      this.opt_done();
      if (this.openeye == false) {
        this.openeye = true;
      }
      else {
        this.openeye = ! false;
      }
    }
    if (e == 2) {
      this.out_done();
      if (this.open_optout == false) {
        this.open_optout = true;
      }
      else {
        this.open_optout = ! false;
      }
    }
    if (e == 3) {
      this.help_done();
      if (this.open_opthelp == false) {
        this.open_opthelp = true;
      }
      else {
        this.open_opthelp = ! false;
      }
    }
  }

  editclose() {
    this.submitted = false;
    if (this.openeye == true || this.yes == true) {
      this.openeye = false;
      this.yes = false;
    }
    else {
      this.openeye = ! true;
      this.yes = ! true;
    }

  }
  optout_close() {
    this.keyword_not = (this.campaignForm.value.optoutKeywords == '' && this.campaignForm.value.optoutMessage !== '') ? true : false;
    if (this.open_optout == true || this.outoption == true) {
      this.open_optout = false;
      this.outoption = false;
    }
    else {
      this.open_optout = ! true;
      this.outoption = ! true;
    }

  }
  helpclose() {
    this.help_not = (this.campaignForm.value.helpKeywords == '' && this.campaignForm.value.helpMessage !== '') ? true : false;
    if (this.open_opthelp == true || this.opthelp == true) {
      this.open_opthelp = false;
      this.opthelp = false;
    }
    else {
      this.open_opthelp = ! true;
      this.opthelp = ! true;
    }

  }
  opt_done() {
    this.camp = {
      first: this.campaignForm.value.optinKeywords,
      second: this.campaignForm.value.optinMessage
    }
  }
  out_done() {
    this.opt_out = {
      first: this.campaignForm.value.optoutKeywords,
      second: this.campaignForm.value.optoutMessage
    }
  }

  help_done() {
    this.opt_outhelp = {
      first: this.campaignForm.value.helpKeywords,
      second: this.campaignForm.value.helpMessage
    }
  }

  hideEyes(event: any) {
    if (event == 1) {
      this.optInEye = false;
      this.campaignForm.patchValue({
        optinMessage: '',
        optinKeywords: null
      });
    }
    if (event == 2) {
      this.optOutEye = false;
      this.campaignForm.patchValue({
        optoutMessage: '',
        optoutKeywords: null
      });
    }

    if (event == 3) {
      this.optHelpEye = false;
      this.campaignForm.patchValue({
        helpMessage: '',
        helpKeywords: null

      });
    }


  }
  hideYes1() {
    let optmessage: any = this.campaignForm.get('optinMessage');
    optmessage.setValidators([]);
    optmessage.updateValueAndValidity();
    this.opt_done();
    this.yes = false;
  }


  hideYes2() {
    // let optmessage: any = this.campaignForm.get('optoutMessage');
    // optmessage.setValidators([]);
    // optmessage.updateValueAndValidity();
    this.out_done();
    this.outoption = false;
  }

  hideYes3() {
    // let optmessage: any = this.campaignForm.get('helpMessage');
    // optmessage.setValidators([]);
    // optmessage.updateValueAndValidity();
    this.help_done()
    this.opthelp = false;
  }


  toggleCloseDropdownSelection() {
    this.closeDropdownSelection = !this.closeDropdownSelection;
    this.dropdownSettings = Object.assign({}, this.dropdownSettings, { closeDropDownOnSelection: this.closeDropdownSelection });
  }

  displayErr() {
    if (this.identityStatus == 'UNVERIFIED') {
      this.errMessage = "Brand registration status unverified";
    }
    else {
      this.errMessage = "Brand registration status pending";
    }
    setTimeout(() => {
      this.errMessage = "";
    }, 7000);
  }

  showMsg() {
    this.errMessage = this.serviceMessage;
    setTimeout(() => {
      this.errMessage = "";
    }, 5000);
  }

  pushFile() {
    const fileInput = this.fileData.files[0];
    // fileInput.fileName = fileInput.name;
    // delete fileInput.name; 
    if (fileInput) {
      this.uploadBtn = true;
      const file: File = fileInput;
      const fileSize = file.size;
      const maxSizePerFile = 10 * 1024 * 1024;
      if (fileSize > maxSizePerFile) {
        this.errMessage = "Individual file size limit exceeded";
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
        fileInput.value = '';
        return;
      }
      const fileNameExists = this.selectedFile.some(f => f.name === file.name);
      if (fileNameExists) {
        this.errMessage = "File Already Exists";
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
        fileInput.value = '';
        return;
      }
      const reader = new FileReader();
      reader.readAsDataURL(file);
      this.selectedFile.push(file);
      if (this.selectedFile.length >= 5) {
        this.displayedFilesCount = 5;
        const buttonClick = document.getElementById("file");
        buttonClick.style.pointerEvents = "none";
      }
      fileInput.value = '';
      this.uploadBtn = true;

      const totalFileSize = this.selectedFile.reduce((total, selectedFile) => total + selectedFile.size, 0);
      const maxTotalSize = 30 * 1024 * 1024;
      if (totalFileSize + fileSize > maxTotalSize) {
        this.errMessage = "Total files size limit exceeded";
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
        fileInput.value = '';
        return;
      }
    }
  }
  onFileChange(event: Event) {
    const fileInput = event.target as HTMLInputElement;
    if (fileInput.files && fileInput.files.length > 0) {
      this.uploadBtn = false;
      this.fileData = fileInput;
    }
    else {
      this.uploadBtn = true;
    }
  }
  downloadFile(fileData: any) {
    if (fileData.key) {
      fetch(fileData.path).then(resp => resp.arrayBuffer()).then(resp => {
        const file = new Blob([resp], { type: 'application/pdf' });
        const fileURL = URL.createObjectURL(file);
        const link = document.createElement('a');
        link.href = fileURL;
        link.download = fileData.path.split('campaignMultimediaFile/')[1];
        link.click();
      });
    }
    else {
      if (fileData) {
        const a = document.createElement('a');
        a.href = URL.createObjectURL(fileData);
        a.download = fileData.name;
        a.click();
      }
    }
  }

  // viewFile(data: any) { 
  //   const pdfModal = document.getElementById('modalPdfForFile');
  //   const imageModal = document.getElementById('modalImageForFile');
  //   const txtModal = document.getElementById('modalTxtForFile');
  //   // const docxModal = document.getElementById('modalDocxForFile');
  //   const audioModal = document.getElementById('modalAudioForFile');
  //   const videoModal = document.getElementById('modalVideoForFile');
  //   const modalImage = document.getElementById('modalImage') as HTMLImageElement;
  //   const modalImage123 = document.getElementById('modalPdf') as HTMLIFrameElement;
  //   const audioModal12 = document.getElementById('audioModal') as HTMLAudioElement;
  //   const videoModal12 = document.getElementById('videoModal') as HTMLVideoElement;
  //   const txtModal12 = document.getElementById('txtModal') as HTMLIFrameElement;

  //   if (data.mimeType.startsWith('image/')) {
  //     // const imageData = data;
  //     modalImage.src = data.path;
  //     // Open the modal for images
  //     $(imageModal).modal('show');
  //   } else if (data.mimeType === 'application/pdf') {
  //     modalImage123.src = data.path;
  //     // Open the modal for pdf files
  //     $(pdfModal).modal('show');
  //   } else if(data.mimeType.startsWith('audio/')){
  //     audioModal12.src = data.path;
  //     //Open modal for Audio
  //     $(audioModal).modal('show');
  //     $(audioModal).on('hidden.bs.modal', function () {
  //       audioModal12.pause();
  //     });
  //   } else if(data.mimeType.startsWith('video/')){
  //     videoModal12.src = data.path;
  //     // Open Modal for Video
  //     $(videoModal).modal('show');
  //     $(videoModal).on('hidden.bs.modal', function () {
  //       videoModal12.pause();
  //     });
  //   }
  //   else if(data.mimeType === 'text/plain'){
  //     txtModal12.src = data.path;
  //     // Open Modal for txt file
  //     $(txtModal).modal('show');
  //   }
  //   else {
  //     if (data) {
  //       const a = document.createElement('a');
  //       a.href = data.path;
  //       a.download = data.name;
  //       a.click();
  //       // $(docxModal).modal('show');
  //     }
  //   }
  // }
  // removeFile(fileToRemove: any): void {
  //   this.selectedFile = this.selectedFile.filter(file => file !== fileToRemove);
  //   this.displayedFilesCount-- ;
  //   const buttonClick = document.getElementById("file");
  // 	buttonClick.style.pointerEvents = "auto";
  //   this.campaignService.deleteAddCampFile(fileToRemove.id).subscribe(res => {  
  //     if (res.status == 200) {
  //       this.responseMessage = res.message;
  //       setTimeout(() => {
  //         this.responseMessage = "";
  //       }, 5000);
  //     }
  //     else {
  //       this.responseMessage = res.message;
  //       setTimeout(() => {
  //         this.responseMessage = "";
  //       }, 5000);
  //     }

  //   })
  // }
  viewFile(data: any) {
    const pdfModal = document.getElementById('modalPdfForFile');
    const imageModal = document.getElementById('modalImageForFile');
    const txtModal = document.getElementById('modalTxtForFile');
    // const docxModal = document.getElementById('modalDocxForFile');
    const audioModal = document.getElementById('modalAudioForFile');
    const videoModal = document.getElementById('modalVideoForFile');
    const modalImage = document.getElementById('modalImage') as HTMLImageElement;
    const modalImage123 = document.getElementById('modalPdf') as HTMLIFrameElement;
    const audioModal12 = document.getElementById('audioModal') as HTMLAudioElement;
    const videoModal12 = document.getElementById('videoModal') as HTMLVideoElement;
    const txtModal12 = document.getElementById('txtModal') as HTMLIFrameElement;
    if (data.key) {
      if (data.mimeType.startsWith('image/')) {
        // const imageData = data;
        modalImage.src = data.path;
        // Open the modal for images
        $(imageModal).modal('show');
      } else if (data.mimeType === 'application/pdf') {
        modalImage123.src = data.path;
        // Open the modal for pdf files
        $(pdfModal).modal('show');
      } else if (data.mimeType.startsWith('audio/')) {
        audioModal12.src = data.path;
        //Open modal for Audio
        $(audioModal).modal('show');
        $(audioModal).on('hidden.bs.modal', function () {
          audioModal12.pause();
        });
      } else if (data.mimeType.startsWith('video/')) {
        videoModal12.src = data.path;
        // Open Modal for Video
        $(videoModal).modal('show');
        $(videoModal).on('hidden.bs.modal', function () {
          videoModal12.pause();
        });
      } else if (data.mimeType === 'text/plain') {
        txtModal12.src = data.path;
        // Open Modal for txt file
        $(txtModal).modal('show');
      }
      else {
        if (data) {
          const a = document.createElement('a');
          a.href = data.path;
          a.download = data.name;
          a.click();
          // $(docxModal).modal('show');
        }
      }
    }
    else {
      if (data.type.startsWith('image/')) {
        const imageData = data;
        modalImage.src = URL.createObjectURL(imageData);
        // Open the modal for images
        $(imageModal).modal('show');
      } else if (data.type === 'application/pdf') {
        const pdfData = data
        modalImage123.src = URL.createObjectURL(pdfData);
        // Open the modal for non-image files
        $(pdfModal).modal('show');
      } else if (data.type.startsWith('audio/')) {
        const audioData = data
        audioModal12.src = URL.createObjectURL(audioData);
        //Open modal for Audio
        $(audioModal).modal('show');
        $(audioModal).on('hidden.bs.modal', function () {
          audioModal12.pause();
        });
      } else if (data.type.startsWith('video/')) {
        const videoData = data
        videoModal12.src = URL.createObjectURL(videoData);
        // Open Modal for Video
        $(videoModal).modal('show');
        $(videoModal).on('hidden.bs.modal', function () {
          videoModal12.pause();
        });
      } else if (data.type === 'text/plain') {
        const txtData = data
        txtModal12.src = URL.createObjectURL(txtData);
        // Open Modal for txt file
        $(txtModal).modal('show');
      }
      else {
        if (data) {
          const a = document.createElement('a');
          a.href = URL.createObjectURL(data);
          a.download = data.name;
          a.click();
          // $(docxModal).modal('show');
        }
      }
    }
  }
  removeFile(fileToRemove: any): void {
    if (this.smCampKey) {
      if (fileToRemove.key) {
        this.selectedFile = this.selectedFile.filter(file => file !== fileToRemove);
        this.displayedFilesCount--;
        const buttonClick = document.getElementById("file");
        buttonClick.style.pointerEvents = "auto";
        this.campaignService.deleteSamFile(fileToRemove.key).subscribe(res => {
          if (res.status == 200) {
            this.responseMessage = res.message;
            setTimeout(() => {
              this.responseMessage = "";
            }, 5000);
          }
          else {
            this.responseMessage = res.message;
            setTimeout(() => {
              this.responseMessage = "";
            }, 5000);
          }
        })
      } else {
        this.selectedFile = this.selectedFile.filter(file => file.name !== fileToRemove.name);
        this.displayedFilesCount--;
        const buttonClick = document.getElementById("file");
        buttonClick.style.pointerEvents = "auto";
        this.responseMessage = "Campaign File Removed Successfully";
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
      }
    } else {
      this.selectedFile = this.selectedFile.filter(file => file !== fileToRemove);
      this.displayedFilesCount--;
      const buttonClick = document.getElementById("file");
      buttonClick.style.pointerEvents = "auto";
      this.campaignService.deleteSamFile(fileToRemove.key).subscribe(res => {
        if (res.status == 200) {
          this.responseMessage = res.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
        }
        else {
          this.responseMessage = res.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
        }

      })
    }
  }
  getCharacterCount(input: string): number {
    const characters = input.replace(/\s/g, '');
    return characters.length;
  }

  minLengthWithoutSpacesValidator(minLength: number): ValidatorFn {
    return (control: AbstractControl): ValidationErrors | null => {
      const value: string = control.value;

      if (!value) {
        return null;
      }
      const nonWhitespaceLength = value.replace(/\s/g, '').length;
      return nonWhitespaceLength >= minLength ? null : { minLengthWithoutSpaces: true };
    };
  }

  ngAfterViewInit() {
    this.moveToCampaignDetailsStep();
  }
  getMNOs() {
    let dataMNO = JSON.stringify({
      usecase: this.usecase,
      brandId: this.brandId
    });
    if (this.brandstatus == "new_brand") {
      this.campaignService.mnoMetaDataForRegister(dataMNO).subscribe(res => {
        this.campaignMno = [];
        this.mnoIds = [];
        if (res.status = 200) {
          let mnoDetail = res.data;
          if (mnoDetail != undefined) {
            //this.mnoIds = Object.keys(mnoDetail)
            let length = Object.keys(mnoDetail).length;
            for (let i = 0; i < length; i++) {
              this.campaignMno.push({ "mnoDetail": Object.values(mnoDetail)[i], "key": Object.keys(mnoDetail)[i] })
            }
            this.campaignMno.forEach(element => {
              if (element.mnoDetail.qualify == true) {
                this.mnoIds.push(element.key);
              }
            });

            if (this.mnoIds.length <= 0) {
              this.mnoButton = false
            }
            else {
              this.mnoButton = true
            }

            if (this.campaignMno.length > 0) {
              this.carrierListOrMnos = true
            }
            else {
              this.carrierListOrMnos = false
            }
            if (this.usecase == 'M2M' || this.usecase == 'SWEEPSTAKE' || this.usecase == 'SOCIAL' || this.usecase == 'PROXY' || this.usecase == 'CARRIER_EXEMPT' || this.usecase == 'AGENTS_FRANCHISES') {
              this.m2mEnableCase = true;
            }
            else {
              this.m2mEnableCase = false;
            }
            if (this.usecase == '2FA') {
              this.enableCase2fa = true;
            }
            else {
              this.enableCase2fa = false;
            }
            this.campaignForm.patchValue({
              mnoIds: this.mnoIds
            });
            if (this.smCampKey && this.oldMno.length > 0) {
              this.setMnos();
            }
            // this.sameBranddetails();          
            this.responseMessage = res.message;
            setTimeout(() => {
              this.responseMessage = "";
            }, 5000);
          }
          if (this.campaignMno.length > 0) {
            this.carrierListOrMnos = true
          }
          else {
            this.carrierListOrMnos = false
          }
          this.campaignForm.patchValue({
            mnoIds: this.mnoIds
          })
          this.sameBranddetails();
          this.responseMessage = res.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
        }
        else {
          this.responseMessage = res.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
        }
      })

    }
    else {
      this.campaignService.mnoMetaDataForRegister(dataMNO).subscribe(res => {
        this.campaignMno = [];
        this.mnoIds = [];
        if (res.status = 200) {
          let mnoDetail = res.data;
          if (mnoDetail != undefined) {
            //this.mnoIds = Object.keys(mnoDetail)
            let length = Object.keys(mnoDetail).length;
            for (let i = 0; i < length; i++) {
              this.campaignMno.push({ "mnoDetail": Object.values(mnoDetail)[i], "key": Object.keys(mnoDetail)[i] })
            }
            this.campaignMno.forEach(element => {
              if (element.mnoDetail.qualify == true) {
                this.mnoIds.push(element.key);
              }
            });

            if (this.mnoIds.length <= 0) {
              this.mnoButton = false
            }
            else {
              this.mnoButton = true
            }

            if (this.campaignMno.length > 0) {
              this.carrierListOrMnos = true
            }
            else {
              this.carrierListOrMnos = false
            }
            if (this.usecase == 'M2M' || this.usecase == 'SWEEPSTAKE' || this.usecase == 'SOCIAL' || this.usecase == 'PROXY' || this.usecase == 'CARRIER_EXEMPT' || this.usecase == 'AGENTS_FRANCHISES') {
              this.m2mEnableCase = true;
            }
            else {
              this.m2mEnableCase = false;
            }
            if (this.usecase == '2FA') {
              this.enableCase2fa = true;
            }
            else {
              this.enableCase2fa = false;
            }
            this.campaignForm.patchValue({
              mnoIds: this.mnoIds
            });
            if (this.smCampKey && this.oldMno.length > 0) {
              this.setMnos();
            }
            // this.sameBranddetails();          
            if (!this.smCampKey) {
              this.responseMessage = res.message;
            }
            setTimeout(() => {
              this.responseMessage = "";
            }, 5000);
          }
          if (this.campaignMno.length > 0) {
            this.carrierListOrMnos = true
          }
          else {
            this.carrierListOrMnos = false
          }
          this.campaignForm.patchValue({
            mnoIds: this.mnoIds
          })
          this.sameBranddetails();
          if (!this.smCampKey) {
            this.responseMessage = res.message;
          }
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
        }
        else {
          this.responseMessage = res.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
        }
      })
    }

  }

  moveToCampaignDetailsStep() {
    if (this.firstpage) {
      this.stepper.selectedIndex = 1;
      this.useCaseSelection(this.brandId);
    }
    else if (this.stepper && this.smCampKey) {
      this.stepper.selectedIndex = 2;
      this.campaignDetail(this.smCampKey);
      this.getCampaignFiles(this.smCampKey);
      this.getCampaignMnoDetails();
    }
  }
  getCampaignMnoDetails() {
    let payLoad = JSON.stringify({
      campId: this.smCampKey,
      iduser: this.iduser
    });
    this.campaignService.campMnoMetaDataDetails(payLoad).subscribe(res => {
      if (res.status == 200) {
        this.oldMno = res.data;
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    });
  }
  getCampaignFiles(smCampId) {
    let payLoad = JSON.stringify({
      smCampKey: smCampId
    });
    this.campaignService.getNewCampaignsFileById(payLoad).subscribe((res) => {
      if (res.status == 200) {
        res.data.forEach((element: any) => {
          fetch(element.path)
            .then(response => response.blob())
            .then(blob => {
              // Create a File object
              const file = new File([blob], element.fileName, {
                lastModified: element.lastModified,
                type: element.mimeType,
              });
              const fileObject: any = {
                file: file,
                key: element.key,
                path: element.path,
                mimeType: element.mimeType
              }
              this.selectedFile.push(fileObject);
              if (this.selectedFile && this.selectedFile.length >= 5) {
                this.displayedFilesCount = 5;
                const buttonClick = document.getElementById("file");
                buttonClick.style.pointerEvents = "none";
              }
            }
            )
            .catch(error => console.error('Error fetching file:', error));
        });
      }

    });
  }

  campaignDetail(smCampKey) {
    let payLoad = JSON.stringify({
      smcampKey: smCampKey
    });
    this.campaignService.getNewCampDetailById(payLoad).subscribe((res) => {
      if (res.status == 200) {
        this.campDetails = res.data[0];
        this.campaignForm.patchValue({
          usecase: this.campDetails.usecase,
          subUsecases: this.campDetails.subUsecases,
          description: this.campDetails.campaign_description,
          messageFlow: this.campDetails.messageFlow,
          optinMessage: this.campDetails.optinMessage,
          optoutMessage: this.campDetails.optoutMessage,
          helpMessage: this.campDetails.helpMessage,
          sample1: this.campDetails.sample1,
          sample2: this.campDetails.sample2,
          sample3: this.campDetails.sample3,
          sample4: this.campDetails.sample4,
          sample5: this.campDetails.sample5,
          optinKeywords: this.campDetails.optinKeywords,
          optoutKeywords: this.campDetails.optoutKeywords,
          helpKeywords: this.campDetails.helpKeywords,
          autoRenewal: this.campDetails.autoRenewal,
          subscriberOptin: this.campDetails.subscriberOptin === 'true' ? true :
            this.campDetails.subscriberOptin === 'false' ? false :
              this.campDetails.subscriberOptin === null || this.campDetails.subscriberOptin === undefined || this.campDetails.subscriberOptin === '' ? '' :
                this.campDetails.subscriberOptin,
          subscriberOptout: this.campDetails.subscriberOptout === 'true' ? true :
            this.campDetails.subscriberOptout === 'false' ? false :
              this.campDetails.subscriberOptout === null || this.campDetails.subscriberOptout === undefined || this.campDetails.subscriberOptout === '' ? '' :
                this.campDetails.subscriberOptout,
          subscriberHelp: this.campDetails.subscriberHelp === 'true' ? true :
            this.campDetails.subscriberHelp === 'false' ? false :
              this.campDetails.subscriberHelp === null || this.campDetails.subscriberHelp === undefined || this.campDetails.subscriberHelp === '' ? '' :
                this.campDetails.subscriberHelp,
          numberPool: this.campDetails.numberPool === 'true' ? true :
            this.campDetails.numberPool === 'false' ? false :
              this.campDetails.numberPool === null || this.campDetails.numberPool === undefined || this.campDetails.numberPool === '' ? '' :
                this.campDetails.numberPool,
          directLending: this.campDetails.directLending === 'true' ? true :
            this.campDetails.directLending === 'false' ? false :
              this.campDetails.directLending === null || this.campDetails.directLending === undefined || this.campDetails.directLending === '' ? '' :
                this.campDetails.directLending,
          embeddedLink: this.campDetails.noEmbeddedLink === 'true' ? true :
            this.campDetails.noEmbeddedLink === 'false' ? false :
              this.campDetails.noEmbeddedLink === null || this.campDetails.noEmbeddedLink === undefined || this.campDetails.noEmbeddedLink === '' ? '' :
                this.campDetails.noEmbeddedLink,
          embeddedPhone: this.campDetails.noEmbeddedPhone === 'true' ? true :
            this.campDetails.noEmbeddedPhone === 'false' ? false :
              this.campDetails.noEmbeddedPhone === null || this.campDetails.noEmbeddedPhone === undefined || this.campDetails.noEmbeddedPhone === '' ? '' :
                this.campDetails.noEmbeddedPhone,
          ageGated: this.campDetails.ageGated === 'true' ? true :
            this.campDetails.ageGated === 'false' ? false :
              this.campDetails.ageGated === null || this.campDetails.ageGated === undefined || this.campDetails.ageGated === '' ? '' :
                this.campDetails.ageGated,
          termsAndConditions: this.campDetails.termsAndConditions === 'true' ? true :
            this.campDetails.termsAndConditions === 'false' ? false :
              this.campDetails.termsAndConditions === null || this.campDetails.termsAndConditions === undefined || this.campDetails.termsAndConditions === '' ? '' :
                this.campDetails.termsAndConditions,
        });
        // set mno
        this.usecase = this.campDetails.usecase;
        this.subUsecase = this.campDetails.subUsecases;
        if (!this.brandId) {
          this.brandId = this.campDetails.brandId;
        }

        this.selectedSubCases = this.campDetails.subUsecases;
        this.onCampaign();
        // set Campaign UseCases
        this.isDisabled = true;
        this.selectedBrand = false;
      }
      else {
        this.errMessage = res.message;
      }
    });
  }
  setMnos() {
    this.mnoIds = [];
    this.campaignMno.forEach(ele => {
      ele.mnoDetail['isMno'] = false;
    });
    this.oldMno.forEach((element: any, index: any) => {
      this.campaignMno.forEach(ele => {
        if (element.mno == ele.mnoDetail.mno) {
          ele.mnoDetail['isMno'] = true;
          this.mnoIds.push(ele.key);
        }
        if (this.oldMno.length - 1 == index) {
          this.campaignForm.patchValue({
            mnoIds: this.mnoIds
          });
        }
      });
    });
  }
  sameBranddetails() {
    if (this.brandstatus == 'same_brand' || this.brandstatus == 'new_brand') {
      if (this.campaignstatus == 'same_campaign') {
        this.setProvision('7');

      }
      if (this.brandstatus == 'same_brand' || this.brandstatus == 'new_brand') {
        if (this.campaignstatus == 'edit_campaign') {

        }
      }
    }
  }

  saveFormWithValidation(){
    let subscriberOptout = this.campaignForm.get('subscriberOptout');
    let optoutMessage = this.campaignForm.get('optoutMessage');
    let subscriberHelp = this.campaignForm.get('subscriberHelp');
    let helpMessage: any = this.campaignForm.get('helpMessage');
  
  if (subscriberOptout.value == true) {
   optoutMessage.setValidators([Validators.required, this.minLengthWithoutSpacesValidator(20)]);
  } else {
    optoutMessage.clearValidators();
  }
  optoutMessage.updateValueAndValidity();
  
  if (subscriberHelp.value == true) {
    helpMessage.setValidators([Validators.required, this.minLengthWithoutSpacesValidator(20)]);
  } else {
    helpMessage.clearValidators();
  }
  helpMessage.updateValueAndValidity();
   // this.campaignForm.markAllAsTouched();
  }

  setProvision(data: any) {
    this.provisionStatus = data;
    if (this.smCampKey && (this.brandstatus == 'same_brand' || this.brandstatus == 'new_brand') && this.campaignstatus == 'same_campaign') {
      this.redundantCampaign();
    }
    else if (this.smCampKey && (this.brandstatus == 'same_brand' || this.brandstatus == 'new_brand') && this.campaignstatus == 'edit_campaign') {
      if (this.redExistCamp == 'Save') {
        this.saveFormWithoutValidation();
        this.campaignForm.patchValue({
          smCampaignKey: this.smCampKey
        });
      }
      this.redundantCampaign();
    }
    else if (this.smCampKey) {
      if (this.existCamp == 'Save' && this.provisionStatus == 6) {
        this.saveFormWithoutValidation();
        this.campaignForm.patchValue({
          smCampaignKey: this.smCampKey
        });
      } else if (this.existCamp == 'Save' && this.provisionStatus == 7) {
        this.saveFormWithValidation()
        this.campaignForm.patchValue({
          smCampaignKey: this.smCampKey
        });
      }
      this.copyCampaign();
    }
    else {
      if (data == '6') {
        this.saveFormWithoutValidation();
        this.registerCampaign();
      }
      else {
        this.saveFormWithValidation()
        this.registerCampaign();
      }
    }
  }
  // getValidatorsForControl(controlName: string): ValidatorFn[] {
  //   switch(controlName) {
  //       case 'embeddedLink':
  //       case 'embeddedPhone':
  //       case 'termsAndConditions':
  //       case 'numberPool':
  //       case 'ageGated':
  //       case 'directLending':
  //       case 'subscriberOptin':
  //       case 'subscriberOptout':
  //       case 'subscriberHelp':
  //       case 'messageFlow':
  //       case 'description':
  //           return [Validators.required];
  //       case 'sample1':
  //       case 'sample2':
  //           return [Validators.required, Validators.minLength(20), Validators.maxLength(1024)];
  //       case 'sample3':
  //       case 'sample4':
  //       case 'sample5':
  //           return [Validators.minLength(20), Validators.maxLength(1024)];
  //       case 'messageFlow':
  //             return [Validators.required, Validators.minLength(40), Validators.maxLength(2048)];
  //       case 'description':
  //             return [Validators.required, Validators.minLength(40), Validators.maxLength(4096)];
  //       default:
  //           return [];
  //   }
  // }

  // saveFormWithValidation() {
  //   Object.keys(this.campaignForm.controls).forEach(controlName => {
  //     const control = this.campaignForm.get(controlName); // Use get() to retrieve control
  //     control.setValidators(this.getValidatorsForControl(controlName));
  //     control.updateValueAndValidity(); // Update validity after setting validators
  //   });
  // }

  ngOnDestroy() {
    this.discretionmodal.nativeElement.click();
    this.vettingidentifiermodal.nativeElement.click();
    this.textmodals.nativeElement.click();
    this.videomodals.nativeElement.click();
    this.audiomodals.nativeElement.click();
    this.docsmodals.nativeElement.click();
    this.imagemodal.nativeElement.click();
    this.pdfmodals.nativeElement.click();
  }
}
