import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';
import { HttpClient } from '@angular/common/http'
import { NotificationService } from '../notification.service'
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
declare var $: any;

@Component({
  selector: 'app-email-subscription-setting',
  templateUrl: './email-subscription-setting.component.html',
  styleUrls: ['./email-subscription-setting.component.css']
})
export class EmailSubscriptionSettingComponent implements OnInit {
  systemtable: any;
  emailheading: any;
  systemtable1: any;
  Category: any = [];
  responseMessage: any = "";
  errMessage: any = "";
  public EmailForm: FormGroup;
  userType: any;
  iduser: any;
  idaccount: any;
  email_ID: any;
  useProfileEmail: boolean = false;
  customEmail: any = {};
  submitted: boolean = false;
  email_Id: any;
  clickedNecId: any | null = null;
  userdata: any = [];
  dataPatched: boolean = false;

  constructor(public router: Router, private http: HttpClient, public data: NotificationService, private fb: FormBuilder) { }

  ngOnInit(): void {
    let session$ = sessionStorage.getItem("isLoggedIn");
    let session = JSON.parse(session$);
    this.userType = session.type;
    this.iduser = session.iduser;
    this.idaccount = session.idaccount;
    this.email_ID = session.email;
    $.getScript('./assets/table.js');
    // this.data.get_systemnotification().subscribe((result) => {
    //   this.systemtable = result[3].emailsubscription
    //   this.emailheading = this.systemtable[0].heading
    // })

    this.EmailForm = this.fb.group({
      'Billing': ['', [Validators.required, Validators.pattern("^[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,10}(;\\s*[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,10})*$")]],
      'Technical': ['', [Validators.required, Validators.pattern("^[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,10}(;\\s*[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,10})*$")]],
      'Invoice': ['', [Validators.required, Validators.pattern("^[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,10}(;\\s*[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,10})*$")]],
      'Feature Updates': ['', [Validators.required, Validators.pattern("^[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,10}(;\\s*[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,10})*$")]],
      'Account Owner': ['', [Validators.required, Validators.pattern("^[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,10}(;\\s*[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,10})*$")]],
    });

    this.getCategory()

    this.getsubscription()

  }

  getCategory() {
    this.data.get_categoryCust().subscribe((res) => {
      if (res.status == 201) {
        this.Category = res.data;
        this.responseMessage = '';
        $('#basic-datatables').dataTable().fnClearTable();
        $('#basic-datatables').dataTable().fnDraw();
        $('#basic-datatables').dataTable().fnDestroy();
        $.getScript('./assets/table.js');
        setTimeout(() => {
          this.responseMessage = '';
        }, 5000);
      } else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = '';
        }, 5000);
      }
    });
  }


  getsubscription() {
    this.data.getEmail_subscription().subscribe((res) => {
      if (res.status == 201) {
        this.userdata = res.data;
        this.patchEmails();
        this.dataPatched = this.userdata.length > 0;
      } else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    });
  }

  patchEmails() {
    const formValues = {};
    let allControlsMatchEmailId = true;

    this.userdata.forEach((entry) => {
      formValues[entry.nec_id] = entry.email;
    });

    this.data.get_categoryCust().subscribe((res) => {
      if (res.status == 201) {
        this.Category = res.data;
        $('#basic-datatables').dataTable().fnClearTable();
        $('#basic-datatables').dataTable().fnDraw();
        $('#basic-datatables').dataTable().fnDestroy();
        $.getScript('./assets/table.js');
        this.Category.forEach((data) => {
          if (formValues[data.nec_id]) {
            this.EmailForm.get(data.title)?.patchValue(formValues[data.nec_id]);
            if (!formValues[data.nec_id].includes(this.email_ID)) {
              allControlsMatchEmailId = false;
            }
          } else {
            allControlsMatchEmailId = false;
          }
          const control = this.EmailForm.get(data.title);
          const sub = control?.valueChanges.subscribe(() => {
            const newValue = control?.value;
            if (!newValue.includes(this.email_ID)) {
              this.useProfileEmail = false;
              sub.unsubscribe();
            }
          });
        });
        this.useProfileEmail = allControlsMatchEmailId;
        setTimeout(() => {
          this.responseMessage = '';
        }, 5000);
      } else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = '';
        }, 5000);
      }
    });
  }


  SaveEMail(data: any) {
    this.submitted = true;
    if (this.EmailForm.get(data.title).invalid) {
      return false;
    } else {
      let title = data.title
      if (this.EmailForm.value.hasOwnProperty(title)) {
        let email = this.EmailForm.value[title];
        let emails = email.split(';').map((e: string) => e.trim() + '').join('; ');
        let payLoad: any = JSON.stringify({
          Email_ID: emails,
          nec_id: data.nec_id
        });
        this.data.sendmaildata(payLoad).subscribe((res) => {
          if (res.status == 201) {
            this.responseMessage = res.message;
            this.getsubscription()
            //this.useProfileEmail = false;
            setTimeout(() => {
              this.responseMessage = '';
            }, 5000);
          } else {
            this.errMessage = res.message;
            setTimeout(() => {
              this.errMessage = "";
            }, 5000);
          }
        });
      } else {
        this.errMessage = "Something Went Wrong!"
        setTimeout(() => {
          this.errMessage = ""
        }, 5000);
      }
    }
  }

  updateEMail(data: any) {
    this.submitted = true;
    if (this.EmailForm.get(data.title).invalid) {
      return false;
    } else {
      let title = data.title
      if (this.EmailForm.value.hasOwnProperty(title)) {
        let email = this.EmailForm.value[title];
        let emails = email.split(';').map((e: string) => {
          return e.trim();
        }).join('; ') + '';
        let payLoad: any = JSON.stringify({
          Email_ID: emails,
          nec_id: data.nec_id
        });
        this.data.Update_CustMail(payLoad).subscribe((res) => {
          if (res.status == 201) {
            this.responseMessage = res.message;
            this.getsubscription()
            //this.useProfileEmail = false;
            setTimeout(() => {
              this.responseMessage = '';
            }, 5000);
          } else {
            this.errMessage = res.message;
            setTimeout(() => {
              this.errMessage = "";
            }, 5000);
          }
        });
      } else {
        this.errMessage = "Something Went Wrong!"
        setTimeout(() => {
          this.errMessage = ""
        }, 5000);
      }
    }
  }

  updateEmailFields() {
    this.data.Cust_MailSubsc().subscribe((res) => {
      if (res.status == 201) {
        this.email_ID = res.data[0].email;
        if (this.useProfileEmail) {
          Object.keys(this.EmailForm.controls).forEach((controlName) => {
            const control = this.EmailForm.get(controlName);
            const currentValue = control.value;
            control.setValue(this.email_ID, { emitEvent: false });
            const sub = control.valueChanges.subscribe(() => {
              const newValue = control.value;
              if (!newValue.includes(this.email_ID)) {
                this.useProfileEmail = false;
                sub.unsubscribe();
              }
            });
          });
        } else {
          this.submitted = false;
          this.EmailForm.reset();
          this.getsubscription();
        }
      } else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = '';
        }, 5000);
      }
    });
  }


  DataPatchedForNecId(necId: any): boolean {
    const emailObj = this.userdata.find((entry) => entry.nec_id === necId);
    return !!emailObj;
  }

}
