import { Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import { ObsiptrunkingService } from '../obsiptrunking.service';
import { FormBuilder, FormGroup ,Validators} from '@angular/forms';
import * as XLSX from 'xlsx';
import { saveAs } from 'file-saver';
declare var $: any;

@Component({
  selector: 'app-siptrunkingsetting',
  templateUrl: './siptrunkingsetting.component.html',
  styleUrls: ['./siptrunkingsetting.component.css']
})

export class SiptrunkingsettingComponent implements OnInit {
  @ViewChild('addsetting') addsetting: ElementRef;
  @ViewChild('sweetalert') sweetalert: ElementRef;
  show_filter: boolean = false;
  userInfo: any;
  // public filterUser: FormGroup;
  public addsip: FormGroup;
  errMessage: any;
  responseMessage: any;
  public submitted : boolean = false
  SIP: any = [];
  id: any;
  EXCEL_TYPE = 'application/csv';
  EXCEL_EXTENSION = '.csv';
  idstr: any;
  totalcount: any;


  constructor( public data: ObsiptrunkingService, public fb: FormBuilder) { }


  ngOnInit(): void {
    this.data. get_obsiptrunking().subscribe((result) => {
      this.userInfo = result[0].siptruckingtable;
    });

    // this.filterUser = this.fb.group({
    //   from_date: [''],
    //   to_date:[''],
    //   sipname:[''],
    //   sipip:[''],
    //   sipprefix:['']
    // });


    this.addsip = this.fb.group({
      sipip:['',[Validators.required,Validators.pattern('(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)')]],
      sipprefix:['',[Validators.required,Validators.pattern(/^\s*\S.*$/m)]],
      sipname: ['', [Validators.required, Validators.pattern(/^(?=.*[a-zA-Z!@#$%^&*().,<>{}[\]<>?_`~=+\-|;:'"\/\\])[a-zA-Z!@#$%^&*().,<>{}[\]<>?_`~=+\-|;:'"\/\\ ]*$/)
      ]]
    })

    this.GetSIPData()
  }

  // showfilter() {
  //   if (this.show_filter == false) {
  //     this.show_filter = true;
  //   }
  //   else {
  //     this.show_filter = false;
  //   }
  // }

  GetSIPData(){
    this.data.SIPTrunkingData().subscribe((res)=>{
      if(res.status == 201){
        this.SIP = res.data
        $('#basic-datatables1').DataTable().clear();
        $('#basic-datatables1').DataTable().destroy();
        $.getScript('./assets/tollfree.js');
        // this.responseMessage = res.message
        // setTimeout(() => {
        //   this.responseMessage = ""
        // }, 5000);
      }else{
        this.errMessage = res.message
        setTimeout(() => {
          this.errMessage = ""
        }, 5000);
      }
    })
  }

  AddSIP(){
    this.submitted = true
    if(this.addsip.invalid){
      return false
    }else{
      this.data.AddSip(this.addsip.value).subscribe((res)=>{
        if(res.status == 201){
          this.responseMessage= res.message
          this.addsetting.nativeElement.click()
          this.GetSIPData()
          setTimeout(() => {
            this.responseMessage = ""
          }, 5000);
        }else{
          this.errMessage = res.message
          setTimeout(() => {
            this.errMessage = ""
          }, 5000);
        }
      })
    }
  }

  Edit(data:any){
    this.id = data.idsipts
    this.addsip.patchValue({
      sipip : data.sip_ip,
      sipname : data.sip_name,
      sipprefix : data.sip_prefix,
    })
  }

  EditSIP(){
    this.submitted = true
    if(this.addsip.invalid){
      return false
    }else{
      let payLoad: any = ({
        data: this.addsip.value,
        id: this.id,
      });     
       this.data.EditSIPTrunking(payLoad).subscribe((res)=>{
        if(res.status == 201){
          this.responseMessage = res.message
          this.GetSIPData()
          this.addsetting.nativeElement.click()
          setTimeout(() => {
            this.responseMessage = ""
          }, 5000);
          }else{
             this.errMessage = res.message
             setTimeout(() => {
               this.errMessage = ""
             }, 5000);
          }
      })
    }
  }

  ResetSIP(){
    this.submitted = false 
    this.addsip.reset()
    this.id = ''
  }

  ResetEdit(){
    this.submitted = false 
    this.addsip.reset()
  }

  getid(id:any){
    this.idstr = id;
    this.totalcount = '';
    this.data.getcount(this.idstr).subscribe((res)=>{
      if(res.status == 201){
        this.totalcount = res.data[0].total_count;
      }else{
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage='';
        }, 5000);
      }
    })
  }

  DeleteSIP(){
    // if (confirm("Are you sure you want delete SIP Trunking Setting!")) {
      this.data.deleteSIP(this.idstr).subscribe((res)=>{
        if(res.status == 201){
          this.responseMessage = res.message
          this.sweetalert.nativeElement.click();
          this.GetSIPData();
          setTimeout(() => {
            this.responseMessage = ""
          }, 5000);
          }else{
            this.errMessage = res.message
            setTimeout(() => {
              this.errMessage = ""
            }, 5000);
          }
      })
    // }else {
    //  return
    // }
  }

  downloadCSV(){
    setTimeout(() => {
      this.data.SIPTrunkingData().subscribe((res)=>{
        if(res.status == 201){
          let SIPdata = res.data
          if (SIPdata.length > 0) {
            let NewFilteredRes = SIPdata.map((item) => {
              const { created_at, sip_prefix, sip_ip, sip_name } = item;
              const formattedDate = created_at ? new Date(created_at).toLocaleDateString('en-US') : 'N/A';
              const sipname = sip_name;
              const sipip = sip_ip;
              const sipprefix = sip_prefix;
              return {
                'SIP Name': sipname,
                'SIP Override IP': sipip,
                'SIP Override Prefix': sipprefix,
                'Created At': formattedDate
              };
            });
            const worksheet: XLSX.WorkSheet = XLSX.utils.json_to_sheet(NewFilteredRes);
            const workbook: XLSX.WorkBook = { Sheets: { 'SIP Trunking Setting': worksheet }, SheetNames: ['SIP Trunking Setting'] };
            const excelBuffer: any = XLSX.write(workbook, { bookType: 'csv', type: 'array' });
            this.saveAsExcelFile(excelBuffer, 'SIP Trunking Setting');
          } else {
            this.errMessage = 'No Record Available'
            setTimeout(() => {
              this.errMessage = '';
            }, 5000);
          }
        }else{
          this.errMessage = res.message
          setTimeout(() => {
            this.errMessage = ""
          }, 5000);
        }
      })
    }, 1000);
  }

  private saveAsExcelFile(buffer: any, fileName: string): void {
    const data: Blob = new Blob([buffer], {
      type: this.EXCEL_TYPE
    });
    saveAs(data, fileName + new Date().getTime() + this.EXCEL_EXTENSION);
  }

  ngOnDestroy(){
    this.addsetting.nativeElement.click();
    this.sweetalert.nativeElement.click();
  }

}
