import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';
import { FormBuilder, FormGroup } from '@angular/forms';
import { OutboundService } from '../outbound.service';
import { routing, routingForm } from '../outbound.class'
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { Observable } from 'rxjs';
declare var $: any;

@Component({
	selector: 'app-routingprofile',
	templateUrl: './routingprofile.component.html',
	styleUrls: ['./routingprofile.component.css']
})
export class RoutingprofileComponent extends AppComponentClass<routing, routingForm> {
	p: number = 1;
	rowdata: any;
	page = 1;
	count = 0;
	tableSize = 5;
	tableSizes = [ 5, 9, 12];
	filterTerm: string;
	public show: boolean = false;
	public buttonName: any = "Add";
	public routingForm: FormGroup;
	public submitted: boolean = false
	public collection = "";
	public heading = [];
	public upper_heading = "";
	label: Observable<any>;

	constructor(public data: OutboundService, public router: Router, public fb: FormBuilder) {
		super(data, router, fb);
	}

	ngOnInit(): void {
		// @subscribing form group
		this.data.solution.subscribe(res => {
			if (res != null) {
				console.log("Update data " + JSON.stringify(res));
				this.cdata = new routingForm(res);
				this.keyfield = res.id;
				this.routingForm = this.cdata.makeform(this.fb);
			} else {
				console.log("adding data " + JSON.stringify(res));
				this.cdata = new routingForm(null);
				this.keyfield = -1;
				this.routingForm = this.cdata.makeform(this.fb);
			}
		});

		this.data.get_routing().subscribe((result) => {
			this.label = result[1]
			this.heading = result[0].headers
			this.rowdata = result[0].routing_profile
			console.log("result::", result)
		
		});

	
	}

	// @to edit the record
	editRow(rowdata: any): void {
		this.show = true
		this.Edit(rowdata)
	}

	// @to save/update form data
	onSubmit() {
		this.submitted = true;

		if (this.routingForm.invalid) {
			return false;
		} else {
			console.log("submit data::", this.cdata);
			if (this.cdata.saveForm(this.routingForm)) {
				console.log("Submitted data ::\n" + JSON.stringify(this.cdata));
				if (this.keyfield == -1) {
					this.data.saveData(JSON.stringify(this.cdata)).subscribe(res => {
						console.log("Response data::\n", res);
						this.ngOnInit();
					});
				} else {
					this.data.updateData(JSON.stringify(this.cdata)).subscribe(res => {
						console.log("Response data::\n", res);
						this.ngOnInit();
					});
				}
			}
		}
	}

	saveForm(data: any){
		console.log(data, "data");
	}

	toggle() {
		this.show = !this.show;
		// CHANGE THE NAME OF THE BUTTON.
		if (this.show) this.buttonName = "Close";
		else this.buttonName = "Add";
	}

	onTableSizeChange(event): void {
		this.tableSize = event.target.value;
		this.page = 1;
	} 
	  
	onTableDataChange(event){
		this.page = event;
	} 
}

