import { Component, OnInit } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { ProfileService } from '../profile.service';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { Router } from '@angular/router';
// import { mimeType } from "./mime-type-validator";

@Component({
  selector: 'app-userprofile',
  templateUrl: './userprofile.component.html',
  styleUrls: ['./userprofile.component.css']
})
export class UserprofileComponent extends AppComponentClass<any, any>{

  profileForm : FormGroup;
  changepasswordForm : FormGroup;
  submitted:boolean= false;
  userlist: any = '';
  public key: number;
  responseMessage = "";
  imagePreview: any;

  constructor(public data: ProfileService, public router: Router, public fb: FormBuilder) {
		super(data, router, fb);
    this.profileForm = this.fb.group({
      first_name: ['', [Validators.required]],
      last_name: ['', [Validators.required]],
      user_name: ['', [Validators.required]],
      email: ['', [Validators.required, Validators.pattern("^[a-z0-9._%+-]+@[a-z0-9.-]+\\.[a-z]{2,10}$")]],
      contact_number: ['',  [Validators.required, Validators.pattern("[0-9 ]{10}")]],
      // profile_pic : [''],
      // company_name: ['', [Validators.required]],
      // address1: ['', [Validators.required]],
      // address2: ['', [Validators.required]],
      // city: ['', [Validators.required]],
      // state: ['', [Validators.required]],
      // zip_code: ['', [Validators.required]]
    });

    this.changepasswordForm = this.fb.group({
      old_password: ['', [Validators.required]],
      new_password: ['', [Validators.required]],
      confirm_password: ['', [Validators.required]]
    });
	}

  ngOnInit(): void {

    this.data.getUsers("profile").subscribe(res=>{
      this.userlist=res.data[0];

      this.profileForm = this.fb.group({
        first_name: [this.userlist[0].first_name],
        last_name: [this.userlist[0].last_name],
        user_name: [this.userlist[0].user_name],
        email: [this.userlist[0].email],
        contact_number: [this.userlist[0].contact_number],
        image: [this.userlist[0].image]
      });
    });
  }
  
  onImagePicked(event: Event){
    const file = (event.target as HTMLInputElement).files[0];
    this.profileForm.patchValue({
      image: file
    });
    this.profileForm.get('image').updateValueAndValidity();
    const reader = new FileReader();
    reader.onload = () => {
      this.imagePreview = reader.result;
    }
    reader.readAsDataURL(file);
  }

  onSubmit(){
    this.submitted = true;
    if(this.profileForm.invalid){
        return false;
    }
    else{
        let retreive_value = this.profileForm.value;
        console.log(retreive_value);

        this.data.SaveData(retreive_value, this.profileForm.value.image).subscribe(res=>{
          this.responseMessage=res.message;
          setTimeout(()=>{
            this.responseMessage= "";
            }, 5000);
        }, err => {
          this.responseMessage = err;
        })
        
    }
  }

  change_password(){
    this.submitted = true;
    if(this.changepasswordForm.invalid){
      return false;
    }
    else{
      let retrieve_value = this.changepasswordForm.value;
      let curaccount:any = JSON.parse(sessionStorage.getItem("isLoggedIn"));
      this.key=(curaccount.iduser)
      if(this.changepasswordForm.get('new_password').value===this.changepasswordForm.get('confirm_password').value)
      {
        console.log("Thanks for Updating Change Password: " + JSON.stringify(this.cdata)+ " With Param Key :"+this.key);  
        this.data.updatePassword(JSON.stringify(this.changepasswordForm.value), this.key).subscribe( rs =>  {
          console.log(rs);    
          // alert('Password changed successfully!!');  
          this.responseMessage=rs.message;
          setTimeout(()=>{
            this.responseMessage= "";
            }, 5000); 
          //this.openSnackBar("Password changed successfully","Clear");
        }, err => {
          this.responseMessage = err;
        }); 
      }
      else {
           alert("Your entered confirm password does not match");
         // this.openSnackBar("Your entered confirm password does not match","Clear");
      }
    }
  }
}
