import { Component, EventEmitter, Input, OnInit, Output } from '@angular/core';
import { FormBuilder, FormGroup } from '@angular/forms';
import { Observable } from 'rxjs';

@Component({
  selector: 'app-dynamicform',
  templateUrl: './dynamicform.component.html',
  styleUrls: ['./dynamicform.component.css']
})
export class DynamicformComponent implements OnInit {

  @Input() formData: any;
  @Input() editData?: any;
  @Output() onSave = new EventEmitter();

  dynamicForm: FormGroup;
  formFields: any = [];
  fields = {};
  newFormData = {};

  constructor(private fb: FormBuilder) { }

  ngOnInit(): void {
    console.log(this.editData);

    if(this.editData != undefined){
      this.formData.subscribe(response => {
        this.formFields = response;
  
        this.formFields.forEach(element => {
            this.fields[element.formControl] = [];
        });
      });
        this.dynamicForm.patchValue(this.editData);  
    }
    else {
      this.formData.subscribe(response => {
        this.formFields = response;
  
        this.formFields.forEach(element => {
            this.fields[element.formControl] = [];
        });
      });
          this.dynamicForm = this.fb.group(this.fields);
    }
  }

  onAddForm(){
      this.onSave.emit(this.dynamicForm.value);
  }
}
