import { Component, OnInit } from '@angular/core';
import { FormBuilder, FormGroup, Validators, FormControl } from '@angular/forms';
import { ShortcodesmsService } from '../shortcodesms.service';
declare var $: any;

@Component({
  selector: 'app-shortcode-number',
  templateUrl: './shortcode-number.component.html',
  styleUrls: ['./shortcode-number.component.css']
})
export class ShortcodeNumberComponent implements OnInit {
  userType: any;
  show_filter: boolean = false;
  public filterForm: FormGroup;
  submitted: boolean = false;
  userfilter: any;
  datafilter0: void;
  datafilter1: any;
  datafilter2: any;
  datafilter3: any;
  datafilter4: any;
  datafilter5: any;
  datafilter6: any;
  datafilter7: any;
  datafilter8: any;
  sc_number: any[];
  scNewRec: any[];

  responseMessage: any = '';
  errMessage: any = '';
  allconnection: any;
 
  constructor(private fb: FormBuilder,public data: ShortcodesmsService,) { }

  ngOnInit() {
    let session$ = sessionStorage.getItem("isLoggedIn");
    let session = JSON.parse(session$);
    this.userType = session.type;

    this.data.get_shortcodetype().subscribe((result) => {
      this.userfilter = result[4].Shortcodenumber;
      this.datafilter0 = this.userfilter.numbfilter1
      this.datafilter1 = this.userfilter.numbfilter2
      this.datafilter2 = this.userfilter.numbfilter3
      this.datafilter3 = this.userfilter.numbfilter4
      this.datafilter4 = this.userfilter.numbfilter5
      this.datafilter5 = this.userfilter.numbfilter6
      this.datafilter6 = this.userfilter.numbfilter7
      this.datafilter7 = this.userfilter.numbfilter8
    });

    this.filterForm = this.fb.group({
      from:[''],
      to:[''],
      san:[''],
      batchid:[''],
      screquestid:[''],
      shortcode:[''],
      cstype:[''],
      scnoapproved:[''],
    })


    $('#basic-datatables2').dataTable().fnClearTable();
    $('#basic-datatables2').dataTable().fnDraw();
    $('#basic-datatables2').dataTable().fnDestroy();

    $('#basic-datatables7').dataTable().fnClearTable();
    $('#basic-datatables7').dataTable().fnDraw();
    $('#basic-datatables7').dataTable().fnDestroy();
    $.getScript('./assets/tollfree.js');
    this.get_sc_number();
   
  }



  get_sc_number() {
    this.data.allConnection().subscribe((res) => {
      this.allconnection = res.data;
      this.data.sc_number_list().subscribe(result => {
        if (result.status == 200) {
          this.scNewRec = result.data;
          this.scNewRec.forEach(item => {
            const matchingConnection = this.allconnection.find(conn => conn.connection_key === item.connection);
            if (matchingConnection) {
              item.name = matchingConnection.name;
            }
          });
          $('#basic-datatables4').dataTable().fnClearTable();
          $('#basic-datatables4').dataTable().fnDraw();
          $('#basic-datatables4').dataTable().fnDestroy();

          $('#basic-datatables1').dataTable().fnClearTable();
          $('#basic-datatables1').dataTable().fnDraw();
          $('#basic-datatables1').dataTable().fnDestroy();
          $.getScript('./assets/tollfree.js');
        }
        else {
          this.errMessage = result.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      });
    });
  }

  showfilter() {
    if (this.show_filter == false) {
      this.show_filter = true;
    }
    else {
      this.show_filter = false;
    }
  }
  onSubmit(){
    this.submitted = true;
  }
  onReset(){
    this.submitted = false
    this.filterForm.reset()
  }
}
