import { Injectable } from '@angular/core';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Observable } from 'rxjs/Observable';
import { AppService } from '../shared/service/AppService.class';
import { LoaderEnabled } from '../shared/loader/loader.service';
import { environment } from 'src/environments/environment';

@Injectable({
  providedIn: 'root'
})
export class ShortcodesmsService extends AppService<any> {

  httpHeaders: any = new HttpHeaders({
    "Content-Type": "application/json"
  });

  constructor(public http: HttpClient) {
    super(http)
  }


  // get_shortcodetype(): Observable<any> {
  //   return this.http.get('./assets/shortcode.json')
  // }

  get_Carrier(): Observable<any> {
    return this.http.get('./assets/shortcode.json')
  }

  get_shortcodetype(): Observable<any> {
    return this.http.get('./assets/shortcode.json')
  }
  
  @LoaderEnabled()
  getMessage(): Observable<any> {
    this.appmod = "getmessage";
    let result = super.getService();
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getcontent(): Observable<any> {
    this.appmod = "getContent";
    let result = super.getService();
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getSubscription(): Observable<any> {
    this.appmod = "getsubscription";
    let result = super.getService();
    this.appmod = "";
    return result;
  }


  @LoaderEnabled()
  submitShortcode(payLoad: any, file: File | any): Observable<any> {
   const formData = new FormData();
   for (let i = 0; i < file.length; i++) {
     formData.append("ATTACHMENTS", file[i], file[i].name);
   }
   formData.append("ATTACHMENTS", file);
   formData.append("data", payLoad);
   const apiURL = environment.SERVER + 'saveShortCodeCampaign';
   let httpHeaders = new HttpHeaders({
   });
   return this.http.post(apiURL, formData, { headers: httpHeaders });
 }

 @LoaderEnabled()
 GetCamp(): Observable<any> {
   this.appmod = "getshortcamp";
   let result = super.getService();
   this.appmod = "";
   return result;
 }

 @LoaderEnabled()
 ViewSCdata(id:any): Observable<any> {
   this.appmod = "getSCdata";
   let result = super.getService(id);
   this.appmod = "";
   return result;
 }

 @LoaderEnabled()
 copySCDAta(data?: any): Observable<any> {
   this.appmod = "copySC";
   let result = super.saveService(data);
   this.appmod = "";
   return result;
 }

 @LoaderEnabled()
 UpdateCamapaign(data: any, file: File | any): Observable<any> {
   const formData = new FormData();
   for (let i = 0; i < file.length; i++) {
     formData.append("ATTACHMENTS", file[i]);
   }
   formData.append("data", data);
   const apiURL = environment.SERVER + 'updateshortcampaign';
   let httpHeaders = new HttpHeaders({});

   return this.http.post(apiURL, formData, { headers: httpHeaders });
 }

 
 @LoaderEnabled()
 rejectSCampaign(data: any): Observable<any> {
   this.appmod = "rejectSC";
   let result = super.saveService(data);
   this.appmod = "";
   return result;
 }

 @LoaderEnabled()
 approveSCampaign(data: any): Observable<any> {
   this.appmod = "approveSC";
   let result = super.saveService(data);
   this.appmod = "";
   return result;
 }

 @LoaderEnabled()
 appllyFilter(data?: any): Observable<any> {
   this.appmod = "scfilter";
   let result = super.saveService(data);
   this.appmod = "";
   return result;
 }

 @LoaderEnabled()
 getCarrier(): Observable<any> {
   this.appmod = "carrier_coverage";
   let result = super.getService();
   this.appmod = "";
   return result;
 }

 @LoaderEnabled()
 get_scBatch(): Observable<any> {
   this.appmod = 'get_scbatchId';
   let result = super.getService();
   this.appmod = "";
   return result;
 }

 @LoaderEnabled()
 sc_number_list(): Observable<any> {
   this.appmod = "sc_numberList";
   let result = super.getService();
   this.appmod = "";
   return result;
 }

 @LoaderEnabled()
 sendcsvForNumberMap(data: any) {     
   this.appmod = "csvForNumberMap";
   let result = super.updateService(data);
   this.appmod = "";
   return result;
 }

 @LoaderEnabled()
 approveShortCode(data: any) {
   this.appmod = "approveShortCodeStatus";
   let result = super.updateService(data);
   this.appmod = "";
   return result;
 }

 @LoaderEnabled()
 rejectShortCode(data: any) {
   this.appmod = "rejectShortCodeStatus";
   let result = super.updateService(data);
   this.appmod = "";
   return result;
 }

@LoaderEnabled()
sendshortcoderequest(data: any, file: File | any): Observable<any> {
  const formData = new FormData();
  formData.append("data", data);
  for (let i = 0; i < file.length; i++) {
    formData.append("ATTACHMENTS", file[i], file[i].name);
  }
  formData.append("ATTACHMENTS", file);
  const apiURL = environment.SERVER + 'sendshortcoderequest';
  let httpHeaders = new HttpHeaders({
  });
  return this.http.post(apiURL, formData, { headers: httpHeaders });
}

@LoaderEnabled()
updaterequest(data: any, file: File | any): Observable<any> {
  const formData = new FormData();
  formData.append("data", data);
  for (let i = 0; i < file.length; i++) {
    formData.append("ATTACHMENTS", file[i]);
  }
  const apiURL = environment.SERVER + 'updateSCRequest';
  let httpHeaders = new HttpHeaders({});

  return this.http.post(apiURL, formData, { headers: httpHeaders });
}

@LoaderEnabled()
getSCdata(payLoad): Observable<any> {
  this.appmod = 'getsingleSCDetails';
  let result = super.getService(payLoad);
  this.appmod = "";
  return result;
}

@LoaderEnabled()
getIDRequest(): Observable<any> {
  this.appmod = "getIDRequest";
  let result = super.getService();
  this.appmod = "";
  return result;
}

@LoaderEnabled()
getSCRequest(): Observable<any> {
  this.appmod = "getSCRequest";
  let result = super.getService();
  this.appmod = "";
  return result;
}

@LoaderEnabled()
rejectstatus(data: any) {
  this.appmod = "rejectstatus";
  let result = super.updateService(data);
  this.appmod = "";
  return result;
}

@LoaderEnabled()
approveSC_req(data: any) {
  this.appmod = "approveSCrStatus";
  let result = super.updateService(data);
  this.appmod = "";
  return result;
}

@LoaderEnabled()
getConnection(data:any): Observable<any> {
  this.appmod = 'get_conn';
  let result = super.getService(data);
  this.appmod = "";
  return result;
}
@LoaderEnabled()
allConnection(): Observable<any> {
  this.appmod = 'allget_conn';
  let result = super.getService();
  this.appmod = "";
  return result;
}

@LoaderEnabled()
Saverandomvanity(data: any, file: File | any): Observable<any> {
  const formData = new FormData();
  formData.append("data", data);
  for (let i = 0; i < file.length; i++) {
    formData.append("ATTACHMENTS", file[i], file[i].name);
  }
  formData.append("ATTACHMENTS", file);
  const apiURL = environment.SERVER + 'Saverandomvanity';
  let httpHeaders = new HttpHeaders({
  });
  return this.http.post(apiURL, formData, { headers: httpHeaders });
}

@LoaderEnabled()
GetRates(iduser): Observable<any> {
  this.appmod = 'GetRates';
  let result = super.getService(iduser);
  this.appmod = "";
  return result;
}

}
