import { Injectable } from '@angular/core';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Observable } from 'rxjs';
import { AppService } from 'src/app/shared/service/AppService.class';
import { LoaderEnabled } from '../shared/loader/loader.service';
import { environment } from 'src/environments/environment';

@Injectable({
  providedIn: 'root'
})
export class SmsService extends AppService<any>{

  constructor(public http: HttpClient) {
    super(http)
  }

  @LoaderEnabled()
  sendSMS(data: any): Observable<any> {

    const apiURL = environment.SERVER + 'sms';

    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });

    return this.http.post(apiURL, data, { headers: httpHeaders });
  }

  @LoaderEnabled()
  saveData(data: any): Observable<any> {
    let tmp = this.appmod;
    this.appmod = 'mdrsearch';
    let result = super.saveService(data);
    this.appmod = tmp;
    return result;
  }

  updateData(data: any): Observable<any> {
    let tmp = this.appmod;
    this.appmod = 'custom/saveheadermapping';
    let result = super.saveService(data);
    this.appmod = tmp;
    return result;
  }

  @LoaderEnabled()
  getMDRFilter(data: any): Observable<any> {
    this.appmod = "getmdrfilter";
    let result = super.getService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getAllMmsMediaFiles(): Observable<any> {
    let apiUrl = environment.SERVER + 'listallmmsmedia';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.get(apiUrl, { headers: httpHeaders });
  }
  
  @LoaderEnabled()
  summerySmsmdrForm(data: any): Observable<any> {
    this.appmod = "summerysmsmdrfilter";
    let result = super.getService(data);
    this.appmod = "";
    return result;
  }
  
  @LoaderEnabled()
  getMMSMDR(data: any): Observable<any> {
    this.appmod = "getmmsmdrfilter";
    let result = super.getService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  summeryCdrForm(data: any): Observable<any> {
    this.appmod = "summerymmsmdrfilter";
    let result = super.getService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  twofaTemaplate(data?: any): Observable<any> {
    let apiUrl = environment.SERVER + '2fa-template';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.post(apiUrl, data, { headers: httpHeaders });
  }
  @LoaderEnabled()
  get2FATemplate(id2fa_template): Observable<any> {
    let apiUrl = environment.SERVER + '2fa-template';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.get(apiUrl, { headers: httpHeaders, params: { id2fa_template: id2fa_template } });
  }
  @LoaderEnabled()
  get2FATemplates(type: any): Observable<any> {
    let apiUrl = environment.SERVER + '2fa-templates';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.get(apiUrl, { headers: httpHeaders, params: { type } });
  }
  @LoaderEnabled()
  update2FATemplate(data?: any): Observable<any> {
    let apiUrl = environment.SERVER + '2fa-template';
    let httpheaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.put(apiUrl, data, { headers: httpheaders });
  }
  @LoaderEnabled()
  delete2FATemplate(id2fa_template): Observable<any> {
    let apiUrl = environment.SERVER + '2fa-template';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.delete(apiUrl, { headers: httpHeaders, params: { id2fa_template: id2fa_template } });
  }

  @LoaderEnabled()
  SendOtpBySMS(data: any): Observable<any> {
    let tmp = this.appmod;
    this.appmod = 'sendotpbysms';
    let result = super.saveService(data);
    this.appmod = tmp;
    return result;
  }
  @LoaderEnabled()
  verifySMSOtp(data: any): Observable<any> {
    let apiUrl = environment.SERVER + 'verifyotp';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.post(apiUrl, data, { headers: httpHeaders });
  }
  @LoaderEnabled()
  SendOtpByCall(data?: any): Observable<any> {
    let apiUrl = environment.SERVER + 'sendotpbycall';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.post(apiUrl, data, { headers: httpHeaders });
  }

  @LoaderEnabled()
  verifyOtp(data: any): Observable<any> {
    let apiUrl = environment.SERVER + 'verify-call-otp';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.post(apiUrl, data, { headers: httpHeaders });
  }
  @LoaderEnabled()
  setDefaultTemplate(data?: any): Observable<any> {
    const apiURL = environment.SERVER + '2fa-defaultTemplate';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.put(apiURL, { data }, { headers: httpHeaders });
  }

  get_mdrs(): Observable<any> {
    return this.http.get('./assets/mdrs.json');
  }

  get_smsconf(): Observable<any> {
    return this.http.get('./assets/smsconf.json');
  }

  get_testmessage(): Observable<any> {
    return this.http.get('./assets/testmessage.json');
  }

  get_ipwhitelist(): Observable<any> {
    return this.http.get('./assets/ipwhitelist.json');
  }

  @LoaderEnabled()
  deleteMmsMedia(mediaID): Observable<any> {
    let apiUrl = environment.SERVER + 'deletemmsmedia';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.delete(apiUrl, { headers: httpHeaders, params: { mediaID: mediaID } });
  }

  @LoaderEnabled()
  uploadMmsMediaFile(media: any, file: File | any): Observable<any> {
    const formData = new FormData();
    formData.append("UPLOAD", file);
    formData.append("data", JSON.stringify(media));
    const apiURL = environment.SERVER + 'uploadmmsmedia';
    let httpHeaders = new HttpHeaders({
    });
    return this.http.post(apiURL, formData, { headers: httpHeaders });
  }


  @LoaderEnabled()
  getMmsMediaFiles(): Observable<any> {
    let apiUrl = environment.SERVER + 'listmmsmedia';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.get(apiUrl, { headers: httpHeaders });
  }
  
}
