import { Component, OnInit } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { ActivatedRoute, ParamMap, Router } from '@angular/router';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import { TariffService } from '../tariff.service';

@Component({
  selector: 'app-add-service',
  templateUrl: './add-service.component.html',
  styleUrls: ['./add-service.component.css']
})

export class AddServiceComponent implements OnInit {
  listdata: any;
  preferenceForm: FormGroup
  didForm: FormGroup;
  smsForm: FormGroup
  voiceForm: FormGroup
  public submitted: boolean = false;
  suppliers: any;
  preferenceDID: any = [];
  preferenceSMS: any = [];
  preferenceVoice: any = [];
  responseMessage: any;
  voiceSupplier = [];
  smsSupplier = [];
  didSupplier = [];
  status: boolean = false;
  idservice = "";
  didPreference: any = [];
  smsPreference: any = [];
  voicePreference: any = [];
  data1:any;
  data2:any;
  data3:any;

  constructor(private data: UsermanagementService,
    private tariffService: TariffService,
    public router: Router, public fb: FormBuilder,
    private route: ActivatedRoute
  ) { }

  ngOnInit(): void {
    this.preferenceForm = this.fb.group({
      idservice: [''],
      name: ['', [Validators.required, Validators.minLength(3)]],
      description: ['', [Validators.required, Validators.minLength(10)]],
    });

    this.didForm = this.fb.group({
      preference1: [{ value: '', disabled: true }, [Validators.required]],
      preference2: [''],
      preference3: [''],
    });

    this.smsForm = this.fb.group({
      preference1: [{ value: '', disabled: true }, [Validators.required]],
    });

    this.voiceForm = this.fb.group({
      preference1: [{ value: '', disabled: true }, [Validators.required]],
    });

    this.addDidProvider();
    this.data.getpreference().subscribe((result) => {
      this.listdata = result;
    });

    this.route.paramMap.subscribe((params: ParamMap) => {
      this.idservice = params.get("id");
      if (this.idservice) {
        this.tariffService.getSingleService({ idservice: this.idservice }).subscribe(res => {
          this.preferenceForm.patchValue({
            idservice: this.idservice,
            name: res.data.name,
            description: res.data.description
          })
          this.didForm.get('preference1').enable();
          this.smsForm.enable();
          this.voiceForm.enable();
        }, err => {
          console.log(err.message);
        });
       
        this.data.getPreference({ type: "did", idservice: this.idservice }).subscribe(result => {
          if (result.data.length > 0) {
            this.didPreference = result.data;
         
            this.didForm.patchValue({
              preference1: this.didPreference[0].idsupplier,
            });
            if (this.didPreference[1]) {
              this.didForm.patchValue({
                preference2: this.didPreference[1].idsupplier,
              });
            }
            if (this.didPreference[2]) {
              this.didForm.patchValue({
                preference3: this.didPreference[2].idsupplier,
              });
            }
            for (let i = 0; i <= this.didPreference.length; i++) {
              if (this.didPreference[i]) {
                this.preferenceDID[i] = { index: i, idsupplier: this.didPreference[i].idsupplier, idservice: this.idservice, priority: this.didPreference[i].priority, type: this.didPreference[i].type, idpreferemce: this.didPreference[i].idpreference };
              }
            }
          }
          
          this.didProvider();
        }, error => {
          this.responseMessage = error.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
        });

        this.data.getPreference({ type: "sms", idservice: this.idservice }).subscribe(result => {
          if (result.data.length > 0) {
            this.smsPreference = result.data;
            this.smsForm.patchValue({
              preference1: this.smsPreference[0].idsupplier
            });
          }
        }, error => {
          this.responseMessage = error.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
        });

        this.data.getPreference({ type: "voice", idservice: this.idservice }).subscribe(result => {
          if (result.data.length > 0) {
            this.voicePreference = result.data;
            this.voiceForm.patchValue({
              preference1: this.voicePreference[0].idsupplier
            });
          }
        }, error => {
          this.responseMessage = error.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
        });
      }
    });

    this.data.getSuppliers().subscribe(supplier => {
      this.suppliers = supplier.data;
      supplier.data.forEach(element => {
        if (element.sms == "yes") {
          this.smsSupplier.push(element);
        }
        if (element.voice == "yes") {
          this.voiceSupplier.push(element);
        }
        if (element.did == "yes") {
          this.didSupplier.push(element);
        }
      });
    });
  }

  handleInput(event: any, field: string) {
    let value = event.target.value;
    let control = this.preferenceForm.get(field);
  
    if (!value) {
      control.setErrors({ 'required': true });
    } else if (value.startsWith(' ')) {
      control.setErrors({ 'whitespace': true });
      value = value.trim();
      event.target.value = value;
    } else if ((field === 'name' && value.length < 3) || (field === 'description' && value.length < 10)) {
      control.setErrors({ 'minlength': true });
    } else {
      control.setErrors(null);
    }
  }

  addPreference() {
    this.submitted = true;
    if (this.preferenceForm.invalid) {
      return;
    }
    else {
      if (this.idservice) {
        this.tariffService.updatePreferenceService(this.preferenceForm.value).subscribe(res => {
          this.responseMessage = res.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
        }, err => {
          this.responseMessage = err.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
        });
      }
      else {
        this.tariffService.savePreferenceService(this.preferenceForm.value).subscribe(res => {
          if (res.data && res.data.insertId) {
            this.idservice = res.data.insertId;
            sessionStorage.setItem("insertId", this.idservice);
            this.didForm.get('preference1').enable();
            this.smsForm.enable();
            this.voiceForm.enable();
          }
          this.responseMessage = res.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
        }, err => {
          this.responseMessage = err.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
        });
      }
    }
  }

  // onPreference(e: any, type: any) {
  //   this.didSupplier.forEach(element => {
  //     if(element.selected =='true'){
  //       element.selected = "false";
  //     }
  //     if (e.target[e.target.options.selectedIndex].value == element.key) {
  //       element.selected = "true";
  //     }
  //   });
  //   if (this.idservice == "") {
  //     this.idservice = sessionStorage.getItem("insertId");
  //   }

  //   let index = e.target.id;
  //   this.preferenceDID[index] = { index: index, "idsupplier": e.target.value, "idservice": this.idservice, "priority": index, type: type };
  // }
  // For Add Preference
  addDidProvider(){
    this.didForm.get("preference2").disable();
    this.didForm.get("preference3").disable();
  }
// For Edit Preference
  didProvider(){ 
    this.data1='';
    this.data2='';
    this.data3='';
  
    if(this.didPreference[0]){
      this.data1=this.didPreference[0].idsupplier !== 'undefined' || '' ? this.didPreference[0].idsupplier:'';
    }
    if(this.didPreference[1]){
      this.data2=this.didPreference[1].idsupplier !== 'undefined' || '' ? this.didPreference[1].idsupplier:'';
    }
    if(this.data3=this.didPreference[2]){
    this.data3=this.didPreference[2].idsupplier !== 'undefined' || '' ? this.didPreference[2].idsupplier:'';
    }
     
    if(this.data1 == '' || this.data1 == undefined){
      this.didForm.get("preference2").disable();
    }
    else{
      this.didForm.get("preference2").enable();
    }
   
    if(this.data2 == '' || this.data2 == undefined){  
      this.didForm.get("preference3").disable();
    }
    else{ 
      this.didForm.get("preference3").enable();
    }
  }
  // preference 1
  onPreference1(e: any, type: any){
    if(e.target.value!=''){
      this.data1=e.target.value;
      $(".select2 option[value='" + e.target.value + "']").prop('disabled', true);
      $(".select2 option[value!='" + e.target.value + "']").prop('disabled', false);
     
      $(".select3 option[value='" + e.target.value + "']").prop('disabled', true);
      $(".select3 option[value!='" + e.target.value + "']").prop('disabled', false);

      if(this.data3!='' || this.data2!=''){
        $(".select2 option[value='" + this.data3 + "']").prop('disabled', true);
        $(".select3 option[value='" + this.data2 + "']").prop('disabled', true);
      }

      this.didForm.get("preference2").enable();

      if (this.idservice == "") {
        this.idservice = sessionStorage.getItem("insertId");
      }
      
      let index = e.target.id;
      this.preferenceDID[index] = { index: index, "idsupplier": e.target.value, "idservice": this.idservice, "priority": index, type: type };
    }
  }
  // Preference 2
  onPreference2(e: any, type: any){
    if(e.target.value!=''){
      this.data2=e.target.value;
      $(".select3 option[value='" + e.target.value + "']").prop('disabled', true);
      $(".select3 option[value!='" + e.target.value + "']").prop('disabled', false);

      $(".select1 option[value='" + e.target.value + "']").prop('disabled', true);
      $(".select1 option[value!='" + e.target.value + "']").prop('disabled', false);

      if(this.data3!='' || this.data1!=''){
        $(".select1 option[value='" + this.data3 + "']").prop('disabled', true);
        $(".select3 option[value='" + this.data1 + "']").prop('disabled', true);
      }
  
      this.didForm.get("preference3").enable();

      if (this.idservice == "") {
        this.idservice = sessionStorage.getItem("insertId");
      }
      
      let index = e.target.id;
      this.preferenceDID[index] = { index: index, "idsupplier": e.target.value, "idservice": this.idservice, "priority": index, type: type };
    }
  }

  // preference 3
  onPreference3(e: any, type: any){
    if(e.target.value!=''){
      this.data3=e.target.value;
      $(".select1 option[value='" + e.target.value + "']").prop('disabled', true);
      $(".select1 option[value!='" + e.target.value + "']").prop('disabled', false);

      $(".select2 option[value='" + e.target.value + "']").prop('disabled', true);
      $(".select2 option[value!='" + e.target.value + "']").prop('disabled', false);

      if(this.data2!='' || this.data1!=''){
        $(".select2 option[value='" + this.data1 + "']").prop('disabled', true);
        $(".select1 option[value='" + this.data2 + "']").prop('disabled', true);
      }

      if (this.idservice == "") {
        this.idservice = sessionStorage.getItem("insertId");
      }
      
      let index = e.target.id;
      this.preferenceDID[index] = { index: index, "idsupplier": e.target.value, "idservice": this.idservice, "priority": index, type: type };
    }
  }

  onSMS(e, type) {
    this.didSupplier.forEach(element => {
      if (e.target[e.target.options.selectedIndex].value == element.key) {
        element.selected = "true";
      }
    });

    if (this.idservice == "") {
      this.idservice = sessionStorage.getItem("insertId");
    }
    let index = e.target.id;
    this.preferenceSMS[index] = { index: index, "idsupplier": e.target.value, "idservice": this.idservice, "priority": index, type: type };
  }

  onVoice(e, type) {
    this.didSupplier.forEach(element => {
      if (e.target[e.target.options.selectedIndex].value == element.key) {
        element.selected = "true";
      }
    });

    if (this.idservice == "") {
      this.idservice = sessionStorage.getItem("insertId");
    }
    let index = e.target.id;
    this.preferenceVoice[index] = { index: index, "idsupplier": e.target.value, "idservice": this.idservice, "priority": index, type: type };
  }

  resetOptions() {
    $('select').prop('selectedIndex', 0);
    this.didSupplier.forEach(element => {
      element.selected = "false";
    });
  }

  // @to save/update form data
  onSetPreference() {
    this.submitted = true;
    if (!this.idservice) {
      return false;
    }
    if (this.didForm.invalid) {
      return false;
    } 
    else {
      this.data.updatePreference(JSON.stringify(this.preferenceDID)).subscribe(res => {
        this.responseMessage = res.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
      }, err => {
        this.responseMessage = err.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
      });
    }
  }

  onSetSMS() {
    this.submitted = true
    if (!this.idservice) {
      return false;
    }
    if (this.smsForm.invalid) {
      return false;
    }
    else {
      this.data.updatePreference(JSON.stringify(this.preferenceSMS)).subscribe(res => {
        this.responseMessage = res.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
      }, err => {
        this.responseMessage = err.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
      });
    }
  }

  onSetVoice() {
    this.submitted = true;
    if (!this.idservice) {
      return false;
    }
    if (this.voiceForm.invalid) {
      return false;
    }
    else {
      this.data.updatePreference(JSON.stringify(this.preferenceVoice)).subscribe(res => {
        this.responseMessage = res.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
      }, err => {
        this.responseMessage = err.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
      });
    }
  }

  onReset(){
    this.submitted = false;
    const idservice = this.preferenceForm.value.idservice; // Store the existing idservice
    this.preferenceForm.reset(); // Reset the form
    this.preferenceForm.patchValue({ idservice }); 
  }

  onResetDID(){
    this.submitted = false;
    this.didForm.reset();
    this.didForm.get('preference1').setValue('');
    this.didForm.get('preference2').setValue('');
    this.didForm.get('preference3').setValue('');
  }

  onResetSMS(){
    this.submitted = false;
    this.smsForm.reset();
    this.smsForm.get('preference1').setValue('');
  }

  onResetVoice(){
    this.submitted = false;
    this.voiceForm.reset();
    this.voiceForm.get('preference1').setValue('');
  }
  
}
