import { Component, Input, OnInit, ViewChild } from '@angular/core';
import { FormBuilder, FormGroup } from '@angular/forms';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import { TariffService } from '../tariff.service';

@Component({
  selector: 'app-ratelist',
  templateUrl: './ratelist.component.html',
  styleUrls: ['./ratelist.component.css']
})
export class RatelistComponent implements OnInit {
  
  @Input() idtariff: any;
  @Input() DLCRate: any;
  status: boolean = false;
  
  headers: any;
  ratelists: any;
  public rateForm: FormGroup;
  responseMessage:any = "";

  constructor(private data: UsermanagementService, private fb: FormBuilder,
    private tariffService: TariffService,
  ) { }

  ngOnInit(): void {

    this.data.getsmsrate().subscribe((result) => {
      this.headers = result[0].headers_details;
      this.ratelists = result[0].rowdata;

      // if(this.DLCRate !=undefined ){
      //   this.DLCRate.subscribe(res => {
      //     this.ratelists = res.data;
      //     this.status = true;
      //     let tmp=[];
      //     res.data.forEach(element => {
      //       tmp["iddlca2p_"+ element.priority] = [element.id_dlc_a2p];
      //       tmp["category_"+ element.priority] = [element.priority],
      //       tmp["a_"+element.priority]=[element.a];
      //       tmp["b_"+element.priority]=[element.b];
      //       tmp["c_"+element.priority]=[element.c];
      //       tmp["d_"+element.priority]=[element.d];
      //       tmp["e_"+element.priority]=[element.e];
      //       tmp["inboundA2Psurcharge_"+element.priority]=[element.inbound_A2P_surcharge];
      //     });
      //     this.rateForm = this.fb.group(tmp);
      //   })
      // }
      // else{
          let tmp=[];
          this.ratelists.forEach(element => {
            this.status = true;
            tmp["priority_"+ element.priority] = [element.priority],
            tmp["idtariff_"+ element.priority] = [this.idtariff];
            tmp["category_"+ element.priority] = [element.category],
            tmp["a_"+element.priority]=[0];
            tmp["b_"+element.priority]=[0];
            tmp["c_"+element.priority]=[0];
            tmp["d_"+element.priority]=[0];
            tmp["e_"+element.priority]=[0];
            tmp["inboundA2Psurcharge_"+element.priority]=[0];
        });
          this.rateForm = this.fb.group(tmp);
      // }
    });
  }

  onSaveRates(){
          // console.log(this.rateForm.value);
          let response: any = [];
          response[0]=[];
          response[1]=[];
          response[2]=[];
          response[3]=[];
          response[4]=[];
          response[5]=[];
          response[6]=[];
          response[7]=[];
          response[8]=[];

          for(let key of Object.keys(this.rateForm.value)){
            let tmp=key.split('_');
            response[tmp[1]].push({field: tmp[0], value: this.rateForm.value[key]});
          }
              let temp = response.slice(1, 7);

              if(this.DLCRate != undefined){
                this.tariffService.update10DLCRates(temp).subscribe(resp => {
                  this.responseMessage = resp.message;  
                  setTimeout(()=>{
                    this.responseMessage= "";
                  }, 5000);
                });
              }
              else{
                this.tariffService.addA2PDLCRates(temp).subscribe(resp => {
                  this.responseMessage = resp.message;  
                  setTimeout(()=>{
                    this.responseMessage= "";
                  }, 5000);
                });
              }
        }

        
        onlyNumber(e){
          const charCode = (e.which) ? e.which : e.keyCode;
          if (charCode > 31 && (charCode < 48 || charCode > 57)) {
            return false;
          }
        }
}

