import { Injectable } from '@angular/core';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Observable } from 'rxjs/Observable';
import { AppService } from '../shared/service/AppService.class';
import { LoaderEnabled } from '../shared/loader/loader.service';
import { environment } from 'src/environments/environment';


@Injectable({
  providedIn: 'root'
})
export class TollfreesmsService extends AppService<any>{

  httpHeaders: any = new HttpHeaders({
    "Content-Type": "application/json"
  });

  constructor(public http: HttpClient) {
    super(http)
  }

  get_tollfreeheader(): Observable<any> {
    return this.http.get('./assets/tollfreesms.json')
  }

  get_tollfree_detail(): Observable<any> {
    return this.http.get('./assets/tollfree_viewdetail.json')
  }

  get_tollfree_sender(): Observable<any> {
    return this.http.get('./assets/tollfree_verifysender.json')
  }

  @LoaderEnabled()
  did_number(): Observable<any> {
    this.appmod = "did_number";
    let result = super.getService();
    this.appmod = "";
    return result;
  }

  /* to get request id acc to idaccount*/
  @LoaderEnabled()
  get_RequestID(): Observable<any> {
    this.appmod = "get_RequestID";
    let result = super.getService();
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  updateVerifySender(data: any, file: File | any): Observable<any> {
    const formData = new FormData();
    for (let i = 0; i < file.length; i++) {
      formData.append("ATTACHMENTS", file[i]);
    }
    formData.append("data", data);
    const apiURL = environment.SERVER + 'updateVerifySender';
    let httpHeaders = new HttpHeaders({});

    return this.http.post(apiURL, formData, { headers: httpHeaders });
  }

  @LoaderEnabled()
  verifySender(data: any, file: File | any): Observable<any> {
    const formData = new FormData();
    for (let i = 0; i < file.length; i++) {
      formData.append("ATTACHMENTS", file[i], file[i].name);
    }
    formData.append("ATTACHMENTS", file);
    formData.append("data", data);
    const apiURL = environment.SERVER + 'saveVefiySender';
    let httpHeaders = new HttpHeaders({
    });
    return this.http.post(apiURL, formData, { headers: httpHeaders });
  }

  @LoaderEnabled()
  get_verifySender(): Observable<any> {
    let tmp = this.appmod;
    this.appmod = "getVerified_Sender";
    let result = super.getService();
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  view_VerifySender(payLoad): Observable<any> {
    this.appmod = 'getsingleSenderDetails';
    let result = super.getService(payLoad);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getRequestIdfromBatchId(id: any): Observable<any> {
    this.appmod = 'getrequestID';
    let result = super.getService(id);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getAssign_number(): Observable<any> {
    let tmp = this.appmod;
    this.appmod = "getAssign_number";
    let result = super.getService();
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  downloadCSVemail(id: any): Observable<any> {
    this.appmod = 'downloadCSVemail';
    let result = super.getService(id);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getBatch(): Observable<any> {
    this.appmod = 'getbatchId';
    let result = super.getService();
    this.appmod = "";
    return result;
  }


  @LoaderEnabled()
  approveSender(data: any) {
    this.appmod = "approveSenderStatus";
    let result = super.updateService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  rejectSenderStatus(data: any) {
    this.appmod = "rejectSenderstatus";
    let result = super.updateService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  sendMailIds(data: any) {
    this.appmod = "csvForIntq";
    let result = super.updateService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  approveReview(data: any) {
    this.appmod = "approveReviewStatus";
    let result = super.updateService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  rejectReview(data: any) {
    this.appmod = "rejectReviewStatus";
    let result = super.updateService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  applyTollfreeFilter(data?: any): Observable<any> {
    this.appmod = "tollfreefilter";
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  did_change(data: any) {
    this.appmod = "did_change";
    let result = super.updateService(data);
    this.appmod = "";
    return result;
  }
  @LoaderEnabled()
  did_reject(data: any) {
    this.appmod = "did_reject";
    let result = super.updateService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  get_status(data?: any): Observable<any> {
    this.appmod = 'get_status';
    let result = super.getService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  resendEmail(data: any) {
    this.appmod = "resendEmailtoIntq";
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  emailTollfreeFilter(data?: any): Observable<any> {
    this.appmod = "emailtollfreefilter";
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  onEnable_service(data?: any) {
    this.appmod = "EnableTFsms";
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  onDisable_service(data?: any) {
    this.appmod = "disableTFsms";
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  applyFilter(data?: any): Observable<any> {
    this.appmod = "tollfreeAssignfilter";
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }
}
