import { Component, OnInit } from '@angular/core';
import {UsermanagementService} from '../usermanagement.service';
import { Router } from '@angular/router';
import { FormBuilder, FormGroup, FormControl} from '@angular/forms';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { didupload,  didForm } from '../user.class';
@Component({
  selector: 'app-didupload',
  templateUrl: './didupload.component.html',
  styleUrls: ['./didupload.component.css']
})
export class DiduploadComponent extends AppComponentClass<didupload, didForm> {
  p: number = 1;
	rowdata: any;
	listdata: any;
  modelform: any;
  public show: boolean = false;
  public package: any;
  public buttonName: any = "Add";
  public didForm: FormGroup;
  public submitted : boolean = false;
  filterTerm: string;
  fileToUpload: File = null;
  file:any;

  constructor(public data: UsermanagementService, public router: Router, public fb: FormBuilder) {
		super(data, router, fb);
	}

  
  ngOnInit(): void {

    // @subscribing form group
		this.data.solution.subscribe(res => {
			if (res != null) {
				this.cdata = new didForm(res);
				this.keyfield = res.id;
				this.didForm = this.cdata.makeform(this.fb);
			} else {
				this.cdata = new didForm(null);
				this.keyfield = -1;
				this.didForm = this.cdata.makeform(this.fb);
			}
		});

    this.data.getdidupload().subscribe((result) => {
	  this.modelform = result; 
    });
}

	// @to save/update form data
	onSubmit() {
		this.submitted = true;

		if (this.didForm.invalid) {
			return false;
		} else {
			if (this.cdata.saveForm(this.didForm)) {
				if (this.keyfield == -1) {
					this.data.saveData(JSON.stringify(this.cdata)).subscribe(res => {
						this.ngOnInit();
					});
				} else {
					this.data.updateData(JSON.stringify(this.cdata)).subscribe(res => {
						this.ngOnInit();
					});
				}
			}
		}
	}


	handleFileInput(files) {
		let sessionid = 32;
		let filetype = "agent guide";
		files.item(0)["sessionid"] = sessionid;
		files.item(0)["filetyepe"] = filetype;
		this.fileToUpload = files.item(0);
		this.data.postFile(this.fileToUpload,sessionid,filetype).subscribe(res => {
		  this.file = res.filename;
		}, error => {
		  console.log(error);
		});
	}
}

