import { Component, OnInit } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { MatDialog } from '@angular/material/dialog';
import { MatSlideToggleChange } from '@angular/material/slide-toggle';
import { environment } from 'src/environments/environment';
import { UsermanagementService } from '../../usermanagement.service';

@Component({
  selector: 'app-payment',
  templateUrl: './payment.component.html',
  styleUrls: ['./payment.component.css']
})

export class PaymentComponent implements OnInit {

  public status: boolean = false;
  submitted: boolean;
  public key: number;
  public ptype: number;
  header: any;
  paymentlist: any;
  public isapply: boolean = true;
  isLoggedIn: any;
  responseMessage: any;
  paymentSettingForm: FormGroup;
  subbmitted: boolean = false;
  isAutoPayment = false;
  isAutoEmail: Boolean = false;
  isAutowebhook: Boolean = false;
  paymentData: any = "";
  errMessage: any = "";
  stripeCards: any = [];
  isCard: Boolean = false;
  paymentHandler: any;
  isNewCard: Boolean = false;
  webHookShow: any;
  defaultamt: any;
  topup_amount: any;
  idwallet: any;

  constructor(private data: UsermanagementService, public dialog: MatDialog, private fb: FormBuilder) { }

  ngOnInit(): void {

    this.data.stripeCards().subscribe(res => {
      if (res.status == 200) {
        if (res.data.length > 0) {
          this.stripeCards = res.data;
          this.isCard = true;
          if (this.stripeCards.length >= 5) {
            this.isNewCard = true;
          }
          else {
            this.isNewCard = false;
          }
        }
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.errMessage = err.message;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });


    this.paymentSettingForm = this.fb.group({
      idwallet: [],
      defaultamt: ['', [Validators.required, Validators.min(1), Validators.max(500000)]],
      topup_amount: ['', [Validators.required, Validators.min(1), Validators.max(500000)]],
      webhook_url: [''],
      credit_limit: ['']
    });

    this.data.getBalance().subscribe(response => {
      if (response.data[0].isWebhook == 'true') {
        this.webHookShow = '1';
      } else {
        this.webHookShow = '2';
      }
      if (response.status == 200) {
        if (response.data.length > 0) {
          this.paymentData = response.data[0];
          this.idwallet = this.paymentData.idwallet;
          this.paymentSettingForm.patchValue({
            idwallet: response.data[0].idwallet,
            defaultamt: response.data[0].min_balance,
            topup_amount: response.data[0].topup_amount,
            webhook_url: response.data[0].webhook_url,
            credit_limit: response.data[0].credit_limit
          });
        }
        else {
          this.paymentData = {
            status: 'false',
            isWebhook: 'false',
            isEmail: 'false',
          }
        }
      }
      else {
        this.errMessage = response.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.errMessage = err.message;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });
  }

  onPaymentSetting() {
    this.subbmitted = true;
    if (this.paymentSettingForm.invalid) {
      return;
    }
    else {
      if (!this.isCard) {
        this.errMessage = "Add Card Detail For Auto Payment!";
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
      else {
        if (this.webHookShow == '1' && this.paymentSettingForm.value.webhook_url == "") {
          this.errMessage = "Please Enter Webhook url";
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
          return;
        }
        this.data.updatePaymentService(this.paymentSettingForm.value).subscribe(response => {
          if (response.status == 201) {
            this.responseMessage = response.message;
            setTimeout(() => {
              this.responseMessage = "";
            }, 5000);
            this.ngOnInit();
          }
          else {
            this.errMessage = response.message;
            setTimeout(() => {
              this.errMessage = "";
            }, 5000);
          }
        }, err => {
          this.errMessage = err.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        });
      }
    }
  }

  onEmailStatus(e: MatSlideToggleChange) {
    let status: any;
    if (e.checked) {
      status = 'true';
    }
    else {
      status = 'false';
    }
    if (!this.isCard) {
      e.source.writeValue(false);
      this.errMessage = "Add Card Detail For Auto Payment!";
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    }
    else {
      this.data.updatePaymentService({ idwallet: this.paymentSettingForm.value.idwallet, isAutoEmail: status }).subscribe(response => {
        if (response.status == 201) {
          this.responseMessage = response.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
          this.ngOnInit();
        }
        else {
          this.errMessage = response.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      }, err => {
        this.responseMessage = err;
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
      });
    }
  }

  onAutoPayment(e: MatSlideToggleChange) {
    let status: any;
    if (e.checked) {
      status = 'true';
    }
    else {
      status = 'false';
    }
    if (this.isCard) {
      this.data.updatePaymentService({ idwallet: this.paymentSettingForm.value.idwallet, isAutoPayment: status }).subscribe(response => {
        if (response.status == 201) {
          this.responseMessage = response.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
          this.ngOnInit();
        }
        else {
          this.errMessage = response.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      }, err => {
        this.errMessage = err.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      });
    }
    else {
      e.source.writeValue(false);
      this.errMessage = "Add Card Detail For Auto Payment!";
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
      // this.createCard();
    }
  }
  dftBalance(e) {
    if (e == '1') {
      this.paymentSettingForm.patchValue({
        defaultamt: 200,
      });
    } else {
      this.paymentSettingForm.patchValue({
        topup_amount: 200,
      });
    }

  }
  onIsWebhook(e: MatSlideToggleChange) {
    let status: any;
    if (e.checked) {
      status = 'true';
      this.webHookShow = '1';
    }
    else {
      status = 'false';
      this.webHookShow = '2';
    }
    if (this.isCard) {
      this.data.updatePaymentService({ idwallet: this.paymentSettingForm.value.idwallet, isAutowebhook: status }).subscribe(response => {
        if (response.status == 201) {
          this.responseMessage = response.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
          this.ngOnInit();
        }
        else {
          this.errMessage = response.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      }, err => {
        this.errMessage = err.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      });
    }
    else {
      e.source.writeValue(false);
      this.errMessage = "Add Card Detail For Auto WebHook!";
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    }
  }

  getAmount(e:any) {    
		this.defaultamt = e.target.value;	
		this.paymentSettingForm.patchValue({
		  defaultamt: this.defaultamt
		});
		let data = e.target.value;    
		e.target.value = (data.indexOf(".") >= 0) ? (data.substr(0, data.indexOf(".")) + data.substr(data.indexOf("."), 2)) : data;
		 return ;     
	  }

    getTopup(e:any) { 
      this.topup_amount = e.target.value;    
      this.paymentSettingForm.patchValue({
        topup_amount: this.topup_amount
      });
      let data1 = e.target.value;    
      e.target.value = (data1.indexOf(".") >= 0) ? (data1.substr(0, data1.indexOf(".")) + data1.substr(data1.indexOf("."), 2)) : data1;
       return ;     
      }

      resetform() {
        this.submitted = false;
        this.paymentSettingForm.reset();
        this.paymentSettingForm.patchValue({
          idwallet: this.idwallet,
        })
      }

}
