import { Component, ElementRef, OnInit } from '@angular/core';
import { FormBuilder, FormGroup, FormControl, Validators  } from '@angular/forms';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { ActivatedRoute, ParamMap, Router } from '@angular/router';
import { WhitelabelService } from '../whitelabel.service';
import { Observable } from 'rxjs';  

declare var $: any;
@Component({
  selector: 'app-whitelabel',
  templateUrl: './whitelabel.component.html',
  styleUrls: ['./whitelabel.component.css']
})

export class WhitelabelComponent extends AppComponentClass<any, any> {

  public themeForm: FormGroup;
  submitted:boolean= false;
  responseMessage = ""; 
  idTheme: any;
  imagePreview: any;

  constructor(public data: WhitelabelService, public router: Router, public fb: FormBuilder, private route: ActivatedRoute) {
		super(data, router, fb);

		this.themeForm = this.fb.group({
			id_theme: [],
			brandName: ['', Validators.required],
			domain: ["", Validators.required],
			custom_logo: ["", Validators.required],
			logo: ["", Validators.required],
			email:['', [Validators.required,
				Validators.pattern("^[a-z0-9._%+-]+@[a-z0-9.-]+\\.[a-z]{2,10}$")]],
			phone: ["", [Validators.required, ] ],
			support_url: ["", Validators.required,],
			header_color: ["", Validators.required,],
			navbar_color: ["", Validators.required,],
			sidebar_color: ["", Validators.required,],
			ssl_certificate: ["", Validators.required,],
			ssl_key: ["", Validators.required,]
		})
  }

  ngOnInit(): void {

	this.route.paramMap.subscribe((params: ParamMap) => {
		this.idTheme = params.get('id');
		this.data.getTheme(this.idTheme).subscribe(res => {
		 let result = res.data[0];
		  this.themeForm.patchValue({
			id_theme: result.id_theme,
			brandName: result.brandName,
			domain: result.domain,
			email: result.email,
			phone: result.phone,
			support_url: result.support_url,
			header_color: result.header_color,
			navbar_color: result.navbar_color,
			sidebar_color: result.sidebar_color,
			ssl_certificate: result.ssl_certificate,
			ssl_key: result.ssl_key
		  })
		});
	  });

	// End Domain form Details

	$("#defaultSelect").change(function(){
		var color = $("option:selected", this).attr("class");
		$("#defaultSelect").attr("class", color);
	});

	$("#defaultSelect1").change(function(){
		var color = $("option:selected", this).attr("class");
		$("#defaultSelect1").attr("class", color);
	});

	$("#defaultSelect2").change(function(){
		var color = $("option:selected", this).attr("class");
		$("#defaultSelect2").attr("class", color);
	});

  }

  onImagePicked(event: Event){
    const file = (event.target as HTMLInputElement).files[0];

    this.themeForm.patchValue({
		logo: file
    });

    this.themeForm.get("logo").updateValueAndValidity();
    const reader = new FileReader();
    reader.onload = () => {
      this.imagePreview = reader.result;
    }
    reader.readAsDataURL(file);
  }

  // @to save/update form data
    onTheme() {
		this.submitted = true;
		if(this.themeForm.invalid){
			return false;
		}
		else{
			this.data.updateTheme(this.themeForm.value, this.themeForm.value.logo).subscribe(res => {
				this.responseMessage = res.message;  
				setTimeout(()=>{
				  this.responseMessage= "";
				}, 5000);
				this.router.navigate(['/whitelabel/whitelabel-details']);
			})	
		}
	
		this.themeForm.reset();
	}

	onDeleteTheme(id){
		console.log(id);
	}
}
