import { isIconLookup } from './is-icon-lookup.util';
/**
 * Normalizing icon spec.
 */
export var faNormalizeIconSpec = function (iconSpec, defaultPrefix) {
    if (isIconLookup(iconSpec)) {
        return iconSpec;
    }
    if (Array.isArray(iconSpec) && iconSpec.length === 2) {
        return { prefix: iconSpec[0], iconName: iconSpec[1] };
    }
    if (typeof iconSpec === 'string') {
        return { prefix: defaultPrefix, iconName: iconSpec };
    }
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibm9ybWFsaXplLWljb24tc3BlYy51dGlsLmpzIiwic291cmNlUm9vdCI6Im5nOi8vQGZvcnRhd2Vzb21lL2FuZ3VsYXItZm9udGF3ZXNvbWUvIiwic291cmNlcyI6WyJzaGFyZWQvdXRpbHMvbm9ybWFsaXplLWljb24tc3BlYy51dGlsLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUNBLE9BQU8sRUFBRSxZQUFZLEVBQUUsTUFBTSx1QkFBdUIsQ0FBQztBQUVyRDs7R0FFRztBQUNILE1BQU0sQ0FBQyxJQUFNLG1CQUFtQixHQUFHLFVBQ2pDLFFBQW1DLEVBQ25DLGFBQXlCO0lBRXpCLElBQUksWUFBWSxDQUFDLFFBQVEsQ0FBQyxFQUFFO1FBQzFCLE9BQU8sUUFBUSxDQUFDO0tBQ2pCO0lBRUQsSUFBSSxLQUFLLENBQUMsT0FBTyxDQUFDLFFBQVEsQ0FBQyxJQUFLLFFBQXFCLENBQUMsTUFBTSxLQUFLLENBQUMsRUFBRTtRQUNsRSxPQUFPLEVBQUUsTUFBTSxFQUFFLFFBQVEsQ0FBQyxDQUFDLENBQUMsRUFBRSxRQUFRLEVBQUUsUUFBUSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUM7S0FDdkQ7SUFFRCxJQUFJLE9BQU8sUUFBUSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxPQUFPLEVBQUUsTUFBTSxFQUFFLGFBQWEsRUFBRSxRQUFRLEVBQUUsUUFBUSxFQUFFLENBQUM7S0FDdEQ7QUFDSCxDQUFDLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBJY29uRGVmaW5pdGlvbiwgSWNvbkxvb2t1cCwgSWNvblByZWZpeCwgSWNvblByb3AgfSBmcm9tICdAZm9ydGF3ZXNvbWUvZm9udGF3ZXNvbWUtc3ZnLWNvcmUnO1xuaW1wb3J0IHsgaXNJY29uTG9va3VwIH0gZnJvbSAnLi9pcy1pY29uLWxvb2t1cC51dGlsJztcblxuLyoqXG4gKiBOb3JtYWxpemluZyBpY29uIHNwZWMuXG4gKi9cbmV4cG9ydCBjb25zdCBmYU5vcm1hbGl6ZUljb25TcGVjID0gKFxuICBpY29uU3BlYzogSWNvblByb3AgfCBJY29uRGVmaW5pdGlvbixcbiAgZGVmYXVsdFByZWZpeDogSWNvblByZWZpeCxcbik6IEljb25Mb29rdXAgfCBJY29uRGVmaW5pdGlvbiA9PiB7XG4gIGlmIChpc0ljb25Mb29rdXAoaWNvblNwZWMpKSB7XG4gICAgcmV0dXJuIGljb25TcGVjO1xuICB9XG5cbiAgaWYgKEFycmF5LmlzQXJyYXkoaWNvblNwZWMpICYmIChpY29uU3BlYyBhcyBzdHJpbmdbXSkubGVuZ3RoID09PSAyKSB7XG4gICAgcmV0dXJuIHsgcHJlZml4OiBpY29uU3BlY1swXSwgaWNvbk5hbWU6IGljb25TcGVjWzFdIH07XG4gIH1cblxuICBpZiAodHlwZW9mIGljb25TcGVjID09PSAnc3RyaW5nJykge1xuICAgIHJldHVybiB7IHByZWZpeDogZGVmYXVsdFByZWZpeCwgaWNvbk5hbWU6IGljb25TcGVjIH07XG4gIH1cbn07XG4iXX0=