import { OnChanges, OnInit, OnDestroy, SimpleChanges } from "@angular/core";
import { ApexAnnotations, ApexAxisChartSeries, ApexChart, ApexDataLabels, ApexFill, ApexGrid, ApexLegend, ApexNonAxisChartSeries, ApexMarkers, ApexNoData, ApexPlotOptions, ApexResponsive, ApexStates, ApexStroke, ApexTheme, ApexTitleSubtitle, ApexTooltip, ApexXAxis, ApexYAxis } from "../model/apex-types";
import * as ɵngcc0 from '@angular/core';
export declare class ChartComponent implements OnInit, OnChanges, OnDestroy {
    chart: ApexChart;
    annotations: ApexAnnotations;
    colors: any[];
    dataLabels: ApexDataLabels;
    series: ApexAxisChartSeries | ApexNonAxisChartSeries;
    stroke: ApexStroke;
    labels: string[];
    legend: ApexLegend;
    markers: ApexMarkers;
    noData: ApexNoData;
    fill: ApexFill;
    tooltip: ApexTooltip;
    plotOptions: ApexPlotOptions;
    responsive: ApexResponsive[];
    xaxis: ApexXAxis;
    yaxis: ApexYAxis | ApexYAxis[];
    grid: ApexGrid;
    states: ApexStates;
    title: ApexTitleSubtitle;
    subtitle: ApexTitleSubtitle;
    theme: ApexTheme;
    autoUpdateSeries: boolean;
    private chartElement;
    private chartObj;
    ngOnInit(): void;
    ngOnChanges(changes: SimpleChanges): void;
    ngOnDestroy(): void;
    private createElement;
    render(): Promise<void>;
    updateOptions(options: any, redrawPaths?: boolean, animate?: boolean, updateSyncedCharts?: boolean): Promise<void>;
    updateSeries(newSeries: ApexAxisChartSeries | ApexNonAxisChartSeries, animate?: boolean): void;
    appendSeries(newSeries: ApexAxisChartSeries | ApexNonAxisChartSeries, animate?: boolean): void;
    appendData(newData: any[]): void;
    toggleSeries(seriesName: string): any;
    showSeries(seriesName: string): void;
    hideSeries(seriesName: string): void;
    resetSeries(): void;
    zoomX(min: number, max: number): void;
    toggleDataPointSelection(seriesIndex: number, dataPointIndex?: number): void;
    destroy(): void;
    setLocale(localeName?: string): void;
    paper(): void;
    addXaxisAnnotation(options: any, pushToMemory?: boolean, context?: any): void;
    addYaxisAnnotation(options: any, pushToMemory?: boolean, context?: any): void;
    addPointAnnotation(options: any, pushToMemory?: boolean, context?: any): void;
    removeAnnotation(id: string, options?: any): void;
    clearAnnotations(options?: any): void;
    dataURI(): Promise<void>;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<ChartComponent, never>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<ChartComponent, "apx-chart", never, { "autoUpdateSeries": "autoUpdateSeries"; "chart": "chart"; "annotations": "annotations"; "colors": "colors"; "dataLabels": "dataLabels"; "series": "series"; "stroke": "stroke"; "labels": "labels"; "legend": "legend"; "markers": "markers"; "noData": "noData"; "fill": "fill"; "tooltip": "tooltip"; "plotOptions": "plotOptions"; "responsive": "responsive"; "xaxis": "xaxis"; "yaxis": "yaxis"; "grid": "grid"; "states": "states"; "title": "title"; "subtitle": "subtitle"; "theme": "theme"; }, {}, never, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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