import { DoCheck, ElementRef, EventEmitter, OnChanges, OnDestroy, OnInit, SimpleChanges } from '@angular/core';
import { Color } from './color';
import { ThemeService } from './theme.service';
import { ChartConfiguration, ChartDataSets, ChartOptions, ChartPoint, ChartType, PluginServiceGlobalRegistration, PluginServiceRegistrationOptions } from 'chart.js';
import * as ɵngcc0 from '@angular/core';
export declare type SingleDataSet = Array<number | null | undefined | number[]> | ChartPoint[];
export declare type MultiDataSet = SingleDataSet[];
export declare type SingleOrMultiDataSet = SingleDataSet | MultiDataSet;
export declare type PluginServiceGlobalRegistrationAndOptions = PluginServiceGlobalRegistration & PluginServiceRegistrationOptions;
export declare type SingleLineLabel = string;
export declare type MultiLineLabel = string[];
export declare type Label = SingleLineLabel | MultiLineLabel;
export declare class BaseChartDirective implements OnChanges, OnInit, OnDestroy, DoCheck {
    private element;
    private themeService;
    data: SingleOrMultiDataSet;
    datasets: ChartDataSets[];
    labels: Label[];
    options: ChartOptions;
    chartType: ChartType;
    colors: Color[];
    legend: boolean;
    plugins: PluginServiceGlobalRegistrationAndOptions[];
    chartClick: EventEmitter<{
        event?: MouseEvent;
        active?: {}[];
    }>;
    chartHover: EventEmitter<{
        event: MouseEvent;
        active: {}[];
    }>;
    ctx: string;
    chart: Chart;
    private old;
    private subs;
    /**
     * Register a plugin.
     */
    static registerPlugin(plugin: PluginServiceGlobalRegistrationAndOptions): void;
    static unregisterPlugin(plugin: PluginServiceGlobalRegistrationAndOptions): void;
    constructor(element: ElementRef, themeService: ThemeService);
    ngOnInit(): void;
    private themeChanged;
    ngDoCheck(): void;
    copyLabel(a: Label): Label;
    labelsEqual(a: Label, b: Label): boolean;
    copyColor(a: Color): Color;
    colorsEqual(a: Color, b: Color): boolean;
    updateColors(): void;
    ngOnChanges(changes: SimpleChanges): void;
    ngOnDestroy(): void;
    update(duration?: any): {};
    hideDataset(index: number, hidden: boolean): void;
    isDatasetHidden(index: number): boolean;
    toBase64Image(): string;
    getChartConfiguration(): ChartConfiguration;
    getChartBuilder(ctx: string): Chart;
    smartMerge(options: any, overrides: any, level?: number): any;
    private isMultiLineLabel;
    private joinLabel;
    private propagateDatasetsToData;
    private propagateDataToDatasets;
    private isMultiDataSet;
    private getDatasets;
    private refresh;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<BaseChartDirective, never>;
    static ɵdir: ɵngcc0.ɵɵDirectiveDefWithMeta<BaseChartDirective, "canvas[baseChart]", ["base-chart"], { "options": "options"; "data": "data"; "datasets": "datasets"; "labels": "labels"; "chartType": "chartType"; "colors": "colors"; "legend": "legend"; "plugins": "plugins"; }, { "chartClick": "chartClick"; "chartHover": "chartHover"; }, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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