import { OnInit, OnDestroy, AfterViewInit, ElementRef, ChangeDetectorRef } from '@angular/core';
import { ColorFormats, Cmyk, Hsla, Rgba } from './formats';
import { AlphaChannel, OutputFormat, SliderPosition } from './helpers';
import { ColorPickerService } from './color-picker.service';
import * as ɵngcc0 from '@angular/core';
export declare class ColorPickerComponent implements OnInit, OnDestroy, AfterViewInit {
    private elRef;
    private cdRef;
    private service;
    private isIE10;
    private cmyk;
    private hsva;
    private width;
    private height;
    private cmykColor;
    private outputColor;
    private initialColor;
    private fallbackColor;
    private listenerResize;
    private listenerMouseDown;
    private directiveInstance;
    private sliderH;
    private sliderDimMax;
    private directiveElementRef;
    private dialogArrowSize;
    private dialogArrowOffset;
    private dialogInputFields;
    private useRootViewContainer;
    show: boolean;
    hidden: boolean;
    top: number;
    left: number;
    position: string;
    format: ColorFormats;
    slider: SliderPosition;
    hexText: string;
    hexAlpha: number;
    cmykText: Cmyk;
    hslaText: Hsla;
    rgbaText: Rgba;
    arrowTop: number;
    selectedColor: string;
    hueSliderColor: string;
    alphaSliderColor: string;
    cpWidth: number;
    cpHeight: number;
    cpColorMode: number;
    cpCmykEnabled: boolean;
    cpAlphaChannel: AlphaChannel;
    cpOutputFormat: OutputFormat;
    cpDisableInput: boolean;
    cpDialogDisplay: string;
    cpIgnoredElements: any;
    cpSaveClickOutside: boolean;
    cpCloseClickOutside: boolean;
    cpPosition: string;
    cpUsePosition: string;
    cpPositionOffset: number;
    cpOKButton: boolean;
    cpOKButtonText: string;
    cpOKButtonClass: string;
    cpCancelButton: boolean;
    cpCancelButtonText: string;
    cpCancelButtonClass: string;
    cpPresetLabel: string;
    cpPresetColors: string[];
    cpPresetColorsClass: string;
    cpMaxPresetColorsLength: number;
    cpPresetEmptyMessage: string;
    cpPresetEmptyMessageClass: string;
    cpAddColorButton: boolean;
    cpAddColorButtonText: string;
    cpAddColorButtonClass: string;
    cpRemoveColorButtonClass: string;
    cpTriggerElement: ElementRef;
    dialogElement: ElementRef;
    hueSlider: ElementRef;
    alphaSlider: ElementRef;
    handleEsc(event: any): void;
    handleEnter(event: any): void;
    constructor(elRef: ElementRef, cdRef: ChangeDetectorRef, service: ColorPickerService);
    ngOnInit(): void;
    ngOnDestroy(): void;
    ngAfterViewInit(): void;
    openDialog(color: any, emit?: boolean): void;
    closeDialog(): void;
    setupDialog(instance: any, elementRef: ElementRef, color: any, cpWidth: string, cpHeight: string, cpDialogDisplay: string, cpFallbackColor: string, cpColorMode: string, cpCmykEnabled: boolean, cpAlphaChannel: AlphaChannel, cpOutputFormat: OutputFormat, cpDisableInput: boolean, cpIgnoredElements: any, cpSaveClickOutside: boolean, cpCloseClickOutside: boolean, cpUseRootViewContainer: boolean, cpPosition: string, cpPositionOffset: string, cpPositionRelativeToArrow: boolean, cpPresetLabel: string, cpPresetColors: string[], cpPresetColorsClass: string, cpMaxPresetColorsLength: number, cpPresetEmptyMessage: string, cpPresetEmptyMessageClass: string, cpOKButton: boolean, cpOKButtonClass: string, cpOKButtonText: string, cpCancelButton: boolean, cpCancelButtonClass: string, cpCancelButtonText: string, cpAddColorButton: boolean, cpAddColorButtonClass: string, cpAddColorButtonText: string, cpRemoveColorButtonClass: string, cpTriggerElement: ElementRef): void;
    setColorMode(mode: string): void;
    setInitialColor(color: any): void;
    setPresetConfig(cpPresetLabel: string, cpPresetColors: string[]): void;
    setColorFromString(value: string, emit?: boolean, update?: boolean): void;
    onResize(): void;
    onDragEnd(slider: string): void;
    onDragStart(slider: string): void;
    onMouseDown(event: MouseEvent): void;
    onAcceptColor(event: Event): void;
    onCancelColor(event: Event): void;
    onFormatToggle(change: number): void;
    onColorChange(value: {
        s: number;
        v: number;
        rgX: number;
        rgY: number;
    }): void;
    onHueChange(value: {
        v: number;
        rgX: number;
    }): void;
    onValueChange(value: {
        v: number;
        rgX: number;
    }): void;
    onAlphaChange(value: {
        v: number;
        rgX: number;
    }): void;
    onHexInput(value: string | null): void;
    onRedInput(value: {
        v: number;
        rg: number;
    }): void;
    onBlueInput(value: {
        v: number;
        rg: number;
    }): void;
    onGreenInput(value: {
        v: number;
        rg: number;
    }): void;
    onHueInput(value: {
        v: number;
        rg: number;
    }): void;
    onValueInput(value: {
        v: number;
        rg: number;
    }): void;
    onAlphaInput(value: {
        v: number;
        rg: number;
    }): void;
    onLightnessInput(value: {
        v: number;
        rg: number;
    }): void;
    onSaturationInput(value: {
        v: number;
        rg: number;
    }): void;
    onCyanInput(value: {
        v: number;
        rg: number;
    }): void;
    onMagentaInput(value: {
        v: number;
        rg: number;
    }): void;
    onYellowInput(value: {
        v: number;
        rg: number;
    }): void;
    onBlackInput(value: {
        v: number;
        rg: number;
    }): void;
    onAddPresetColor(event: any, value: string): void;
    onRemovePresetColor(event: any, value: string): void;
    private openColorPicker;
    private closeColorPicker;
    private updateColorPicker;
    private setDialogPosition;
    private isDescendant;
    private createDialogBox;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<ColorPickerComponent, never>;
    static ɵcmp: ɵngcc0.ɵɵComponentDefWithMeta<ColorPickerComponent, "color-picker", never, {}, {}, never, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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