import { OnChanges, OnDestroy, EventEmitter, ApplicationRef, ElementRef, ViewContainerRef, Injector, ComponentFactoryResolver } from '@angular/core';
import { ColorPickerService } from './color-picker.service';
import { AlphaChannel, ColorMode, OutputFormat } from './helpers';
import * as ɵngcc0 from '@angular/core';
export declare class ColorPickerDirective implements OnChanges, OnDestroy {
    private injector;
    private cfr;
    private appRef;
    private vcRef;
    private elRef;
    private _service;
    private dialog;
    private dialogCreated;
    private ignoreChanges;
    private cmpRef;
    private viewAttachedToAppRef;
    colorPicker: string;
    cpWidth: string;
    cpHeight: string;
    cpToggle: boolean;
    cpDisabled: boolean;
    cpIgnoredElements: any;
    cpFallbackColor: string;
    cpColorMode: ColorMode;
    cpCmykEnabled: boolean;
    cpOutputFormat: OutputFormat;
    cpAlphaChannel: AlphaChannel;
    cpDisableInput: boolean;
    cpDialogDisplay: string;
    cpSaveClickOutside: boolean;
    cpCloseClickOutside: boolean;
    cpUseRootViewContainer: boolean;
    cpPosition: string;
    cpPositionOffset: string;
    cpPositionRelativeToArrow: boolean;
    cpOKButton: boolean;
    cpOKButtonText: string;
    cpOKButtonClass: string;
    cpCancelButton: boolean;
    cpCancelButtonText: string;
    cpCancelButtonClass: string;
    cpPresetLabel: string;
    cpPresetColors: string[];
    cpPresetColorsClass: string;
    cpMaxPresetColorsLength: number;
    cpPresetEmptyMessage: string;
    cpPresetEmptyMessageClass: string;
    cpAddColorButton: boolean;
    cpAddColorButtonText: string;
    cpAddColorButtonClass: string;
    cpRemoveColorButtonClass: string;
    cpInputChange: EventEmitter<{
        input: string;
        value: number | string;
        color: string;
    }>;
    cpToggleChange: EventEmitter<boolean>;
    cpSliderChange: EventEmitter<{
        slider: string;
        value: string | number;
        color: string;
    }>;
    cpSliderDragEnd: EventEmitter<{
        slider: string;
        color: string;
    }>;
    cpSliderDragStart: EventEmitter<{
        slider: string;
        color: string;
    }>;
    colorPickerOpen: EventEmitter<string>;
    colorPickerClose: EventEmitter<string>;
    colorPickerCancel: EventEmitter<string>;
    colorPickerSelect: EventEmitter<string>;
    colorPickerChange: EventEmitter<string>;
    cpCmykColorChange: EventEmitter<string>;
    cpPresetColorsChange: EventEmitter<any>;
    handleClick(): void;
    handleFocus(): void;
    handleInput(event: any): void;
    constructor(injector: Injector, cfr: ComponentFactoryResolver, appRef: ApplicationRef, vcRef: ViewContainerRef, elRef: ElementRef, _service: ColorPickerService);
    ngOnDestroy(): void;
    ngOnChanges(changes: any): void;
    openDialog(): void;
    closeDialog(): void;
    cmykChanged(value: string): void;
    stateChanged(state: boolean): void;
    colorChanged(value: string, ignore?: boolean): void;
    colorSelected(value: string): void;
    colorCanceled(): void;
    inputFocus(): void;
    inputChange(event: any): void;
    inputChanged(event: any): void;
    sliderChanged(event: any): void;
    sliderDragEnd(event: {
        slider: string;
        color: string;
    }): void;
    sliderDragStart(event: {
        slider: string;
        color: string;
    }): void;
    presetColorsChanged(value: any[]): void;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<ColorPickerDirective, never>;
    static ɵdir: ɵngcc0.ɵɵDirectiveDefWithMeta<ColorPickerDirective, "[colorPicker]", ["ngxColorPicker"], { "cpWidth": "cpWidth"; "cpHeight": "cpHeight"; "cpToggle": "cpToggle"; "cpDisabled": "cpDisabled"; "cpIgnoredElements": "cpIgnoredElements"; "cpFallbackColor": "cpFallbackColor"; "cpColorMode": "cpColorMode"; "cpCmykEnabled": "cpCmykEnabled"; "cpOutputFormat": "cpOutputFormat"; "cpAlphaChannel": "cpAlphaChannel"; "cpDisableInput": "cpDisableInput"; "cpDialogDisplay": "cpDialogDisplay"; "cpSaveClickOutside": "cpSaveClickOutside"; "cpCloseClickOutside": "cpCloseClickOutside"; "cpUseRootViewContainer": "cpUseRootViewContainer"; "cpPosition": "cpPosition"; "cpPositionOffset": "cpPositionOffset"; "cpPositionRelativeToArrow": "cpPositionRelativeToArrow"; "cpOKButton": "cpOKButton"; "cpOKButtonText": "cpOKButtonText"; "cpOKButtonClass": "cpOKButtonClass"; "cpCancelButton": "cpCancelButton"; "cpCancelButtonText": "cpCancelButtonText"; "cpCancelButtonClass": "cpCancelButtonClass"; "cpPresetLabel": "cpPresetLabel"; "cpPresetColorsClass": "cpPresetColorsClass"; "cpMaxPresetColorsLength": "cpMaxPresetColorsLength"; "cpPresetEmptyMessage": "cpPresetEmptyMessage"; "cpPresetEmptyMessageClass": "cpPresetEmptyMessageClass"; "cpAddColorButton": "cpAddColorButton"; "cpAddColorButtonText": "cpAddColorButtonText"; "cpAddColorButtonClass": "cpAddColorButtonClass"; "cpRemoveColorButtonClass": "cpRemoveColorButtonClass"; "colorPicker": "colorPicker"; "cpPresetColors": "cpPresetColors"; }, { "cpInputChange": "cpInputChange"; "cpToggleChange": "cpToggleChange"; "cpSliderChange": "cpSliderChange"; "cpSliderDragEnd": "cpSliderDragEnd"; "cpSliderDragStart": "cpSliderDragStart"; "colorPickerOpen": "colorPickerOpen"; "colorPickerClose": "colorPickerClose"; "colorPickerCancel": "colorPickerCancel"; "colorPickerSelect": "colorPickerSelect"; "colorPickerChange": "colorPickerChange"; "cpCmykColorChange": "cpCmykColorChange"; "cpPresetColorsChange": "cpPresetColorsChange"; }, never>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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