import { Cmyk, Rgba, Hsla, Hsva } from './formats';
import { ColorPickerComponent } from './color-picker.component';
import * as ɵngcc0 from '@angular/core';
export declare class ColorPickerService {
    private active;
    constructor();
    setActive(active: ColorPickerComponent | null): void;
    hsva2hsla(hsva: Hsva): Hsla;
    hsla2hsva(hsla: Hsla): Hsva;
    hsvaToRgba(hsva: Hsva): Rgba;
    cmykToRgb(cmyk: Cmyk): Rgba;
    rgbaToCmyk(rgba: Rgba): Cmyk;
    rgbaToHsva(rgba: Rgba): Hsva;
    rgbaToHex(rgba: Rgba, allowHex8?: boolean): string;
    normalizeCMYK(cmyk: Cmyk): Cmyk;
    denormalizeCMYK(cmyk: Cmyk): Cmyk;
    denormalizeRGBA(rgba: Rgba): Rgba;
    stringToHsva(colorString?: string, allowHex8?: boolean): Hsva | null;
    outputFormat(hsva: Hsva, outputFormat: string, alphaChannel: string | null): string;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<ColorPickerService, never>;
    static ɵprov: ɵngcc0.ɵɵInjectableDef<ColorPickerService>;
}

//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29sb3ItcGlja2VyLnNlcnZpY2UuZC50cyIsInNvdXJjZXMiOlsiY29sb3ItcGlja2VyLnNlcnZpY2UuZC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtBQUNBOztBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOzs7QUFDQSIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENteWssIFJnYmEsIEhzbGEsIEhzdmEgfSBmcm9tICcuL2Zvcm1hdHMnO1xuaW1wb3J0IHsgQ29sb3JQaWNrZXJDb21wb25lbnQgfSBmcm9tICcuL2NvbG9yLXBpY2tlci5jb21wb25lbnQnO1xuZXhwb3J0IGRlY2xhcmUgY2xhc3MgQ29sb3JQaWNrZXJTZXJ2aWNlIHtcbiAgICBwcml2YXRlIGFjdGl2ZTtcbiAgICBjb25zdHJ1Y3RvcigpO1xuICAgIHNldEFjdGl2ZShhY3RpdmU6IENvbG9yUGlja2VyQ29tcG9uZW50IHwgbnVsbCk6IHZvaWQ7XG4gICAgaHN2YTJoc2xhKGhzdmE6IEhzdmEpOiBIc2xhO1xuICAgIGhzbGEyaHN2YShoc2xhOiBIc2xhKTogSHN2YTtcbiAgICBoc3ZhVG9SZ2JhKGhzdmE6IEhzdmEpOiBSZ2JhO1xuICAgIGNteWtUb1JnYihjbXlrOiBDbXlrKTogUmdiYTtcbiAgICByZ2JhVG9DbXlrKHJnYmE6IFJnYmEpOiBDbXlrO1xuICAgIHJnYmFUb0hzdmEocmdiYTogUmdiYSk6IEhzdmE7XG4gICAgcmdiYVRvSGV4KHJnYmE6IFJnYmEsIGFsbG93SGV4OD86IGJvb2xlYW4pOiBzdHJpbmc7XG4gICAgbm9ybWFsaXplQ01ZSyhjbXlrOiBDbXlrKTogQ215aztcbiAgICBkZW5vcm1hbGl6ZUNNWUsoY215azogQ215ayk6IENteWs7XG4gICAgZGVub3JtYWxpemVSR0JBKHJnYmE6IFJnYmEpOiBSZ2JhO1xuICAgIHN0cmluZ1RvSHN2YShjb2xvclN0cmluZz86IHN0cmluZywgYWxsb3dIZXg4PzogYm9vbGVhbik6IEhzdmEgfCBudWxsO1xuICAgIG91dHB1dEZvcm1hdChoc3ZhOiBIc3ZhLCBvdXRwdXRGb3JtYXQ6IHN0cmluZywgYWxwaGFDaGFubmVsOiBzdHJpbmcgfCBudWxsKTogc3RyaW5nO1xufVxuIl19